// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

template<typename InstrType>
InstrType& hkTypeVm::Program::addInstr()
{
    LargestInstruction& instr = m_code.expandOne();
    return *new(&instr) InstrType();
}

template<typename InstrType>
InstrType& hkTypeVm::Program::addInstr(const InstrType& instr)
{
    LargestInstruction& newInstr = m_code.expandOne();
    return *new(&newInstr) InstrType(instr);
}

template<typename P>
inline hkTypeVm::Program::IteratorImpl<P>& hkTypeVm::Program::IteratorImpl<P>::operator++()
{
    ++m_idx;
    return *this;
}

template<typename P>
inline hkTypeVm::Program::IteratorImpl<P> hkTypeVm::Program::IteratorImpl<P>::operator++(int)
{
    IteratorImpl<P> ret = *this; ++(*this); return ret;
}

template<typename P>
inline hkTypeVm::Program::IteratorImpl<P>& hkTypeVm::Program::IteratorImpl<P>::operator--()
{
    --m_idx;
    return *this;
}

template<typename P>
inline hkTypeVm::Program::IteratorImpl<P> hkTypeVm::Program::IteratorImpl<P>::operator--(int)
{
    IteratorImpl<P> ret = *this; --(*this); return ret;
}
template<typename P>
inline bool hkTypeVm::Program::IteratorImpl<P>::operator!=(const IteratorImpl<P>& rhs) const
{
    return m_prog != rhs.m_prog || m_idx != rhs.m_idx;
}

template<typename P>
inline bool hkTypeVm::Program::IteratorImpl<P>::operator==(const IteratorImpl<P>& rhs) const
{
    return !((*this) != rhs);
}

template<typename P>
inline hkTypeVm::Program::IteratorImpl<P> hkTypeVm::Program::IteratorImpl<P>::operator+(int v) const
{
    IteratorImpl<P> it(m_prog, m_idx);
    it += v;
    return it;
}

template<typename P>
inline hkTypeVm::Program::IteratorImpl<P> hkTypeVm::Program::IteratorImpl<P>::operator-(int v) const
{
    return IteratorImpl<P>(m_prog, m_idx - v);
}

template<typename P>
inline int hkTypeVm::Program::IteratorImpl<P>::operator-(const IteratorImpl<P>& rhs) const
{
    return int(m_idx) - rhs.m_idx;
}

template<typename P>
inline hkTypeVm::Program::IteratorImpl<P>& hkTypeVm::Program::IteratorImpl<P>::operator+=(int v)
{
    m_idx += v;
    return *this;
}

template<typename P>
inline typename hkTypeVm::Program::IteratorImpl<P>::ValueType& hkTypeVm::Program::IteratorImpl<P>::operator*()
{
    return m_prog->m_code[m_idx];
}

template<typename P>
inline typename hkTypeVm::Program::IteratorImpl<P>::ValueType* hkTypeVm::Program::IteratorImpl<P>::operator->()
{
    return &(**this);
}

template<typename InstrType>
void hkTypeVm::Program::replace(Iterator b, Iterator e, const InstrType& instr)
{
    new(&*b) InstrType(instr);
    if(const int toRemove = e - b - 1)
    {
        m_code.removeAtAndCopy(b.m_idx + 1, toRemove);
    }
}


template<typename InstrType>
void hkTypeVm::Program::insertAfter(Iterator it, const InstrType& instr)
{
    LargestInstruction* newInstr = m_code.expandAt(it.m_idx + 1, 1);
    new (newInstr) InstrType(instr);
}


inline hkTypeVm::Program::Iterator hkTypeVm::Program::begin()
{
    return Iterator(this, 0);
}

inline hkTypeVm::Program::Iterator hkTypeVm::Program::end()
{
    return Iterator(this, m_code.getSize());
}

inline hkTypeVm::Program::ConstIterator hkTypeVm::Program::begin() const
{
    return ConstIterator(this, 0);
}

inline hkTypeVm::Program::ConstIterator hkTypeVm::Program::end() const
{
    return ConstIterator(this, m_code.getSize());
}

inline bool hkTypeVm::Program::isEmpty() const
{
    return begin() == end();
}

inline _Ret_maybenull_ const hkTypeVm::Program::DefaultInstruction* hkTypeVm::Program::InstructionBase::isDefaultInstruction() const
{
    switch(getInstructionType())
    {
        case INST_ARRAY:
        case INST_BOOL:
        //case INST_CONTAINER:
        case INST_INT:
        case INST_FLOAT:
        case INST_POINTER:
        case INST_RECORD:
        case INST_STRING:
        case INST_CONVERT_INTEGER:
        case INST_CONVERT_FLOAT:
            return static_cast<const DefaultInstruction*>(this);

        default:
            return HK_NULL;
    }
}

inline _Ret_maybenull_ const hkTypeVm::Program::ProgramInstruction* hkTypeVm::Program::InstructionBase::isProgramInstruction() const
{
    switch(getInstructionType())
    {
        case INST_ARRAY:
        case INST_RECORD:
            return static_cast<const ProgramInstruction*>(this);

        default:
            return HK_NULL;
    }
}

inline _Ret_maybenull_ const hkTypeVm::Program::RecordInstruction* hkTypeVm::Program::InstructionBase::isRecordInstruction() const
{
    return getInstructionType() == INST_RECORD ? static_cast<const RecordInstruction*>(this) : HK_NULL;
}

inline _Ret_maybenull_ const hkTypeVm::Program::ArrayInstruction* hkTypeVm::Program::InstructionBase::isArrayInstruction() const
{
    return getInstructionType() == INST_ARRAY ? static_cast<const ArrayInstruction*>(this) : HK_NULL;
}

inline _Ret_maybenull_ const hkTypeVm::Program::BlockInstruction* hkTypeVm::Program::InstructionBase::isBlockInstruction() const
{
    return getInstructionType() == INST_BLOCK ? static_cast<const BlockInstruction*>(this) : HK_NULL;
}

template<typename Type>
_Ret_maybenull_ const Type* hkTypeVm::Program::DefaultInstruction::getDstTypeAs() const
{
    HK_ASSERT_NO_MSG(0x5fc5b0f7, hkDynCast<Type>(m_dstType));
    return static_cast<const Type*>(m_dstType);
}

template<typename Type>
_Ret_maybenull_ const Type* hkTypeVm::Program::DefaultInstruction::getSrcTypeAs() const
{
    HK_ASSERT_NO_MSG(0x148d33e5, m_srcType == HK_NULL || hkDynCast<Type>(m_srcType));
    return static_cast<const Type*>(m_srcType);
}

inline hkReflect::Var hkTypeVm::Program::DefaultInstruction::getSrcVar(_In_opt_ void* srcAddr) const
{
    HK_ASSERT_NO_MSG(0x14f756d7, m_srcType != HK_NULL || srcAddr == HK_NULL);
    return hkReflect::Var(srcAddr, m_srcType);
}

inline hkReflect::Var hkTypeVm::Program::DefaultInstruction::getDstVar(_In_opt_ void* dstAddr) const
{
    return hkReflect::Var(dstAddr, m_dstType);
}

template<typename VarType>
VarType hkTypeVm::Program::DefaultInstruction::getSrcVarAs(_In_ const void* srcAddr) const
{
    HK_ASSERT_NO_MSG(0x1de295d9, m_srcType == HK_NULL || hkDynCast<typename VarType::MyType>(m_srcType));
    return VarType(srcAddr, getSrcTypeAs<typename VarType::MyType>());
}

template<typename VarType>
VarType hkTypeVm::Program::DefaultInstruction::getDstVarAs(_In_ const void* srcAddr) const
{
    return VarType(srcAddr, getDstTypeAs<typename VarType::MyType>());
}

inline _Ret_maybenull_ const hkReflect::RecordType* hkTypeVm::Program::RecordInstruction::getDstType() const
{
    const hkReflect::RecordType* res = DefaultInstruction::getDstType()->asRecord();
    HK_ASSERT_NO_MSG(0xda88b6f, res);
    return res;
}

inline hkReflect::RecordVar hkTypeVm::Program::RecordInstruction::getDstVar(_In_ void* dstAddr) const { return hkReflect::RecordVar(dstAddr, getDstType()); }

inline _Ret_notnull_ const hkReflect::ArrayType* hkTypeVm::Program::ArrayInstruction::getDstType() const
{
    const hkReflect::ArrayType* res = DefaultInstruction::getDstType()->asArray();
    HK_ASSERT_NO_MSG(0x26cd1d5b, res);
    return res;
}

inline hkReflect::ArrayVar hkTypeVm::Program::ArrayInstruction::getDstVar(_In_ void* dstAddr) const { return hkReflect::ArrayVar(dstAddr, getDstType()); }

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
