// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT    : COMMON
// VISIBILITY : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/System/hkBaseSystem.h>
#include <Common/Base/Reflect/TypeReg/Detail/hkTypeRegDetail.h>

// The head of the list for this DLL, which gets added to the registry singleton
hkReflect::Detail::TypeRegNode* hkReflect::Detail::TypeRegNode::s_listHead;
bool hkReflect::Detail::TypeRegNode::s_accessedListHead = false;

#define POINTER_CLEAR_BITS(v) POINTER_CLEAR_BIT(v, 0x03)
#define POINTER_CLEAR_BIT(v,b) hkClearBits(v, b)
#define POINTER_GET_BIT(v,b) ((hkUlong(v) & b) != 0)
#define POINTER_SET_BIT(v,b) hkSetBits(v, b)

hkReflect::Detail::TypeRegNode::TypeRegNode(_In_ hkReflect::Type* type)
    : m_next(POINTER_CLEAR_BITS(s_listHead)), m_type(type), m_right(nullptr), m_left(nullptr)
{
    HK_ASSERT(0x2a8c3491, !s_accessedListHead, "This constructor automatically registers types, and is intended only for the static initialization in excutables and dynamic libraries.");
    s_listHead = this;
}

hkReflect::Detail::TypeRegNode::TypeRegNode(_In_ hkReflect::Type* type, _In_opt_ hkReflect::Detail::TypeRegNode* next)
    : m_next(next), m_type(type), m_right(nullptr), m_left(nullptr)
{
}

bool hkReflect::Detail::TypeRegNode::typeIsUsed() const
{
    return POINTER_GET_BIT(m_next, 0x1);
}

void hkReflect::Detail::TypeRegNode::markTypeUsed()
{
    m_next = POINTER_SET_BIT(m_next, 0x1);
}

_Ret_maybenull_ const hkReflect::Detail::TypeRegNode* hkReflect::Detail::TypeRegNode::getNext() const
{
    return POINTER_CLEAR_BITS(m_next);
}

_Ret_maybenull_ hkReflect::Detail::TypeRegNode* hkReflect::Detail::TypeRegNode::getNext()
{
    return POINTER_CLEAR_BITS(m_next);
}

bool hkReflect::Detail::TypeRegNode::typeIsDuplicate() const
{
    return POINTER_GET_BIT(m_next, 0x2);

}
/// Mark the type as used
void hkReflect::Detail::TypeRegNode::markTypeDuplicate(bool dup)
{
    if (dup)
    {
        m_next = POINTER_SET_BIT(m_next, 0x2);
    }
    else
    {
        m_next = POINTER_CLEAR_BIT(m_next, 0x2);
    }
}

void hkReflect::Detail::TypeRegNode::setChildren(_In_opt_ hkReflect::Detail::TypeRegNode* left, _In_opt_ hkReflect::Detail::TypeRegNode* right)
{
    // There are still some types that are not strictly equal but that will compare as such
    // T*, hkRefPtr<T> will all match, hkArray<X> and hkArray<const X> will match etc.
    // Allow equality here, we will return whichever one we randomly hit first in the list
    HK_ASSERT(0x721b3850, left == nullptr || (hkReflect::Type::compareName(left->getType(), right->getType()) <= 0), "Invalid sorting order");
    m_left = left;
    m_right = right;
}

_Ret_maybenull_ hkReflect::Detail::TypeRegNode* hkReflect::Detail::TypeRegNode::getFirstLocalEntry()
{
    s_accessedListHead = true;
    return POINTER_CLEAR_BITS(s_listHead);
}

bool hkReflect::Detail::TypeRegNode::isLocalEntryRegistered()
{
    if (hkReflect::Detail::TypeRegNode* typeRegNode = getFirstLocalEntry())
    {
        if (hkReflect::Detail::BuiltinTypeReg::getInstance().isInitialised())
        {
            return hkReflect::Detail::BuiltinTypeReg::getInstance().isRegistered(getFirstLocalEntry());
        }
        else
        {
            return false;
        }
    }

    return true;
}

hkResult HK_CALL hkReflect::Detail::TypeRegNode::addToBuiltinRegistry(void*)
{
    if (hkReflect::getTypeReg())
    {
        if (hkReflect::Detail::TypeRegNode* typeRegNode = getFirstLocalEntry())
        {
            addToBuiltinRegistry(typeRegNode);
        }
        return HK_SUCCESS;
    }
    return HK_FAILURE;
}
hkResult HK_CALL hkReflect::Detail::TypeRegNode::removeFromBuiltinRegistry(void*)
{
    if (hkReflect::getTypeReg())
    {
        if (hkReflect::Detail::TypeRegNode* typeRegNode = getFirstLocalEntry())
        {
            removeFromBuiltinRegistry(typeRegNode);
        }
    }
    return HK_SUCCESS;
}

static hkBaseSystem::InitNode s_initTypeReg("Register Types",
    &hkReflect::Detail::TypeRegNode::addToBuiltinRegistry,
    &hkReflect::Detail::TypeRegNode::removeFromBuiltinRegistry);

#if defined(HK_MEMORY_TRACKER_ENABLE)

#include <Common/Base/Memory/Tracker/hkMemoryTrackerRegistry.h>

hkReflect::Detail::TrackerRegNode* hkReflect::Detail::TrackerRegNode::s_head = nullptr;
bool hkReflect::Detail::TrackerRegNode::s_accessedHead = false;

hkReflect::Detail::TrackerRegNode::TrackerRegNode(hkReflect::Detail::TypeData type, Handle handle, bool fixup)
    : m_type(POINTER_SET_BIT(reinterpret_cast<hkReflect::Type*>(type), fixup)), m_handle(handle), m_next(s_head)
{
    HK_ASSERT( 0x22441293, !s_accessedHead, "This constructor automatically registers tracked types, and is intended only for the static initialization in excutables and dynamic libraries." );
    s_head = this;
}

const hkReflect::Detail::TrackerRegNode* hkReflect::Detail::TrackerRegNode::getFirstLocalEntry()
{
    s_accessedHead = true;
    return s_head;
}

hkResult hkReflect::Detail::TrackerRegNode::addToBuiltinRegistry(_Inout_ void*)
{
    if (hkMemoryTrackerRegistry::isInitialised())
    {
        if (const hkReflect::Detail::TrackerRegNode* typeRegNode = getFirstLocalEntry())
        {
            addToBuiltinRegistry(typeRegNode);
        }
        return HK_SUCCESS;
    }
    return HK_FAILURE;
}

hkResult hkReflect::Detail::TrackerRegNode::removeFromBuiltinRegistry(_Inout_ void*)
{
    if (hkMemoryTrackerRegistry::isInitialised())
    {
        if (const hkReflect::Detail::TrackerRegNode* typeRegNode = getFirstLocalEntry())
        {
            removeFromBuiltinRegistry(typeRegNode);
        }
        return HK_SUCCESS;
    }
    return HK_FAILURE;
}


static hkBaseSystem::InitNode s_initTrackerReg("Register Tracker Types",
    &hkReflect::Detail::TrackerRegNode::addToBuiltinRegistry,
    &hkReflect::Detail::TrackerRegNode::removeFromBuiltinRegistry);

#endif

#undef POINTER_CLEAR_BITS
#undef POINTER_CLEAR_BIT
#undef POINTER_GET_BIT
#undef POINTER_SET_BIT

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
