// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

namespace hkReflect {
namespace Detail {

    /// Static instances of this class are in the generated reflection
    /// files. This ensures all known types are added on startup.
    /// The file hkTypeRegNode.cxx should be included in any DLL which contains reflection data.
    struct TypeRegNode
    {
    public:
        HK_DECLARE_CLASS(TypeRegNode, NoNew);

        /// Constructor which automatically registers the entry.
        /// This should only be used in static data.
        TypeRegNode(_In_ hkReflect::Type* type);

        /// Constructor which doesn't automatically register the entry.
        TypeRegNode(_In_ hkReflect::Type* type, _In_opt_ TypeRegNode* next);

        ///
        _Ret_maybenull_ TypeRegNode* getNext();
        _Ret_maybenull_ const TypeRegNode* getNext() const;

        ///
        _Ret_notnull_ hkReflect::Type* getType() { return m_type; }
        _Ret_notnull_ const hkReflect::Type* getType() const { return m_type; }

        // Internal use
        void setChildren(_In_opt_ TypeRegNode* left, _In_opt_ TypeRegNode* right);

        _Ret_maybenull_ const TypeRegNode* getLeft() const { return m_left; }
        _Ret_maybenull_ const TypeRegNode* getRight() const { return m_right; }

    public:

        /// Check if this type was used directly.
        /// Typically types are marked used when accessed by name.
        /// Types may be used even though the flag is not set (e.g. indirectly via parent or field)
        bool typeIsUsed() const;
        /// Mark the type as used
        void markTypeUsed();

        /// Check if this type was used directly.
        /// Typically types are marked used when accessed by name.
        /// Types may be used even though the flag is not set (e.g. indirectly via parent or field)
        bool typeIsDuplicate() const;
        /// Mark the type as used
        void markTypeDuplicate(bool dup);

        static hkResult HK_CALL addToBuiltinRegistry(_Inout_ void*);
        static hkResult HK_CALL removeFromBuiltinRegistry(_Inout_ void*);
        static _Ret_maybenull_ TypeRegNode* HK_CALL getFirstLocalEntry();
        static bool HK_CALL isLocalEntryRegistered();

    private:

        static TypeRegNode* s_listHead;
        static bool s_accessedListHead;

        HK_EXPORT_COMMON static void addToBuiltinRegistry(_Inout_ TypeRegNode* head);
        HK_EXPORT_COMMON static void removeFromBuiltinRegistry(_Inout_ TypeRegNode* head);

        /// A list corresponding to the types in a library.
        /// This list gets merged with the lists of other projects by the type registry.
        mutable TypeRegNode* m_next;

        /// The registered type
        hkReflect::Type* m_type;

        /// An entry which is lexicographically greater than this entry or null.
        TypeRegNode* m_right;
        /// An entry which is lexicographically less than this entry or null.
        TypeRegNode* m_left;
    };

#if defined(HK_MEMORY_TRACKER_ENABLE)
    /// Equivalent of TypeRegNode for tracker types.
    class TrackerRegNode
    {
    public:
        HK_DECLARE_CLASS(TrackerRegNode, NoNew);

        
        typedef const hkUint16* Handle;

        TrackerRegNode(TypeData type, Handle handle, bool fixup);

        _Ret_notnull_ hkReflect::Type* getType() const;
        bool mustFixup() const;

        HK_ALWAYS_INLINE Handle getHandle() const { return m_handle; }
        HK_ALWAYS_INLINE _Ret_maybenull_ const TrackerRegNode* getNext() const { return m_next; }

        static hkResult HK_CALL addToBuiltinRegistry(_Inout_ void*);
        static hkResult HK_CALL removeFromBuiltinRegistry(_Inout_ void*);
        static _Ret_maybenull_ const TrackerRegNode* HK_CALL getFirstLocalEntry();

    private:
        HK_EXPORT_COMMON static void addToBuiltinRegistry(_Inout_ const TrackerRegNode* head);
        HK_EXPORT_COMMON static void removeFromBuiltinRegistry(_Inout_ const TrackerRegNode* head);

    private:
        // Last bit of this is set if the type must be fixed up.
        hkReflect::Type* m_type;
        Handle m_handle;
        const TrackerRegNode* m_next;

        static TrackerRegNode* s_head;
        static bool s_accessedHead;
    };
#endif

}
} // hkReflect.Detail

// Manually register a type, this should only be used for type with hk::ManualTypeRegistration
#define HK_MANUALLY_REGISTER_TYPE(cppType, cppTypeUniqueName) hkReflect::Detail::TypeRegNode cppTypeUniqueName ## _typeRegNode(HK_REFLECT_GET_NON_CONST_TYPE(cppType))

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
