// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/Reflect/TypeReg/Detail/hkTypeRegNode.h>
#include <Common/Base/Reflect/TypeReg/Detail/hkTypeRegDetail.h>
#include <Common/Base/Reflect/Core/Detail/hkReflectTypeDetail.h>
#include <Common/Base/Object/hkSingleton.h>
#include <Common/Base/Fwd/hkcstring.h>

#if !defined(HK_DYNAMIC_DLL)
#include <Common/Base/Reflect/TypeReg/Detail/hkTypeRegNode.hxx>
#endif

#define POINTER_CLEAR_BITS(v) POINTER_CLEAR_BIT(v, 0x03)
#define POINTER_CLEAR_BIT(v,b) hkClearBits(v, b)
#define POINTER_GET_BIT(v,b) ((hkUlong(v) & b) != 0)


void hkReflect::Detail::TypeRegNode::addToBuiltinRegistry(_Inout_ TypeRegNode* head)
{
    hkReflect::Detail::BuiltinTypeReg::getInstance().addBatch(head);
}

void hkReflect::Detail::TypeRegNode::removeFromBuiltinRegistry(_Inout_ TypeRegNode* head)
{
    hkReflect::Detail::BuiltinTypeReg::getInstance().removeBatch(head);
}

#if defined(HK_MEMORY_TRACKER_ENABLE)

#include <Common/Base/Memory/Tracker/hkMemoryTrackerRegistry.h>

hkReflect::Type* hkReflect::Detail::TrackerRegNode::getType() const { return POINTER_CLEAR_BIT(m_type, 0x1); }
bool hkReflect::Detail::TrackerRegNode::mustFixup() const { return POINTER_GET_BIT(m_type, 0x1); }

void hkReflect::Detail::TrackerRegNode::addToBuiltinRegistry(_Inout_ const TrackerRegNode* head)
{
    hkMemoryTrackerRegistry::getInstance().addEntries(head);
}

void hkReflect::Detail::TrackerRegNode::removeFromBuiltinRegistry(_Inout_ const TrackerRegNode* head)
{
    hkMemoryTrackerRegistry::getInstance().removeEntries(head);
}

#endif

#undef POINTER_CLEAR_BITS
#undef POINTER_CLEAR_BIT
#undef POINTER_GET_BIT

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
