// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/Base/Reflect/TypeReg/hkTypeReg.h>
#include <Common/Base/Thread/CriticalSection/hkCriticalSection.h>
#include <Common/Base/Serialize/Util/hkSerializeMultiMap.h>
#include <Common/Base/Reflect/Util/hkReflectionCheckUtil.h>

namespace hkReflect {
namespace Detail
{
    class HK_EXPORT_COMMON BuiltinTypeReg : public hkReflect::MutableTypeReg
    {
    public:
        HK_DECLARE_CLASS(BuiltinTypeReg, New, Singleton);

        BuiltinTypeReg();
        ~BuiltinTypeReg();

        virtual _Ret_maybenull_ const hkReflect::Type* typeFromName(_In_z_ const char* name) const HK_OVERRIDE;
        virtual _Ret_maybenull_ const hkReflect::Type* typeFromType(_In_opt_ const hkReflect::Type* type) const HK_OVERRIDE;
        virtual _Ret_maybenull_ const hkReflect::Type* builtinFromFormat(hkUint32 format) const;

        virtual hkResult add(_Inout_ hkReflect::Type* type) HK_OVERRIDE;
        virtual hkResult remove(_Inout_ hkReflect::Type* type) HK_OVERRIDE;

        virtual Subscription subscribeForChange(TypesChangedFunc func, _In_ void* data) HK_OVERRIDE;
        virtual void appendAllTypesToArray(hkArray<const Type*>& types) const HK_OVERRIDE;

        void addBatch(_Inout_ TypeRegNode* head);
        void removeBatch(_Inout_ TypeRegNode* head);
        bool isRegistered(_In_ TypeRegNode* head) const;

        void notifyTypesMutated() HK_OVERRIDE;
        _Ret_maybenull_ const TypeRegNode* getNameTreeRoot() const { return m_nameTreeRoot; }


    protected:

        void rebuildEverything();
        void fireCallbacks(const TypesChangedFuncArgs& args);

        const TypeRegNode* m_nameTreeRoot;

        hkArray<TypeRegNode*> m_lists;

        // This lock only protects the subsequent members.
        // All the previous fields are assumed to be set up at init time.
        mutable hkCriticalSection m_lock;
        struct SubscriptionImpl;
        friend struct SubscriptionImpl;
        // The refptr in Subscription owns these. The impl destructor sets its own impl in this array to null.
        hkArray< SubscriptionImpl* > m_subscriptions;
        hkArray<Type*> m_extraTypes;
        hkMap<hkUlong, const Type*> m_typeFromFormat;
        hkSerializeMultiMap<const Type*, Type*> m_duplicates;

        /// Incremental type checker.
        CheckUtil::IncrementalChecker m_checker;

    protected:

        /// Searches the tree rooted at \ref m_nameTreeRoot for a type in this type
        /// registry with the same name as the type passed as argument. It returns
        /// this type if it's found or HK_NULL otherwise.
        ///
        /// This function is similar to (this class's implementation of)
        /// \ref typeFromType, but only checks the types in the tree with root
        /// \ref m_nameTreeRoot, while types in m_extraTypes are ignored.
        _Ret_maybenull_ const hkReflect::Type* treeTypeFromType(_In_ const hkReflect::Type* type) const;
    };
}
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
