// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/Reflect/ReflectFile/hkSimpleToken.h>

// This class is the simple base for tokenization of c/c++ like source files.
class HK_EXPORT_COMMON hkSimpleTokenizer
{
public:

    hkSimpleTokenizer(_In_z_ const char* str, _In_opt_z_ const char* originalFileName = HK_NULL, hkUint32 lineOffset = 0);

    hkSimpleTokenizer(const hkStringView& str, _In_opt_z_ const char* originalFileName = HK_NULL, hkUint32 lineOffset = 0);

    bool getNext(hkSimpleToken& token);

    bool peek(hkSimpleToken& token);

    // enables / disables parsing of <[...]> tokens as strings (e.g. when parsing preprocessor style code)
    HK_INLINE void setPreprocessorStyleStringParsing(bool preprocessorStyleStrings);

    _Ret_opt_z_ const char* getOriginalFileName() const;

private:

    HK_INLINE bool isNewLine(char chr);

    HK_INLINE bool isEnd(_In_z_ const char* chr) const;

    hkSimpleToken::StringType::Enum getStringBeginDelimiter(char chr) const;

    hkSimpleToken::StringType::Enum getStringEndDelimiter(char chr) const;

    const char* m_originalFileName;

    const char* m_str;

    hkUint32 m_strLen;

    hkUint32 m_offset;

    hkUint32 m_lineNumber;

    bool m_preprocessorStyleStrings;
};

#include <Common/Base/Reflect/ReflectFile/hkSimpleTokenizer.inl>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
