// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

class HK_EXPORT_COMMON hkSimpleToken
{
    public:

        hkSimpleToken()
            : m_start(HK_NULL), m_length(0), m_lineNumber(0), m_stringLiteralType(StringType::NONE)
        {
        }

        HK_INLINE hkSimpleToken(_In_z_ const char* start, hkUint32 length, hkUint32 lineNumber)
            : m_start(start), m_length(length), m_lineNumber(lineNumber), m_stringLiteralType(StringType::NONE)
        {
        }


        HK_INLINE bool operator == (_In_z_ const char* other ) const
        {
            const hkUint32 otherLength = static_cast<hkUint32>(hkString::strLen( other ));

            if(m_length != otherLength)
                return false;

            return hkString::strNcmp(other, m_start, m_length) == 0;
        }

        HK_INLINE bool operator != (_In_z_ const char* other ) const
        {
            return hkString::strNcmp(other, m_start, m_length) != 0;
        }

        bool copyToBuffer(_Out_writes_opt_(maxLength) char* buffer, hkUint32 maxLength) const;

        template<hkUint32 bufferSize> bool copyToBuffer( char (&buffer)[bufferSize] ) const
        {
            return copyToBuffer(buffer, bufferSize);
        }

        HK_INLINE bool startsWith(_In_z_ const char* start ) const
        {
            hkUint32 prefixLength = hkString::strLen(start);

            if(m_length < prefixLength)
                return false;

            return hkString::strNcmp(start, m_start, hkMath::min2(m_length, prefixLength)) == 0;
        }

        HK_INLINE _Ret_z_ const char* getStart() const { return m_start; }

        HK_INLINE _Ret_z_ const char* getEnd() const { return m_start + m_length; }

        HK_INLINE hkUint32 getLength() const { return m_length; }

        HK_INLINE hkUint32 getLineNumber() const { return m_lineNumber; }

        struct StringType
        {
            enum Enum
            {
                NONE = 0,   // 0 explicitly specified on purpose, so conversion of this enum value to 'bool' produces 'false'
                QUOTED,
                ANGLE_BRACKETED
            };
        };

        HK_INLINE StringType::Enum getStringLiteralType() const { return m_stringLiteralType; }

        HK_INLINE bool isValid() const { return m_start != HK_NULL && m_length > 0; }

        bool isValidIdentifier() const;

        bool isValidInteger( hkInt32& result ) const;

        bool isValidFloat( hkReal& result ) const;

        bool isValidBool( bool& result ) const;

    protected:

        friend class hkSimpleTokenizer;

        const char* m_start;

        hkUint32 m_length;

        hkUint32 m_lineNumber;

        StringType::Enum m_stringLiteralType;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
