// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

namespace hkReflect
{
namespace Detail
{
    /// Implements allocation/deallocation through an hkMemoryAllocator passed on construction.
    struct HK_EXPORT_COMMON CustomAllocImpl : public AllocationImpl
    {
    public:
        HK_DECLARE_CLASS(CustomAllocImpl, New);
        /// A null allocator means use the global heap
        CustomAllocImpl(_In_opt_ hkMemoryAllocator* mem = HK_NULL) : m_allocator(mem) {}

        virtual Var allocate(_In_ const hkReflect::Type* type) const HK_OVERRIDE
        {
            return hkReflect::Detail::allocateDefault(type, allocator());
        }
        virtual Var allocateForClone(const Var& src, _In_ const Type* type) const HK_OVERRIDE
        {
            return allocate(type);
        }
        virtual void deallocate(_Inout_ void* target, _In_ const hkReflect::Type* type) const HK_OVERRIDE
        {
            hkReflect::Detail::deallocateDefault(target, type, allocator());
        }

    protected:
        hkMemoryAllocator& allocator() const { return *(m_allocator ? m_allocator : hkMemHeapAllocator()); }
        hkMemoryAllocator* m_allocator;
    };

    /// hkReferencedObject derived objects. Allocates and sets memsizeAndFlags.
    /// Handles relarrays appropriately.
    struct ReferencedObjectAllocImpl : public AllocationImpl
    {
        HK_DECLARE_CLASS(ReferencedObjectAllocImpl, New);

        ReferencedObjectAllocImpl() {}

        static const ReferencedObjectAllocImpl s_instance;

        virtual Var allocateForClone(const Var& src, _In_ const hkReflect::Type* type) const HK_OVERRIDE;
        virtual Var allocate(_In_ const Type* type) const HK_OVERRIDE;
        virtual void deallocate(_Inout_ void* target, _In_ const hkReflect::Type* type) const HK_OVERRIDE;

        virtual bool isInPlaceConstructible(_In_ const hkReflect::Type* type) const HK_OVERRIDE;
    };

    //
    // Arrays
    //

        /// Pointer and int size.
    struct HK_EXPORT_COMMON StaticArrayImpl : public ArrayImpl
    {
        HK_DECLARE_CLASS(StaticArrayImpl, New, EmptyCtor);
        struct AnyArray { hkUint8* begin; hkUint8* end; };

        static const StaticArrayImpl s_instance;

        virtual hkResult getValue(_In_ const void* addr, _In_ const ArrayType* type, _Out_ ArrayValue* val) const HK_OVERRIDE;
        virtual hkResult setNumElements(_Inout_ void* arrAddr, _In_ const ArrayType* arrType, int len) const HK_OVERRIDE;
    };

    struct HK_EXPORT_COMMON hkArrayImpl : public ArrayImpl
    {
    public:
        // Default instance which uses the thread-local heap.
        static const hkArrayImpl s_instance;

        static HK_INLINE void* getDataPointerInline(_Inout_ void* p) { return static_cast<Dummy_hkArray*>(p)->ptr; }
        static HK_INLINE int getCountInline(_In_ const void* p) { return static_cast<const Dummy_hkArray*>(p)->size; }

        hkArrayImpl(hkMemoryAllocator* a);
        hkArrayImpl();

        virtual hkResult getValue(_In_ const void* addr, _In_ const hkReflect::ArrayType* type, _Out_ ArrayValue* val) const HK_OVERRIDE;
        virtual hkResult setNumElements(_Inout_ void* arrAddr, _In_ const hkReflect::ArrayType* arrType, int len) const HK_OVERRIDE;
        virtual hkResult spliceInto(_Inout_ void* arrAddr, _In_ const hkReflect::ArrayType* arrType, int index, int numToDel, const hkReflect::ArrayValue& var) const HK_OVERRIDE;
        virtual AllocResult allocateElements(_Inout_ void* arrAddr, _In_ const ArrayType* arrType, QualType elemType, int len) const HK_OVERRIDE;
        virtual hkResult inplaceFixup(_Inout_ void* self, _In_ const Type* selfType, _Inout_ void* target, _In_ const Type* targetType, int count) const HK_OVERRIDE;
        virtual void clearAllocs(_Inout_ void* arrAddr, _In_ const ArrayType* type) const HK_OVERRIDE;

        static void HK_CALL fixupReflectedMethods(_Inout_ hkReflect::Type* type);
        static void HK_CALL copyConstructHelper(_Inout_ void* target, _In_ const void* source, _In_ const hkReflect::Type* type, int num);
        static void HK_CALL copyAssignHelper(_Inout_ void* target, _In_ const void* source, _In_ const hkReflect::Type* type, int num);
        static void HK_CALL destructorHelper(_Inout_ void* target, _In_ const hkReflect::Type* type, int num);

    protected:
        struct Dummy_hkArray { void* ptr; int size; int cap; };
        void allocateBuffer(_Inout_ Dummy_hkArray* array, int elemSize, int len) const;
        hkResult _setNumElements(_Inout_ Dummy_hkArray* array, _In_ const hkReflect::Type* elementType, int len) const;
        hkResult _spliceInto(_Inout_ Dummy_hkArray* array, _In_ const hkReflect::Type* elementType, int index, int numToDel, const hkReflect::ArrayValue& var) const;
        virtual AllocResult _allocateElements(_Inout_ Dummy_hkArray* array, _In_opt_ const ArrayType* arrType, _In_ const hkReflect::Type* elementType, int len) const;
        void clearAllocsInternal(_Inout_ void* arrAddr, _In_ const hkReflect::Type* subType) const;

    protected:
        // If not null, use this allocator else use thread local heap.
        hkMemoryAllocator* m_mem;
    };

    struct HK_EXPORT_COMMON hkInplaceArrayImpl : public hkArrayImpl
    {
    public:
        hkInplaceArrayImpl() {}
        static const hkInplaceArrayImpl s_instance;
    protected:
        virtual AllocResult _allocateElements(_Inout_ Dummy_hkArray* array, _In_ const ArrayType* arrType, _In_ const hkReflect::Type* elementType, int len) const HK_OVERRIDE;
    };

    /// Corresponds to a struct { void* data; int size; int cap; Type* elemType };
    struct HK_EXPORT_COMMON HomogeneousArrayImpl : public hkArrayImpl
    {
        enum Flags
        {
            CAPACITY_MASK = int(0x7FFFFFFF),
            FLAG_MASK = int(0x80000000),
            DONT_DEALLOCATE_FLAG = int(0x80000000), // Indicates that the storage is not the array's to delete
        };

        struct InMemory
        {
            void* ptr;
            int size;
            int cap;
            const hkReflect::Type* elementType;
        };

        static const HomogeneousArrayImpl s_instance;
        HomogeneousArrayImpl(hkMemoryAllocator* a) : hkArrayImpl(a) {}

        virtual hkResult getValue(_In_ const void* arrAddr, _In_ const ArrayType* arrType, _Out_ ArrayValue* val) const HK_OVERRIDE;
        virtual hkResult setNumElements(_Inout_ void* arrAddr, _In_ const ArrayType* arrTypey, int len) const HK_OVERRIDE;
        virtual hkResult spliceInto(_Inout_ void* arrAddr, _In_ const ArrayType* arrType, int index, int numToDel, const ArrayValue& val) const HK_OVERRIDE;
        virtual AllocResult allocateElements(_Inout_ void* arrAddr, _In_ const ArrayType* arrType, QualType elemType, int len) const HK_OVERRIDE;
        virtual hkResult inplaceFixup(_Inout_ void* self, _In_ const Type* selfType, void* target, _In_ const Type* targetType, int count) const HK_OVERRIDE;
        virtual void clearAllocs(_Inout_ void* arrAddr, _In_ const ArrayType* type) const HK_OVERRIDE;
    };


    //
    // Record
    //

    struct HK_EXPORT_COMMON HavokRecordImpl : public RecordImpl
    {
        HK_DECLARE_CLASS(HavokRecordImpl, New);
        HavokRecordImpl() {}

        virtual hkResult setValue(_Inout_ void* addr, _In_ const RecordType* type, const RecordVar& other) const HK_OVERRIDE;
        virtual hkResult getValue(_In_ const void* addr, _In_ const RecordType* type, _Inout_ RecordVar* val) const HK_OVERRIDE;

        static const HavokRecordImpl s_instance;
    };


    //
    // String
    //

        // A char* which comes from a havok allocator.
    struct HK_EXPORT_COMMON HavokStringImpl : public StringImpl
    {
        HavokStringImpl() { /* keep clang happy */ }
        static const HavokStringImpl s_instance;

        /// A null allocator means use the global heap
        HavokStringImpl(hkMemoryAllocator* alloc);

        virtual hkResult setValue(_Inout_ void* addr, _In_ const hkReflect::StringType* type, StringValue newValue) const HK_OVERRIDE;
        virtual hkResult getValue(_In_ const void* addr, _In_ const hkReflect::StringType* type, _Out_ StringValue* val) const HK_OVERRIDE;
        virtual void clearAllocs(_Inout_ void* string, _In_ const StringType* type) const HK_OVERRIDE;

        hkMemoryAllocator* m_allocator;
    };


    //
    // Pointer
    //

    /// Implementation used for hkViewPtr.
    struct HK_EXPORT_COMMON ViewPointerImpl : public RawPointerImpl
    {
        ViewPointerImpl() { /* keep clang happy */ }
        static const ViewPointerImpl s_instance;
    };

    struct HK_EXPORT_COMMON VarPropertyImpl : PointerImpl
    {
        typedef MethodTypes<Var>::GetterType GetterType;
        typedef MethodTypes<Var>::SetterType SetterType;

        GetterType m_get;
        SetterType m_set;

        VarPropertyImpl(GetterType mg, SetterType ms) : m_get(mg), m_set(ms) {}

        virtual hkResult setValue(_Inout_ void* addr, _In_ const hkReflect::PointerType* type, const Var& var) const HK_OVERRIDE;
        virtual hkResult getValue(_In_ const void* addr, _In_ const hkReflect::PointerType* type, _Out_ Var* val) const HK_OVERRIDE;
    };
}
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
