// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/Reflect/Impl/hkHavokImpl.h>
#include <Common/Base/Container/RelArray/hkRelArrayUtil.h>
#include <Common/Base/Container/RelArray/hkRelArray.h>
#include <Common/Base/Reflect/Util/hkReflectClone.h>
#include <Common/Base/Reflect/Core/Detail/hkReflectTypeDetail.h>
#include <Common/Base/Container/Array/hkVariantArray.h>

#if defined(HK_MEMORY_TRACKER_ENABLE)
#include <Common/Base/Memory/Tracker/hkMemoryTrackerSnapshot.h>
#include <Common/Base/Memory/Tracker/hkMemoryTrackerRegistry.h>
#endif

const hkReflect::Detail::HomogeneousArrayImpl hkReflect::Detail::HomogeneousArrayImpl::s_instance(HK_NULL);

hkReflect::Var hkReflect::Detail::ReferencedObjectAllocImpl::allocateForClone(const Var& src, _In_ const hkReflect::Type* type) const
{
    if( type->findAttribute<hk::ContainsRelArrays>() )
    {
        hkRelArrayUtil util(type->getSizeOf());
        int numRelArrays = 0;
        for( hkReflect::DeclIter<hkReflect::DataFieldDecl> it(type); it.advance(); )
        {
            const hkReflect::DataFieldDecl f = it.current();
            if( const ArrayType* at = f.getType()->asArray() )
            {
                typedef hkRelArray<char> RelArray;
                HK_ASSERT_NO_MSG(0x70272600, hkString::strCmp( getType<hkRelArray<char> >()->getName(), getType<hkRelArray<int> >()->getName() ) == 0 );
                if( (at->getSizeOf() == sizeof(RelArray)) && (at->getFixedCount() <= 0) )
                {
                    if( hkString::strCmp( at->getName(), getType<RelArray>()->getName() ) == 0 )
                    {
                        util.addRelArray( src, type, f.getName() ); 
                        numRelArrays += 1;
                    }
                }
            }
        }
        HK_ASSERT_NO_MSG(0x63558b3f, numRelArrays > 0);
        Var res(util.allocate(), type);
        HK_MEMORY_TRACKER_ADD_MANUAL(HK_NULL, type, res.getAddress(),
            static_cast<hkReferencedObject*>(res.getAddress())->getMemorySizeAndFlags(), true);
        return res;
    }
    // else we don't have relarrays
    return allocate(type);
}

hkReflect::Var hkReflect::Detail::ReferencedObjectAllocImpl::allocate(_In_ const hkReflect::Type* type) const
{
    hkReflect::Var res = hkReflect::Detail::allocateDefault(type);
    static_cast<hkReferencedObject*>(res.getAddress())->setMemorySizeAndFlags(hkReferencedObject::AUTO_MEMSIZE);
    return res;
}

void hkReflect::Detail::ReferencedObjectAllocImpl::deallocate(_Inout_ void* target, _In_ const hkReflect::Type* type) const
{
    HK_MEMORY_TRACKER_REMOVE(target);
    hkReferencedObject* b = static_cast<hkReferencedObject*>(target);
    hkMemHeapBlockFree<void>(b, (b->getMemorySizeAndFlags() == hkReferencedObject::AUTO_MEMSIZE) ?
        type->getSizeOf() : b->getMemorySizeAndFlags());
}

bool hkReflect::Detail::ReferencedObjectAllocImpl::isInPlaceConstructible(_In_ const hkReflect::Type* type) const
{
    
    
    return !type->findAttribute<hk::ContainsRelArrays>();
}

const hkReflect::Detail::ReferencedObjectAllocImpl hkReflect::Detail::ReferencedObjectAllocImpl::s_instance;

//
// Record
//

hkResult hkReflect::Detail::HavokRecordImpl::setValue(_Inout_ void* addr, _In_ const RecordType* type, const RecordVar& other) const
{
    HK_ASSERT(0x2f905879, !type->hasCallbacks(), "Direct assignment cannot be used on a type with callbacks");

    // Try direct assignment.
    if (other.isInstanceOf(type) && !other.getType()->isProperty())
    {
        if (TypeDetail::copyAssign(addr, other.getAddress(), type).isSuccess())
        {
            return HK_SUCCESS;
        }
    }

    // Member-by-member impl-based assignment
    
    if (const RecordType* parent = type->getParentRecord())
    {
        HK_RETURN_IF_FAILED(parent->getImpl()->setValue(addr, parent, other));
    }
    RecordVar var(addr, type);
    for (DeclIter<FieldDecl> it(type); it.advance();)
    {
        Var tgt = var[it.current()];
        Var src = other[it.current()];
        HK_RETURN_IF_FAILED(tgt.assign(src));
    }
    return HK_SUCCESS;
}

hkResult hkReflect::Detail::HavokRecordImpl::getValue(_In_ const void* addr, _In_ const RecordType* type, _Inout_ hkReflect::RecordVar* val) const
{
    *val = RecordVar(addr,type);
    return HK_SUCCESS;
}

const hkReflect::Detail::HavokRecordImpl hkReflect::Detail::HavokRecordImpl::s_instance;


//
// String
//


hkReflect::Detail::HavokStringImpl::HavokStringImpl(hkMemoryAllocator* alloc)
    : m_allocator(alloc)
{
}

hkResult hkReflect::Detail::HavokStringImpl::setValue(_Inout_ void* string, _In_ const hkReflect::StringType* type, hkReflect::StringValue newValue) const
{
    hkMemoryAllocator& alloc = m_allocator ? *m_allocator : *hkMemHeapAllocator();
    char* dstBuffer = HK_NULL;
    if (newValue)
    {
        const int stringSize = hkString::strLen(newValue) + 1;
        dstBuffer = static_cast<char*>(alloc.blockAlloc(stringSize));
        hkString::memCpy(static_cast<char*>(dstBuffer), newValue, stringSize);
    }

    *reinterpret_cast<const char**>(string) = dstBuffer;
    return HK_SUCCESS;
}

hkResult hkReflect::Detail::HavokStringImpl::getValue(_In_ const void* string, _In_ const hkReflect::StringType* type, _Out_ hkReflect::StringValue* val) const
{
    *val = *static_cast<char const* const*>(string);
    return HK_SUCCESS;
}

void hkReflect::Detail::HavokStringImpl::clearAllocs(_Inout_ void* string, _In_ const StringType* type) const
{
    char* val = *static_cast<char**>(string);
    if (val)
    {
        hkMemoryAllocator& alloc = m_allocator ? *m_allocator : *hkMemHeapAllocator();
        const int stringSize = hkString::strLen(val);
        alloc.blockFree(val, stringSize + 1);
    }
}

const hkReflect::Detail::HavokStringImpl hkReflect::Detail::HavokStringImpl::s_instance(HK_NULL);

//
// Pointer
//

const hkReflect::Detail::ViewPointerImpl hkReflect::Detail::ViewPointerImpl::s_instance;



hkResult hkReflect::Detail::StaticArrayImpl::getValue(_In_ const void* arrAddr, _In_ const hkReflect::ArrayType* arrType, _Out_ hkReflect::ArrayValue* val) const
{
    const AnyArray* array = static_cast<const AnyArray*>(arrAddr);
    int byteLength = hkLosslessCast<int>(array->end - array->begin);
    HK_ASSERT_NO_MSG(0x39dcc0c5, byteLength % arrType->getSubType()->getSizeOf() == 0);
    *val = ArrayValue(array->begin, byteLength / arrType->getSubType()->getSizeOf(), arrType->getSubType() );
    return HK_SUCCESS;
}

hkResult hkReflect::Detail::StaticArrayImpl::setNumElements(_Inout_ void* arrAddr, _In_ const hkReflect::ArrayType* arrType, int len) const
{
    AnyArray* array = static_cast<AnyArray*>(arrAddr);
    return len == (array->end - array->begin) / arrType->getSubType()->getSizeOf() ? HK_SUCCESS : HK_FAILURE;
}

const hkReflect::Detail::StaticArrayImpl hkReflect::Detail::StaticArrayImpl::s_instance;

hkReflect::Detail::hkArrayImpl::hkArrayImpl(hkMemoryAllocator* a) : m_mem(a) {}
hkReflect::Detail::hkArrayImpl::hkArrayImpl() : m_mem(HK_NULL) {}

hkResult hkReflect::Detail::hkArrayImpl::getValue(_In_ const void* arrAddr, _In_ const hkReflect::ArrayType* arrType, _Out_ hkReflect::ArrayValue * val) const
{
    const Dummy_hkArray* array = static_cast<const Dummy_hkArray*>(arrAddr);
    *val = hkReflect::ArrayValue(array->ptr, array->size, arrType->getSubType() );
    return HK_SUCCESS;
}

void hkReflect::Detail::hkArrayImpl::allocateBuffer(_Inout_ Dummy_hkArray* array, int elemSize, int len) const
{
    const int capMask = hkArrayBase<char>::CAPACITY_MASK;
    int oldCap = array->cap & capMask;
    if (len > oldCap)
    {
        hkMemoryAllocator& alloc = m_mem ? *m_mem : hkContainerHeapAllocator().get(array); 
        hkArrayUtil::_reserve(alloc, array, len, elemSize);
        HK_ASSERT_NO_MSG(0x7b32ca25, (array->cap & capMask) > oldCap);
    }
    array->size = len;
}

hkResult hkReflect::Detail::hkArrayImpl::setNumElements(_Inout_ void* arrAddr, _In_ const hkReflect::ArrayType* arrType, int len) const
{
    Dummy_hkArray* array = static_cast<Dummy_hkArray*>(arrAddr);
    const hkReflect::Type* elementType = arrType->getSubType();
    return _setNumElements(array, elementType, len);
}

hkResult hkReflect::Detail::hkArrayImpl::_setNumElements(_Inout_ Dummy_hkArray* array, _In_ const hkReflect::Type* elementType, int len) const
{
    HK_ASSERT_NO_MSG(0x574d7d64, elementType);
    const int oldSize = array->size;
    const int elemSize = elementType->getSizeOf();

    if( len == oldSize )
    {
        return HK_SUCCESS;
    }

    if ( len < oldSize )
    {
        // destruct old elements
        array->size = len;
        hkReflect::TypeDetail::destruct(hkAddByteOffset(array->ptr, len*elemSize), elementType, oldSize-len);
        return HK_SUCCESS;
    }

    // early out if the element type is not default-constructible
    Detail::UnaryFunction defaultConstructionFunction = HK_NULL;
    if (len > oldSize)
    {
        defaultConstructionFunction = hkReflect::TypeDetail::getDefaultConstructionFunction(elementType);
        if (!defaultConstructionFunction)
        {
            return HK_FAILURE;
        }
    }

    allocateBuffer(array, elemSize, len);

    // construct new elements
    if (len > oldSize)
    {
        defaultConstructionFunction(hkAddByteOffset(array->ptr, oldSize*elemSize), elementType, len-oldSize);
    }

    return HK_SUCCESS;
}

hkResult hkReflect::Detail::hkArrayImpl::spliceInto(_Inout_ void* arrAddr, _In_ const hkReflect::ArrayType* arrType, int index, int numToDel, const hkReflect::ArrayValue& toInsert) const
{
    const hkReflect::Type* elementType = arrType->getSubType();
    if (toInsert.getSubType() && !elementType->equals(toInsert.getSubType()))
    {
        return HK_FAILURE;
    }

    Dummy_hkArray* array = static_cast<Dummy_hkArray*>(arrAddr);
    return _spliceInto(array, elementType, index, numToDel, toInsert);
}

hkResult hkReflect::Detail::hkArrayImpl::_spliceInto(_Inout_ Dummy_hkArray* array, _In_ const hkReflect::Type* elementType, int index, int numToDel, const hkReflect::ArrayValue& toInsert) const
{
    if( index < 0 ) index = array->size;
    if( numToDel < 0 ) numToDel = array->size;

    HK_ASSERT_NO_MSG(0x328f4a17, index <= array->size );
    HK_ASSERT_NO_MSG(0x18b509b6, (index+numToDel) <= array->size );

    const int numToInsert = toInsert.getCount();
    const int newSize     = numToInsert + array->size - numToDel;
    const int numToMove   = array->size - index - numToDel;

    if( numToDel==0 && toInsert.getCount()==0)
    {
        return HK_SUCCESS;
    }

    HK_ASSERT_NO_MSG(0x41ca2a0a, elementType);
    const int elemSize = elementType->getSizeOf();

    // early out if the element type is not copy-constructible
    Detail::BinaryFunction copyConstructionFunction = HK_NULL;
    if (numToInsert > 0)
    {
        copyConstructionFunction = hkReflect::TypeDetail::getCopyConstructionFunction(elementType);
        if (!copyConstructionFunction)
        {
            
            return HK_FAILURE;
        }
    }

    allocateBuffer(array, elemSize, newSize);

    void* firstToDel = hkAddByteOffset(array->ptr, index * elemSize);
    const void* firstToMove = hkAddByteOffset(array->ptr, (index + numToDel) * elemSize);
    void* moveDest = hkAddByteOffset(array->ptr, (index + numToInsert) * elemSize);

    // destruct elements which will be overwritten
    if (numToDel > 0)
    {
        hkReflect::TypeDetail::destruct(firstToDel, elementType, numToDel);
    }

    // move forward/backward the last elements
    hkMemUtil::memMove(moveDest, firstToMove, numToMove*elemSize);

    // copies the new elements in the array
    if (numToInsert > 0)
    {
        copyConstructionFunction(firstToDel, toInsert.getAddress(), elementType, numToInsert);
    }

    return HK_SUCCESS;
}

hkReflect::Detail::ArrayImpl::AllocResult hkReflect::Detail::hkArrayImpl::allocateElements(_Inout_ void* arrAddr, _In_ const ArrayType* arrType, QualType elemType, int len) const
{
    if (!elemType->equals(arrType->getSubType()) || hkReflect::TypeDetail::getReflectConstructionFunction(elemType) == HK_NULL)
    {
        return ALLOC_FAILURE;
    }
    Dummy_hkArray* array = static_cast<Dummy_hkArray*>(arrAddr);
    return _allocateElements(array, arrType, elemType, len);
}

hkReflect::Detail::ArrayImpl::AllocResult hkReflect::Detail::hkArrayImpl::_allocateElements(_Inout_ Dummy_hkArray* array, _In_opt_ const ArrayType* /*arrType*/, _In_ const hkReflect::Type* elemType, int len) const
{
    const int capMask = hkArrayBase<char>::CAPACITY_MASK;
    if ((array->cap & capMask) != 0)
    {
        return ALLOC_NOT_EMPTY;
    }

    int elemSize = elemType->getSizeOf();
    allocateBuffer(array, elemSize, len);

    // Set new memory to 0 (bypass ctor might leave fields uninitialized)
    hkString::memSet(array->ptr, 0, elemSize * len);

    // Construct new elements
    hkReflect::TypeDetail::reflectConstruct(array->ptr, elemType, len);

    return ALLOC_SUCCESS;
}

hkResult hkReflect::Detail::hkArrayImpl::inplaceFixup(_Inout_ void* self, _In_ const Type* selfType, _Inout_ void* target, _In_ const Type* targetType, int count) const
{
    Dummy_hkArray* a = static_cast<Dummy_hkArray*>(self);
    a->ptr = target;
    a->size = count;
    a->cap = count | hkArray<char>::DONT_DEALLOCATE_FLAG;
    return HK_SUCCESS;
}

void HK_CALL hkReflect::Detail::hkArrayImpl::fixupReflectedMethods(_Inout_ hkReflect::Type* type)
{
    const ArrayType* arrType = type->asArray();
    HK_ASSERT_NO_MSG(0x2a5c3564, arrType);
    const Type* subType = arrType->getSubType();
    HK_ASSERT_NO_MSG(0x5d20e4cd, subType);

    // Def ctor and dtor are always available
    hkReflect::TypeDetail::localSetOptional<Opt::DEF_CONSTRUCTOR>(type, &ExplicitWrapper< Opt::DEF_CONSTRUCTOR, hkArray<char> >::func);
    hkReflect::TypeDetail::localSetOptional<Opt::DESTRUCTOR>(type, &destructorHelper);

    // Copy is available only if elements are copy-constructible.
    if (hkReflect::TypeDetail::getCopyConstructionFunction(subType))
    {
        hkReflect::TypeDetail::localSetOptional<Opt::COPY_CONSTRUCTOR>(type, &copyConstructHelper);
        hkReflect::TypeDetail::localSetOptional<Opt::COPY_ASSIGNMENT>(type, &copyAssignHelper);
    }
    else
    {
        hkReflect::TypeDetail::localSetOptional<Opt::COPY_CONSTRUCTOR>(type, nullptr);
        hkReflect::TypeDetail::localSetOptional<Opt::COPY_ASSIGNMENT>(type, nullptr);
    }
}

namespace
{
    const hkReflect::ArrayType* ashkArray(_In_ const hkReflect::Type* type)
    {
        // Get native type.
        type = hkReflect::TypeDetail::skipDecorators(type);
        const hkReflect::ArrayType* arr = type->asArray();
        HK_ASSERT_NO_MSG(0xc50d220, arr);
        HK_ASSERT_NO_MSG(0x336bb1b1, arr->getSubType());
        return arr;
    }
}

void hkReflect::Detail::hkArrayImpl::clearAllocs(_Inout_ void* arrAddr, _In_ const ArrayType* type) const
{
    clearAllocsInternal(arrAddr, type->getSubType());
}

void hkReflect::Detail::hkArrayImpl::clearAllocsInternal(_Inout_ void* arrAddr, _In_ const Type* elementType) const
{
    HK_COMPILE_TIME_ASSERT(int(hkArray<char>::DONT_DEALLOCATE_FLAG) == int(HomogeneousArrayImpl::DONT_DEALLOCATE_FLAG));

    Dummy_hkArray* t = static_cast<Dummy_hkArray*>(arrAddr);
    hkMemoryAllocator& alloc = m_mem ? *m_mem : hkContainerHeapAllocator().get(arrAddr); 

    // From hkArrayBase::_clearAndDeallocate().
    const int capMask = hkArrayBase<char>::CAPACITY_MASK;
    const int cap = t->cap & capMask;
    if (cap && (t->cap & hkArray<char>::DONT_DEALLOCATE_FLAG) == 0)
    {
        HK_ASSERT_NO_MSG(0x6b22d4b5, elementType);
        int numBytes = cap * elementType->getSizeOf();
        alloc.bufFree(t->ptr, numBytes);
    }
}

void HK_CALL hkReflect::Detail::hkArrayImpl::copyConstructHelper(_Inout_ void* target, _In_ const void* source, _In_ const hkReflect::Type* type, int num)
{
    const ArrayType* arrType = ashkArray(type);
    const hkReflect::Type* subType = arrType->getSubType();
    const hkArrayImpl* impl = static_cast<const hkArrayImpl*>(arrType->getImpl());

    for (int i = 0; i < num; ++i)
    {
        Dummy_hkArray* t = static_cast<Dummy_hkArray*>(target) + i;
        t->ptr = HK_NULL;
        t->size = 0;
        t->cap = hkArray<char>::DONT_DEALLOCATE_FLAG;

        const Dummy_hkArray* s = static_cast<const Dummy_hkArray*>(source) + i;
        ArrayValue val(s->ptr, s->size, subType);
        impl->_spliceInto(t, subType, 0, t->size, val);
    }
}

void HK_CALL hkReflect::Detail::hkArrayImpl::copyAssignHelper(_Inout_ void* target, _In_ const void* source, _In_ const hkReflect::Type* type, int num)
{
    const ArrayType* arrType = ashkArray(type);
    const hkReflect::Type* subType = arrType->getSubType();
    const hkArrayImpl* impl = static_cast<const hkArrayImpl*>(arrType->getImpl());

    for (int i = 0; i < num; ++i)
    {
        Dummy_hkArray* t = static_cast<Dummy_hkArray*>(target) + i;
        const Dummy_hkArray* s = static_cast<const Dummy_hkArray*>(source) + i;
        ArrayValue val(s->ptr, s->size, subType);
        impl->_spliceInto(t, subType, 0, -1, val);
    }
}

void HK_CALL hkReflect::Detail::hkArrayImpl::destructorHelper(_Inout_ void* target, _In_ const hkReflect::Type* type, int num)
{
    const ArrayType* arrType = ashkArray(type);
    const hkReflect::Type* subType = arrType->getSubType();
    const hkArrayImpl* impl = static_cast<const hkArrayImpl*>(arrType->getImpl());

    for (int i = 0; i < num; ++i)
    {
        Dummy_hkArray* t = static_cast<Dummy_hkArray*>(target)+i;
        if (t->size)
        {
            hkReflect::TypeDetail::destruct(t->ptr, subType, t->size);
        }
        impl->clearAllocsInternal(t, subType);
    }
}

#ifdef HK_MEMORY_TRACKER_ENABLE
void HK_CALL hkReflect::Tracker::hkArrayHandlerInternal(const Var& var, hkMemoryTrackerSnapshot& snapshot, int elemSize)
{
    struct Dummy_hkArray { void* ptr; int size; int cap; };
    Dummy_hkArray* t = static_cast<Dummy_hkArray*>(var.getAddress());
    if (t->cap && (t->cap & hkArray<char>::DONT_DEALLOCATE_FLAG) == 0)
    {
        hkMemoryTrackerSnapshot::Block block;
        block.m_name = "buffer_hkArray";
        block.m_ptr = t->ptr;
        block.m_type = var.getType()->asArray()->getSubType();
        block.m_num = t->size;
        block.m_size = t->cap * elemSize;
        snapshot.addLinkedBlock(block, true);
    }
}
#endif

const hkReflect::Detail::hkArrayImpl hkReflect::Detail::hkArrayImpl::s_instance;

hkReflect::Detail::ArrayImpl::AllocResult hkReflect::Detail::hkInplaceArrayImpl::_allocateElements(_Inout_ Dummy_hkArray* array, _In_ const ArrayType* arrType, _In_ const hkReflect::Type* elemType, int len) const
{
    const int sizeArr = arrType->getSizeOf();

    // Check that data ptr points inside the array. This check is done for convenience,
    // instead of explicitly testing that m_data == m_storage.get().
    if (array->ptr >= array && array->ptr < array + sizeArr)
    {
        // Memory should only be allocated if len exceeds the existing in-place capacity.
        if(len > (array->cap & hkArrayBase<char>::CAPACITY_MASK))
        {
            int elemSize = elemType->getSizeOf();
            allocateBuffer(array, elemSize, len);
            hkString::memSet(array->ptr, 0, elemSize * len);
        }
        else
        {
            array->size = len;
        }

        // Construct new elements
        hkReflect::TypeDetail::reflectConstruct(array->ptr, elemType, len);
        return ALLOC_SUCCESS;
    }

    return ALLOC_NOT_EMPTY;
}

const hkReflect::Detail::hkInplaceArrayImpl hkReflect::Detail::hkInplaceArrayImpl::s_instance;

hkResult hkReflect::Detail::HomogeneousArrayImpl::getValue(_In_ const void* arrAddr, _In_ const ArrayType* arrType, _Out_ hkReflect::ArrayValue * val) const
{
    const InMemory* a = static_cast<const InMemory*>(arrAddr);
    *val = ArrayValue(a->ptr, a->size, a->elementType );
    return HK_SUCCESS;
}

hkResult hkReflect::Detail::HomogeneousArrayImpl::setNumElements(_Inout_ void* arrAddr, _In_ const ArrayType* arrType, int len) const
{
    InMemory* array = static_cast<InMemory*>(arrAddr);
    
    if (!array->elementType)
    {
        return HK_FAILURE;
    }
    return _setNumElements(static_cast<Dummy_hkArray*>(arrAddr), array->elementType, len);
}

hkReflect::Detail::ArrayImpl::AllocResult hkReflect::Detail::HomogeneousArrayImpl::allocateElements(_Inout_ void* arrAddr, _In_ const ArrayType* arrType, QualType elemType, int len) const
{
    InMemory* array = static_cast<InMemory*>(arrAddr);
    HK_ASSERT_NO_MSG(0x212b1045, array->ptr == HK_NULL);
    HK_ASSERT_NO_MSG(0x212b1045, array->elementType == HK_NULL);
    array->elementType = elemType;
    if (hkReflect::TypeDetail::getReflectConstructionFunction(elemType) == HK_NULL)
    {
        return ALLOC_FAILURE;
    }
    return _allocateElements(static_cast<Dummy_hkArray*>(arrAddr), arrType, array->elementType, len);
}

hkResult hkReflect::Detail::HomogeneousArrayImpl::spliceInto(_Inout_ void* arrAddr, _In_ const ArrayType* arrType, int index, int numToDel, const ArrayValue& val) const
{
    InMemory* array = static_cast<InMemory*>(arrAddr);

    if (val.getSubType())
    {
        if (array->elementType && !array->elementType->equals(val.getSubType()))
        {
            // Ensure that we are replacing all the contents of the array.
            if (array->size && (index != 0 || (numToDel != array->size && numToDel != -1)))
            {
                return HK_FAILURE;
            }

            // Clear all the contents.
            reinterpret_cast<hkVariantArray*>(array)->clearAndDeallocate();
        }

        array->elementType = val.getSubType();
    }
    return hkArrayImpl::_spliceInto(static_cast<Dummy_hkArray*>(arrAddr), array->elementType, index, numToDel, val);
}

hkResult hkReflect::Detail::HomogeneousArrayImpl::inplaceFixup(_Inout_ void* self, _In_ const Type* selfType, void* target, _In_ const Type* targetType, int count) const
{
    HK_ASSERT_NO_MSG(0x25a4289c, targetType || count == 0);
    InMemory* a = static_cast<InMemory*>(self);
    a->elementType = targetType;
    a->cap = count | DONT_DEALLOCATE_FLAG;
    if (count)
    {
        a->ptr = target;
        a->size = count;
    }
    return HK_SUCCESS;
}

void hkReflect::Detail::HomogeneousArrayImpl::clearAllocs(_Inout_ void* arrAddr, _In_ const ArrayType* type) const
{
    InMemory* a = static_cast<InMemory*>(arrAddr);
    clearAllocsInternal(arrAddr, a->elementType);
}

hkResult hkReflect::Detail::VarPropertyImpl::setValue(_Inout_ void* addr, _In_ const hkReflect::PointerType*, const Var& var) const
{
    if (m_set)
    {
        return m_set(addr, var) ? HK_SUCCESS : HK_FAILURE;
    }
    return HK_FAILURE;
}

hkResult hkReflect::Detail::VarPropertyImpl::getValue(_In_ const void* self, _In_ const hkReflect::PointerType*, _Out_ hkReflect::Var* val) const
{
    *val = m_get(self);
    return HK_SUCCESS;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
