// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0


HK_INLINE bool hkReflect::Detail::canSetPtr(_In_ const hkReflect::Type* pointedType, const hkReflect::Var& value)
{
    return canSetPtr(pointedType, value.getType()) || value.getAddress() == nullptr;
}

HK_INLINE bool hkReflect::Detail::canSetPtr(_In_ const hkReflect::Type* pointedType, _In_ const hkReflect::Type* valueType)
{
    return pointedType->asVoid() || valueType == HK_NULL || valueType->extendsOrEquals(pointedType);
}

template<typename INT_TYPE>
hkResult hkReflect::Detail::IntegerPropertyImpl<INT_TYPE>::setValue(_Inout_ void* addr, _In_ const hkReflect::IntType*, const hkReflect::IntValue& val) const
{
    if (m_set)
    {
        return m_set(addr, val.convertTo<INT_TYPE>()) ? HK_SUCCESS : HK_FAILURE;
    }
    return HK_FAILURE;
}

template<typename INT_TYPE>
hkResult hkReflect::Detail::IntegerPropertyImpl<INT_TYPE>::getValue(_In_ const void* addr, _In_ const hkReflect::IntType*, _Out_ hkReflect::IntValue* val) const
{
    INT_TYPE i = m_get(addr);
    val->set(i);
    return HK_SUCCESS;
}

template<typename FP_TYPE>
hkResult hkReflect::Detail::FloatPropertyImpl<FP_TYPE>::setValue(_Inout_ void* addr, _In_ const hkReflect::FloatType*, hkReflect::FloatValue val) const
{
    if (m_set)
    {
        FP_TYPE i = FP_TYPE(val);
        return m_set(addr, i) ? HK_SUCCESS : HK_FAILURE;
    }
    return HK_FAILURE;
}

template<typename FP_TYPE>
hkResult hkReflect::Detail::FloatPropertyImpl<FP_TYPE>::getValue(_In_ const void* addr, _In_ const hkReflect::FloatType*, _Out_ FloatValue* val) const
{
    FP_TYPE i = m_get(addr);
    *val = i;
    return HK_SUCCESS;
}

template<typename PointerTypeC, typename PointeeTypeC>
hkResult hkReflect::Detail::PointerPropertyImpl<PointerTypeC, PointeeTypeC>::setValue(_Inout_ void* addr, _In_ const hkReflect::PointerType* type, const Var& var) const
{
    if (canSetPtr(type->getSubType(), var))
    {
        if (m_set)
        {
            return m_set(addr, PointerType((PointeeType*)var.getAddress())) ? HK_SUCCESS : HK_FAILURE;
        }
    }
    return HK_FAILURE;
}

template<typename PointerTypeC, typename PointeeTypeC>
hkResult hkReflect::Detail::PointerPropertyImpl<PointerTypeC, PointeeTypeC>::getValue(_In_ const void* self, _In_ const hkReflect::PointerType* type, _Out_ Var* val) const
{
    const void* addr = m_get(self);
    *val = hkReflect::exactObj(addr, type->getSubType());
    return HK_SUCCESS;
}

template <typename T>
inline hkReflect::Detail::AddrAndType hkReflect::Detail::callGetExactType(_In_ const T* obj)
{
    HK_ASSERT_NO_MSG(0x50c9c637, obj);
    return obj->getExactType();
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
