// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/Reflect/Impl/hkBuiltinImpl.h>
#include <Common/Base/Container/RelArray/hkRelArrayUtil.h>
#include <Common/Base/Container/RelArray/hkRelArray.h>
#include <Common/Base/Memory/System/hkMemorySystem.h>
#include <Common/Base/Memory/System/Debug/hkDebugMemorySystem.h>
#include <Common/Base/Reflect/Core/Detail/hkReflectTypeDetail.h>

hkReflect::Var hkReflect::Detail::allocateDefault(_In_ const hkReflect::Type* type)
{
    const hkReflect::Var& object = allocateDefault(type, *hkMemHeapAllocator());
    if (hkDebugMemorySystem* debugMemorySystem = hkMemorySystem::getInstance().getDebugInterface())
    {
        debugMemorySystem->tagAddress(object.getAddress(), type->getName());
    }
    HK_MEMORY_TRACKER_ADD_MANUAL(HK_NULL, type, object.getAddress(), type->getSizeOf(), true);
    return object;
}

void hkReflect::Detail::deallocateDefault(_Inout_ void* target, _In_ const hkReflect::Type* type)
{
    HK_MEMORY_TRACKER_REMOVE(target);
    deallocateDefault(target, type, *hkMemHeapAllocator());
}

hkReflect::Var hkReflect::Detail::allocateDefault(_In_ const hkReflect::Type* type, hkMemoryAllocator& mem)
{
    
    HK_ASSERT_NO_MSG(0x5234a2b4, type->findAttribute<hk::ContainsRelArrays>() == HK_NULL);
    int size = type->getSizeOf();
    void* p = mem.blockAlloc(size);
    hkMemUtil::memSet(p, 0, size);
    return hkReflect::Var(p, type);
}

void hkReflect::Detail::deallocateDefault(_Inout_ void* target, _In_ const hkReflect::Type* type, hkMemoryAllocator& mem)
{
    
    HK_ASSERT_NO_MSG(0xf736962, type->findAttribute<hk::ContainsRelArrays>() == HK_NULL);
    int size = type->getSizeOf();
    mem.blockFree(target, size);
}

const hkReflect::Detail::HeapAllocImpl hkReflect::Detail::HeapAllocImpl::s_instance;

hkReflect::Detail::RepeatImpl::RepeatImpl()
{
}

hkResult hkReflect::Detail::RepeatImpl::getValue(_In_ const void* arrAddr, _In_ const ArrayType* arrType, _Out_ ArrayValue* val) const
{
    int fixedSize = arrType->getFixedCount();
    HK_ASSERT_NO_MSG(0x477b3c6d, fixedSize > 0);
    *val = ArrayValue(const_cast<void*>(arrAddr), fixedSize, arrType->getSubType());
    return HK_SUCCESS;
}

hkResult hkReflect::Detail::RepeatImpl::setNumElements(_Inout_ void* arrAddr, _In_ const ArrayType* arrType, int len) const
{
    return len == arrType->getFixedCount() ? HK_SUCCESS : HK_FAILURE;
}

hkReflect::Detail::ArrayImpl::AllocResult hkReflect::Detail::RepeatImpl::allocateElements(_Inout_ void* arrAddr, _In_ const ArrayType* arrType, QualType elemType, int len) const
{
    if (elemType && elemType->equals(arrType->getSubType()) && len == arrType->getFixedCount())
    {
        return ALLOC_SUCCESS;
    }
    return ALLOC_FAILURE;
}

const hkReflect::Detail::RepeatImpl hkReflect::Detail::RepeatImpl::s_instance;


//
// String
//
hkResult hkReflect::Detail::StaticStringImpl::setValue(_Inout_ void* string, _In_ const hkReflect::StringType*, hkReflect::StringValue newValue) const
{
    
    // when we loading types (Named, Record::Fields) from a tagfile for example.
    // A solution would be to create a copy of the native types and patch the impl
    // pointers so that they would use the string pool.
    //HK_ASSERT(0x2b2b889b, 0, "Shouldn't call set on char* members.");
    *reinterpret_cast<const char**>(string) = newValue;
    return HK_SUCCESS;
}

hkResult hkReflect::Detail::StaticStringImpl::getValue(_In_ const void* string, _In_ const hkReflect::StringType* type, _Out_ hkReflect::StringValue* val) const
{
    *val = *static_cast<char const* const*>(string);
    return HK_SUCCESS;
}

const hkReflect::Detail::StaticStringImpl hkReflect::Detail::StaticStringImpl::s_instance;



hkResult hkReflect::Detail::CharBufferImpl::setValue(_Inout_ void* string, _In_ const hkReflect::StringType* type, hkReflect::StringValue newValue) const
{
    if (newValue.m_value)
    {
        const int typeSize = type->getSizeOf();
        if (hkString::strLen(newValue.m_value) >= typeSize)
        {
            return HK_FAILURE;
        }
        hkString::strNcpy(reinterpret_cast<char*>(string), typeSize, newValue.m_value, typeSize);
    }
    return HK_SUCCESS;
}

hkResult hkReflect::Detail::CharBufferImpl::getValue(_In_ const void* string, _In_ const hkReflect::StringType* type, _Out_ hkReflect::StringValue* val) const
{
    *val = static_cast<char const*>(string);
    return HK_SUCCESS;
}

const hkReflect::Detail::CharBufferImpl hkReflect::Detail::CharBufferImpl::s_instance;


//
// Pointer
//

hkResult hkReflect::Detail::RawPointerImpl::setValue(_Inout_ void* self, _In_ const hkReflect::PointerType* type, const hkReflect::Var& val) const
{
    // We can't assume that the source object will have a vtable, we just perform a type-based check.
    if (!hkReflect::Detail::canSetPtr(type->getSubType(), val))
    {
        return HK_FAILURE;
    }
    *(void**)self = const_cast<void*>(val.getAddress());
    return HK_SUCCESS;
}
hkResult hkReflect::Detail::RawPointerImpl::getValue(_In_ const void* self, _In_ const hkReflect::PointerType* type, _Out_ hkReflect::Var* val) const
{
    const void* addr = getInline(self);
    *val = Var(exactObj(addr, type->getSubType()));
    return HK_SUCCESS;
}

hkResult hkReflect::Detail::RawPointerImpl::inplaceFixup(_Inout_ void* self, _In_ const Type* selfType, _Inout_ void* target, _In_ const Type* targetType, int count) const
{
    *(void**)self = target;
    return HK_SUCCESS;
}


const hkReflect::Detail::RawPointerImpl hkReflect::Detail::RawPointerImpl::s_instance;



//
// Properties
//

template<typename Storage>
hkReflect::Detail::BoolImplN<Storage>::~BoolImplN()
{
}

template<typename Storage>
hkResult hkReflect::Detail::BoolImplN<Storage>::setValue(_Inout_ void* addr, _In_ const BoolType* type, BoolValue val) const
{
    *reinterpret_cast<Storage*>(addr) = (val != 0);
    return HK_SUCCESS;
}

template<typename Storage>
hkResult hkReflect::Detail::BoolImplN<Storage>::getValue(_In_ const void* addr, _In_ const hkReflect::BoolType*, _Out_ hkReflect::BoolValue* val) const
{
    *val = *reinterpret_cast<const Storage*>(addr) != 0;
    return HK_SUCCESS;
}

template<typename Storage>
const hkReflect::Detail::BoolImplN<Storage> hkReflect::Detail::BoolImplN<Storage>::s_instance;

template struct HK_EXPORT_COMMON hkReflect::Detail::BoolImplN<hkUint8>;
template struct HK_EXPORT_COMMON hkReflect::Detail::BoolImplN<hkUint16>;
template struct HK_EXPORT_COMMON hkReflect::Detail::BoolImplN<hkUint32>;
template struct HK_EXPORT_COMMON hkReflect::Detail::BoolImplN<bool>;


template<typename Storage>
hkReflect::Detail::IntImplN<Storage>::~IntImplN()
{
}

template<typename Storage>
hkResult hkReflect::Detail::IntImplN<Storage>::setValue(_Inout_ void* addr, _In_ const hkReflect::IntType* type, const hkReflect::IntValue& val) const
{
    Storage s;
    if (val.get(&s))
    {
        *reinterpret_cast<Storage*>(addr) = s;
        return HK_SUCCESS;
    }
    return HK_FAILURE;
}

template<typename Storage>
hkResult hkReflect::Detail::IntImplN<Storage>::getValue(_In_ const void* addr, _In_ const hkReflect::IntType*, _Out_ hkReflect::IntValue* val) const
{
    val->set<Storage>(*reinterpret_cast<const Storage*>(addr));
    return HK_SUCCESS;
}

template<typename Storage>
const hkReflect::Detail::IntImplN<Storage> hkReflect::Detail::IntImplN<Storage>::s_instance;

hkReflect::Detail::IntImplN<char>::~IntImplN() {}

hkResult hkReflect::Detail::IntImplN<char>::setValue(_Inout_ void* addr, _In_ const hkReflect::IntType*, const hkReflect::IntValue& val) const
{
    const hkUint64 absValue = val.absValue();
    if (val.isNegative())
    {
        if (absValue <= 128)
        {
            *reinterpret_cast<unsigned char*>(addr) = ~static_cast<unsigned char>(absValue & 0x0ff) + 1;
            return HK_SUCCESS;
        }
        else
        {
            return HK_FAILURE;
        }
    }
    else
    {
        if (absValue < 256)
        {
            *reinterpret_cast<unsigned char*>(addr) = static_cast<unsigned char>(absValue & 0x0ff);
            return HK_SUCCESS;
        }
        else
        {
            return HK_FAILURE;
        }
    }
}

hkResult hkReflect::Detail::IntImplN<char>::getValue(_In_ const void* addr, _In_ const hkReflect::IntType*, _Out_ hkReflect::IntValue* val) const
{
    unsigned char v = *reinterpret_cast<const unsigned char*>(addr);
    val->set(v, false);
    return HK_SUCCESS;
}

const struct hkReflect::Detail::IntImplN<char> hkReflect::Detail::IntImplN<char>::s_instance;

template struct HK_EXPORT_COMMON hkReflect::Detail::IntImplN<unsigned char>;
template struct HK_EXPORT_COMMON hkReflect::Detail::IntImplN<signed char>;
template struct HK_EXPORT_COMMON hkReflect::Detail::IntImplN<short>;
template struct HK_EXPORT_COMMON hkReflect::Detail::IntImplN<unsigned short>;
template struct HK_EXPORT_COMMON hkReflect::Detail::IntImplN<int>;
template struct HK_EXPORT_COMMON hkReflect::Detail::IntImplN<unsigned int>;
template struct HK_EXPORT_COMMON hkReflect::Detail::IntImplN<long>;
template struct HK_EXPORT_COMMON hkReflect::Detail::IntImplN<unsigned long>;
template struct HK_EXPORT_COMMON hkReflect::Detail::IntImplN<long long>;
template struct HK_EXPORT_COMMON hkReflect::Detail::IntImplN<unsigned long long>;

template<typename Storage>
hkReflect::Detail::FloatImplN<Storage>::~FloatImplN() {}

template<typename Storage>
hkResult hkReflect::Detail::FloatImplN<Storage>::setValue(_Inout_ void* addr, _In_ const hkReflect::FloatType*, hkReflect::FloatValue val) const
{
    const Storage s = (Storage)val;
    *reinterpret_cast<Storage*>(addr) = s;
    return HK_SUCCESS; 
}

template<typename Storage>
hkResult hkReflect::Detail::FloatImplN<Storage>::getValue(_In_ const void* addr, _In_ const hkReflect::FloatType*, _Out_ hkReflect::FloatValue* val) const
{
    *val = *reinterpret_cast<const Storage*>(addr);
    return HK_SUCCESS;
}

template<typename Storage>
const hkReflect::Detail::FloatImplN<Storage> hkReflect::Detail::FloatImplN<Storage>::s_instance;

template struct HK_EXPORT_COMMON hkReflect::Detail::FloatImplN<float>;
template struct HK_EXPORT_COMMON hkReflect::Detail::FloatImplN<double>;

hkReflect::Detail::FloatImplN<hkHalf16>::~FloatImplN()
{
}

hkResult hkReflect::Detail::FloatImplN<hkHalf16>::setValue(_Inout_ void* addr, _In_ const hkReflect::FloatType*, hkReflect::FloatValue val) const
{
    reinterpret_cast<hkHalf16*>(addr)->setReal<true>((hkReal)val);
    return HK_SUCCESS; 
}

hkResult hkReflect::Detail::FloatImplN<hkHalf16>::getValue(_In_ const void* addr, _In_ const hkReflect::FloatType*, _Out_ hkReflect::FloatValue* val) const
{
    hkReal r; reinterpret_cast<const hkHalf16*>(addr)->store(&r);
    *val = r;
    return HK_SUCCESS;
}

const hkReflect::Detail::FloatImplN<hkHalf16> hkReflect::Detail::FloatImplN<hkHalf16>::s_instance;

hkResult hkReflect::Detail::StringPropertyImpl::setValue(_Inout_ void* addr, _In_ const hkReflect::StringType* type, hkReflect::StringValue newValue) const
{
    if (m_set)
    {
        return m_set(addr, newValue) ? HK_SUCCESS : HK_FAILURE;
    }
    return HK_FAILURE;
}
hkResult hkReflect::Detail::StringPropertyImpl::getValue(_In_ const void* addr, _In_ const hkReflect::StringType* type, _Out_ hkReflect::StringValue* val) const
{
    *val = m_get(addr);
    return HK_SUCCESS;
}

hkResult hkReflect::Detail::BoolPropertyImpl::setValue(_Inout_ void* addr, _In_ const hkReflect::BoolType*, hkReflect::BoolValue val) const
{
    if (m_set)
    {
        return m_set(addr, val) ? HK_SUCCESS : HK_FAILURE;
    }
    return HK_FAILURE;
}

hkResult hkReflect::Detail::BoolPropertyImpl::getValue(_In_ const void* addr, _In_ const hkReflect::BoolType*, _Out_ hkReflect::BoolValue* val) const
{
    *val = m_get(addr);
    return HK_SUCCESS;
}

hkReflect::Var hkReflect::Detail::HeapAllocImpl::allocate(_In_ const hkReflect::Type* type) const
{
    return hkReflect::Detail::allocateDefault(type);
}
hkReflect::Var hkReflect::Detail::HeapAllocImpl::allocateForClone(const hkReflect::Var& src, _In_ const hkReflect::Type* type) const
{
    return allocate(type);
}
void hkReflect::Detail::HeapAllocImpl::deallocate(_Inout_ void* target, _In_ const hkReflect::Type* type) const
{
    hkReflect::Detail::deallocateDefault(target, type);
}

void HK_CALL hkReflect::Detail::Trivial<hkReflect::Opt::DEF_CONSTRUCTOR>::func(_Inout_ void* target, _In_ const hkReflect::Type* type, int num)
{
    hkMemUtil::memSet(target, 0, num * type->getSizeOf());
}

void HK_CALL hkReflect::Detail::Trivial<hkReflect::Opt::COPY_CONSTRUCTOR>::func(_Inout_ void* target, _In_ const void* source, _In_ const hkReflect::Type* type, int num)
{
    hkMemUtil::memMove(target, source, num * type->getSizeOf());
}

void HK_CALL hkReflect::Detail::Trivial<hkReflect::Opt::COPY_ASSIGNMENT>::func(_Inout_ void* target, _In_ const void* source, _In_ const hkReflect::Type* type, int num)
{
    hkMemUtil::memMove(target, source, num * type->getSizeOf());
}

void HK_CALL hkReflect::Detail::Trivial<hkReflect::Opt::DESTRUCTOR>::func( _Inout_ void* target, _In_ const hkReflect::Type* type, int num )
{
    // Do nothing.
}

void HK_CALL hkReflect::Detail::assertOnInvalidDestruction(_Inout_ void* target, _In_ const hkReflect::Type*, int num)
{
    HK_ASSERT(0x6cc80d1, 0, "Tried destroying an instance of a type whose destructor is inaccessible");
}

namespace
{
    void runUnaryFunction(hkReflect::Detail::UnaryFunction func, _Inout_ void* obj, _In_ const hkReflect::Type* type, int num, int stride)
    {
        if (stride == type->getSizeOf())
        {
            func(obj, type, num);
        }
        else
        {
            for (int objIdx = 0; objIdx < num; ++objIdx)
            {
                func(hkAddByteOffset(obj, stride * objIdx), type, 1);
            }
        }
    }

    void runBinaryFunction(hkReflect::Detail::BinaryFunction func, _Inout_ void* tgt, _In_ const void* src, _In_ const hkReflect::Type* type, int num, int stride)
    {
        if (stride == type->getSizeOf())
        {
            func(tgt, src, type, num);
        }
        else
        {
            for (int objIdx = 0; objIdx < num; ++objIdx)
            {
                func(hkAddByteOffset(tgt, stride * objIdx), hkAddByteOffset(src, stride * objIdx), type, 1);
            }
        }
    }

    template<hkReflect::Optional OPT>
    void runUnaryFunction(_Inout_ void* obj, _In_ const hkReflect::Type* type, int num, int stride)
    {
        hkReflect::Detail::UnaryFunction func = hkReflect::TypeDetail::decoratorGetOptional<OPT>(type);

        
        if (!hkReflect::TypeDetail::isTrivialMethod<OPT>(func))
        {
            HK_ASSERT_NO_MSG(0x201e3570, func != HK_NULL);
            runUnaryFunction(func, obj, type, num, stride);
        }
    }
    template<hkReflect::Optional OPT>
    void runBinaryFunction(_Inout_ void* tgt, _In_ const void* src, _In_ const hkReflect::Type* type, int num, int stride)
    {
        hkReflect::Detail::BinaryFunction func = hkReflect::TypeDetail::decoratorGetOptional<OPT>(type);

        // We can't preemptively memmove the whole object during copy assignment, so trivial methods cannot be skipped
        // and must be run on each object.
        bool runTrivial = OPT == hkReflect::Opt::COPY_ASSIGNMENT;

        
        if (runTrivial || !hkReflect::TypeDetail::isTrivialMethod<OPT>(func))
        {
            HK_ASSERT_NO_MSG(0x76821c92, func != HK_NULL);
            runBinaryFunction(func, tgt, src, type, num, stride);
        }
    }
}

void HK_CALL hkReflect::Detail::Implicit<hkReflect::Opt::DEF_CONSTRUCTOR>::func(_Inout_ void* p, _In_ const hkReflect::Type* type, int num)
{
    // Clear memory.
    hkString::memSet(p, 0, num * type->getSizeOf());

    if (const RecordType* rec = type->asRecord())
    {
        // Call default ctor on the parent.
        if (const RecordType* parent = rec->getParentRecord())
        {
            runUnaryFunction<Opt::DEF_CONSTRUCTOR>(p, parent, num, type->getSizeOf());
        }

        // Assert that the type is not polymorphic.
        
        for (const hkReflect::Type* current = type; current; current = current->getParent())
        {
            HK_ASSERT_NO_MSG(0x20257c1b, !current->hasOwnVtable());
            HK_ASSERT_NO_MSG(0x5840f265, !TypeDetail::localHasOptional(current, Opt::INTERFACES));
        }
    }

    // Initialize all fields which need additional work.
    if(const DeclsArray* decls = TypeDetail::decoratorGetOptional<Opt::DECLS>(type) )
    {
        for (auto field : decls->getDataFields())
        {
            runUnaryFunction<Opt::DEF_CONSTRUCTOR>(hkAddByteOffset(p, field.getOffset()), field.getType(), num, type->getSizeOf());
        }
    }
}

void HK_CALL hkReflect::Detail::Implicit<hkReflect::Opt::COPY_CONSTRUCTOR>::func(_Inout_updates_bytes_(_Inexpressible_()) void* target, _In_reads_bytes_(_Inexpressible_()) const void* source, _In_ const hkReflect::Type* type, int num)
{
    // Copy over memory (this initializes simple values and vtables).
    hkString::memMove(target, source, num * type->getSizeOf());

    if (const RecordType* rec = type->asRecord())
    {
        // Call copy ctor on the parent.
        if (const RecordType* parent = rec->getParentRecord())
        {
            runBinaryFunction<Opt::COPY_CONSTRUCTOR>(target, source, parent, num, type->getSizeOf());

            // The copy constructor of the parent may have overwritten the vtables.
            
            initializeVtables(target, type, num);
        }
    }

    // Copy-construct all fields which need additional work.
    if(const DeclsArray* decls = TypeDetail::decoratorGetOptional<Opt::DECLS>(type) )
    {
        for (auto field : decls->getDataFields())
        {
            runBinaryFunction<Opt::COPY_CONSTRUCTOR>(
                hkAddByteOffset(target, field.getOffset()), hkAddByteOffset(source, field.getOffset()),
                field.getType(), num, type->getSizeOf());
        }
    }
}

void HK_CALL hkReflect::Detail::Implicit<hkReflect::Opt::COPY_ASSIGNMENT>::func(_Inout_updates_bytes_(_Inexpressible_()) void* target, _In_reads_bytes_(_Inexpressible_()) const void* source, _In_ const hkReflect::Type* type, int num)
{
    if (const DeclsArray* decls = TypeDetail::decoratorGetOptional<Opt::DECLS>(type) )
    {
        auto fields = decls->getDataFields();

        if (const RecordType* rec = type->asRecord())
        {
            // Call copy assignment on the parent.
            if (const RecordType* parent = rec->getParentRecord())
            {
                BinaryFunction parentFunc = TypeDetail::getCopyAssignmentFunction(parent);
                HK_ASSERT_NO_MSG(0x5f21fcc4, parentFunc != HK_NULL);

                if (fields.getSize() == 0)
                {
                    // This type has no fields, just copy the parent.
                    parentFunc(target, source, parent, num);
                }
                else if (fields[0].getOffset() >= parent->getSizeOf())
                {
                    // Simple case: fields do not overlap the parent storage, can call the parent copy safely.
                    for (int objIdx = 0; objIdx < num; ++objIdx)
                    {
                        parentFunc(hkAddByteOffset(target, type->getSizeOf() * objIdx),
                            hkAddByteOffset(source, type->getSizeOf() * objIdx), parent, 1);
                    }
                }
                else
                {
                    // Some fields overlap with the parent storage.
                    if (parentFunc == &hkReflect::Detail::Trivial<Opt::COPY_ASSIGNMENT>::func)
                    {
                        // parentFunc is memmove; do not memmove all the parent storage, but only up to the first field of the child.
                        for (int objIdx = 0; objIdx < num; ++objIdx)
                        {
                            hkString::memMove(hkAddByteOffset(target, type->getSizeOf() * objIdx),
                                hkAddByteOffset(source, type->getSizeOf() * objIdx), fields[0].getOffset());
                        }
                    }
                    else if (parentFunc != &hkReflect::Detail::Implicit<Opt::COPY_ASSIGNMENT>::func)
                    {
#if 0   // See 'paranoid' check below, not hit in practice, so removed from 'HK_DEBUG' builds but code left here in case needed for investigation.
                        // parentFunc is explicit; it shouldn't write over its padding, check that it actually doesn't
                        hkInplaceArray<unsigned char, 128>::Temp backup;
                        // Backup the overlap.
                        backup.append(static_cast<const unsigned char*>(target), type->getSizeOf() * num);
#endif
                        runBinaryFunction(parentFunc, target, source, parent, num, type->getSizeOf());

#if 0
                        int overlapSize = parent->getSizeOf() - fields[0].getOffset();
                        for (int objIdx = 0; objIdx < num; ++objIdx)
                        {
                            int overlapOffset = type->getSizeOf() * objIdx + fields[0].getOffset();
                            const void* overlap = hkAddByteOffset(target, overlapOffset);
                            const void* reference = hkAddByteOffset(backup.begin(), overlapOffset);

                            // Check if the parent function has written on the overlap.
                            HK_ASSERTV(0x56714c2f, hkString::memCmp(overlap, reference, overlapSize) == 0,
                                "Type {} cannot have an implicit operator= because its fields are "
                                "overwritten by the operator= in the parent", type->getFullName());
                        }
#endif
                    }
                    else
                    {
                        runBinaryFunction(parentFunc, target, source, parent, num, type->getSizeOf());
                    }
                }
            }
        }

        // Copy over all fields.
        for (auto field : fields)
        {
            runBinaryFunction<Opt::COPY_ASSIGNMENT>(
                hkAddByteOffset(target, field.getOffset()), hkAddByteOffset(source, field.getOffset()),
                field.getType(), num, type->getSizeOf());
        }
    }
}

void HK_CALL hkReflect::Detail::Implicit<hkReflect::Opt::DESTRUCTOR>::func(_Inout_updates_bytes_(_Inexpressible_()) void* target, _In_ const hkReflect::Type* type, int num)
{
    // Call dtor on all the fields which have one.
    if( const DeclsArray* decls = TypeDetail::decoratorGetOptional<Opt::DECLS>(type) )
    {
        auto fields = decls->getDataFields();
        for (auto cur = fields.rbegin(), end = fields.rend(); cur != end; ++cur)
        {
            auto field = *cur;
            runUnaryFunction<Opt::DESTRUCTOR>(hkAddByteOffset(target, (num - 1) * type->getSizeOf() + field.getOffset()),
                field.getType(), num, -type->getSizeOf());
        }
    }

    if (const RecordType* rec = type->asRecord())
    {
        // Call dtor on the parent.
        if (const RecordType* parent = rec->getParentRecord())
        {
            runUnaryFunction<Opt::DESTRUCTOR>(hkAddByteOffset(target, (num - 1) * type->getSizeOf()),
                parent, num, -type->getSizeOf());
        }
    }
}

void HK_CALL hkReflect::Detail::Unknown<hkReflect::Opt::DEF_CONSTRUCTOR>::func(_Inout_ void*, _In_ const hkReflect::Type*, int) { HK_ASSERT_NO_MSG(0x5abeb91, 0); }
void HK_CALL hkReflect::Detail::Unknown<hkReflect::Opt::COPY_CONSTRUCTOR>::func(_Inout_ void*, _In_ const void*, _In_ const hkReflect::Type*, int) { HK_ASSERT_NO_MSG(0x4d2efee6, 0); }
void HK_CALL hkReflect::Detail::Unknown<hkReflect::Opt::COPY_ASSIGNMENT>::func(_Inout_ void*, _In_ const void*, _In_ const hkReflect::Type*, int) { HK_ASSERT_NO_MSG(0x437dae8d, 0); }

namespace
{
    _Ret_maybenull_ const hkReflect::ArrayType* asRepeat(_In_ const hkReflect::Type* type)
    {
        const hkReflect::ArrayType* arr = type->asArray();
        HK_ASSERT_NO_MSG(0x4fd7ed0f, arr);
        HK_ASSERT_NO_MSG(0x5572d17, arr->getSubType());
        HK_ASSERT_NO_MSG(0x73a3c293, arr->getFixedCount() > 0);
        return arr;
    }

    template <hkReflect::Optional OPT> struct RepeatWrapper;

    template <>
    struct RepeatWrapper<hkReflect::Opt::DEF_CONSTRUCTOR>
    {
        static void HK_CALL func(_Inout_ void* target, _In_ const hkReflect::Type* type, int num)
        {
            const hkReflect::ArrayType* arr = asRepeat(type);
            HK_ON_DEBUG(hkResult res = )
                hkReflect::TypeDetail::defaultConstruct(target, arr->getSubType(), num * arr->getFixedCount());
            HK_ASSERT_NO_MSG(0x5dc6823c, res.isSuccess());
        }
    };

    template <>
    struct RepeatWrapper < hkReflect::Opt::COPY_CONSTRUCTOR >
    {
        static void HK_CALL func(_Inout_ void* target, _In_ const void* source, _In_ const hkReflect::Type* type, int num)
        {
            const hkReflect::ArrayType* arr = asRepeat(type);
            HK_ON_DEBUG(hkResult res = )
                hkReflect::TypeDetail::copyConstruct(target, source, arr->getSubType(), num * arr->getFixedCount());
            HK_ASSERT_NO_MSG(0x38ec601c, res.isSuccess());
        }
    };

    template <>
    struct RepeatWrapper < hkReflect::Opt::COPY_ASSIGNMENT >
    {
        static void HK_CALL func(_Inout_ void* target, _In_ const void* source, _In_ const hkReflect::Type* type, int num)
        {
            const hkReflect::ArrayType* arr = asRepeat(type);
            HK_ON_DEBUG(hkResult res = )
                hkReflect::TypeDetail::copyAssign(target, source, arr->getSubType(), num * arr->getFixedCount());
            HK_ASSERT_NO_MSG(0x6b3ff05b, res.isSuccess());
        }
    };

    template <>
    struct RepeatWrapper < hkReflect::Opt::DESTRUCTOR >
    {
        static void HK_CALL func(_Inout_ void* target, _In_ const hkReflect::Type* type, int num)
        {
            const hkReflect::ArrayType* arr = asRepeat(type);
            hkReflect::TypeDetail::destruct(target, arr->getSubType(), num * arr->getFixedCount());
        }
    };

    template<hkReflect::Optional OPT>
    void fixupMethod(_Inout_ hkReflect::ArrayType* arr)
    {
        typedef typename hkReflect::Detail::OptionStorage<OPT>::Storage FuncType;
        FuncType elemFunc = hkReflect::TypeDetail::decoratorGetOptional<OPT>(arr->getSubType());
        if (elemFunc == &hkReflect::Detail::Trivial<OPT>::func)
        {
            // Element type is trivial, use trivial method.
            hkReflect::TypeDetail::localSetOptional<OPT>(arr, &hkReflect::Detail::Trivial<OPT>::func);
        }
        else if (elemFunc != HK_NULL)
        {
            // Element type is non-trivial, forward method to the elements.
            hkReflect::TypeDetail::localSetOptional<OPT>(arr, &RepeatWrapper<OPT>::func);
        }
        else
        {
            // Disallow method.
            hkReflect::TypeDetail::localSetOptionalUlong(arr, OPT, 0);
        }
    }

    void repeatFixupFunc(_Inout_ hkReflect::Type* type)
    {
        hkReflect::ArrayType* arr = const_cast<hkReflect::ArrayType*>(asRepeat(type));

        // Fixup the methods depending on the subtype.
        fixupMethod<hkReflect::Opt::DEF_CONSTRUCTOR>(arr);
        fixupMethod<hkReflect::Opt::COPY_CONSTRUCTOR>(arr);
        fixupMethod<hkReflect::Opt::COPY_ASSIGNMENT>(arr);

        // Add a destructor if one is needed.
        if (hkReflect::TypeDetail::decoratorGetOptional<hkReflect::Opt::DESTRUCTOR>(arr->getSubType()))
        {
            hkReflect::TypeDetail::localSetOptional<hkReflect::Opt::DESTRUCTOR>(arr, &RepeatWrapper<hkReflect::Opt::DESTRUCTOR>::func);
        }
    }

    const hk::FixupReflectedMethods repeatFixupAttr = { &repeatFixupFunc };
}

const hkReflect::Detail::FixedArrayStorage<hkUlong, hkReflect::Detail::AttributeItem, 1> hkReflect::Detail::s_repeatReflectionAttributes =
{
    1, { { &repeatFixupAttr, HK_REFLECT_GET_TYPE(hk::FixupReflectedMethods) } }
};

hkResult hkReflect::Detail::ReferencedObjectPointerImpl::setValue(_Inout_ void* self, _In_ const hkReflect::PointerType* type, const hkReflect::Var& val) const
{
    HK_ASSERT_NO_MSG(0x653ff5e8, type->getSubType()->extendsOrEquals<hkReferencedObject>());
    // We can't assume that the source object will have a vtable, we just perform a type-based check.
    if (!hkReflect::Detail::canSetPtr(type->getSubType(), val))
    {
        return HK_FAILURE;
    }
    const hkReferencedObject* oldObj = static_cast<const hkReferencedObject*>(*static_cast<void**>(self));
    const hkReferencedObject* newObj = static_cast<const hkReferencedObject*>(val.getAddress());
    *(void**)self = const_cast<void*>(val.getAddress());
    if (newObj)
    {
        newObj->addReference();
    }
    if (oldObj)
    {
        oldObj->removeReference();
    }
    return HK_SUCCESS;
}

const hkReflect::Detail::ReferencedObjectPointerImpl hkReflect::Detail::ReferencedObjectPointerImpl::s_instance;

hkResult hkReflect::Detail::ReferenceImpl::setValue(_Inout_ void* self, _In_ const hkReflect::PointerType* type, const Var& var) const
{
    if (!var) return HK_FAILURE;
    return RawPointerImpl::setValue(self, type, var);
}

bool hkReflect::Detail::ReferenceImpl::canBeNull() const { return false; }

const hkReflect::Detail::ReferenceImpl hkReflect::Detail::ReferenceImpl::s_instance;

#ifdef HK_MEMORY_TRACKER_ENABLE
namespace hkReflect {
    namespace Detail {
        const hkReflect::Detail::TrackerRegNode HandleHelper< hkArray< void* > >::trackerRegNode(ReflectionOf< hkArray<void*> >::Holder::typeData, &trackerHandle, false);
        const hkUint16 HandleHelper< hkArray<void*> >::trackerHandle = HK_TRACKER_CAST_TO_HANDLE(&trackerRegNode);
    }
}
#endif

hkReflect::Detail::TypeRegNode hkReflect::Detail::PtrReflection<void>::typeRegNode(reinterpret_cast<hkReflect::Type*>(&typeData));

const hkReflect::Detail::TemplatePod<1 + 0> hkReflect::Detail::PtrReflection<void>::params =
{ HK_REFLECT_GET_TYPE(void*), { (1 + 0) & 0xffff,{ { hkUlong(HK_REFLECT_GET_TYPE(void)), "tT" } } } };

hkReflect::Detail::TypeData hkReflect::Detail::PtrReflection<void>::typeData =
{
    hkReflect::Opt::FORMAT | hkReflect::Opt::SUBTYPE | hkReflect::Opt::IMPL | hkReflect::Opt::NAME |
    hkReflect::Opt::DEF_CONSTRUCTOR | hkReflect::Opt::COPY_CONSTRUCTOR | hkReflect::Opt::DESTRUCTOR |
    hkReflect::Opt::COPY_ASSIGNMENT | hkReflect::Opt::INHERITANCE | hkReflect::Opt::TEMPLATE |
    hkReflect::Opt::ALLOC_IMPL | hkReflect::Opt::SIZE_ALIGN | hkReflect::Opt::FLAGS,
    0, // parent
    HK_REFLECT_TYPE_OPTIONAL(Opt::FORMAT, hkReflect::Format::OfPointer::Value),
    HK_REFLECT_TYPE_OPTIONAL(Opt::SUBTYPE, HK_REFLECT_GET_TYPE(void)),
    HK_REFLECT_TYPE_OPTIONAL(Opt::IMPL, &hkReflect::Detail::RawPointerImpl::s_instance),
    HK_REFLECT_TYPE_OPTIONAL(Opt::NAME, "T*"),
    HK_REFLECT_TYPE_OPTIONAL(Opt::DEF_CONSTRUCTOR, &Trivial<Opt::DEF_CONSTRUCTOR>::func),
    HK_REFLECT_TYPE_OPTIONAL(Opt::COPY_CONSTRUCTOR, &Trivial<Opt::COPY_CONSTRUCTOR>::func),
    HK_REFLECT_TYPE_OPTIONAL(Opt::DESTRUCTOR, nullptr),
    HK_REFLECT_TYPE_OPTIONAL(Opt::COPY_ASSIGNMENT, &Trivial<Opt::COPY_ASSIGNMENT>::func ),
    HK_REFLECT_TYPE_OPTIONAL(Opt::INHERITANCE, 0),
    HK_REFLECT_TYPE_OPTIONAL(Opt::TEMPLATE, reinterpret_cast<const TemplateParameterArray*>(&PtrReflection<void>::params)),
    HK_REFLECT_TYPE_OPTIONAL(Opt::ALLOC_IMPL, &HeapAllocImpl::s_instance),
    HK_REFLECT_TYPE_OPTIONAL_SIZE_ALIGN(sizeof(void*), HK_ALIGN_OF(void*), 0),
    HK_REFLECT_TYPE_OPTIONAL(Opt::FLAGS, Type::TYPE_POINTER_WEAK),
    hkUlong(&PtrReflection<void>::typeRegNode)
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
