// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL !ANDROID
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

template<typename T, typename Allocator>
hkReflect::Detail::stdVectorImpl<T, Allocator>::stdVectorImpl()
{
}

template<typename T, typename Allocator>
hkResult hkReflect::Detail::stdVectorImpl<T, Allocator>::getValue(_In_ const void* arrAddr, _In_ const hkReflect::ArrayType* arrType, _Out_ hkReflect::ArrayValue* val) const
{
    const std::vector<T, Allocator>* stdVectorPtr = reinterpret_cast<const std::vector<T, Allocator>*>(arrAddr);

    *val = hkReflect::ArrayValue(stdVectorPtr->size() ? reinterpret_cast<void*>(const_cast<T*>(&(stdVectorPtr->at(0)))) : HK_NULL, static_cast<int>(stdVectorPtr->size()), arrType->getSubType());
    return HK_SUCCESS;
}

template<typename T, typename Allocator>
hkResult hkReflect::Detail::stdVectorImpl<T, Allocator>::setNumElements(_Inout_ void* arrAddr, _In_ const hkReflect::ArrayType* arrType, int len) const
{
    std::vector<T, Allocator>* stdVectorPtr = reinterpret_cast<std::vector<T, Allocator>*>(arrAddr);
    stdVectorPtr->resize(len);
    return HK_SUCCESS;
}

template<typename T, typename Allocator>
hkReflect::Detail::ArrayImpl::AllocResult hkReflect::Detail::stdVectorImpl<T, Allocator>::allocateElements(_Inout_ void* arrAddr, _In_ const hkReflect::ArrayType* arrType, hkReflect::QualType elemType, int len) const
{
    if (!elemType->equals(hkReflect::getType<T>()))
    {
        return ALLOC_FAILURE;
    }
    
    std::vector<T, Allocator>* stdVectorPtr = reinterpret_cast<std::vector<T, Allocator>*>(arrAddr);

    if (stdVectorPtr->size())
    {
        return ALLOC_NOT_EMPTY;
    }

    stdVectorPtr->resize(len);
    return ALLOC_SUCCESS;
}

template<typename T, typename Allocator>
hkResult hkReflect::Detail::stdVectorImpl<T, Allocator>::spliceInto(_Inout_ void* arrAddr, _In_ const hkReflect::ArrayType* arrType, int index, int numToDel, const hkReflect::ArrayValue& var) const
{
    std::vector<T, Allocator>* stdVectorPtr = reinterpret_cast<std::vector<T, Allocator>*>(arrAddr);

    
    if (numToDel)
    {
        stdVectorPtr->erase(stdVectorPtr->begin() + index, stdVectorPtr->begin() + index + numToDel);
    }

    for (int i = 0; i < var.getCount(); i++)
    {
        stdVectorPtr->insert(stdVectorPtr->begin() + index + i, *reinterpret_cast<const T*>(var[i].getAddress()));
    }

    return HK_FAILURE;
}

template<typename T, typename Allocator>
const hkReflect::Detail::stdVectorImpl<T, Allocator> hkReflect::Detail::stdVectorImpl<T, Allocator>::s_instance;

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
