// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL !ANDROID
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#if defined(__HAVOK_PARSER__)
namespace std
{
    template<typename T> class char_traits {};
    template<typename T> class allocator {};

    template < typename charT,
        typename traits = char_traits<charT>,    // basic_string::traits_type
        typename Alloc = allocator<charT>        // basic_string::allocator_type
    > class basic_string
    {
    public:
        HK_DECLARE_CLASS(basic_string, NewOpaque, Reflect);
        HK_REFLECT_AS_STRING_UTF8_MUTABLE(&hkReflect::Detail::stdCStringImpl::s_instance);
        HK_RECORD_ATTR(hk::ReflectDetails(fields = false));
        HK_RECORD_ATTR(hk::IgnoreTemplateParams(charT, traits, Alloc));
        HK_RECORD_ATTR(hk::Allocatable(false));
        HK_RECORD_ATTR(hk::Retargetable(false));
        HK_RECORD_ATTR(hk::ExternalReflection);
        HK_RECORD_ATTR(hk::Validate(false), hk::HasCustomValidation);

        // As long as these are implemented, reflection will generate calls to them which will go to the real ones
        basic_string() {}
        basic_string(const basic_string& other) {}
        basic_string& operator=(const basic_string& other) { return *this; }
        ~basic_string() {}
    };

    typedef basic_string<char> string
        /*HK_ATTR( hk::Reflect )*/;

    // Lookalike vector for the reflection system
    // The template arguments should match the std::vector ones
    template<typename T, typename Allocator = allocator<T> > class vector
    {
    public:
        HK_DECLARE_CLASS(vector, NewOpaque, Reflect);
        HK_RECORD_ATTR(hk::Retargetable(false));
        HK_REFLECT_AS_ARRAY((&hkReflect::Detail::stdVectorImpl<T, Allocator>::s_instance), T); // Brackets are required for preprocessor

        // We ignore the allocator parameter in reflection as we have no idea what it might be. We can use non-default allocators as long
        // as we are consistent.
        HK_RECORD_ATTR(hk::IgnoreTemplateParams(Allocator));
        HK_RECORD_ATTR(hk::ReflectDetails(fields = false));
        // We don't want to allow these to be allocatable at the top level, only as members
        HK_RECORD_ATTR(hk::Allocatable(false));
        HK_RECORD_ATTR(hk::ExternalReflection);
        HK_RECORD_ATTR(hk::Validate(false), hk::HasCustomValidation);

        // As long as these are implemented, reflection will generate calls to them which will go to the real ones
        vector() {}
        vector(const vector& other) {}
        vector& operator=(const vector& other) { return *this; }
        ~vector() {}
    };

    template<typename Key> class hash {};
    template<typename Key> class equal_to {};
    template<typename First, typename Second> class pair {};

    template<class Key,
        class T,
        class Hash = hash<Key>,
        class KeyEqual = equal_to<Key>,
        class Allocator = allocator< pair<const Key, T> >>
        class unordered_map
    {
    };
}

#else // not __HAVOK_PARSER__

#include <vector>
#include <unordered_map>
#include <string>

namespace hkReflect
{
    namespace Detail
    {

        template<typename T, typename Allocator>
        struct stdVectorImpl : public hkReflect::Detail::ArrayImpl
        {
        public:
            // Default instance which uses the default allocator
            static const stdVectorImpl s_instance;

            stdVectorImpl();

            virtual hkResult getValue(_In_ const void* arrAddr, _In_ const hkReflect::ArrayType* arrType, _Out_ hkReflect::ArrayValue* val) const HK_OVERRIDE;
            virtual hkResult setNumElements(_Inout_ void* arrAddr, _In_ const hkReflect::ArrayType* arrType, int len) const HK_OVERRIDE;
            virtual AllocResult allocateElements(_Inout_ void* arrAddr, _In_ const hkReflect::ArrayType* arrType, QualType elemType, int len) const HK_OVERRIDE;
            virtual hkResult spliceInto(_Inout_ void* arrAddr, _In_ const hkReflect::ArrayType* arrType, int index, int numToDel, const hkReflect::ArrayValue& var) const HK_OVERRIDE;

            // Cannot clear allocations without destructing the elements, so do nothing and leak.
            //virtual void clearAllocs(void* arrAddr, const hkReflect::ArrayType* type) const HK_OVERRIDE;

        };

        struct HK_EXPORT_COMMON stdCStringImpl : public hkReflect::Detail::StringImpl
        {
            stdCStringImpl() { /* keep clang happy */ }
            static const stdCStringImpl s_instance;

            virtual hkResult setValue(_Inout_ void* addr, _In_ const hkReflect::StringType* type, StringValue newValue) const HK_OVERRIDE;
            virtual hkResult getValue(_In_ const void* addr, _In_ const hkReflect::StringType* type, _Out_ StringValue* val) const HK_OVERRIDE;
            virtual void clearAllocs(_Inout_ void* arrAddr, _In_ const hkReflect::StringType* type) const HK_OVERRIDE;
        };

    }
    namespace Typedef
    {
        template<typename T> struct Resolve< std::char_traits<T> > { typedef std::char_traits< HK_REFLECT_RESOLVE(T) > Type; };
        template<typename T> struct Resolve< std::allocator<T> > { typedef std::allocator< HK_REFLECT_RESOLVE(T) > Type; };
    }
}

#endif // __HAVOK_PARSER__

#include <Common/Base/Reflect/Impl/Std/hkReflectStd.inl>
#include <Common/Base/_Auto/TemplateTypes/hkReflectStd_Types.inl>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
