// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/Base/Container/Hash/hkHashMap.h>

namespace hkReflect
{
        /// Utility class to produce a hash from a type.
        /// Changes to the types (renames, offset changes, flag changes) all result in different signatures.
        /// Note that the hashing a type gives different results on different platforms, unless the type has the
        /// exact same layout, flags, etc.
    class HK_EXPORT_COMMON TypeHasher
    {
    public:

        HK_DECLARE_CLASS(TypeHasher, New);

            /// Optionally specify a mask to consider only a subset of the type's information for hashing.
        TypeHasher(hkUlong optMask = hkLong(-1));

        ~TypeHasher();
            /// Return the hash of the given type.
        hkUint32 calc(_In_ const hkReflect::Type* type);
            /// Reset any cached data.
        void clear();

        static hkUint32 _addTypeName(hkUint32 sig, _In_ const hkReflect::Type* t);
        static hkUint32 _addTypeTemplate(hkUint32 sig, _In_ const hkReflect::Type* t);

    protected:
        hkUint32 _addType(hkUint32 sig, _In_ const hkReflect::Type* t);
        hkHashMap<const hkReflect::Type*, hkUint64> m_map;
        hkUlong m_optMask;
    };

        /// Utility class to produce a hash from the properties declared by a type.
        /// This is complementary to TypeHasher. While TypeHasher produces a hash of serializable data in a Type,
        /// this only hashes its property Decls (name only). Should be used with TypeHasher to ensure that the
        /// name and the order of the Decls in a type has not changed.
    class HK_EXPORT_COMMON PropertyHasher
    {
    public:

        HK_DECLARE_CLASS( PropertyHasher, New );

        PropertyHasher();

        ~PropertyHasher();

        /// Return the hash of the given type.
        hkUint32 calc( const hkReflect::Type* type );

        /// Return the hash of the given type.
        hkUint32 calc( const hkReflect::Type* type, bool& isNew );

        /// Reset any cached data.
        void clear();

    protected:
        hkHashMap<const hkReflect::Type*, hkUint32> m_map;
    };
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
