// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

HK_ALWAYS_INLINE hkReflect::Var::Var()
    : m_addr(HK_NULL), m_impl(HK_NULL)
{
}

template<typename T>
inline hkReflect::Var::Var(_In_ T* addr, typename hkReflect::Detail::DisableIfSpecial<T>::Type)
{
    Detail::AddrAndType exact = exactObj(addr);
    m_addr = const_cast<void*>(exact.m_addr);
    m_type = exact.m_type;
    m_impl = m_type ? m_type->getImpl() : HK_NULL;
}

HK_INLINE hkReflect::Var::Var(_In_ void* addr, hkReflect::QualType type, _In_ const hkReflect::Detail::Impl* impl, bool isDynamic)
    : m_addr(addr), m_type(type), m_impl(impl, isDynamic)
{
}

inline hkReflect::Var::Var(_In_ const void* addr, hkReflect::QualType type)
    : m_addr(const_cast<void*>(addr)), m_type(type.withConst()), m_impl(type ? type->getImpl() : HK_NULL)
{
}

inline hkReflect::Var::Var(const hkReflect::Detail::AddrAndType& addrAndType)
    : m_addr(addrAndType.m_addr), m_type(addrAndType.m_type), m_impl(m_type ? m_type->getImpl() : HK_NULL)
{
}

HK_INLINE hkReflect::Var::Var(_In_ const void* addr, hkReflect::QualType type, _In_ const hkReflect::Detail::Impl* impl, bool isDynamic)
    : m_addr(const_cast<void*>(addr)), m_type(type.withConst()), m_impl(impl, isDynamic)
{
}

HK_INLINE hkReflect::Var::Var(_In_ const hkReflect::Type* addr)
    : m_addr(const_cast<hkReflect::Type*>(addr))
    , m_type(addr ? hkReflect::exactTypeOf(addr) : hkReflect::getType<Type>().get())
    , m_impl(m_type->getImpl())
{
}

HK_INLINE hkReflect::Var::Var(_In_ const hkReflect::Var* addr)
    : m_addr(const_cast<hkReflect::Var*>(addr))
    , m_type(hkReflect::getType<Var>().get())
    , m_impl(m_type->getImpl())
{
}

HK_INLINE hkReflect::Var hkReflect::Var::fromUnknownObject(_In_ const void* addr)
{
    return Var(addr, hkReflect::getType<void>());
}

template<typename T>
HK_INLINE hkReflect::Var hkReflect::Var::fromRef(T& t)
{
    return Var(&t, hkReflect::getType<T>());
}

template<typename Type, typename FieldType>
HK_INLINE hkReflect::Var hkReflect::Var::fromField(_In_ Type* addr, _In_ FieldType Type::*memberPointer)
{
    hkReflect::DataFieldDecl decl(memberPointer);
    return hkReflect::Var(addr)[decl];
}

HK_INLINE bool hkReflect::Var::operator==(const hkReflect::Var& rhs) const
{
    return (!isValid() && !rhs.isValid()) || (m_addr == rhs.getAddress() && m_type == rhs.getType());
}

template<typename T, typename F>
hkReflect::Var hkReflect::Var::operator [](F T::*f) const
{
    DataFieldDecl field(f);
    return (*this)[field];
}

template<typename T>
HK_INLINE _Ret_maybenull_ T* hkReflect::Var::dynCast() const
{
    HK_ASSERT_NO_MSG(0x42ff9fca, typeIsExact());
    return upCast<T>();
}

HK_INLINE bool hkReflect::Var::isInstanceOf(_In_ const Type* t) const
{
    return hkReflect::upCast(m_addr, m_type, t) != HK_NULL;
}

template <typename T>
inline _Ret_maybenull_ T* hkReflect::Var::castToInterface() const
{
    return castToInterface(hkReflect::getType<T>()).template upCast<T>();
}

template<typename T>
HK_INLINE _Ret_maybenull_ T* hkReflect::Var::upCast() const
{
    return hkReflect::upCast<T>(m_addr, m_type);
}

HK_ALWAYS_INLINE bool hkReflect::Var::hasDynamicImpl() const
{
    return m_impl.isDynamic();
}

HK_ALWAYS_INLINE hkResult hkReflect::BoolVar::getValue(_Out_ hkReflect::BoolValue* val) const
{
    return getImpl()->getValue(m_addr, getType(), val);
}

HK_ALWAYS_INLINE hkReflect::BoolValue hkReflect::BoolVar::getValue() const
{
    BoolValue v;
    getValue(&v);
    return v;
}

HK_ALWAYS_INLINE hkResult hkReflect::BoolVar::setValue(hkReflect::BoolValue i) const
{
    return getImpl()->setValue(m_addr, getType(), i);
}

HK_ALWAYS_INLINE bool hkReflect::IntVar::isSigned() const
{
    return getType()->isSigned();
}

HK_ALWAYS_INLINE hkResult hkReflect::IntVar::getValue(_Out_ IntValue* val) const
{
    return getImpl()->getValue(m_addr, getType(), val);
}

HK_ALWAYS_INLINE hkReflect::IntValue hkReflect::IntVar::getValue() const
{
    IntValue v;
    getValue(&v);
    return v;
}

HK_ALWAYS_INLINE hkResult hkReflect::IntVar::setValue(hkReflect::IntValue i) const
{
    return getImpl()->setValue(const_cast<void*>(m_addr), getType(), i);
}

HK_ALWAYS_INLINE hkResult hkReflect::FloatVar::getValue(_Out_ FloatValue* val) const
{
    return getImpl()->getValue(m_addr, getType(), val);
}

HK_ALWAYS_INLINE hkReflect::FloatValue hkReflect::FloatVar::getValue() const
{
    FloatValue v;
    getValue(&v);
    return v;
}

HK_ALWAYS_INLINE hkResult hkReflect::FloatVar::setValue(hkReflect::FloatValue i) const
{
    return getImpl()->setValue(m_addr, getType(), i);
}

HK_ALWAYS_INLINE hkResult hkReflect::StringVar::getValue(_Out_ StringValue* val) const
{
    return getImpl()->getValue(m_addr, getType(), val);
}

HK_ALWAYS_INLINE hkReflect::StringValue hkReflect::StringVar::getValue() const
{
    StringValue v;
    getValue(&v);
    return v;
}

HK_ALWAYS_INLINE hkResult hkReflect::StringVar::setValue(hkReflect::StringValue i) const
{
    return getImpl()->setValue(m_addr, getType(), i);
}

HK_ALWAYS_INLINE hkResult hkReflect::PointerVar::setValue(const hkReflect::Var& v) const
{
    return getImpl()->setValue(m_addr, getType(), v);
}

HK_ALWAYS_INLINE hkResult hkReflect::PointerVar::getValue(_Out_ hkReflect::Var* v) const
{
    return getImpl()->getValue(m_addr, getType(), v);
}

inline hkReflect::Var hkReflect::PointerVar::getValue() const
{
    Var v;
    getImpl()->getValue(m_addr, getType(), &v);
    HK_ASSERT_NO_MSG(0x6219fb99, v.typeIsExact());
    return v;
}

HK_ALWAYS_INLINE bool hkReflect::PointerVar::isNull() const
{
    return !getValue().isValid();
}

HK_ALWAYS_INLINE const hkReflect::QualType hkReflect::PointerVar::getSubType() const
{
    return getValue().getType();
}

HK_ALWAYS_INLINE hkResult hkReflect::PointerVar::copyFrom(const hkReflect::PointerVar& other) const
{
    hkReflect::Var v;
    HK_RETURN_IF_FAILED(other.getValue(&v));
    return setValue(v);
}

HK_ALWAYS_INLINE hkResult hkReflect::ArrayVar::setArraySize(int len) const
{
    return getImpl()->setNumElements(m_addr, getType(), len);
}

HK_ALWAYS_INLINE _Ret_maybenull_ void* hkReflect::ArrayVar::getDataPointer() const
{
    ArrayValue v;
    getImpl()->getValue(m_addr, getType(), &v);
    return v.getAddress();
}

HK_ALWAYS_INLINE hkResult hkReflect::ArrayVar::spliceInto(int index, int numToDel, const hkReflect::ArrayValue& _insert) const
{
    return getImpl()->spliceInto(m_addr, getType(), index, numToDel, _insert);
};

HK_ALWAYS_INLINE hkResult hkReflect::ArrayVar::insertAt(int index, const Var& var) const
{
    return spliceInto(index, 0, ArrayValue(var.getAddress(), 1, var.getType()));
}

HK_ALWAYS_INLINE hkResult hkReflect::ArrayVar::pushBack(const Var& var) const
{
    return spliceInto(-1, 0, ArrayValue(var.getAddress(), 1, var.getType()));
}

HK_ALWAYS_INLINE hkResult hkReflect::ArrayVar::removeAt(int index) const
{
    return spliceInto(index, 1, ArrayValue());
}

HK_ALWAYS_INLINE hkResult hkReflect::ArrayVar::append(hkReflect::ArrayValue h) const
{
    return spliceInto(-1, 0, h);
}

HK_ALWAYS_INLINE hkResult hkReflect::ArrayVar::clear() const
{
    return spliceInto(0, -1, ArrayValue());
}

HK_ALWAYS_INLINE hkReflect::Detail::AutoCast hkDynCast(const hkReflect::Detail::IndirectVar& var)
{
    return hkReflect::Detail::AutoCast(var.m_var.getAddress(), var.m_var.getType());
}

template <typename To>
HK_INLINE _Ret_maybenull_ To* hkReflect::exactMatchDynCast(const hkReflect::Var& var)
{
    return var.getType() && var.getType()->equals<To>() ?
        static_cast<To*>(var.getAddress()) :
        HK_NULL;
}

template <typename T>
HK_ALWAYS_INLINE _Ret_maybenull_ T* hkReflect::upCast(const hkReflect::Var& var)
{
    return var.upCast<T>();
}

hkReflect::RecordVar hkReflect::RecordVar::getValue() const
{
    return *this;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
