// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

namespace hkReflect
{
    HK_INLINE Var ArrayValue::operator[](int i) const
    {
        HK_ASSERT_NO_MSG(0x52805426, m_elemSize > 0);
        return Var(hkAddByteOffset(m_elemPtr, i * m_elemSize), m_elemType, m_elemImpl, m_elemImpl.isDynamic());
    }
    HK_INLINE ArrayValue::ArrayValue(_In_ const void* elem, int nelem, QualType etype, _In_ const hkReflect::Detail::Impl* elemImpl, bool isDynamic)
        : m_elemPtr(const_cast<void*>(elem)), m_elemType(etype), m_numElem(nelem), m_elemSize(0), m_elemImpl(elemImpl, isDynamic)
    {
        if (etype)
        {
            m_elemSize = etype->getSizeOf();
            if (!elemImpl)
            {
                m_elemImpl = etype->getImpl();
            }
        }
    }
    HK_INLINE ArrayValue ArrayValue::slice(int startIdx, int endIdx)
    {
        HK_ASSERT_NO_MSG(0x7d783476, startIdx < endIdx);
        HK_ASSERT_NO_MSG(0x1fc6490b, startIdx >= 0 && endIdx <= m_numElem);
        return ArrayValue(hkAddByteOffset(m_elemPtr, m_elemType->getSizeOf()*startIdx), endIdx - startIdx, m_elemType);
    }

    template <typename T>
    HK_INLINE hkArrayView<T> ArrayValue::isArrayOf() const
    {
        if (m_elemType->equals<T>())
        {
            return hkArrayView<T>(static_cast<T*>(m_elemPtr), m_numElem);
        }
        return hkArrayView<T>();
    }

    HK_INLINE _Notvalid_ void* ArrayValue::getEndAddress() const
    {
        return hkAddByteOffset(m_elemPtr, m_numElem * m_elemSize);
    }

    HK_ALWAYS_INLINE Detail::ImplPtr::ImplPtr() {}

    HK_INLINE Detail::ImplPtr::ImplPtr(_In_ const Detail::Impl* impl, bool isDynamic)
        : Base(const_cast<Detail::Impl*>(impl), isDynamic ? IMPL_DYNAMIC : IMPL_NATIVE)
    {
        addRefIfDynamic();
    }

    HK_INLINE Detail::ImplPtr::ImplPtr(const ImplPtr& rhs)
        : Base(rhs)
    {
        addRefIfDynamic();
    }

    HK_INLINE void Detail::ImplPtr::operator=(const ImplPtr& rhs)
    {
        rhs.addRefIfDynamic();
        removeRefIfDynamic();
        Base::operator=(rhs);
    }

#ifdef HK_MOVE_SEMANTICS
    HK_INLINE Detail::ImplPtr::ImplPtr(ImplPtr&& rhs)
        : Base(rhs)
    {
        rhs.set(HK_NULL, IMPL_NATIVE);
    }
    HK_INLINE void Detail::ImplPtr::operator=(ImplPtr&& rhs)
    {
        removeRefIfDynamic();
        Base::operator=(rhs);
        rhs.set(HK_NULL, IMPL_NATIVE);
    }
#endif

    HK_INLINE Detail::ImplPtr::~ImplPtr()
    {
        removeRefIfDynamic();
    }

    HK_INLINE void Detail::ImplPtr::addRefIfDynamic() const
    {
        if (isDynamic())
        {
            getPtr()->addReference();
        }
    }

    HK_INLINE void Detail::ImplPtr::removeRefIfDynamic() const
    {
        if (isDynamic())
        {
            getPtr()->removeReference();
        }
    }
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
