// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/Reflect/Core/hkReflectValue.h>
#include <Common/Base/Container/String/hkString.h>

namespace hkReflect
{

bool StringValue::operator==( StringValue other ) const
{
    return ( m_value == other.m_value )
        || ( ( m_value != HK_NULL ) && ( other.m_value != HK_NULL ) && ( hkString::strCmp( m_value, other.m_value ) == 0 ) );
}

bool StringValue::operator==(_In_opt_z_ const char* other) const
{
    return ( m_value == other )
        || ( ( m_value != HK_NULL ) && ( other != HK_NULL ) && ( hkString::strCmp( m_value, other ) == 0 ) );
}

bool StringValue::operator!=(StringValue other) const
{
    return !((*this) == other);
}

bool StringValue::operator!=(_In_opt_z_ const char* other) const
{
    return !((*this) == other);
}

int StringValue::compare(StringValue other) const
{
    const char* sa = m_value;
    const char* sb = other.m_value;
    if (sa == sb)
    {
        return 0;
    }
    else if (sa == HK_NULL)
    {
        return -1;
    }
    else if (sb == HK_NULL)
    {
        return 1;
    }
    else
    {
        return hkString::strCmp(sa, sb);
    }
}

IntValue operator+(const IntValue& lhs, const IntValue& rhs)
{
    // a + b == sign(a) * abs(a) + sign(b) * abs(b)
    //
    // sign(a) == sign(b) <=> a + b = sign(a) * (abs(a) + abs(b))
    if (lhs.m_negative == rhs.m_negative)
    {
        return IntValue(lhs.m_value + rhs.m_value, lhs.m_negative);
    }
    // sign(a) != sign(b) <=> -sign(a) = sign(b)
    //                    <=> a + b = sign(a) * abs(a) - sign(a) * abs(b)
    //                    <=> a + b = sign(a) * (abs(a) - abs(b))
    //
    // We want to avoid computing a negative number hence:
    // if (abs(a) > abs(b)): a + b =  sign(a) * (abs(a) - abs(b))
    //                 else: a + b = -sign(a) * (abs(b) - abs(a))
    else if (lhs.m_value > rhs.m_value)
    {
        return IntValue(lhs.m_value - rhs.m_value, lhs.m_negative);
    }
    else
    {
        return IntValue(rhs.m_value - lhs.m_value, rhs.m_negative);
    }
}

}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
