// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

namespace hkReflect
{
    namespace Detail
    {
        template <typename Type> HK_INLINE bool kindMatches(hkReflect::Kind kind) { return hkReflect::KindFromType<Type>::kind == kind; }

        template <> HK_INLINE bool kindMatches<hkReflect::ValueType>(hkReflect::Kind kind)
        {
            return kindMatches<hkReflect::IntType>(kind)
                || kindMatches<hkReflect::FloatType>(kind)
                || kindMatches<hkReflect::BoolType>(kind)
                || kindMatches<hkReflect::StringType>(kind);
        }

        template <> HK_INLINE bool kindMatches<hkReflect::ContainerType>(hkReflect::Kind kind)
        {
            return /*kind == KIND_CONTAINER || */kindMatches<hkReflect::ArrayType>(kind);
        }

        template <> HK_INLINE bool kindMatches<hkReflect::CompoundType>(hkReflect::Kind kind)
        {
            return kindMatches<hkReflect::RecordType>(kind)
                || kindMatches<hkReflect::ContainerType>(kind)
                || kindMatches<hkReflect::PointerType>(kind);
        }

        template <> HK_INLINE bool kindMatches<hkReflect::Type>(hkReflect::Kind) { return true; }
    }
}

template<typename T>
hkReflect::Decl::Decl(hkReflect::QualifiedType<T> t)
{
    init(t);
}

template<typename T>
hkReflect::FieldDecl::FieldDecl(hkReflect::QualifiedType<T> t)
{
    init(t);
}

template<typename T>
hkReflect::DataFieldDecl::DataFieldDecl(hkReflect::QualifiedType<T> t)
{
    init(t);
}

template<typename T>
hkReflect::PropertyFieldDecl::PropertyFieldDecl(hkReflect::QualifiedType<T> t)
{
    init(t);
}

HK_INLINE hkReflect::FieldDecl hkReflect::Decl::asField() const
{
    return FieldDecl(m_type);
}
HK_INLINE hkReflect::PropertyFieldDecl hkReflect::Decl::asPropertyField() const
{
    return PropertyFieldDecl(m_type);
}
HK_INLINE hkReflect::DataFieldDecl hkReflect::Decl::asDataField() const
{
    return DataFieldDecl(m_type);
}

template<typename Type, typename FieldType>
hkReflect::DataFieldDecl::DataFieldDecl(_In_ FieldType Type::*memberPointer)
{
    const hkReflect::Type* type = hkReflect::getType<Type>();
    const hkReflect::Type* fieldType = hkReflect::getType<FieldType>();
    hkLong offset = hkLong(&(char&)(reinterpret_cast<Type*>(32)->*memberPointer)) - 32;
    createFromField(type, fieldType, offset);
}

HK_INLINE hkReflect::QualType hkReflect::Decl::getType() const
{
    return m_type;
}

HK_INLINE _Ret_maybenull_ const hkReflect::Type* hkReflect::Type::getParent() const
{
    return m_parent;
}

HK_INLINE hkReflect::Kind hkReflect::Type::getKind() const
{
    return (Kind)(valueGlobal(Opt::FORMAT) & 0xf);
}

template<typename ValueAttribute>
typename ValueAttribute::AttributeType hkReflect::Type::getValueAttribute(typename ValueAttribute::AttributeType ifNotFound) const
{
    if(const ValueAttribute* valAttr = findAttribute<ValueAttribute>())
    {
        return valAttr->m_value;
    }
    else
    {
        return ifNotFound;
    }
}


HK_INLINE bool hkReflect::DeclIterAll::advance()
{
    const Decl* d = hkAddByteOffset(m_declCur, sizeof(void*));
    if(d < m_declEnd) { m_declCur = d; return true; }
    else return advance2();
}


template<typename DECL>
HK_INLINE bool hkReflect::DeclIter<DECL>::advance()
{
    while( m_it.advance() )
    {
        if( m_it.current().getFlags().anyIsSet(DECL::MASK) )
        {
            return true;
        }
    }
    return false;
}

template<typename DECL>
HK_INLINE bool hkReflect::FilteredDeclIter<DECL>::advance()
{
    while(DeclIter<DECL>::advance())
    {
        if( m_filter(this->current()) )
        {
            return true;
        }
    }
    return false;
}


// TemplateParams


inline int hkReflect::Template::getNumParams() const
{
    return m_numParams & 0xffff;
}


inline _Ret_notnull_ const hkReflect::Template::Parameter* hkReflect::Template::getParams() const
{
    return reinterpret_cast<const hkReflect::Template::Parameter*>(this + 1);
}

inline _Ret_notnull_ const hkReflect::Template::Parameter* hkReflect::Template::getParam(int idx) const
{
    HK_ASSERT_NO_MSG(0x62c86cab, idx < getNumParams());
    const hkReflect::Template::Parameter* params = getParams();

    return params + idx;
}


#define HK_REFLECT_TYPE_TO_KIND_METHODS(KIND, METH_NAME) \
    HK_INLINE _Ret_maybenull_ const hkReflect::KIND* hkReflect::Type::METH_NAME() const \
    { \
        return hkReflect::Detail::kindMatches< KIND >(getKind()) ? static_cast<const KIND *>(this) : HK_NULL; \
    } \
    HK_INLINE _Ret_maybenull_ hkReflect::KIND* hkReflect::Type::METH_NAME() \
    { \
        return hkReflect::Detail::kindMatches< KIND >(getKind()) ? static_cast< KIND *>(this) : HK_NULL; \
    }

HK_REFLECT_TYPE_TO_KIND_METHODS(VoidType, asVoid);
HK_REFLECT_TYPE_TO_KIND_METHODS(ValueType, asValue);
HK_REFLECT_TYPE_TO_KIND_METHODS(BoolType, asBool);
HK_REFLECT_TYPE_TO_KIND_METHODS(IntType, asInteger);
HK_REFLECT_TYPE_TO_KIND_METHODS(FloatType, asFloat);
HK_REFLECT_TYPE_TO_KIND_METHODS(StringType, asString);
HK_REFLECT_TYPE_TO_KIND_METHODS(PointerType, asPointer);
HK_REFLECT_TYPE_TO_KIND_METHODS(CompoundType, asCompound);
HK_REFLECT_TYPE_TO_KIND_METHODS(ArrayType, asArray);
HK_REFLECT_TYPE_TO_KIND_METHODS(RecordType, asRecord);
HK_REFLECT_TYPE_TO_KIND_METHODS(OpaqueType, asOpaque);

#undef HK_REFLECT_CAST_TO_KIND_METHODS

HK_INLINE bool hkReflect::Type::isPolymorphic() const
{
    return valueGlobal(Opt::EXACT_TYPE) != 0;
}

HK_INLINE hkReflect::FieldDecl hkReflect::Type::isField() const
{
    return FieldDecl(QualType(this));
}

HK_INLINE bool hkReflect::Type::isDynamicType() const
{
    return getTypeFlags().anyIsSet(TYPE_DYNAMIC);
}

HK_INLINE bool hkReflect::Type::hasOwnVtable() const
{
    return getTypeFlags().anyIsSet(TYPE_OWN_VTABLE);
}

HK_INLINE bool hkReflect::Type::isAbstract() const
{
    return getTypeFlags().anyIsSet(TYPE_ABSTRACT);
}

HK_INLINE bool hkReflect::Type::isTypedef() const
{
    return isDecorator() && hasLocal(Opt::NAME);
}

HK_INLINE _Ret_maybenull_ const hkReflect::Type* hkReflect::Decl::getDeclContext() const
{
    return m_type ? m_type->getDeclContext() : HK_NULL;
}

HK_INLINE bool hkReflect::Type::hasCustomSetter() const
{
    return isField() ? isField().hasCustomSetter() : false;
}

HK_INLINE bool hkReflect::Type::hasCallbacks() const
{
    return isField() ? isField().hasCallbacks() : false;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
