// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/Reflect/Visitor/hkReflectVisitor.h>
#include <Common/Base/Container/String/hkStringBuf.h>
#include <Common/Base/Reflect/Core/Detail/hkReflectTypeDetail.h>
#include <Common/Base/Reflect/Core/hkReflectCallable.h>
#include <Common/Base/System/hkBaseSystem.h>
#include <Common/Base/System/Log/hkLog.h>
#include <Common/Base/System/Hardware/hkHardwareInfo.h>
#include <limits.h>

#if defined(HK_SSE_VERSION) && (HK_CONFIG_SIMD == HK_CONFIG_SIMD_ENABLED) && defined(HK_ARCH_INTEL)
#define HK_INDEXOF_USE_POPCNT
#endif

//HK_COMPILE_TIME_ASSERT(sizeof(hkReflect::Type) == sizeof(hkReflect::Detail::TypeData));
HK_COMPILE_TIME_ASSERT(sizeof(hkReflect::FieldDecl) == sizeof(hkReflect::Detail::RecordFieldPod));

// ----------------------- Explicitly sized built-in types definition ------------------------ //

// Storages of explicitly sized basic types
#define REGISTER_TYPE2(SYMBOL, TYPE) \
    static hkReflect::Detail::TypeRegNode SYMBOL(HK_REFLECT_GET_NON_CONST_TYPE(TYPE))
#define REGISTER_TYPE(TYPE) REGISTER_TYPE2(TYPE##_typeRegNode, TYPE)
#define REGISTER_TYPE_MANUAL(TYPE, BASE) \
    static hkReflect::Detail::TypeRegNode TYPE##_typeRegNode(BASE)

namespace
{
    hkLog::RegisteredOrigin ReflectionLog("Reflection", hkLog::Level::Info);

    template<typename T>
    struct AlignOfHack
    {
        enum { Value = HK_ALIGN_OF(T) };
    };

    // This exact block is in hkTypeCopier.cpp also
    #if HK_POINTER_SIZE == 4
        #if defined(HK_PLATFORM_WIIU)
        #elif defined(HK_PLATFORM_WIN32)
        #elif (defined(HK_PLATFORM_ANDROID) && defined(HK_ARCH_ARM)) || defined(HK_PLATFORM_PSVITA)
        #else // everything else
            template<> struct AlignOfHack<signed long long> { enum { Value = 4 }; };
            template<> struct AlignOfHack<unsigned long long> { enum { Value = 4 }; };
            template<> struct AlignOfHack<double> { enum { Value = 4 }; };
        #endif
    #endif
};

HK_EXPORT_COMMON hkLog::RegisteredOrigin& hkReflect::Detail::getLog()
{
    return ReflectionLog;
}


hkReflect::Detail::TypeData hkReflect::ReflectionOf<void>::typeData =
{
    hkReflect::Opt::FORMAT | hkReflect::Opt::NAME | hkReflect::Opt::INHERITANCE | hkReflect::Opt::SIZE_ALIGN | hkReflect::Opt::FLAGS,
    0, //parent
    HK_REFLECT_TYPE_OPTIONAL(Opt::FORMAT, hkReflect::Format::OfVoid::Value),
    HK_REFLECT_TYPE_OPTIONAL(Opt::NAME, "void"),
    HK_REFLECT_TYPE_OPTIONAL(Opt::INHERITANCE, 0),
    HK_REFLECT_TYPE_OPTIONAL(Opt::SIZE_ALIGN, 0),
    HK_REFLECT_TYPE_OPTIONAL(Opt::FLAGS, hkReflect::Type::TYPE_NOT_SERIALIZABLE)
};
REGISTER_TYPE(void);

hkReflect::Detail::TypeData hkReflect::ReflectionOf<bool>::typeData =
{
    hkReflect::Opt::FORMAT | hkReflect::Opt::IMPL | hkReflect::Opt::NAME | hkReflect::Opt::DEF_CONSTRUCTOR | hkReflect::Opt::COPY_CONSTRUCTOR |
    hkReflect::Opt::COPY_ASSIGNMENT | hkReflect::Opt::INHERITANCE | hkReflect::Opt::ALLOC_IMPL | hkReflect::Opt::SIZE_ALIGN,
    0, //parent
    HK_REFLECT_TYPE_OPTIONAL(Opt::FORMAT, hkReflect::Format::OfBool<bool>::Value),
    HK_REFLECT_TYPE_OPTIONAL(Opt::IMPL, &hkReflect::Detail::BoolImplN<bool>::s_instance),
    HK_REFLECT_TYPE_OPTIONAL(Opt::NAME, "bool"),
    HK_REFLECT_TYPE_OPTIONAL(Opt::DEF_CONSTRUCTOR, hkReflect::Detail::Trivial<hkReflect::Opt::DEF_CONSTRUCTOR>::func),
    HK_REFLECT_TYPE_OPTIONAL(Opt::COPY_CONSTRUCTOR, hkReflect::Detail::Trivial<hkReflect::Opt::COPY_CONSTRUCTOR>::func),
    HK_REFLECT_TYPE_OPTIONAL(Opt::COPY_ASSIGNMENT, hkReflect::Detail::Trivial<hkReflect::Opt::COPY_ASSIGNMENT>::func),
    HK_REFLECT_TYPE_OPTIONAL(Opt::INHERITANCE, 0),
    HK_REFLECT_TYPE_OPTIONAL(Opt::ALLOC_IMPL, &hkReflect::Detail::HeapAllocImpl::s_instance),
    HK_REFLECT_TYPE_OPTIONAL_SIZE_ALIGN(sizeof(bool), HK_ALIGN_OF(bool), 0)
};
REGISTER_TYPE(bool);


typedef char* charstar;
namespace hkReflect {
hkReflect::Detail::TypeData ReflectionOf<charstar>::typeData =
{
    hkReflect::Opt::FORMAT | hkReflect::Opt::IMPL | hkReflect::Opt::NAME | hkReflect::Opt::DEF_CONSTRUCTOR | hkReflect::Opt::COPY_CONSTRUCTOR |
    hkReflect::Opt::COPY_ASSIGNMENT | hkReflect::Opt::INHERITANCE | hkReflect::Opt::ALLOC_IMPL | hkReflect::Opt::SIZE_ALIGN,
    0, //parent
    HK_REFLECT_TYPE_OPTIONAL(Opt::FORMAT, hkReflect::Format::OfStringUtf8<0, false>::Value),
    HK_REFLECT_TYPE_OPTIONAL(Opt::IMPL, &hkReflect::Detail::StaticStringImpl::s_instance),
    HK_REFLECT_TYPE_OPTIONAL(Opt::NAME, "char*"),
    HK_REFLECT_TYPE_OPTIONAL(Opt::DEF_CONSTRUCTOR, hkReflect::Detail::Trivial<hkReflect::Opt::DEF_CONSTRUCTOR>::func),
    HK_REFLECT_TYPE_OPTIONAL(Opt::COPY_CONSTRUCTOR, hkReflect::Detail::Trivial<hkReflect::Opt::COPY_CONSTRUCTOR>::func),
    HK_REFLECT_TYPE_OPTIONAL(Opt::COPY_ASSIGNMENT, hkReflect::Detail::Trivial<hkReflect::Opt::COPY_ASSIGNMENT>::func),
    HK_REFLECT_TYPE_OPTIONAL(Opt::INHERITANCE, 0),
    HK_REFLECT_TYPE_OPTIONAL(Opt::ALLOC_IMPL, &hkReflect::Detail::HeapAllocImpl::s_instance),
    HK_REFLECT_TYPE_OPTIONAL_SIZE_ALIGN(sizeof(char*), HK_ALIGN_OF(char*), 0)
};
}
REGISTER_TYPE(charstar);

HK_TRACKEROF_DEFINE_REFLECTED(charstar);

typedef const char* constcharstar;
namespace hkReflect {
    hkReflect::Detail::TypeData ReflectionOf<constcharstar>::typeData =
    {
        hkReflect::Opt::FORMAT | hkReflect::Opt::IMPL | hkReflect::Opt::NAME | hkReflect::Opt::DEF_CONSTRUCTOR | hkReflect::Opt::COPY_CONSTRUCTOR |
        hkReflect::Opt::COPY_ASSIGNMENT | hkReflect::Opt::INHERITANCE | hkReflect::Opt::ALLOC_IMPL | hkReflect::Opt::SIZE_ALIGN,
        0, //parent
        HK_REFLECT_TYPE_OPTIONAL(Opt::FORMAT, hkReflect::Format::OfStringUtf8<0, true>::Value),
        HK_REFLECT_TYPE_OPTIONAL(Opt::IMPL, &hkReflect::Detail::StaticStringImpl::s_instance),
        HK_REFLECT_TYPE_OPTIONAL(Opt::NAME, "const char*"),
        HK_REFLECT_TYPE_OPTIONAL(Opt::DEF_CONSTRUCTOR, hkReflect::Detail::Trivial<hkReflect::Opt::DEF_CONSTRUCTOR>::func),
        HK_REFLECT_TYPE_OPTIONAL(Opt::COPY_CONSTRUCTOR, hkReflect::Detail::Trivial<hkReflect::Opt::COPY_CONSTRUCTOR>::func),
        HK_REFLECT_TYPE_OPTIONAL(Opt::COPY_ASSIGNMENT, hkReflect::Detail::Trivial<hkReflect::Opt::COPY_ASSIGNMENT>::func),
        HK_REFLECT_TYPE_OPTIONAL(Opt::INHERITANCE, 0),
        HK_REFLECT_TYPE_OPTIONAL(Opt::ALLOC_IMPL, &hkReflect::Detail::HeapAllocImpl::s_instance),
        HK_REFLECT_TYPE_OPTIONAL_SIZE_ALIGN(sizeof(const char*), HK_ALIGN_OF(const char*), 0)
    };
}
REGISTER_TYPE(constcharstar);

HK_TRACKEROF_DEFINE_REFLECTED(constcharstar);

HK_TRACKEROF_DEFINE_REFLECTED(void*);

#define POD_INTEGER_TYPE(TYPE_NAME) \
    hkReflect::Detail::TypeData hkReflect::ReflectionOf<TYPE_NAME>::typeData = \
    {   \
        hkReflect::Opt::FORMAT | hkReflect::Opt::IMPL | hkReflect::Opt::NAME | hkReflect::Opt::DEF_CONSTRUCTOR | hkReflect::Opt::COPY_CONSTRUCTOR | \
        hkReflect::Opt::COPY_ASSIGNMENT | hkReflect::Opt::INHERITANCE | hkReflect::Opt::ALLOC_IMPL | hkReflect::Opt::SIZE_ALIGN, \
        0, \
        HK_REFLECT_TYPE_OPTIONAL(Opt::FORMAT, hkReflect::Format::OfInt<TYPE_NAME>::Value), \
        HK_REFLECT_TYPE_OPTIONAL(Opt::IMPL, &hkReflect::Detail::IntImplN<TYPE_NAME>::s_instance), \
        HK_REFLECT_TYPE_OPTIONAL(Opt::NAME, #TYPE_NAME), \
        HK_REFLECT_TYPE_OPTIONAL(Opt::DEF_CONSTRUCTOR, hkReflect::Detail::Trivial<hkReflect::Opt::DEF_CONSTRUCTOR>::func), \
        HK_REFLECT_TYPE_OPTIONAL(Opt::COPY_CONSTRUCTOR, hkReflect::Detail::Trivial<hkReflect::Opt::COPY_CONSTRUCTOR>::func), \
        HK_REFLECT_TYPE_OPTIONAL(Opt::COPY_ASSIGNMENT, hkReflect::Detail::Trivial<hkReflect::Opt::COPY_ASSIGNMENT>::func), \
        HK_REFLECT_TYPE_OPTIONAL(Opt::INHERITANCE, 0), \
        HK_REFLECT_TYPE_OPTIONAL(Opt::ALLOC_IMPL, &hkReflect::Detail::HeapAllocImpl::s_instance), \
        HK_REFLECT_TYPE_OPTIONAL_SIZE_ALIGN(sizeof(TYPE_NAME), AlignOfHack<TYPE_NAME>::Value, 0) \
    }; \
    REGISTER_TYPE2(HK_PREPROCESSOR_JOIN_TOKEN(int,__LINE__), TYPE_NAME)

// Ensure the list in hkTypeCopier.cpp FOREACH_BUILTIN_TYPE matches
POD_INTEGER_TYPE(signed char);
POD_INTEGER_TYPE(unsigned char);
POD_INTEGER_TYPE(short);
POD_INTEGER_TYPE(unsigned short);
POD_INTEGER_TYPE(int);
POD_INTEGER_TYPE(unsigned int);
POD_INTEGER_TYPE(long);
POD_INTEGER_TYPE(unsigned long);
POD_INTEGER_TYPE(long long);
POD_INTEGER_TYPE(unsigned long long);

hkReflect::Detail::TypeData hkReflect::ReflectionOf<float>::typeData =
{
    hkReflect::Opt::FORMAT | hkReflect::Opt::IMPL | hkReflect::Opt::NAME | hkReflect::Opt::DEF_CONSTRUCTOR | hkReflect::Opt::COPY_CONSTRUCTOR |
    hkReflect::Opt::COPY_ASSIGNMENT | hkReflect::Opt::INHERITANCE | hkReflect::Opt::ALLOC_IMPL | hkReflect::Opt::SIZE_ALIGN,
    0, //parent
    HK_REFLECT_TYPE_OPTIONAL(Opt::FORMAT, hkReflect::Format::OfFloat<float>::Value),
    HK_REFLECT_TYPE_OPTIONAL(Opt::IMPL, &hkReflect::Detail::FloatImplN<float>::s_instance),
    HK_REFLECT_TYPE_OPTIONAL(Opt::NAME, "float"),
    HK_REFLECT_TYPE_OPTIONAL(Opt::DEF_CONSTRUCTOR, hkReflect::Detail::Trivial<hkReflect::Opt::DEF_CONSTRUCTOR>::func),
    HK_REFLECT_TYPE_OPTIONAL(Opt::COPY_CONSTRUCTOR, hkReflect::Detail::Trivial<hkReflect::Opt::COPY_CONSTRUCTOR>::func),
    HK_REFLECT_TYPE_OPTIONAL(Opt::COPY_ASSIGNMENT, hkReflect::Detail::Trivial<hkReflect::Opt::COPY_ASSIGNMENT>::func),
    HK_REFLECT_TYPE_OPTIONAL(Opt::INHERITANCE, 0),
    HK_REFLECT_TYPE_OPTIONAL(Opt::ALLOC_IMPL, &hkReflect::Detail::HeapAllocImpl::s_instance),
    HK_REFLECT_TYPE_OPTIONAL_SIZE_ALIGN(sizeof(float), HK_ALIGN_OF(float), 0)
};

hkReflect::Detail::TypeData hkReflect::ReflectionOf<double>::typeData =
{
    hkReflect::Opt::FORMAT | hkReflect::Opt::IMPL | hkReflect::Opt::NAME | hkReflect::Opt::DEF_CONSTRUCTOR | hkReflect::Opt::COPY_CONSTRUCTOR |
    hkReflect::Opt::COPY_ASSIGNMENT | hkReflect::Opt::INHERITANCE | hkReflect::Opt::ALLOC_IMPL | hkReflect::Opt::SIZE_ALIGN,
    0, //parent
    HK_REFLECT_TYPE_OPTIONAL(Opt::FORMAT, hkReflect::Format::OfFloat<double>::Value),
    HK_REFLECT_TYPE_OPTIONAL(Opt::IMPL, &hkReflect::Detail::FloatImplN<double>::s_instance),
    HK_REFLECT_TYPE_OPTIONAL(Opt::NAME, "double"),
    HK_REFLECT_TYPE_OPTIONAL(Opt::DEF_CONSTRUCTOR, hkReflect::Detail::Trivial<hkReflect::Opt::DEF_CONSTRUCTOR>::func),
    HK_REFLECT_TYPE_OPTIONAL(Opt::COPY_CONSTRUCTOR, hkReflect::Detail::Trivial<hkReflect::Opt::COPY_CONSTRUCTOR>::func),
    HK_REFLECT_TYPE_OPTIONAL(Opt::COPY_ASSIGNMENT, hkReflect::Detail::Trivial<hkReflect::Opt::COPY_ASSIGNMENT>::func),
    HK_REFLECT_TYPE_OPTIONAL(Opt::INHERITANCE, 0),
    HK_REFLECT_TYPE_OPTIONAL(Opt::ALLOC_IMPL, &hkReflect::Detail::HeapAllocImpl::s_instance),
    HK_REFLECT_TYPE_OPTIONAL_SIZE_ALIGN(sizeof(double), AlignOfHack<double>::Value, 0)
};

REGISTER_TYPE(float);
REGISTER_TYPE(double);

// ----------------------- Platform dependent built-in types definition ------------------------ //

//

//
POD_INTEGER_TYPE(char);


#if 0
hkReflect::Detail::TypeData hkReflect::ReflectionOf<hkQuadReal>::typeData = {
    hkReflect::Opt::FORMAT | hkReflect::Opt::SUBTYPE |hkReflect::Opt::IMPL | hkReflect::Opt::NAME | hkReflect::Opt::DEF_CONSTRUCTOR | hkReflect::Opt::COPY_CONSTRUCTOR |
    hkReflect::Opt::COPY_ASSIGNMENT | hkReflect::Opt::INHERITANCE | hkReflect::Opt::ALLOC_IMPL | hkReflect::Opt::SIZE_ALIGN,
    HK_NULL, //parent
    HK_REFLECT_TYPE_OPTIONAL(Opt::FORMAT, hkReflect::Format::OfArray<4>::Value),
    HK_REFLECT_TYPE_OPTIONAL(Opt::SUBTYPE, &hkReflect::ReflectionOf<hkReal>::typeData),
    HK_REFLECT_TYPE_OPTIONAL(Opt::IMPL, &hkReflect::Detail::RepeatImpl::s_instance),
    HK_REFLECT_TYPE_OPTIONAL(Opt::NAME, "hkQuadReal"),
    HK_REFLECT_TYPE_OPTIONAL(Opt::DEF_CONSTRUCTOR, hkReflect::Detail::Trivial<hkReflect::Opt::DEF_CONSTRUCTOR>::func),
    HK_REFLECT_TYPE_OPTIONAL(Opt::COPY_CONSTRUCTOR, hkReflect::Detail::Trivial<hkReflect::Opt::COPY_CONSTRUCTOR>::func),
    HK_REFLECT_TYPE_OPTIONAL(Opt::COPY_ASSIGNMENT, hkReflect::Detail::Trivial<hkReflect::Opt::COPY_ASSIGNMENT>::func),
    HK_REFLECT_TYPE_OPTIONAL(Opt::INHERITANCE, 0),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::ALLOC_IMPL, &hkReflect::Detail::HeapAllocImpl::s_instance),
    HK_REFLECT_TYPE_OPTIONAL_SIZE_ALIGN( sizeof(hkQuadReal), HK_ALIGN_OF(hkQuadReal), 0)
};
REGISTER_TYPE( hkQuadReal );
#endif

#if defined(HK_INDEXOF_USE_POPCNT)

#if HK_SSE_VERSION >= 0x42

static const bool s_supportsPopCnt = true;

#else /* HK_SSE_VERSION < 0x42 */

static bool s_supportsPopCnt = false;

static hkResult checkPopCntSupport(void*)
{
    hkHardwareInfo info;
    s_supportsPopCnt = info.m_cpuFeatures & hkHardwareInfo::POPCNT;
    return HK_SUCCESS;
}

static hkBaseSystem::InitNode s_checkPopCntSupport("Check support for _mm_popcnt_u32", &checkPopCntSupport, nullptr, nullptr);

#endif /* HK_SSE_VERSION >= 0x42 */

#endif /* defined(HK_INDEXOF_USE_POPCNT) */

static HK_INLINE int s_indexOf(hkUlong optionalUlong, hkUint32 opt)
{
    hkUint32 optional = hkLosslessCast<hkUint32>(optionalUlong);
    HK_ASSERT_NO_MSG(0x69c3508f, optional & opt);
    hkUint32 bits = optional & (opt-1);

    return hkMath::countBitsSet(bits);
}

_Ret_notnull_ hkUlong* hkReflect::Type::accessLocal(hkReflect::Optional opt) const
{
    HK_ASSERT_NO_MSG(0x2ef6aaf8, m_optional & opt);
    int index = s_indexOf(m_optional, opt);
    return optionalsArray() + index;
}


_Ret_notnull_ hkUlong* hkReflect::Type::addressLocalUnchecked(hkReflect::Optional opt) const
{
    HK_ASSERT_NO_MSG(0x6b7bf16f, m_optional & opt);
    int index = s_indexOf(m_optional, opt);
    return optionalsArray() + index;
}

_Ret_maybenull_ hkUlong* hkReflect::Type::addressGlobal(hkReflect::Optional opt) const
{
    const Type* cur = this;
    do
    {
        if(cur->m_optional & opt)
        {
            int index = s_indexOf(cur->m_optional, opt);
            return cur->optionalsArray() + index;
        }
        else
        {
            cur = cur->getParent();
        }
    } while(cur);
    return HK_NULL;
}

_Ret_maybenull_ hkUlong* hkReflect::Type::addressDecorator(hkReflect::Optional opt) const
{
    const Type* cur = this;
    do
    {
        if(cur->m_optional & opt)
        {
            int index = s_indexOf(cur->m_optional, opt);
            return cur->optionalsArray() + index;
        }
        else if( cur->m_optional & Opt::FORMAT )
        {
            return HK_NULL;
        }
        else
        {
            cur = cur->getParent();
        }
    } while(cur);
    return HK_NULL;
}
hkReflect::Var hkReflect::Type::getDefault() const
{
    if( const void* d = valueDecorator<void*>(Opt::DEFAULT) )
    {
        return Var(d, this);
    }
    return Var();
}

int hkReflect::Type::getSizeOf() const
{
    return Detail::SizeAlign(valueDecorator(Opt::SIZE_ALIGN)).m_sizeOf;
}

int hkReflect::Type::getAlignOf() const
{
    return Detail::SizeAlign(valueDecorator(Opt::SIZE_ALIGN)).m_alignOf;
}

_Ret_maybenull_ const hkReflect::Template* hkReflect::Type::getTemplate() const
{
    const Type* cur = this;
    do
    {
        if (cur->m_optional & Opt::TEMPLATE)
        {
            int index = s_indexOf(cur->m_optional, Opt::TEMPLATE);
            return reinterpret_cast<const hkReflect::Template*>(*(cur->optionalsArray() + index));
        }
        else if (cur->m_optional & (Opt::FORMAT |Opt::NAME))
        {
            return HK_NULL;
        }
        else
        {
            cur = cur->getParent();
        }
    } while (cur);
    return HK_NULL;
}

bool hkReflect::Type::extendsOrEquals(_In_ const Type* test) const
{
    HK_ASSERT_NO_MSG(0x5abcf751, this);
    HK_ASSERT_NO_MSG(0x6c8b6c8a, test);

    const Type* self = this;
    if (self == test)
    {
        return true;
    }

#if defined(HK_DEBUG_SLOW)
    const void* typeWorldA = this->getTypeWorld();
    const void* typeWorldB = test->getTypeWorld();
    HK_ASSERTV(0x636cf2ff, typeWorldA == typeWorldB, "Types {} and {} belong to different worlds and cannot be compared", this->getFullName(), test->getFullName());
#endif

    const Detail::InheritanceInfo* ia = TypeDetail::getInheritance(this);
    const Detail::InheritanceInfo* ib = TypeDetail::getInheritance(test);
    if (ia && ib) // both have inheritance info
    {
        // Opt::INHERITANCE is present; additionally check whether the contained data is != 0
        HK_ASSERTV(0x2a9cf1cc, *ia, "The inheritance information for type {} hasn't been precomputed yet - the type needs to be registered first to enable type equality checks.", this->getFullName());
        HK_ASSERTV(0x605530a3, *ib, "The inheritance information for type {} hasn't been precomputed yet - the type needs to be registered first to enable type equality checks.", test->getFullName());

        int thisPreOrder = ia->getPreOrder();
        int testPreOrder = ib->getPreOrder();
        int testRightMost = ib->getRightMost();

        // since intervals never overlap we can use thisPreOrder for both ends of the comparison.
        // i.e. is equivalent to ( thisPreOrder >= testPreOrder && thisRightMost <= testRightMost )
        return thisPreOrder >= testPreOrder && thisPreOrder <= testRightMost;
    }
    else
    {
        // At least one type doesn't have inheritance info, so it's dynamic type or non-builtin (temp types in serialization).
        // Either way, in both cases equality is established by pointer identity (see the comments in equals() ), so we iterate over the parents of self
        // and see if one matches test (without decorators).

        test = TypeDetail::skipDecorators(test);

        for (const Type* parent = self; parent; parent = parent->getParent())
        {
            if (parent == test)
            {
                return true;
            }
        }

        return false;
    }
}

bool hkReflect::Type::implements(_In_ const hkReflect::Type* interfaceType) const
{
    // Check main inheritance branch.
    if(this->extendsOrEquals(interfaceType))
    {
        return true;
    }
    // can't use the builtin optional logic since we want to find them all
    for(const Type* type = this; type != HK_NULL; type = type->getParent())
    {
        if(const Detail::InterfaceArray* ifacesPtr = type->valueLocal<const Detail::InterfaceArray*>(Opt::INTERFACES))
        {
            hkArrayView<const Detail::Interface> ifaces = ifacesPtr->items();
            for(int i = 0; i < ifaces.getSize(); ++i)
            {
                if(ifaces[i].m_interfaceType->implements(interfaceType))
                {
                    return true;
                }
            }
        }
    }
    return false;
}


static void _getImplemented(_In_opt_ const hkReflect::Type* root, hkArray<const hkReflect::Type*>& typesOut)
{
    using namespace hkReflect;
    for (const Type* type = root; type != HK_NULL; type = type->getParent())
    {
        // Check for duplicates, the same interface might be repeated in the hierarchy.
        int idx = 0;
        for (; idx < typesOut.getSize(); ++idx)
        {
            if (type->equals(typesOut[idx]))
            {
                break;
            }
        }
        if (idx == typesOut.getSize())
        {
            typesOut.pushBack(type);
        }
        if (const Detail::InterfaceArray* ifacesPtr = TypeDetail::localGetOptional<Opt::INTERFACES>(type))
        {
            hkArrayView<const Detail::Interface> ifaces = ifacesPtr->items();
            for (int i = 0; i < ifaces.getSize(); ++i)
            {
                _getImplemented( ifaces[i].m_interfaceType, typesOut );
            }
        }
    }
}

void hkReflect::Type::getImplemented(hkArray<const hkReflect::Type*>& typesOut) const
{
    // We must make sure to clear this array, since otherwise we might not
    // descend into parent types (already part of the array) because of the duplicate check in _getImplemented.
    typesOut.clear();
    _getImplemented(this, typesOut);
}



_Ret_maybenull_ const hkReflect::Type* hkReflect::Type::getCommonAncestor(_In_opt_ const hkReflect::Type* type0, _In_ const hkReflect::Type* type1)
{
    const hkReflect::Type* current = type0;

    while (current != HK_NULL && !type1->extendsOrEquals(current))
    {
        current = current->getParent();
    }

    return current;
}

_Ret_z_ const char* hkReflect::Type::getName() const
{
    return valueDecorator<const char*>(Opt::NAME);
}

_Ret_maybenull_ const void* hkReflect::Type::getTypeWorld() const
{
    return valueDecorator<const void*>(Opt::TYPE_WORLD);
}

_Ret_maybenull_ const hkReflect::Detail::Impl* hkReflect::Type::getImpl() const
{
    return valueGlobal<Detail::Impl*>(Opt::IMPL);
}

int hkReflect::Type::getVersion() const
{
    return (int)valueDecorator(Opt::VERSION);
}

hkReflect::TypeName hkReflect::Type::getFullName() const
{
    return TypeName(getName(), getTemplate());
}

_Ret_maybenull_ const hkReflect::Type* hkReflect::Type::getDeclContext() const
{
    return valueDecorator<const Type*>(Opt::DECL_CONTEXT);
}


hkReflect::Type::Flags hkReflect::Type::getTypeFlags() const
{
    // Flags are the logical OR of all decorator parents
    // This mimics the behavior of the normal Opt::XXX
    hkUlong f = 0;
    const hkReflect::Type* cur = this;
    do {
        f |= cur->valueLocal(Opt::FLAGS);
        if( cur->hasLocal(Opt::FORMAT) )
        {
            break;
        }
        cur = cur->getParent();
    } while(cur);

    return Flags(hkLosslessCast<hkUint16>(f));
}


const char* hkReflect::Type::getFullName(hkStringBuf& nameBuf, AppendNameForTypeCallback callback /*= HK_NULL*/, AppendFullNameForTypeCallback fullNameCallback /*= HK_NULL*/) const
{
    if (callback)
    {
        callback(this, nameBuf);
    }
    else
    {
        nameBuf = getName();
        if (nameBuf.getLength() == 0)
        {
            nameBuf = "unnamed";
        }
    }

    if (const hkReflect::Template* params = getTemplate())
    {
        if (params->getNumParams())
        {
            nameBuf.append("< ");

            for (int i = 0; i < params->getNumParams(); i++)
            {
                const hkReflect::Template::Parameter* thisParam = params->getParam(i);
                if (i > 0)
                {
                    nameBuf.append(", ");
                }

                if (thisParam->isType())
                {
                    const hkReflect::Type* templateParamType = thisParam->getAsType();
                    if (fullNameCallback)
                    {
                        fullNameCallback(templateParamType, nameBuf);
                    }
                    else if (!templateParamType)
                    {
                        nameBuf.append("(null)");
                    }
                    else
                    {
                        hkStringBuf tempBuf;
                        nameBuf.append(templateParamType->getFullName(tempBuf, callback, fullNameCallback));
                    }
                }
                else
                {
                    nameBuf.appendPrintf("%u", thisParam->getAsValue());
                }
            }

            nameBuf.append(" >");
        }
    }

    return nameBuf.cString();
}


hkReflect::Decl hkReflect::Type::findDecl(_In_opt_z_ const char* name, bool parents) const
{
    if ( name )
    {
        for (const hkReflect::Type* cur = this; cur; )
        {
            while (cur->isDecorator())
            {
                cur = cur->getParent();
            }
            if (const hkReflect::Detail::DeclsArray* decls = cur->valueDecorator<hkReflect::Detail::DeclsArray*>(Opt::DECLS))
            {
                for (auto decl : decls->getAllDecls())
                {
                    if (const char* n = decl.getName())
                    {
                        if (hkString::strCmp(name, n) == 0)
                        {
                            return decl;
                        }
                    }
                }
            }
            if (parents)
            {
                cur = cur->getParent();
            }
            else
            {
                break;
            }
        }
    }
    return hkReflect::Decl();
}


hkReflect::Var hkReflect::Type::findAttribute(_In_ const hkReflect::Type* type) const
{
    const hkReflect::Type* cur = this;
    do {
        if( Var attr = TypeDetail::localFindAttribute( cur, type ) )
        {
            return attr;
        }
        cur = cur->getParent();
    } while(cur);
    return Var();
}


hkReflect::DeclIterAll::DeclIterAll(_In_ const hkReflect::Type* t, _In_opt_ const Type* startAfter)
{
    m_declCur = HK_NULL;
    m_declEnd = HK_NULL;
    m_curType = startAfter;
    m_endType = t;
}

bool hkReflect::DeclIterAll::advance2()
{
    const hkReflect::Type* nextType = HK_NULL;
    const hkReflect::Detail::DeclsArray* nextDecls = HK_NULL;
    // find the first parent which hasn't been traversed and has some decls.
    for( const hkReflect::Type* t = m_endType; t != m_curType; t = t->getParent() )
    {
        if( auto decls = TypeDetail::localGetOptional<Opt::DECLS>(t) )
        {
            if( decls->getFields().getSize() )
            {
                nextType = t;
                nextDecls = decls;
            }
        }
    }
    if( nextType ) // there was a parent
    {
        auto fields = nextDecls->getFields();
        m_curType = nextType;
        m_declCur = fields.begin();
        m_declEnd = fields.end();
        return true;
    }
    return false;
}

// ------------------------- hkReflect::IntType ---------------------------- //

bool hkReflect::IntType::isSigned() const
{
    hkReflect::Format::IntValue format =
        hkReflect::Format::Value::create(hkLosslessCast<hkUint32>(valueDecorator(Opt::FORMAT)));
    return format.isSigned();
}

// -------------------------- hkReflect::RecordType ---------------------------- //

hkReflect::RecordType::RecordType(const RecordType&)
    : CompoundType()
{
    HK_ASSERT_NO_MSG(0x2734a90e,0);
}


_Ret_maybenull_ const hkReflect::RecordType* hkReflect::RecordType::getParentRecord() const
{
    const hkReflect::Type* self = this;
    while (self->isDecorator())
    {
        self = self->getParent();
    }
    const hkReflect::Type* parent = self->getParent();
    HK_ASSERT_NO_MSG(0x1fa7a816, parent == HK_NULL || parent->asRecord());
    return static_cast<const RecordType*>(parent);
}


hkReflect::FieldDecl hkReflect::Type::findField(_In_opt_z_ const char* name, bool includeParents) const
{
    if (name)
    {
        for (const hkReflect::Type* cur = this; cur;)
        {
            hkArrayView<const hkReflect::FieldDecl> fields = cur->getFields();
            for (int i = 0; i < fields.getSize(); i++)
            {
                if (const char* n = fields[i].getName())
                {
                    if (hkString::strCmp(name, n) == 0)
                    {
                        return fields[i];
                    }
                }
            }
            cur = includeParents ? TypeDetail::skipDecorators(cur->getParent()) : HK_NULL;
        }
    }
    return hkReflect::FieldDecl();
}

hkReflect::FieldDecl hkReflect::Type::findFieldNoCase(_In_opt_z_ const char* name, bool includeParents) const
{
    if (name)
    {
        for (const hkReflect::Type* cur = this; cur;)
        {
            hkArrayView<const hkReflect::FieldDecl> fields = cur->getFields();
            for (int i = 0; i < fields.getSize(); i++)
            {
                if (const char* n = fields[i].getName())
                {
                    if (hkString::strCasecmp(name, n) == 0)
                    {
                        return fields[i];
                    }
                }
            }
            cur = includeParents ? TypeDetail::skipDecorators(cur->getParent()) : HK_NULL;
        }
    }
    return hkReflect::FieldDecl();
}

_Ret_maybenull_ const hkReflect::Type* hkReflect::typeFromKind( const hkReflect::Kind kind )
{
    switch( kind )
    {
        case hkReflect::KIND_VOID:
            return hkReflect::getType<hkReflect::Type>();
        case hkReflect::KIND_OPAQUE:
            return hkReflect::getType<hkReflect::OpaqueType>();
        case hkReflect::KIND_BOOL:
            return hkReflect::getType<hkReflect::BoolType>();
        case hkReflect::KIND_STRING:
            return hkReflect::getType<hkReflect::StringType>();
        case hkReflect::KIND_INT:
            return hkReflect::getType<hkReflect::IntType>();
        case hkReflect::KIND_FLOAT:
            return hkReflect::getType<hkReflect::FloatType>();
        case hkReflect::KIND_POINTER:
            return hkReflect::getType<hkReflect::PointerType>();
        case hkReflect::KIND_RECORD:
            return hkReflect::getType<hkReflect::RecordType>();
        case hkReflect::KIND_ARRAY:
            return hkReflect::getType<hkReflect::ArrayType>();
        //case hkReflect::KIND_CONTAINER:
        //  return hkReflect::getType<hkReflect::ContainerType>();

        default:
            HK_ASSERT_NO_MSG(0x7fa45e43,0);
    }
    return HK_NULL;
}

hkArrayView<const hkReflect::FieldDecl> hkReflect::Type::getFields() const
{
    auto decls = valueDecorator<hkReflect::Detail::DeclsArray*>(Opt::DECLS);
    if(decls)
    {
        return decls->getFields();
    }

    return hkArrayView<const hkReflect::FieldDecl>();
}

hkArrayView<const hkReflect::DataFieldDecl> hkReflect::Type::getDataFields() const
{
    auto decls = valueDecorator<hkReflect::Detail::DeclsArray*>(Opt::DECLS);
    if(decls)
    {
        return decls->getDataFields();
    }
    return hkArrayView<const hkReflect::DataFieldDecl>();
}

int hkReflect::Type::getNumFields() const
{
    hkReflect::Detail::DeclsArray* fa = valueDecorator<hkReflect::Detail::DeclsArray*>(Opt::DECLS);
    return fa ? fa->getNumFields() : 0;
}

int hkReflect::Type::getNumDataFields() const
{
    hkReflect::Detail::DeclsArray* fa = valueDecorator<hkReflect::Detail::DeclsArray*>(Opt::DECLS);
    return fa ? fa->getNumDataFields() : 0;
}

int hkReflect::Type::getNumPropertyFields() const
{
    hkReflect::Detail::DeclsArray* fa = valueDecorator<hkReflect::Detail::DeclsArray*>(Opt::DECLS);
    return fa ? fa->getNumPropertyFields() : 0;
}

hkReflect::FieldDecl hkReflect::Type::getField(int i) const
{
    return getFields()[i];
}

_Ret_notnull_ hkReflect::Detail::DeclsArray* hkReflect::Detail::DeclsArray::create(_In_reads_opt_((numFields + numProps) * sizeof(void*)) const void* fieldTypes, int numFields, int numProps, hkMemoryAllocator& alloc)
{
    int numBoth = numFields + numProps;
    int sizeDecls = numBoth * sizeof(void*);
    typedef FixedArrayStorage<DeclsArray::Head, const hkReflect::Type*,1> Array;
    Array* fa = reinterpret_cast<Array*>( alloc.blockAlloc( sizeDecls + sizeof(DeclsArray::Head) ) );
    fa->m_head.m_numDataFields = hkLosslessCast<hkInt16>(numFields);
    fa->m_head.m_numPropertyFields = hkLosslessCast<hkUint16>(numProps);
    fa->m_head.m_numTotalDecls = hkLosslessCast<hkUint16>(numFields + numProps);
    if( fieldTypes )
    {
        hkMemUtil::memCpy(fa->m_items, fieldTypes, sizeDecls);
    }
    else
    {
        hkMemUtil::memSet(fa->m_items, 0, sizeDecls);
    }
    return reinterpret_cast<hkReflect::Detail::DeclsArray*>(fa);
}

void hkReflect::Detail::DeclsArray::reset( int numFields, int numProps )
{
    HK_ASSERT(0x385f6e4f, numFields + numProps == getNumDecls(), "Total decls number must not change" );
    m_store.m_head.m_numDataFields = hkLosslessCast<hkUint16>(numFields);
    m_store.m_head.m_numPropertyFields = hkLosslessCast<hkUint16>(numProps);
}

void hkReflect::Detail::DeclsArray::deallocate(hkMemoryAllocator& m)
{
    hkUlong size = (getNumFields() * sizeof(void*)) + sizeof(DeclsArray::Head);
    m.blockFree(this, hkLosslessCast<int>(size));
}

bool hkReflect::Type::equals(_In_ const hkReflect::Type* t) const
{
    if( this == t )
    {
        return true;
    }

#if defined(HK_DEBUG_SLOW)
    const void* typeWorldA = this->getTypeWorld();
    const void* typeWorldB = t->getTypeWorld();
    HK_ASSERTV(0x2660b313, typeWorldA == typeWorldB, "Types {} and {} belong to different worlds and cannot be compared", this->getFullName(), t->getFullName());
#endif

    const Detail::InheritanceInfo* ia = TypeDetail::getInheritance(this);
    const Detail::InheritanceInfo* ib = TypeDetail::getInheritance(t);
    if( ia && ib ) // both have inheritance info
    {
        // Opt::INHERITANCE is present; additionally check whether the contained data is != 0
        HK_ASSERTV(0x1f616979, *ia, "The inheritance information for type {} hasn't been precomputed yet - the type needs to be registered first to enable type equality checks.", this->getFullName());
        HK_ASSERTV(0x727070ce, *ib, "The inheritance information for type {} hasn't been precomputed yet - the type needs to be registered first to enable type equality checks.", t->getFullName());
        return ia->equals(*ib);
    }
    else if( !ia && !ib )
    {
        // Neither have inheritance info, so they are dynamic types or non-builtin (temp types in serialization).
        //
        // For builtin types, template instantiations can be reflected in multiple plugins and hence duplicated.
        // These duplicates are filtered out and assigned the same Opt::INHERITANCE values on registration, so they compare equal in the branch above.
        //
        // For the temp types in serialization (or other local type worlds) this trivially never happens, and each type is unique.
        //
        // Dynamic types need to be registered with the dynamic type manager, which returns a pointer to an already existing type (builtin or dynamic) if the
        // dynamic type being registered duplicates an existing one. This ensures that properly registered dynamic types also can only be equal if they are the same by memory address.
        //
        // In both cases equality is established by pointer identity, and we just need to skip decorators and compare.
        const hkReflect::Type* thisWithoutDecorators = TypeDetail::skipDecorators(this);
        const hkReflect::Type* otherWithoutDecorators = TypeDetail::skipDecorators(t);

        return thisWithoutDecorators == otherWithoutDecorators;
    }
    else
    {
        // One has inheritance info, while the other doesn't. Since the TypeDetail::getInheritance lookup above already skips decorators, we can't have pointer
        // equality after skipping decorators, so the types cannot be equal.
        return false;
    }
}

bool hkReflect::Type::canBeInstantiated() const
{
    return TypeDetail::globalGetOptional<Opt::ALLOC_IMPL>(this)
        && TypeDetail::getDefaultConstructionFunction(this);
}

hkReflect::Var hkReflect::Type::newInstance() const
{
    Detail::UnaryFunction defaultConstructor = TypeDetail::getDefaultConstructionFunction(this);

    if (defaultConstructor)
    {
        Var obj = TypeDetail::allocate(this);
        if (defaultConstructor)
        {
            defaultConstructor(obj.getAddress(), this, 1);
        }
        return obj;
    }
    else
    {
        HK_ASSERTV(0x33c345a1, false, "Trying to create a new instance of {} which is not default-constructible. Ensure the "
            "type can be constructed (not ReflectIdentity, has default ctor).", getFullName());
        return Var();
    }
}

_Ret_maybenull_ const hkReflect::Callable* hkReflect::Type::findCallable(_In_z_ const char* name, CallableTypes types) const
{
    for ( CallableIterator it( this, types ); it.advance(); )
    {
        if ( hkString::strCmp( it.current()->getName(), name ) == 0 )
        {
            return it.current();
        }
    }
    return HK_NULL;
}

// ---------------------- hkReflect::TypeName --------------------------//

static void TypeName_appendToString(hkReflect::TypeName typeName, hkStringBuf& sb)
{
    if (const char* name = typeName.getName())
    {
        sb.append(name);
    }
    else
    {
        sb.append("unnamed");
    }

    if (const hkReflect::Template* params = typeName.getTemplate())
    {
        if (params->getNumParams())
        {
            sb.append("< ");

            for (int i = 0; i < params->getNumParams(); i++)
            {
                const hkReflect::Template::Parameter* thisParam = params->getParam(i);
                if (i > 0)
                {
                    sb.append(", ");
                }

                if (thisParam->isType())
                {
                    const hkReflect::Type* templateParamType = thisParam->getAsType();
                    TypeName_appendToString(hkReflect::TypeName(templateParamType), sb);
                }
                else
                {
                    sb.appendPrintf("%u", thisParam->getAsValue());
                }
            }

            sb.append(" >");
        }
    }
}

hkReflect::TypeName::TypeName(_In_ const hkReflect::Type* type)
{
    m_name = type ? type->getName() : nullptr;
    m_template = type ? type->getTemplate() : nullptr;
}

_Ret_z_ const char* hkReflect::TypeName::toString(hkStringBuf& sb) const
{
    sb.clear();
    TypeName_appendToString(*this, sb);
    return sb.cString();
}

void HK_CALL hkReflect::TypeName::toString(const hkReflect::Var& var, hkStringBuf& sb, const hkStringView& extra)
{
    if (const TypeName* typeName = hkDynCast<TypeName>(var))
    {
        typeName->toString(sb);
    }
    else
    {
        sb = "<No Type Name>";
    }
    return;
}

int hkReflect::TypeName::compare(hkReflect::TypeName typeA, hkReflect::TypeName typeB)
{
    const char* typeAName = typeA.getName();
    const char* typeBName = typeB.getName();

    if (typeAName || typeBName)
    {
        // Return if only one of the types is named.
        if (!typeAName) { return -1; }
        if (!typeBName) { return 1; }

        // Both types are named.
        if( typeAName != typeBName )
        {
            if (int baseNameCmp = hkString::strCmp(typeAName, typeBName))
            {
                return baseNameCmp;
            }
        }

        // Else the base names are the same. If we have parameters, keep comparing, if not, they are equal
        const hkReflect::Template* paramListA = typeA.getTemplate();
        const hkReflect::Template* paramListB = typeB.getTemplate();
        if (paramListA == paramListB)
        {
            return 0;
        }
        else if (paramListA && paramListB)
        {
            const int numAParams = paramListA->getNumParams();
            const int numBParams = paramListB->getNumParams();

            if (numAParams < numBParams) { return -1; }
            if (numAParams > numBParams) { return 1; }

            for (int i = 0; i < numAParams; i++)
            {
                const hkReflect::Template::Parameter* paramA = paramListA->getParam(i);
                const hkReflect::Template::Parameter* paramB = paramListB->getParam(i);

                if (paramA || paramB)
                {
                    if (!paramA) { return -1; }
                    if (!paramB) { return 1; }

                    if (paramA->getKind() < paramB->getKind())
                    {
                        return -1;
                    }
                    else if (paramA->getKind() > paramB->getKind())
                    {
                        return 1;
                    }
                    else
                    {
                        // Types match
                        if (paramA->isType())
                        {
                            int cmp = Type::compareName(paramA->getAsType(), paramB->getAsType());
                            if (cmp)
                            {
                                return cmp;
                            }
                        }
                        else if (paramA->isValue())
                        {
                            if (paramA->getAsValue() < paramB->getAsValue())
                            {
                                return -1;
                            }
                            else if (paramA->getAsValue() > paramB->getAsValue())
                            {
                                return 1;
                            }
                        }
                        else
                        {
                            HK_ASSERT_NO_MSG(0x384abab, 0); // Invalid parameter
                        }
                    }
                }
            }
        }
        else if (paramListA) // a is a template, b is not
        {
            return 1;
        }
        else if (paramListB) // b is a template, a is not
        {
            return -1;
        }
        else // no template at all
        {
            return 0;
        }
    }

    return 0;
}

int hkReflect::Type::compareName(_In_ const hkReflect::Type* typeA, _In_ const hkReflect::Type* typeB)
{
    return (typeA == typeB)
        ? 0
        : TypeName::compare(typeA->getFullName(), typeB->getFullName());
}


int hkReflect::Template::getSizeOf(int numParams)
{
    return Detail::TemplateParameterArray::sizeOfArrayN(numParams);
}

_Ret_notnull_ hkReflect::Template* hkReflect::Template::create(int numParams, hkMemoryAllocator& a)
{
    int size = Template::getSizeOf(numParams);
    void* alloc = a.blockAllocZero(size);
    return reinterpret_cast<hkReflect::Template*>( Detail::TemplateParameterArray::createInPlace(alloc, numParams) );
}

void hkReflect::Template::destroy(hkMemoryAllocator& a)
{
    int size = Template::getSizeOf((int)m_numParams);
    a.blockFree(this, size);
}

_Ret_maybenull_ const hkReflect::Type* hkReflect::Template::getUndecoratedType() const
{
    return m_undecoratedType;
}

// ---------------------- hkReflect::Decl --------------------------//

_Ret_opt_z_ const char* hkReflect::Decl::getName() const
{
    HK_ASSERT_NO_MSG(0x379ae902, m_type.isNull() || TypeDetail::localHasOptional(m_type,Opt::DECL_FORMAT));
    return m_type ? TypeDetail::decoratorGetOptional<Opt::DECL_NAME>(m_type) : HK_NULL;
}

int hkReflect::FieldDecl::getOffset() const
{
    HK_ASSERT_NO_MSG(0x65e6bde, m_type.isNull() || TypeDetail::localHasOptional(m_type,Opt::DECL_FORMAT));
    hkUlong foaf = TypeDetail::localGetOptional<Opt::DECL_FORMAT>(m_type);
    return Detail::FieldDeclFormat( foaf ).getOffset();
}

hkReflect::Decl::DeclFlags hkReflect::Decl::getFlags() const
{
    HK_ASSERT_NO_MSG(0x213a1913, m_type.isNull() || TypeDetail::localHasOptional(m_type,Opt::DECL_FORMAT));
    hkUlong foaf = TypeDetail::localGetOptional<Opt::DECL_FORMAT>(m_type);
    return Detail::FieldDeclFormat( foaf ).getFlags();
}

bool hkReflect::Decl::operator==( const Decl& rhs ) const
{
    if ( ( m_type.isNull() ) || ( rhs.m_type.isNull() ) )
    {
        return m_type == rhs.m_type;
    }
    else
    {
        DeclFlags flags = getFlags();
        if ( flags != rhs.getFlags() )
        {
            return false;
        }
        else
        {
            if ( flags.anyIsSet( DECL_DATA_FIELD ) )
            {
                DataFieldDecl f( m_type );
                DataFieldDecl g( rhs.m_type );
                return f == g;
            }
            else
            {
                // Only current alternative.
                HK_ASSERT_NO_MSG(0x8d1cbc0, flags.anyIsSet( DECL_PROPERTY_FIELD ) );
                FieldDecl p( m_type );
                FieldDecl q( rhs.m_type );
                return p == q;
            }
        }
    }
}

bool hkReflect::FieldDecl::operator==( const FieldDecl& rhs ) const
{
    if ( ( m_type.isNull() ) || ( rhs.m_type.isNull() ) )
    {
        return m_type == rhs.m_type;
    }
    else
    {
        return getDeclContext()->equals( rhs.getDeclContext() ) && ( hkString::strCmp( getName(), rhs.getName() ) == 0 );
    }
}

hkReflect::Decl::Decl(QualType t)
{
    init(t);
}

void hkReflect::Decl::init(QualType t)
{
    m_type = (t.isValid() && TypeDetail::localHasOptional(t, Opt::DECL_FORMAT)) ? t : HK_NULL;
}

void hkReflect::Decl::toString( const hkReflect::Var& var, hkStringBuf& buf, const hkStringView& extra )
{
    auto decl = static_cast<const Decl*>( var.getAddress() );
    if(decl->m_type)
    {
        buf.format("{}::{}", decl->getDeclContext(), decl->getName());
    }
    else
    {
        buf = "(null Decl)";
    }
}

hkReflect::FieldDecl::FieldDecl(QualType t)
{
    init(t);
}

void hkReflect::FieldDecl::init(QualType t)
{
    if (t.isValid())
    {
        hkUlong foaf = TypeDetail::localGetOptional<Opt::DECL_FORMAT>(t);
        m_type = (Detail::FieldDeclFormat(foaf).getFlags() & (DECL_DATA_FIELD | DECL_PROPERTY_FIELD)) ? t : HK_NULL;
    }
}

hkReflect::DataFieldDecl::DataFieldDecl(QualType t)
{
    init(t);
}

void hkReflect::DataFieldDecl::init(QualType t)
{
    if (t.isValid())
    {
        hkUlong foaf = TypeDetail::localGetOptional<Opt::DECL_FORMAT>(t);
        m_type = (Detail::FieldDeclFormat(foaf).getFlags() & DECL_DATA_FIELD) ? t : HK_NULL;
    }
}

void hkReflect::DataFieldDecl::createFromField(_In_ const hkReflect::Type* type, _In_ const hkReflect::Type* fieldType, hkLong memberOffset)
{
    for (hkReflect::DeclIter<hkReflect::DataFieldDecl> it(type); it.advance(); )
    {
        const hkReflect::DataFieldDecl& dataFieldDecl = it.current();
        if (dataFieldDecl.getOffset() == memberOffset)
        {
            HK_ASSERT(0x2cd841d5, dataFieldDecl.getType()->equals(fieldType), "Field type at offset doesn't match the expected type");
            *this = dataFieldDecl;
            return;
        }
    }

    HK_ASSERT(0x5cd7e1a0, false, "No member found at the expected offset");
}

bool hkReflect::DataFieldDecl::operator==(const DataFieldDecl& rhs) const
{
    if ((m_type.isNull()) || (rhs.m_type.isNull()))
    {
        return m_type == rhs.m_type;
    }
    else
    {
        return (getOffset() == rhs.getOffset()) && (getDeclContext()->equals(rhs.getDeclContext()));
    }
}

hkReflect::PropertyFieldDecl::PropertyFieldDecl(QualType t)
{
    init(t);
}

void hkReflect::PropertyFieldDecl::init(QualType t)
{
    if (t.isValid())
    {
        hkUlong foaf = TypeDetail::localGetOptional<Opt::DECL_FORMAT>(t);
        m_type = (Detail::FieldDeclFormat(foaf).getFlags() & DECL_PROPERTY_FIELD) ? t : HK_NULL;
    }
}

hkUint32 hkHash::hkHashValue(const hkReflect::TypeName& typeName)
{
    hkUint32 ret = hkHashValue(typeName.getName());
    if(const hkReflect::Template* templ = typeName.getTemplate())
    {
        for(int i = 0; i < templ->getNumParams(); i++)
        {
            const hkReflect::Template::Parameter* param = templ->getParam(i);
            ret = combineHashValues(ret, hkHashValue(param->getKind()));
            if(param->isType())
            {
                ret = combineHashValues(ret, hkHashValue(param->getAsType()->getFullName()));
            }
            else
            {
                ret = combineHashValues(ret, hkHashValue(param->getAsValue()));
            }
        }
    }

    return ret;
}

hkResult hkReflect::validateByType(hkReflect::Var value)
{
    const hkReflect::Type* validationType = value.getType();

    hkReflect::Detail::ValidateFunction fn = hkReflect::TypeDetail::globalGetOptional<Opt::VALIDATE>(validationType);

    if (fn)
    {
        const bool res = fn(value.getAddress());
        if (!res)
        {
            hkLog_Warning(ReflectionLog, "Failed validation by type call, object type: {}", validationType);
            return HK_FAILURE;
        }
    }
    return HK_SUCCESS;
}

hkResult hkReflect::validateByType(hkReflect::Var value, _In_ const hkReflect::Type* validationType)
{
    hkReflect::Detail::ValidateFunction fn = hkReflect::TypeDetail::globalGetOptional<Opt::VALIDATE>(validationType);

    if (fn)
    {
        if (value.getType()->equals(validationType))
        {
            const bool res = fn(value.getAddress());
            if (!res)
            {
                hkLog_Warning(ReflectionLog, "Failed validation by type call, object type: {}", validationType);
                return HK_FAILURE;
            }
        }
        else
        {
            hkLog_Warning(ReflectionLog, "Failed validation by type call (type mismatch), validation: {} / value: {}", validationType, value.getType());
            return HK_FAILURE;
        }
    }
    return HK_SUCCESS;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
