// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/Reflect/Core/Detail/hkReflectTypeDetail.h>
#include <Common/Base/Thread/Atomic/hkAtomicPrimitives.h>

// Static Impls must not be deallocated so add an initial reference.
hkReflect::Detail::Impl::Impl() : m_refCount(1) {}

hkReflect::Detail::Impl::~Impl()
{
}

_Ret_maybenull_ void* hkReflect::Detail::Impl::queryInterfaceImpl(_In_ const Type* type, const Var& self) const
{
    return HK_NULL;
}

hkResult hkReflect::Detail::Impl::inplaceFixup(_Inout_ void* self, _In_ const Type* selfType, _Inout_ void* target, _In_ const Type* targetType, int count) const
{
    HK_ASSERT(0x361938a6,0,"Type does not support being loaded inplace");
    return HK_FAILURE;
}

void hkReflect::Detail::Impl::addReference() const
{
    HK_ON_DEBUG(hkUint32 oldVal =) hkAtomic::exchangeAdd(&m_refCount, 1);
    HK_ASSERT(0x15772368, oldVal != hkUint32(-1), "Reference count overflow");
}

void hkReflect::Detail::Impl::removeReference() const
{
    const hkUint32 oldVal = hkAtomic::exchangeAdd(&m_refCount, hkUint32(-1));
    HK_ASSERT(0x46355893, oldVal != 0, "Negative reference count");
    if (oldVal == 1)
    {
        delete this;
    }
}


_Ret_maybenull_ const hkReflect::Detail::Impl* hkReflect::Detail::Impl::getFieldImpl(const Var& parent, hkReflect::FieldDecl field) const
{
    return field.getType()->getImpl();
}

hkReflect::Detail::Impl::SetterType hkReflect::Detail::Impl::getSetter() const
{
    return HK_NULL;
}

hkResult hkReflect::Detail::ArrayImpl::spliceInto(_Inout_ void* arrAddr, _In_ const ArrayType* arrType, int index, int numToDel, const hkReflect::ArrayValue& toInsert) const
{
    const hkReflect::Type* elementType = arrType->getSubType();
    if (toInsert.getSubType() && !elementType->equals(toInsert.getSubType()))
    {
        return HK_FAILURE;
    }

    ArrayValue dst;
    arrType->getImpl()->getValue(arrAddr, arrType, &dst);
    if( index < 0 ) index = dst.getCount();
    if( numToDel < 0 ) numToDel = dst.getCount();

    HK_ASSERT_NO_MSG(0x45d02b2c, index + numToDel <= dst.getCount());
    if (numToDel != toInsert.getCount())
    {
        // The base implementation of arrayimpl.spliceInto doesn't allow resizing.
        // Derived implementations may allow resizing.
        return HK_FAILURE;
    }

    if (!numToDel)
    {
        return HK_SUCCESS;
    }

    // early out if the element type is not copy-constructible
    BinaryFunction copyCtor = TypeDetail::getCopyConstructionFunction(elementType);
    if (!copyCtor)
    {
        return HK_FAILURE;
    }
    void* start = hkAddByteOffset(dst.getAddress(), index * elementType->getSizeOf());

    // destruct the old elements
    TypeDetail::destruct(start, elementType, numToDel);

    // copy-construct the new elements
    copyCtor(start, toInsert.getAddress(), elementType, numToDel);

    return HK_SUCCESS;
}

hkResult hkReflect::Detail::ArrayImpl::setValue(_Inout_ void* arrAddr, _In_ const ArrayType* arrType, const ArrayValue& val) const
{
    return spliceInto(arrAddr, arrType, 0, -1, val);
}

// Pointer

hkReflect::VarIter hkReflect::Detail::CompoundImpl::find(const VarIter& prev, Var var) const
{
    VarIter cur = prev.isValid() ? prev : iterBegin(prev.m_compound.getAddress(), prev.m_compound.getType());
    for( ; cur.isValid(); ++cur )
    {
        if( (*cur).equals(var) )
        {
            return cur;
        }
    }
    return VarIter();
}

hkReflect::VarIter hkReflect::Detail::PointerImpl::iterBegin(_In_ const void* comAddr, _In_ const CompoundType* comType) const
{
    PointerVar pv(comAddr, comType->asPointer());
    return VarIter( pv, pv.getValue(), 0);
}

void hkReflect::Detail::PointerImpl::iterNext(hkReflect::VarIter& prev) const
{
    prev.setInvalid(); // no next
}

// Array

hkReflect::VarIter hkReflect::Detail::ArrayImpl::iterBegin(_In_ const void* comAddr, _In_ const CompoundType* comType ) const
{
    const ArrayType* arrType = comType->asArray();
    HK_ASSERT_NO_MSG(0x59820a2b, arrType);
    ArrayValue aval;
    arrType->getImpl()->getValue(comAddr, arrType, &aval);
    if (aval.getCount())
    {
        return VarIter(CompoundVar(comAddr, comType), aval[0], 0);
    }

    return VarIter();
}

void hkReflect::Detail::ArrayImpl::iterNext(hkReflect::VarIter& prev) const
{
    const ArrayType* arrType = prev.m_compound.getType()->asArray();
    HK_ASSERT_NO_MSG(0x9d38940, arrType);
    ArrayValue aval;
    arrType->getImpl()->getValue(prev.m_compound.getAddress(), arrType, &aval);
    if (static_cast<int>(prev.m_data + 1) < aval.getCount())
    {
        prev.m_data += 1;
        prev.m_cur = aval[int(prev.m_data)];
        return;
    }

    prev.setInvalid();
}

bool hkReflect::Detail::ArrayImpl::insert( hkReflect::Var var, const hkReflect::VarIter& hint ) const
{
    const ArrayType* arrType = hint.m_compound.getType()->asArray();
    HK_ASSERT_NO_MSG(0x4f55d866, arrType);
    ArrayValue aval;
    arrType->getImpl()->getValue(hint.m_compound.getAddress(), arrType, &aval);
    int pos = (hint.m_data < unsigned(aval.getCount())) ? int(hint.m_data) : aval.getCount();
    return arrType->getImpl()->spliceInto(hint.m_compound.getAddress(), arrType, pos, 0, ArrayValue(var.getAddress(), 1, var.getType()) ).isSuccess();
}

bool hkReflect::Detail::ArrayImpl::remove( const hkReflect::VarIter& it ) const
{
    if( it.isValid() )
    {
        const ArrayType* arrType = it.m_compound.getType()->asArray();
        HK_ASSERT_NO_MSG(0x6ac57005, arrType);
        return arrType->getImpl()->spliceInto(it.m_compound.getAddress(), arrType, int(it.m_data), 1, ArrayValue()).isSuccess();
    }
    return false;
}

hkReflect::ContainerValue hkReflect::Detail::ArrayImpl::getContainerValue(_In_ const void* conAddr, _In_ const ContainerType* conType) const
{
    ArrayValue aval;
    this->getValue(conAddr, static_cast<const ArrayType*>(conType), &aval);
    return ContainerValue( aval.getCount(), aval.getSubType() );
}

static _Ret_maybenull_ const hkReflect::Type* nextChildOf(_In_ const hkReflect::Type* curType, _In_ const hkReflect::Type* finalType)
{
    // We only store parent links, so going "down" the hierarchy is a little unnatural.
    // But if we have a the end of the chain, we can go up until finding a type with "curType" as parent.

    // Sounds easy.

    // This is tricky is that the type parents may look like RdddRRdRdddRd where R==record, d==decorator
    // These are grouped using "Rd*", thus the logical hierarchy is
    // [Rddd][R][Rd][Rddd][Rd] (derived are rightmost)
    //     ^  ^   ^     ^   ^
    // And we only want to visit each group once, returning the rightmost one from each.
    // Also curType or finalType could be anywhere in the middle of the group.

    using namespace hkReflect;
    const Type* prevRight = HK_NULL;
    for (const Type* gr = finalType; gr; ) // gr : group rightmost, gl : group leftmost
    {
        // zip through the decorators
        const Type* gl = gr;
        while (gl->isDecorator())
        {
            if (curType == gl)
            {
                return prevRight;
            }
            else // decorator implies we have a parent
            {
                gl = gl->getParent();
            }
        }
        // this must be the start of the next chain

        if (gl == curType)
        {
            return prevRight;
        }
        else
        {
            prevRight = gr;
            gr = gl->getParent();
        }

    }
    return prevRight;
}

static _Ret_notnull_ const hkReflect::RecordType* rootRecordOf(_In_ const hkReflect::RecordType* topType)
{
    using namespace hkReflect;
    const RecordType* cur = topType;
    while (1)
    {
        if (const RecordType* parent = cur->getParentRecord())
        {
            cur = parent;
        }
        else
        {
            return cur;
        }
    }
}

hkReflect::VarIter hkReflect::Detail::RecordImpl::find(const hkReflect::VarIter& prev, hkReflect::Var var) const
{
    if (StringVar svar = var)
    {
        if (hkReflect::RecordVar recVar = prev.m_compound)
        {
            // prev.m_compound.getType is the exact type of the container
            // prev.m_data is the LOCAL index of the member for the current record
            // prev.m_cur is the current var. We can find the current record we're on by
            //    looking at the declcontext of the field we're on
            StringValue name = svar.getValue();
            int startIdx = prev.isValid() ? int(prev.m_data + 1) : 0;
            const RecordType* topType = recVar.getType();
            // We iterate from the root downwards to the final compound type
            // If we have a prev, we're at the declcontext of its field, otherwise start at the root.
            const RecordType* curType = prev.isValid()
                ? prev.m_cur.getType()->getDeclContext()->asRecord()
                : rootRecordOf(topType);
            while (curType)
            {
                // look in current record (don't use findField because we want the index also)
                hkArrayView<const hkReflect::FieldDecl> fields = curType->getFields();
                for (int i = startIdx; i < fields.getSize(); ++i)
                {
                    if (name == fields[i].getName())
                    {
                        return VarIter(recVar, recVar[fields[i]], i);
                    }
                }
                // name not found in curType - go to the next record down
                const Type* c = nextChildOf(curType, topType);
                curType = c ? c->asRecord() : HK_NULL;
            }
        }
    }
    return VarIter();
}

hkReflect::VarIter hkReflect::Detail::RecordImpl::iterBegin(_In_ const void* comAddr, _In_ const hkReflect::CompoundType* comType) const
{
    const RecordType* recType = comType->asRecord();
    if (recType)
    {
        RecordVar rvar(comAddr, recType);
        // VarIter has space for the compoundvar, the current var, and 1 ulong.
        // We need to encode the current iteration position into the ulong.
        // Naively, we could store the absolute field index. But that would require icky index-based method in recordtype.
        // Instead we store only the local index and use the declcontext of iter.m_cur to figure out where we are the hierarchy

        // Find the rootmost field (which may not be in the root record!)
        FieldDecl firstField(HK_NULL);
        for (const RecordType* cur = recType; cur; cur = cur->getParentRecord())
        {
            hkArrayView<const hkReflect::FieldDecl> fields = cur->getFields();
            if (fields.getSize())
            {
                firstField = fields[0];
            }
        }
        if (firstField)
        {
            return VarIter(rvar, rvar[firstField], 0);
        }
    }
    return VarIter();
}

void hkReflect::Detail::RecordImpl::iterNext(hkReflect::VarIter& prev) const
{
    if (prev.isValid())
    {
        if (RecordVar recVar = prev.m_compound)
        {
            const RecordType* curType = prev.m_cur.getType()->getDeclContext()->asRecord();
            int cur = int(prev.m_data);
            int numFields = curType->getNumFields();
            if (cur + 1 < numFields)
            {
                prev.m_data = cur + 1;
                prev.m_cur = recVar[curType->getField(cur + 1)];
                return;
            }
            else // find the next record with fields
            {
                prev.m_data = 0;
                while (const Type* c = nextChildOf(curType, recVar.getType()))
                {
                    curType = c->asRecord();
                    if (curType->getNumFields())
                    {
                        prev.m_cur = recVar[curType->getField(0)];
                        return;
                    }
                }
            }
        }

    }
    prev.setInvalid();
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
