// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

namespace hkReflect
{
        /// Return the type information associated with "T".
    template<typename T>
    HK_ALWAYS_INLINE hkReflect::QualType getType();

        /// Get the name of a given type
    template<typename T> inline _Ret_z_ const char* getName();

        /// Lookup the type in the builtin type registry.
        /// It is an error if the type is a template. In that case use typeFromType instead.
        /// Return the type or null if not found.
    HK_EXPORT_COMMON _Ret_maybenull_ const Type* HK_CALL typeFromName(_In_z_ const char* name);

        /// Lookup the type in the builtin type registry.
        /// Return the type or null if not found.
    HK_EXPORT_COMMON _Ret_maybenull_ const Type* HK_CALL typeFromType(_In_ const Type* type);

        /// Access the builtin type registry
    HK_EXPORT_COMMON _Ret_notnull_ MutableTypeReg* getTypeReg();

        /// Get the presets of the provided reflected enum. Does not compile if T is not a reflected enum.
    template<typename T> HK_ALWAYS_INLINE const hk::Presets& getPresetsOf();

    namespace Detail { struct PointerToT; class AutoCast; }
#ifdef __HAVOK_PARSER__
    namespace Detail
    {
        struct PointerToT {};
        class AutoCast
        {
            public:
                template<typename From> AutoCast(From* from);
                AutoCast(const void* obj, hkReflect::QualType type);
                template<typename To> operator To*() const;
        };
    }
#endif
}

    /// Implicit cast function: it will deduce the type to cast to. Example:
    ///     if(const Foo* foo = hkDynCast(ptr))
    /// Returns HK_NULL if from is HK_NULL.
hkReflect::Detail::AutoCast hkDynCast(hkReflect::Detail::AutoCast from);

    /// Equivalent to C++ dynamic_cast. Returns 'from' cast to 'To*' if the exact type of 'from' equals or extends 'To'
    /// (along the "left-most" hierarchy line), HK_NULL otherwise. Returns HK_NULL if 'from' is HK_NULL.
template <typename To, typename From>
_Ret_maybenull_ typename hkTrait::ConstIfConst<From, To>::type* hkDynCast(_In_opt_ From* from);

    /// Equivalent to C++ dynamic_cast. Returns 'from' cast to 'toType' if the exact type of 'from' equals or extends
    /// 'To' (along the "left-most" hierarchy line), HK_NULL otherwise. Returns HK_NULL if 'from' is HK_NULL.
template<typename From>
_Ret_maybenull_ typename hkTrait::ConstIfConst<From, void>::type* hkDynCast(_In_opt_ From* from, _In_ const hkReflect::Type* toType);



// Advanced use.
//

namespace hkReflect
{
        /// Returns 'from' cast to 'To*' if the dynamic type of 'from' equals the Type of 'To', HK_NULL otherwise.
        /// Advanced use, use hkDynCast instead when doing a simple cast.
    template <typename To, typename From>
    _Ret_maybenull_ To* exactMatchDynCast(_In_opt_ From* from);

        /// Returns 'from' cast to 'const To*' if the dynamic type of 'from' equals the Type of 'To', HK_NULL otherwise.
        /// Advanced use, use hkDynCast instead when doing a simple cast.
    template <typename To, typename From>
    _Ret_maybenull_ const To* exactMatchDynCast(_In_opt_ const From* from);

        /// Overload for Type*; compare the Kind directly. Advanced use, use hkDynCast instead when doing a simple cast.
    template <typename KindType>
    _Ret_maybenull_ const KindType* exactMatchDynCast(_In_ const hkReflect::Type* type);

        /// Equivalent to C++ implicit cast. Returns object cast to 'To*' if 'From' equals or extends 'To' (along the
        /// "left-most" hierarchy line), HK_NULL otherwise.
    template <typename To, typename VoidOrConstVoid>
    typename hkTrait::ConstIfConst<VoidOrConstVoid, To>::type* upCast(_In_ VoidOrConstVoid* object, _In_opt_ const hkReflect::Type* objectType);

        /// Equivalent to C++ implicit cast. Returns object if 'From' equals or extends 'To' (along the "left-most"
        /// hierarchy line), HK_NULL otherwise.
    template <typename VoidOrConstVoid>
    VoidOrConstVoid* upCast(_In_ VoidOrConstVoid* object, _In_opt_ const hkReflect::Type* objectType, _In_ const hkReflect::Type* tgtType);

        /// Look up the exact type of an object given a base type.
        /// I.e. given class A; and class B : public A; B b; A* a = &b;
        /// hkReflect::exactObj(a) would return hkReflect::getType<B>().
        ///
        /// In general if 'ptr' points to an instance of class X, the function will return the address
        /// (X*) of that instance and the type of X. The address might be equal to 'ptr' (if 't' is a
        /// left-most ancestor of X) or different (if 'ptr' is the pointer to an interface sub-object
        /// in the X object which is not the left-most one). E.g.:
        /// class C : public A, public B; C c; A* a = c; B* b = c;
        /// hkReflect::exactObj(a) -> &c == a
        /// hkReflect::exactObj(b) -> &c != b
        ///
        /// Default implementation calls ptr->getExactType() if T has a getExactType() method,
        /// otherwise falls back to exactTypeOf(const void*, const Type*). Should be overloaded for
        /// types with a custom casting mechanism.
        /// We use the PointerToT helper rather than template on T* directly so that
        /// any specific overloads are preferred.
        ///
        /// Do not use this to cast an object; use hkDynCast instead.
    Detail::AddrAndType exactObj(const Detail::PointerToT& ptr);

        /// Look up the exact type of an object given a base type.
        /// If you have compile-time knowledge about the type of "obj", it would be more
        /// efficient to call the exactObj(const Detail::PointerToT&) method instead of this one.
        /// This lookup is done by looking for a hk::ExactTypeFunction attribute in the root
        /// of the inheritance hierarchy of t. If t has no such attribute, the same type is returned.
        ///
        /// Do not use this to cast an object; use hkDynCast instead.
    HK_EXPORT_COMMON Detail::AddrAndType HK_CALL exactObj(_In_opt_ const void* obj, _In_ const Type* t);

        /// Get the exact type of an object from a typed pointer.
        /// Will assert if used on an interface (non left-most ancestor) pointer.
        /// Do not use this to cast an object; use hkDynCast instead.
        
    template <typename T> _Ret_notnull_ const hkReflect::Type* exactTypeOf(_In_ T* ptr);

        /// Get the exact type of an object from a typed pointer.
        /// Can be used on a interface (non left-most ancestor) pointers. Be careful that in that case
        /// the address of the instance of the exact type will be different from 'ptr'.
        /// Do not use this to cast an object; use hkDynCast instead.
        
    template <typename T> _Ret_notnull_ const hkReflect::Type* exactTypeOfUnchecked(_In_ T* ptr);
}


// Utility overloads.

    /// Overload for Type*; compare the Kind directly.
template <typename KindType>
_Ret_maybenull_ const KindType* hkDynCast(_In_ const hkReflect::Type* b);

namespace hkReflect
{
        /// Overload for Type*. Gets the dynamic type (type which reflects) of t from the Kind of t.
    hkReflect::Detail::AddrAndType exactObj(_In_ const hkReflect::Type* t);
}

#if !defined(__HAVOK_PARSER__)
#include <Common/Base/Reflect/Core/hkReflectFuncs.inl>
#endif

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
