// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/Reflect/TypeReg/Detail/hkTypeRegDetail.h>
#include <Common/Base/Reflect/Core/Detail/hkReflectTypeDetail.h>

hkReflect::Detail::AddrAndType hkReflect::exactObj(_In_opt_ const void* object, _In_ const hkReflect::Type* type)
{
    if (object)
    {
        HK_ASSERT_NO_MSG(0x15ba32ce, type);
        if (Detail::ExactTypeFunction etf = TypeDetail::globalGetOptional<Opt::EXACT_TYPE>(type))
        {
            return (*etf)(object);
        }
    }
    return Detail::AddrAndType(object, type);
}

_Ret_notnull_ hkReflect::MutableTypeReg* hkReflect::getTypeReg()
{
    return hkReflect::Detail::BuiltinTypeReg::getInstancePtr();
}

_Ret_maybenull_ const hkReflect::Type* hkReflect::typeFromName(_In_z_ const char* name)
{
    return hkReflect::Detail::BuiltinTypeReg::getInstance().typeFromName(name);
}

_Ret_maybenull_ const hkReflect::Type* hkReflect::typeFromType(_In_ const Type* type)
{
    return hkReflect::Detail::BuiltinTypeReg::getInstance().typeFromType(type);
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
