// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

// Forward definitions and declarations for hkReflect
#if defined(__HAVOK_PARSER__)
    /// Macros to attach an attribute to a declaration.
    /// Internal use only, needed to avoid nested HK_PP_FOR_EACH in HK_DECLARE_CLASS_* macros.
    #define HK_SINGLE_ATTR(...) __attribute__((annotate("hk_attr." #__VA_ARGS__)))
    #define HK_SINGLE_RECORD_ATTR(...) struct HK_SINGLE_ATTR(__VA_ARGS__) HK_PP_JOIN(ReflectionOptions, __COUNTER__){}

    /// Macro to attach an attribute to a declaration.
    /// e.g. int m_variable HK_ATTR( hk::Reflect );
    #define HK_ATTR(...) HK_PP_FOR_EACH(HK_ATTR_ELEM, , __VA_ARGS__)
    #define HK_ATTR_ELEM(I, D, X) HK_SINGLE_ATTR(X)

    /// Attach an attribute to the enclosing record.
    /// The clang extraction step rewrites this to behave as if HK_ATTR had been used on the enclosing record.
    /// This is useful because HK_ATTR on record definitions has an awkward syntax (must be between "class" and the name)
    #define HK_RECORD_ATTR(...) struct HK_ATTR(__VA_ARGS__) HK_PP_JOIN(ReflectionOptions, __COUNTER__){}

    /// Adds a property to the current class.
    /// Usage: HK_PROPERTY(propName, getterMethod[, setterMethod]);
    #define HK_PROPERTY(NAME, ...) \
        struct HK_PREPROCESSOR_JOIN_TOKEN(PropertyPlaceholder, NAME) {} HK_ATTR( hk::PropertyInternal(NAME, __VA_ARGS__) )
#else
#ifndef HK_ATTR // Defined in the case of Visual Assist with va_stdafx.h
    #define HK_SINGLE_ATTR(...)
    #define HK_SINGLE_RECORD_ATTR(...)
    #define HK_ATTR(...)
    #define HK_RECORD_ATTR(...)
    #define HK_PROPERTY(NAME, ...)
#endif
#endif

#if defined(__HAVOK_PARSER__)
// Define a parser only typedef so the parser can check CLASSNAME matches the containing class name.
#define HK_DETAIL_DECLARE_CLASS_PARSER_CHECK( CLASSNAME, ... ) typedef CLASSNAME _HkDeclareClassName;
#else
#define HK_DETAIL_DECLARE_CLASS_PARSER_CHECK( ... )
#endif

#if !defined(__INTELLISENSE__) || (defined(_MSC_VER) && _MSC_VER >= 1900)
    #ifndef HK_DECLARE_CLASS // Defined in the case of Visual Assist with va_stdafx.h
        #define HK_DECLARE_CLASS_ACTION(I, D, X) HK_DECLARE_CLASS_ ## X (D);
        /// Macro to inject code into a class definition. Each usage must have the enclosing class name as the
        /// first parameter and a list of injections as subsequent parameters.
        /// For example: class Foo { HK_DECLARE_CLASS(Foo, New, Reflect, Pod); }; is a shortcut for writing
        /// class Foo { HK_DECLARE_CLASS_New(Foo); HK_DECLARE_CLASS_Reflect(Foo); HK_DECLARE_CLASS_Pod(Foo); };
        /// Grep for "define HK_DECLARE_CLASS_" (note trailing underscore) to find
        #define HK_DECLARE_CLASS(...) \
            HK_DETAIL_DECLARE_CLASS_PARSER_CHECK( __VA_ARGS__ ) \
            HK_PP_FOR_EACH(HK_DECLARE_CLASS_ACTION, __VA_ARGS__)
    #endif
#else
    // IntelliSense before Visual Studio 2015 (compiler version 19.00) can't parse vararg macros,
    // just pretend. See the real definition and documentation a few lines above this one.
    #define HK_DECLARE_CLASS(CLASS_NAME, ...) HK_DECLARE_CLASS_Reflect(CLASS_NAME)
#endif

// Support an array subtype trait (which only works for reflected arrays with statically known subtypes).
#define HK_DEFINE_ARRAY_SUBTYPE( ... ) typedef __VA_ARGS__ ReflectedArraySubtype;

// ------------------------ REFLECTION HELPER MACROS ------------------------ //

#define HK_REFLECT_AS_OPAQUE() \
    HK_SINGLE_RECORD_ATTR( hk::ReflectAs(format=hkReflect::Format::OfOpaque::Value, impl=HK_NULL) ); \
    HK_SINGLE_RECORD_ATTR( hk::ReflectDetails(specials=false, fields=false) ); \
    HK_SINGLE_RECORD_ATTR( hk::AddOptional(Opt::SIZE_ALIGN, 0) ); \
    HK_REFLECT_DETAIL_REFLECTEDAS(hkReflect::OpaqueType)
#define HK_REFLECT_AS_BOOL(IMPL, ...) \
    HK_SINGLE_RECORD_ATTR( hk::ReflectAs(format=__VA_ARGS__, impl=IMPL) ); \
    HK_REFLECT_DETAIL_REFLECTEDAS(hkReflect::BoolType);
#define HK_REFLECT_AS_STRING_UTF8_IMMUTABLE(IMPL) \
    HK_SINGLE_RECORD_ATTR( hk::ReflectAs(format=hkReflect::Format::OfStringUtf8<0,true>::Value, impl=IMPL) ); \
    HK_REFLECT_DETAIL_REFLECTEDAS(hkReflect::StringType);
#define HK_REFLECT_AS_STRING_UTF8_MUTABLE(IMPL) \
    HK_SINGLE_RECORD_ATTR( hk::ReflectAs(format=hkReflect::Format::OfStringUtf8<0,false>::Value, impl=IMPL) ); \
    HK_REFLECT_DETAIL_REFLECTEDAS(hkReflect::StringType);
#define HK_REFLECT_AS_POINTER(IMPL, ...) \
    HK_SINGLE_RECORD_ATTR( hk::ReflectAs(format=hkReflect::Format::OfPointer::Value, subtype=__VA_ARGS__, impl=IMPL) ); \
    HK_REFLECT_DETAIL_REFLECTEDAS(hkReflect::PointerType);
#define HK_REFLECT_AS_VARIANT(IMPL) \
    HK_SINGLE_RECORD_ATTR( hk::ReflectAs(format=hkReflect::Format::OfPointer::Value, subtype=HK_NULL, impl=IMPL) ); \
    HK_REFLECT_DETAIL_REFLECTEDAS(hkReflect::PointerType);
#define HK_REFLECT_AS_ARRAY(IMPL, ...) \
    HK_SINGLE_RECORD_ATTR( hk::ReflectAs(format=hkReflect::Format::OfArray<0>::Value, subtype=__VA_ARGS__, impl=IMPL) ); \
    HK_DEFINE_ARRAY_SUBTYPE( __VA_ARGS__ ); \
    HK_REFLECT_DETAIL_REFLECTEDAS(hkReflect::ArrayType);
#define HK_REFLECT_AS_ARRAY_FIXED(COUNT, ...) \
    HK_SINGLE_RECORD_ATTR( hk::ReflectAs(format=hkReflect::Format::OfArray<COUNT>::Value, subtype=__VA_ARGS__, impl=&hkReflect::Detail::RepeatImpl::s_instance) ); \
    HK_DEFINE_ARRAY_SUBTYPE( __VA_ARGS__ ); \
    HK_REFLECT_DETAIL_REFLECTEDAS(hkReflect::ArrayType);
#define HK_REFLECT_AS_VARIANT_ARRAY(IMPL) \
    HK_SINGLE_RECORD_ATTR( hk::ReflectAs(format=hkReflect::Format::OfArray<0>::Value, subtype=HK_NULL, impl=IMPL) ); \
    HK_REFLECT_DETAIL_REFLECTEDAS(hkReflect::ArrayType);
#define HK_REFLECT_AS_INT(IMPL, ...) \
    HK_SINGLE_RECORD_ATTR( hk::ReflectAs(format=__VA_ARGS__, impl=IMPL) ); \
    HK_REFLECT_DETAIL_REFLECTEDAS(hkReflect::IntType);
#define HK_REFLECT_AS_FLOAT(IMPL, ...) \
    HK_SINGLE_RECORD_ATTR( hk::ReflectAs(format=__VA_ARGS__, impl=IMPL) ); \
    HK_REFLECT_DETAIL_REFLECTEDAS(hkReflect::FloatType);
#define HK_REFLECT_AS_TYPEDEF(...) \
    HK_SINGLE_RECORD_ATTR( hk::ReflectAsTypedef(type=__VA_ARGS__) ); \
    HK_REFLECT_DETAIL_REFLECTEDAS(typename hkReflect::Detail::ReflectedKindOf< __VA_ARGS__ >::Type); \
    typedef __VA_ARGS__ ReflectedAsTypedefOf

    /// Statically reference fields of a type bypassing string lookup.
    /// This requires and #include of the generated _Types.cxx file to get the definition of _Auto.
#define HK_REFLECT_FIELD_OF(TYPE, MEMBER) \
    hkReflect::FieldDecl(reinterpret_cast<const hkReflect::Type*>(TYPE::_Auto::MEMBER::typeData))

// C++ wants "typename" in the definition of HK_REFLECT_AS_TYPEDEF when used in templates, but forbids it when used in
// non-templates. Work around this by using a template struct instead of a simple typedef (so typename is always allowed).
#define HK_REFLECT_DETAIL_REFLECTEDAS(...) \
    template<typename> struct ReflectedAs { typedef __VA_ARGS__ Type; };

#if !defined(HK_DYNAMIC_DLL)
#define HK_REFLECT_VALIDATE_INLINE
#else
#define HK_REFLECT_VALIDATE_INLINE inline
#define HK_INCLUDE_VALIDATE_INLINES
#endif

// Features common to all HK_DECLARE_REFLECTION macros.
// Argument may be a dll declspec or empty to inherit the linkage from the encosing class.
#define HK_DETAIL_REFLECT_INJECT_DECLS_EXPORT(...) \
    HK_SINGLE_RECORD_ATTR(hk::Reflect); \
    HK_SINGLE_RECORD_ATTR(hk::FieldPrefix(m_)); \
    struct _Auto; \
    struct _HABinding; \
    template<typename hkReflectCInvType, typename hkReflectCInvT0, typename hkReflectCInvT1, typename hkReflectCInvT2, \
        typename hkReflectCInvT3, typename hkReflectCInvT4, typename hkReflectCInvT5, typename hkReflectCInvT6, \
        typename hkReflectCInvT7, typename hkReflectCInvT8> friend struct hkReflect::Detail::ConstructorInvoker; \
    __VA_ARGS__ static hkReflect::Detail::TypeData typeData; \
    __VA_ARGS__ HK_REFLECT_VALIDATE_INLINE bool reflectValidate() const HK_SINGLE_ATTR(hk::Reflect(false))


/// This template is used by the ReflectionOf template.




#define HK_DETAIL_REFLECT_DECLARE_IS_REFLECTED_CHECK(CLASS_NAME) \
    template<typename THISTYPE> struct IsReflectedCheck { typedef CLASS_NAME TypeIfReflected; } \

#ifdef HK_COMPILER_CLANG
    #if __has_warning("-Winconsistent-missing-override")
        #define HK_DETAIL_DECLARE_EXACT_TYPE_PREFIX() \
            HK_DETAIL_DIAG_CLANG_PUSH() \
            HK_DETAIL_DIAG_CLANG_OFF(inconsistent-missing-override)
        #define HK_DETAIL_DECLARE_EXACT_TYPE_SUFFIX() \
            HK_DETAIL_DIAG_CLANG_POP()
    #else
        #define HK_DETAIL_DECLARE_EXACT_TYPE_PREFIX()
        #define HK_DETAIL_DECLARE_EXACT_TYPE_SUFFIX()
    #endif
#else
    #define HK_DETAIL_DECLARE_EXACT_TYPE_PREFIX()
    #define HK_DETAIL_DECLARE_EXACT_TYPE_SUFFIX()
#endif
#define HK_DETAIL_REFLECT_INJECT_EXACT_TYPE_EXPORT(...) \
    HK_DETAIL_DECLARE_EXACT_TYPE_PREFIX(); \
    __VA_ARGS__ hkReflect::Detail::AddrAndType getExactType() const HK_SINGLE_ATTR(hk::Reflect(false)); \
    HK_DETAIL_DECLARE_EXACT_TYPE_SUFFIX()


// The (old) normal reflection declaration. The approach to check for "unreflected subclasses" cannot work in this case.
#define HK_DECLARE_REFLECTION() \
    HK_DETAIL_REFLECT_INJECT_DECLS_EXPORT(); \
    template<typename THISTYPE> struct IsReflectedCheck { typedef THISTYPE TypeIfReflected; }; \
    HK_DETAIL_REFLECT_INJECT_EXACT_TYPE_EXPORT(); \
    HK_DETAIL_DECLARE_CLASS_PARSER_CHECK(void)

// Declare that reflection data/methods have dll linkage, even though the class does not.
#define HK_DETAIL_DECLARE_REFLECT_EXPORT(CLASS_NAME, EXPORT_STATEMENT) \
    HK_DETAIL_REFLECT_INJECT_DECLS_EXPORT(EXPORT_STATEMENT); \
    HK_DETAIL_REFLECT_INJECT_EXACT_TYPE_EXPORT(EXPORT_STATEMENT); \
    HK_DETAIL_REFLECT_DECLARE_IS_REFLECTED_CHECK(CLASS_NAME)

// Declare that a class should be reflected
// Normally called from HK_DECLARE_CLASS(..., Reflect, ...)
#define HK_DECLARE_CLASS_Reflect(CLASS_NAME) \
    HK_DETAIL_DECLARE_REFLECT_EXPORT(CLASS_NAME,HK_PP_EMPTY)

// Declare that a class should be reflected, and allow dynamic cast through
// reflection. This is the same as HK_DECLARE_CLASS_Reflect except that
// getExactType() is declared virtual and it assumes a visible overload of
// hkReflect::exactTypeOf(CLASS_NAME*)
// This macro must be used only on the root of the hierarchy which has to be
// dynamically castable. Descendants must be reflected using HK_DECLARE_CLASS(Reflect).
// Normally called from HK_DECLARE_CLASS(..., ReflectVirtualBase, ...).
#define HK_DECLARE_CLASS_ReflectVirtualBase(CLASS_NAME) \
    HK_DETAIL_REFLECT_INJECT_DECLS_EXPORT(); \
    HK_DETAIL_REFLECT_DECLARE_IS_REFLECTED_CHECK(CLASS_NAME); \
    virtual hkReflect::Detail::AddrAndType getExactType() const HK_SINGLE_ATTR(hk::Reflect(false)); \
    struct _GetExactTypeIsVirtual; \
    HK_SINGLE_RECORD_ATTR(hk::GenerateExactTypeMethod(true)); \
    HK_SINGLE_RECORD_ATTR(hk::ExactTypeFunction(&hkReflect::Detail::callGetExactType))

// Declare that only the identity of the class should be reflected (name, inheritance).
// (enables usage of hkDynCast<> on instances of the class). Fields and methods (including constructors/destructors)
// will be ignored. The class will not be serializable. Class objects will not be allocatable from type information.
// Normally called from HK_DECLARE_CLASS(..., ReflectIdentity, ...)
#define HK_DECLARE_CLASS_ReflectIdentity(CLASS_NAME) \
    HK_DECLARE_CLASS_Reflect(CLASS_NAME); \
    HK_SINGLE_RECORD_ATTR(hk::ReflectDetails(specials=false, fields=false)); \
    HK_SINGLE_RECORD_ATTR(hk::Serialize(false)); \
    HK_SINGLE_RECORD_ATTR(hk::Retargetable(false));

// Declare that only the identity of the class should be reflected (name, inheritance) and that it should be constructible via reflection.
// (enables usage of hkDynCast<> on instances of the class). Fields and methods (including constructors/destructors)
// will be ignored. The class will not be serializable. Class objects will not be allocatable from type information.
// Normally called from HK_DECLARE_CLASS(..., ReflectIdentity, ...)
#define HK_DECLARE_CLASS_ReflectConstructible(CLASS_NAME) \
    HK_DECLARE_CLASS_Reflect(CLASS_NAME); \
    HK_SINGLE_RECORD_ATTR(hk::ReflectDetails(specials=true, fields=false)); \
    HK_SINGLE_RECORD_ATTR(hk::Serialize(false)); \
    HK_SINGLE_RECORD_ATTR(hk::Retargetable(false));

// Manually specifies what will be reflected. Equivalent to HK_RECORD_ATTR(hk::ReflectDetails(__VA_ARGS__)).
// Use in addition to Reflect.
// Normally called from HK_DECLARE_CLASS(..., Reflect, ReflectDetails(...), ...).
#define HK_DECLARE_CLASS_ReflectDetails(...) \
    HK_SINGLE_RECORD_ATTR(hk::ReflectDetails(__VA_ARGS__)); HK_PP_IGNORE_ARGS

// Declare that a class is genuinely not reflected even though one of its ancestors is.
// Instances of a non-reflected, polymorphic class will usually be treated as instances of the closest reflected
// ancestor. If the ancestor is abstract, this will produce warnings. Use this macro to explicitly give a dummy type
// to the class (suitable to check for inheritance and nothing else) and suppress these warnings.
// Normally called from HK_DECLARE_CLASS(..., NoReflect, ...)
// Use NoReflect2 if the class has more than one reflected parent or the closest reflected ancestor uses the old
// HK_DECLARE_REFLECTION macro.
#define HK_DECLARE_CLASS_NoReflect(CLASS_NAME) \
    HK_COMPILE_TIME_ASSERT(hkTrait::TypesAreDifferent< CLASS_NAME, typename hkReflect::Detail::GetIsReflectedCheckTypeIfPresent<CLASS_NAME, true>::Type >::result); \
    HK_SINGLE_RECORD_ATTR(hk::Reflect(false)); \
    HK_DETAIL_DECLARE_EXACT_TYPE_PREFIX(); \
    hkReflect::Detail::AddrAndType getExactType() const HK_SINGLE_ATTR( hk::Reflect(false) ) \
    { \
        static hkReflect::Detail::TypeData _typeData = \
        { \
            hkReflect::Opt::IMPL | hkReflect::Opt::NAME | hkReflect::Opt::DEF_CONSTRUCTOR | \
            hkReflect::Opt::COPY_CONSTRUCTOR | hkReflect::Opt::DESTRUCTOR | hkReflect::Opt::COPY_ASSIGNMENT | \
            hkReflect::Opt::ALLOC_IMPL | hkReflect::Opt::SIZE_ALIGN | hkReflect::Opt::FLAGS | \
            hkReflect::Opt::REFLECT_CONSTRUCTOR, \
            0, /* this value gets patched by the HK_REFLECT_GET_TYPE line below */ \
            HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::IMPL, HK_NULL), \
            HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::NAME, #CLASS_NAME), \
            HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DEF_CONSTRUCTOR, HK_NULL), \
            HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::COPY_CONSTRUCTOR, HK_NULL), \
            HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DESTRUCTOR, HK_NULL), \
            HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::COPY_ASSIGNMENT, HK_NULL), \
            HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::ALLOC_IMPL, HK_NULL), \
            HK_REFLECT_TYPE_OPTIONAL_SIZE_ALIGN(sizeof(CLASS_NAME), 0, 0), /* todo.rt size should probably be 0 but will break things */ \
            HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::FLAGS, hkReflect::Type::TYPE_NOT_SERIALIZABLE), \
            HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::REFLECT_CONSTRUCTOR, HK_NULL), \
        }; \
        /* keeping only compile-time const values in the static structure above allows its construction to be thread safe (in pre-C++11, which lacks magic statics) */ \
        /* the only part which is sometimes not compile-time const is HK_REFLECT_GET_TYPE because it might return an address coming from across a DLL boundary */ \
        /* so the struct is patched every time the function is called instead, this shouldn't be any worse performance-wise than a thread-unsafe static initializer check */ \
        _typeData[1] = (hkUlong)HK_REFLECT_GET_TYPE(typename hkReflect::Detail::GetIsReflectedCheckTypeIfPresent<CLASS_NAME, true>::Type); \
        return hkReflect::Detail::AddrAndType(this, reinterpret_cast<const hkReflect::Type*>(&_typeData)); \
    } \
    HK_DETAIL_DECLARE_EXACT_TYPE_SUFFIX()

// As NoReflect, but it can be used to suppress ambiguity errors when a non-reflected class inherits from more than one
// reflected parent or the reflected parent uses HK_DECLARE_REFLECTION.
// Normally called from HK_DECLARE_CLASS(..., NoReflect2(ReflectedParent), ...).
#define HK_DECLARE_CLASS_NoReflect2(...) \
    template <typename THISTYPE> struct IsReflectedCheck { typedef __VA_ARGS__ TypeIfReflected; }; HK_DECLARE_CLASS_NoReflect

/// Define the class version number. Equivalent to HK_RECORD_ATTR(hk::Version(NUM)).
/// Normally called from HK_DECLARE_CLASS(..., Version(2), ...).
#define HK_DECLARE_CLASS_Version(NUM) \
    HK_SINGLE_RECORD_ATTR(hk::Version(NUM) ) HK_PP_IGNORE_ARGS

/// Declare an empty constructor
#define HK_DECLARE_CLASS_EmptyCtor(CLASS_NAME) \
    HK_INLINE CLASS_NAME() {}

/// Declare that a class should have an autogenerated "bypass" constructor.
/// Normally called from HK_DECLARE_CLASS(..., BypassCtor, ...)
#define HK_DECLARE_CLASS_BypassCtor(CLASS_NAME) \
    HK_SINGLE_RECORD_ATTR(hk::GenerateBypassCtor); \
    explicit CLASS_NAME(hkReflect::BypassCtorFlag) HK_SINGLE_ATTR( hk::Reflect(false) )

// Advanced use. Declare that a class can be bypass-constructed trivially.
// Use BypassCtor unless there is a good reason to use this and you know what you are doing.
// Optimization which avoids generating a constructor method. Useful for heavily instantiated templates.
#define HK_DECLARE_CLASS_BypassCtorTrivial(CLASS_NAME) \
    explicit CLASS_NAME(hkReflect::BypassCtorFlag) HK_SINGLE_ATTR( hk::Reflect(false) ); /* Undefined; suppresses PreBuild warning */ \
    HK_SINGLE_RECORD_ATTR( hk::AddOptional( hkReflect::Opt::REFLECT_CONSTRUCTOR, &hkReflect::Detail::Trivial<hkReflect::Opt::DEF_CONSTRUCTOR>::func ) )

/// Declares this class as a RuntimeAttribute (i.e. queryable at runtime via hkReflect::Type::findAttribute)
#define HK_DECLARE_CLASS_RuntimeAttribute(CLASS_NAME) \
    HK_SINGLE_RECORD_ATTR(hk::RuntimeAttribute)
/// Declares this class as a StaticAttribute (i.e. only consumed by hkPreBuild)
#define HK_DECLARE_CLASS_StaticAttribute(CLASS_NAME) \
    HK_SINGLE_RECORD_ATTR(hk::StaticAttribute)

/// Declares an empty, private operator new.
#define HK_DECLARE_CLASS_NoNew(CLASS_NAME) \
    private: void* HK_CALL operator new(hk_size_t) HK_NOEXCEPT HK_SINGLE_ATTR( hk::Reflect(false) ); public:

#define HK_DECLARE_CLASS_NonCopyable(CLASS_NAME) \
    private: CLASS_NAME(const CLASS_NAME&) HK_SINGLE_ATTR(hk::Reflect(false)); void operator=(const CLASS_NAME&) HK_SINGLE_ATTR(hk::Reflect(false)); public:

    /// For compatibility, this will be removed
#define HK_DECLARE_CLASS_Validate(CLASS_NAME)

template <class TYPE>
class hkRefPtr;
class hkStringBuf;
class hkStringView;
namespace hkBaseSystem
{
    struct InitNode;
    namespace Detail { template<typename T> struct RefPtrNoDtor; }
}
namespace hk
{
    struct Presets;
}
/// Declare this class as having a "singleton" instance.
/// Also use one of the HK_SINGLETON_IMPLEMENTATION macros in the classes .cpp file.
#define HK_DECLARE_CLASS_Singleton(CLASS) \
    static hkBaseSystem::InitNode singletonEntry; \
    static hkBaseSystem::Detail::RefPtrNoDtor<CLASS> singleton; \
    static inline CLASS& getInstance() { return *singleton; } \
    static inline CLASS* getInstancePtr() { return singleton; } \
    static inline bool isInitialised() { return (singleton != HK_NULL); } \
    static inline void replaceInstanceAndAddReference(CLASS* c) { singleton = c; } \
    static void replaceInstance(CLASS* c) { singleton.setAndDontIncrementRefCount(c); }

namespace hkReflect
{
    class Type;
        class ValueType;
            class BoolType;
            class IntType;
            class FloatType;
            class StringType;
        class CompoundType;
            class RecordType;
            class PointerType;
            class ContainerType;
                class ArrayType;
        class VoidType;
        class OpaqueType;

    struct VarIter;
    struct Var;
        struct ValueVar;
            struct BoolVar;
            struct IntVar;
            struct FloatVar;
            struct StringVar;
        struct CompoundVar;
            struct PointerVar;
            struct RecordVar;
            struct ContainerVar;
                struct ArrayVar;
        struct OpaqueVar;
        struct VoidVar;

    namespace Detail
    {
        struct Impl;
            struct ValueImpl;
                struct BoolImpl;
                struct IntImpl;
                struct FloatImpl;
                struct StringImpl;
            struct CompoundImpl;
                struct PointerImpl;
                struct RecordImpl;
                struct ContainerImpl;
                    struct ArrayImpl;
            struct OpaqueImpl;
            struct VoidImpl;

        /// TypeData is a variable length struct. See hkReflect::Type for the non-optional members.
        /// The format is { opt_mask, parent_ptr, opts depending on the mask ... }
        typedef hkUlong TypeData[];
        template<typename CLASS, typename T0, typename T1, typename T2, typename T3, typename T4, typename T5, typename T6, typename T7, typename T8> struct ConstructorInvoker;
        template<typename T> struct RefToPtr;
    }

    template<typename T> class QualifiedType;
    typedef QualifiedType<Type> QualType;

    struct HK_EXPORT_COMMON BypassCtorFlag {};
    class TypeBuilder;
    struct TypeDetail;
    class Decl;
    class DeclIterAll;
    template<typename DECL> class DeclIter;
    class FieldDecl;
    class DataFieldDecl;
    class PropertyFieldDecl;
    class Callable;
    class ReturnVariant;
    class Template;
    class TypeName;

    template<typename> struct KindFromType;

    class TypeRegIterator;
    class TypeReg;
    class MutableTypeReg;
    namespace Detail
    {
        template<typename> struct RecordPropertyImpl;
        template<typename> struct IntegerPropertyImpl;
        template<typename> struct EnumPropertyImpl;
        template<typename> struct FloatPropertyImpl;
        template<typename, typename> struct PointerPropertyImpl;
        struct StringPropertyImpl;
        struct BoolPropertyImpl;

        // values for SizeAlign::getRequestedAlign
        enum { ALIGN_UNSET = 0x0fff };
        enum AlignReq
        {
            ALIGN_REQ_NATURAL = 0,
            ALIGN_REQ_2 = 1,
            ALIGN_REQ_4 = 2,
            ALIGN_REQ_8 = 3,
            ALIGN_REQ_16 = 4,
            ALIGN_REQ_32 = 5,
            ALIGN_REQ_REAL4 = 0xf,
        };
    }

    namespace Opt
    {
        namespace Bits
        {
            enum
            {
                FORMAT = 0,
                SUBTYPE = 1,
                IMPL = 2,
                NAME = 3,
                VERSION = 4,
                ATTRIBUTES = 5,
                DEF_CONSTRUCTOR = 6,
                COPY_CONSTRUCTOR = 7,
                //UNUSED = 8
                DESTRUCTOR = 9,
                COPY_ASSIGNMENT = 10,
                FUNCTIONS = 11,
                EXACT_TYPE = 12,
                MESSAGING = 13,
                DEFAULT = 14,
                INHERITANCE = 15,
                POINTER_IMPL = 16,
                INTERFACES = 17,
                TEMPLATE = 18,
                DECL_NAME = 19,
                DECL_FORMAT = 20,
                DECL_CONTEXT = 21,
                ALLOC_IMPL = 22,
                SIZE_ALIGN = 23,
                FLAGS = 24,
                REFLECT_CONSTRUCTOR = 25,
                DECLS = 26,
                AFTER_REFLECT_NEW = 27,
                ATTRIBUTE_STRING = 28,
                TYPE_WORLD = 29,
                VALIDATE = 30
            };
        }

        /// Bit masks for the optional components which each type can have.
        enum Values
        {
            NONE = 0x0,
            FORMAT = 1 << Bits::FORMAT,
            SUBTYPE = 1 << Bits::SUBTYPE, // container element/pointer type
            IMPL = 1 << Bits::IMPL,
            NAME = 1 << Bits::NAME,//char*
            VERSION = 1 << Bits::VERSION,//int32
            ATTRIBUTES = 1 << Bits::ATTRIBUTES,//Attributes
            DEF_CONSTRUCTOR = 1 << Bits::DEF_CONSTRUCTOR,
            //UNUSED
            DESTRUCTOR = 1 << Bits::DESTRUCTOR, // destructor optional
            COPY_CONSTRUCTOR = 1 << Bits::COPY_CONSTRUCTOR,
            COPY_ASSIGNMENT = 1 << Bits::COPY_ASSIGNMENT, // copy assignment operator optional
            FUNCTIONS = 1 << Bits::FUNCTIONS,//Functions*
            EXACT_TYPE = 1 << Bits::EXACT_TYPE, //ExactTypeFunction
            MESSAGING = 1 << Bits::MESSAGING, //msghandler:16 msgid:16
            DEFAULT = 1 << Bits::DEFAULT, // void*
            INHERITANCE = 1 << Bits::INHERITANCE, //type ranges 
            POINTER_IMPL = 1 << Bits::POINTER_IMPL, // pointer impl
            INTERFACES = 1 << Bits::INTERFACES,
            TEMPLATE = 1 << Bits::TEMPLATE,
            DECL_NAME = 1 << Bits::DECL_NAME,
            DECL_FORMAT = 1 << Bits::DECL_FORMAT,
            DECL_CONTEXT = 1 << Bits::DECL_CONTEXT,
            ALLOC_IMPL = 1 << Bits::ALLOC_IMPL,
            SIZE_ALIGN = 1 << Bits::SIZE_ALIGN,
            FLAGS = 1 << Bits::FLAGS,
            REFLECT_CONSTRUCTOR = 1 << Bits::REFLECT_CONSTRUCTOR,
            DECLS = 1 << Bits::DECLS,
            AFTER_REFLECT_NEW = 1 << Bits::AFTER_REFLECT_NEW,
            ATTRIBUTE_STRING = 1 << Bits::ATTRIBUTE_STRING,
            TYPE_WORLD = 1 << Bits::TYPE_WORLD,
            VALIDATE = 1 << Bits::VALIDATE,
        };

        // Keep separate not to break VS enum debug visualizer.
        enum
        {
            // Data only reflection has these opts only
            DATA_ONLY_MASK = (FORMAT | SUBTYPE | IMPL | NAME | VERSION | ATTRIBUTES
            | DEFAULT | INHERITANCE | POINTER_IMPL | INTERFACES | TEMPLATE | DECL_NAME
            | DECL_FORMAT | DECL_CONTEXT | ALLOC_IMPL | SIZE_ALIGN | FLAGS | DECLS | ATTRIBUTE_STRING),
            // Data only but with enough to construct and destruct the type (through a bypass ctor)
            DATA_CONSTRUCTIBLE_MASK = (FORMAT | SUBTYPE | IMPL | NAME | VERSION | ATTRIBUTES
            | DESTRUCTOR | DEFAULT | INHERITANCE | POINTER_IMPL | INTERFACES
            | TEMPLATE | DECL_NAME | DECL_FORMAT | DECL_CONTEXT | ALLOC_IMPL | SIZE_ALIGN
            | FLAGS | REFLECT_CONSTRUCTOR | DECLS | AFTER_REFLECT_NEW | ATTRIBUTE_STRING),
        };
    }

    typedef Opt::Values Optional;

// -------------------------------- Kinds -------------------------------- //

        /// Type objects contain a Kind so they can be discriminated.
        /// For most purposes, using the as or asExactly templates is better than explicitly
        /// distinguishing types using their Kind.
    enum Kind
    {
        // basic
            /// Corresponds to C++ "void" type
        KIND_VOID = 0,
            /// An opaque type, not visible to the reflection system
        KIND_OPAQUE,
            /// True or False
        KIND_BOOL,
            /// Null or null-terminated string
        KIND_STRING,
            /// Signed and unsigned integers.
        KIND_INT,
            /// Floating point values such as float, double, hkHalf16.
        KIND_FLOAT,
            /// Pointers.
        KIND_POINTER,
            /// Type which has named subtypes.
        KIND_RECORD,
            /// Container type which has integer indexed subtypes.
        KIND_ARRAY,
            /// Containers such as set, map and array.
        //KIND_CONTAINER,

        _KIND_MAX,
    };

    namespace Detail
    {
        struct FunctionsPod;
        struct NamedCallablePod;
        struct CallableSignature;
        struct RecordFieldPod;
        struct AttributeArray;
        struct DeclsArray;
        struct TypeRegNode;
        struct TemplateParameterArray;
    }

    namespace Format
    {
        enum
        {
            HostBigEndian = HK_ENDIAN_BIG,
            // 5 bits for kind
            KIND_MASK = 0x1f,
            // note: not all bits make sense for all formats
            IMMUTABLE_BIT = 1 << 7,
            BIG_ENDIAN_BIT = 1 << 8,
            SIGNED_BIT = 1 << 9,
            HIDDEN_BIT = 1 << 10,
            INT_NUM_BITS_SHIFT = 10,
        };

        template<bool IS_BIG_ENDIAN, bool HAS_SIGN, unsigned NUM_BITS>
        struct OfIntGeneric
        {
            // [0-4] Kind
            // [5-7] Reserved 0
            // [8] endianness (0:little, 1:big)
            // [9] signedness (0:unsigned , 1:signed)
            // [10-17] bit count
            // [18-31] Reserved 0
            HK_COMPILE_TIME_ASSERT( NUM_BITS<=64 );
            enum { Value = KIND_INT | (((NUM_BITS>8) && IS_BIG_ENDIAN)? BIG_ENDIAN_BIT :0) | (HAS_SIGN?SIGNED_BIT:0) | (NUM_BITS<<INT_NUM_BITS_SHIFT) };
        };

        template<typename T>
        struct OfInt
        {
            enum { Value = OfIntGeneric<HostBigEndian, hkTrait::IsSigned<T>::result, sizeof(T)*8>::Value };
        };

        // "char" is always reflected as unsigned.
        template<> struct OfInt<char> : public OfInt<unsigned char> {};

        template<bool IS_BIG_ENDIAN, unsigned NUM_BITS>
        struct OfBoolGeneric
        {
            // [0-4] Kind
            // [5-7] Reserved 0
            // [8] endianness (0:little, 1:big)
            // [9] Reserved 0
            // [10-17] bit count
            // [18-31] Reserved 0
            HK_COMPILE_TIME_ASSERT(NUM_BITS <= 64);
            enum { Value = KIND_BOOL | (((NUM_BITS > 8) && IS_BIG_ENDIAN) ? BIG_ENDIAN_BIT : 0) | (NUM_BITS<<INT_NUM_BITS_SHIFT) };
        };

        template<typename T>
        struct OfBool
        {
            // See OfBoolGeneric
            enum { Value = OfBoolGeneric<HostBigEndian, sizeof(T)*8>::Value };
        };

        template<bool IS_BIG_ENDIAN, bool HAS_SIGN_BIT, bool HAS_HIDDEN_BIT, unsigned NUM_EXP_BITS, unsigned NUM_SIGNIF_BITS>
        struct OfFloatGeneric
        {
            // [0-4] Kind
            // [5-7] Reserved 0
            // [8] endianness (0:little, 1:big)
            // [9] has sign bit (0:no 1:yes)
            // [10]: has implicit 1 bit (0:no 1:yes)
            // [11-15] exponent bit count (0-31)
            // [16-23] significand bit count (0-255)
            // [24-31] Reserved 0
            HK_COMPILE_TIME_ASSERT( (NUM_EXP_BITS<=15) && (NUM_SIGNIF_BITS<=255) );
            enum
            {
                EXP_BIAS=(2<<NUM_EXP_BITS)/2-1,
                Value = KIND_FLOAT | ((((HAS_SIGN_BIT + NUM_EXP_BITS + NUM_SIGNIF_BITS)>8) && IS_BIG_ENDIAN) ? BIG_ENDIAN_BIT : 0) | (HAS_SIGN_BIT ? SIGNED_BIT : 0) | (HAS_HIDDEN_BIT ? HIDDEN_BIT : 0) | (NUM_EXP_BITS << 11) | (NUM_SIGNIF_BITS << 16)
            };
        };

        template<typename T>
        struct OfFloat;

        template<>
        struct OfFloat<hkFloat32>
        {
            enum { Value = OfFloatGeneric<HostBigEndian, 1, 1, 8, 23>::Value };
        };
        template<>
        struct OfFloat<hkDouble64>
        {
            enum { Value = OfFloatGeneric<HostBigEndian, 1, 1, 11, 52>::Value };
        };

        template<unsigned FIXED_COUNT, bool IS_IMMUTABLE>
        struct OfStringUtf8
        {
            // [0-4] Kind
            // [5-6] 0:Generic (must use impl) 1:Fixed buffer 2,3:reserved
            // [7] Immutable content (buffer can be shared)
            // [8-15] Reserved 0
            // [16-31] Fixed elements count
            enum { Value = KIND_STRING | (FIXED_COUNT ? (1<<5): 0) | (IS_IMMUTABLE ? IMMUTABLE_BIT : 0) | (FIXED_COUNT <<16) };
        };

        struct OfRecord
        {
            // [0-4] Kind
            // [5-31] Reserved
            enum { Value = KIND_RECORD };
        };
        inline int ofRecord() { return KIND_RECORD; }

        template<unsigned COUNT=0>
        struct OfArray
        {
            // [0-4] Kind
            // [5-7] (0:generic, 1:fixed inplace array, 2+:reserved)
            // [8-31] Fixed elements count
            enum { Value = KIND_ARRAY | (COUNT?(1<<5):0) | (COUNT<<8) };
        };
        inline int ofArray(int count=0) { return KIND_ARRAY | (count?(1<<5):0) | (count<<8); }

        struct OfVoid
        {
            // [0-4] Kind
            // [5-31] Reserved 0
            enum { Value = KIND_VOID };
        };

        struct OfPointer
        {
            // [0-4] Kind
            // [5-31] Reserved 0
            enum { Value = KIND_POINTER };
        };

        //struct OfContainer
        //{
        //  // [0-4] Kind
        //  // [5-31] Reserved 0
        //  enum { Value = KIND_CONTAINER };
        //};

        struct OfOpaque
        {
            // [0-4] Kind
            // [5-31] Reserved 0
            enum { Value = KIND_OPAQUE };
        };

        // This is very simple as it has to go into the instruction union
        struct Value
        {
            hkUint32 m_val;

            HK_INLINE hkUint32 get() const { return m_val; }
            HK_INLINE void set(hkUint32 val) { m_val = val; }
            HK_INLINE bool operator==(const Value& other) const { return m_val == other.m_val; }
            HK_INLINE bool operator!=(const Value& other) const { return m_val != other.m_val; }
            HK_INLINE bool equalsValue(hkUint32 otherVal) const { return m_val == otherVal; }
            HK_INLINE Kind getKind() const { return static_cast<Kind>(m_val & KIND_MASK); }

            static HK_INLINE Value create(hkUint32 val) { Value f; f.set(val); return f; }
        };

            /// See hkReflect::Format::OfIntGeneric
        struct IntValue : public Value
        {
            IntValue(const Value& format)
            {
                m_val = format.get();
                HK_ASSERT_NO_MSG(0x5e1d1764, ((m_val & KIND_MASK) == hkReflect::KIND_INT) || ((m_val & KIND_MASK) == hkReflect::KIND_BOOL));
            }

            bool isBigEndian() const { return (m_val & BIG_ENDIAN_BIT) != 0; }
            bool isSigned() const { return (m_val & SIGNED_BIT) != 0; }
            unsigned numBits() const { return m_val >> INT_NUM_BITS_SHIFT; }
            // + 7 / 8 -> convert to num of bytes needed
            unsigned sizeOf() const { return ((numBits() + 7) >> 3); }
        };

            /// See hkReflect::Format::OfFloatGeneric
        struct FloatValue : public Value
        {
            FloatValue(const Value& format)
            {
                m_val = format.get();
                HK_ASSERT_NO_MSG(0x7279398a, (m_val & KIND_MASK) == hkReflect::KIND_FLOAT); // Kind
            }

            bool isBigEndian() const { return (m_val & BIG_ENDIAN_BIT) != 0; }
            bool hasSignBit() const { return (m_val & SIGNED_BIT) != 0; }
            bool hasImplicitOneBit() const { return (m_val & HIDDEN_BIT) != 0; }
            unsigned numBitsExponent() const { return (m_val >> 11) & (0x01f); }
            unsigned bitOffsetExponent() const { return hasSignBit() ? 1 : 0; }
            unsigned numBitsSignificand() const { return (m_val >> 16) & (0x0ff); }
            unsigned bitOffsetSignificand() const { return bitOffsetExponent() + numBitsExponent(); }

            void setBigEndian(bool isBig) { if (isBig) { m_val |= BIG_ENDIAN_BIT; } else { m_val &= ~BIG_ENDIAN_BIT; } }
            unsigned sizeOf() const { return ((hasImplicitOneBit() ? 1 : 0) + numBitsExponent() + numBitsSignificand() + 7) / 8; }

            HK_INLINE hkUint32 getSwapEndianness() const { return m_val ^ BIG_ENDIAN_BIT; }
        };

            /// See hkReflect::Format::OfStringUtf8
        struct StringValue : public Value
        {
            StringValue(const Value& format)
            {
                m_val = format.get();
                HK_ASSERT_NO_MSG(0x1b4ee49d, (m_val & KIND_MASK) == hkReflect::KIND_STRING); // Kind
            }

            bool isImmutable() const { return (m_val & IMMUTABLE_BIT) != 0; }
            unsigned getFixedCount() const { return (((m_val>>5)&0x7)==1) ? (m_val>>16) : 0; }
        };

            /// See hkReflect::Format::OfArray
        struct ArrayValue : public Value
        {
            ArrayValue(const Value& format)
            {
                m_val = format.get();
                HK_ASSERT_NO_MSG(0x3e423eea, (m_val & KIND_MASK) == hkReflect::KIND_ARRAY); // Kind
            }

            unsigned getFixedCount() const { return m_val >> 8; }
        };
    }

    template<typename T>
    QualType getType();


    // Internal plumbing for the IsReflected trait.
    namespace Detail
    {
        /// Helper struct storing an object address and its type.
        struct AddrAndType
        {
            HK_ALWAYS_INLINE AddrAndType() {}
            HK_ALWAYS_INLINE AddrAndType(_In_ const void* addr, _In_ const hkReflect::Type* type)
                : m_addr((void*)addr), m_type(type) {}
            template <typename T>
            inline AddrAndType(const T* addr)
                : m_addr((void*)addr), m_type(hkReflect::getType<T>()) {}

            void* m_addr;
            const hkReflect::Type* m_type;
        };

        /// Returns U::IsReflectedCheck<U>::TypeIfReflected if it exists, void otherwise.
        template<typename U, bool HasType>
        struct GetIsReflectedCheckTypeIfPresent;

        template<typename U>
        struct GetIsReflectedCheckTypeIfPresent<U, true>
        {
            // It exists, return it.
            typedef typename U::template IsReflectedCheck<U>::TypeIfReflected Type;
        };

        template<typename U>
        struct GetIsReflectedCheckTypeIfPresent<U, false>
        {
            // It doesn't, return void.
            typedef void Type;
        };

        /// Checks if a class has been marked with HK_DECLARE_CLASS_Reflect.
        /// Specifically checks that a) the class declares a nested IsReflectedCheck type, and
        /// b) IsReflectedCheck::TypeIfReflected is equal to T.
        template <typename T>
        struct NestedReflectedCheck
        {
            typedef char yes[1];
            typedef char no[2];

            template <typename C>
            static yes& test(typename C::template IsReflectedCheck<T>::TypeIfReflected*);

            template <typename>
            static no& test(...);

            static const bool exists = sizeof(test<T>(0)) == sizeof(yes);
            typedef typename GetIsReflectedCheckTypeIfPresent<T, exists>::Type TypeInNestedCheck;

            typedef hkTrait::TypesAreEqual<T, TypeInNestedCheck> Type;
            enum { result = Type::result };
        };

        /// Selector for the property impl of a class.
        /// Uses T::PropertyImpl if present, otherwise hkReflect::Detail::RecordPropertyImpl<T>.
        template <typename T, typename _=void>
        struct PropertyImplOf
        {
            typedef hkReflect::Detail::RecordPropertyImpl<T> Type;
        };

        template<typename T>
        struct PropertyImplOf < T, typename hkTrait::If<false, typename T::PropertyImpl, void>::Type >
        {
            typedef typename T::PropertyImpl Type;
        };

        /// Selector for the kind of a reflected type. Defaults to RecordType for classes, IntType for enums.
        template <typename T, typename _ = void>
        struct ReflectedKindOfImpl
        {
            typedef typename hkTrait::If<hkTrait::IsBuiltinType<T>::Result, IntType, RecordType>::Type Type;
        };

        /// If T declares a ReflectedKind, use it.
        template<typename T>
        struct ReflectedKindOfImpl < T, typename hkTrait::If<false, typename T::template ReflectedAs<T>, void>::Type >
        {
            typedef typename T::template ReflectedAs<T>::Type Type;
        };

        template<typename T>
        struct ReflectedKindOf : public ReflectedKindOfImpl<T>
        {
            static_assert(sizeof(typename hkTrait::VoidValue<T>::Type) > 0, "ReflectedKindOf needs T to be defined");
            enum { value = KindFromType<typename ReflectedKindOfImpl<T>::Type >::kind };
        };
    }

    /// Defines as ::Holder the type which contains the TypeData for T.
    /// The default implementation defines Holder as T if T is a class marked with HK_DECLARE_CLASS(Reflect), void
    /// otherwise. Builtins, templates and special types use custom specializations of this trait.
    template<typename T>
    struct ReflectionOf
    {
        typedef typename hkTrait::If< Detail::NestedReflectedCheck<T>::result, T, void>::Type Holder;
        typedef typename Detail::PropertyImplOf<T>::Type PropertyImpl;
    };

    // Const-ness is not reflected.
    template<typename T>
    struct ReflectionOf<const T> : public ReflectionOf<T> {};

    namespace Detail
    {
        /// Things with this type are opaque to the reflection system.
        struct HK_EXPORT_COMMON Opaque
        {
            HK_DECLARE_CLASS(Opaque, NoNew, Reflect);
            HK_RECORD_ATTR(hk::IncludeInMgd(false));

            HK_REFLECT_AS_OPAQUE();
        };

        template <typename T>
        struct MarkAsOpaque {};

        template<typename T>
        struct RemoveMarkAsOpaque
        {
            typedef T Type;
        };

        template<typename T>
        struct RemoveMarkAsOpaque< MarkAsOpaque<T> >
        {
            typedef T Type;
        };
    }

    // Value fields marked as incomplete will maintain their type
    template<typename T>
    struct ReflectionOf< Detail::MarkAsOpaque<T> > : public ReflectionOf<T>{};

    // Remove const.
    template<typename T> struct ReflectionOf< Detail::MarkAsOpaque<const T> > : public ReflectionOf < Detail::MarkAsOpaque<T> > {};

    namespace Detail
    {
        /// Forwards to ReflectionOf and asserts that T is reflected.
        template<typename T>
        struct SafeReflectionOf : public hkReflect::ReflectionOf<T>
        {
            static_assert(hkReflect::IsReflected<T>::result, "Cannot access reflection of non-reflected type T");
        };
    }

    /// Returns the type information associated with the argument.
    /// Identical to hkReflect::getType<...>() except that it generates more efficient code when used in static initializers.
#define HK_REFLECT_GET_TYPE(...)    reinterpret_cast<const hkReflect::Type*>(&hkReflect::Detail::SafeReflectionOf<__VA_ARGS__>::Holder::typeData)
#define HK_REFLECT_GET_NON_CONST_TYPE(...)  reinterpret_cast<hkReflect::Type*>(&hkReflect::ReflectionOf<__VA_ARGS__>::Holder::typeData)

    /// Returns a compile time id that uniquely identifies a reflected method, that id will match the return value of
    /// hkReflect::Callable::getCallableId()
#define HK_REFLECT_GET_METHOD_ID(TYPE, METHOD_NAME) \
    reinterpret_cast<hkUlong>(&TYPE::_Auto::s_##METHOD_NAME::ptr)

#define HK_REFLECTIONOF_ALIAS(OLDTYPE, NEWNAME) \
    namespace hkReflect { template<> struct ReflectionOf< NEWNAME > { typedef ReflectionOf<OLDTYPE>::Holder Holder; }; }

#define HK_REFLECTIONOF_SPECIALIZE( DLLIMP, THING ) \
    HK_REFLECTIONOF_SPECIALIZE_DETAIL( DLLIMP, THING, )

    /// Specialize with property impl
#define HK_REFLECTIONOF_SPECIALIZE2( DLLIMP, THING, PROPIMPL ) \
    HK_REFLECTIONOF_SPECIALIZE_DETAIL( DLLIMP, THING, typedef PROPIMPL PropertyImpl)

#define HK_REFLECTIONOF_SPECIALIZE_DETAIL( DLLIMP, THING, PROPIMPL_DECL ) \
    namespace hkReflect { \
        template<> struct DLLIMP ReflectionOf< THING > { \
            typedef ReflectionOf< THING > Holder; \
            PROPIMPL_DECL; \
            static hkReflect::Detail::TypeData typeData; \
        }; \
    }

#define HK_REFLECTIONOF_SPECIALIZE_KIND( THING, KIND ) \
    namespace hkReflect { namespace Detail { \
        template<> struct ReflectedKindOfImpl< THING > { typedef KIND Type; }; \
    } } \

#define HK_REFLECTIONOF_SPECIALIZE3( DLLIMP, THING, KIND, PROPIMPL ) \
    HK_REFLECTIONOF_SPECIALIZE2( DLLIMP, THING, PROPIMPL ); \
    HK_REFLECTIONOF_SPECIALIZE_KIND( THING, KIND )

    /// Workaround C++ weak typedefs. hkReflect::getType<TDEF>() would return the reflection of the underlying
    /// type, not the typedef itself. The workaround is to associate a "tag" structure with a given typedef.
    /// This allows the reflection of TDEF to be retrieved via getType<TTAG>().
    namespace Typedef
    {
        // Tags replace the original type in reflection so they must behave the same way.
        template<typename T, bool IsBuiltin = hkTrait::IsBuiltinType<T>::Result> struct Tag;
        template<typename T> struct Tag<T, true> { T m_value; };
        template<typename T> struct Tag<T, false> : public T {};

        /// Defines Type to the original type if T is a typedef tag, or a template specialization where some of the
        /// arguments are typedef tags.
        template<typename T>
        struct Resolve
        {
            template <typename C, typename _ = void> struct SfinaeHelper { typedef C Type; };

            /// When using HK_REFLECT_AS_TYPEDEF, use the undecorated type declared by the macro.
            template<typename C>
            struct SfinaeHelper<C, typename hkTrait::If<false, typename C::ReflectedAsTypedefOf, void>::Type>
            {
                typedef typename hkReflect::Typedef::Resolve<typename C::ReflectedAsTypedefOf>::Type Type;
            };

            typedef typename SfinaeHelper<T>::Type Type;
        };

        template<typename T> struct Resolve<const T> { typedef const typename Resolve<T>::Type Type; };
        template<typename T> struct Resolve<T*> { typedef typename Resolve<T>::Type* Type; };
        template<typename T> struct Resolve<T&> { typedef typename Resolve<T>::Type& Type; };
        template<typename T, int N> struct Resolve<T[N]> { typedef typename Resolve<T>::Type Type[N]; };
    }

#define HK_REFLECT_RESOLVE(...) typename HK_REFLECT_RESOLVE2(__VA_ARGS__)
#define HK_REFLECT_RESOLVE2(...) hkReflect::Typedef::Resolve< __VA_ARGS__ >::Type

    // Memory tracker internals.
#if defined(HK_MEMORY_TRACKER_ENABLE)

    // Hook for the generation of a tracker type.
    #define HK_DECLARE_MEMORY_TRACKER_HOOK(CLASS_NAME) \
        struct _OldMacroHack { typedef CLASS_NAME _TrackerType; static const hkUint16 _trackerValue = 0; }; \
        static const hkUint16 _trackerValue = 0; \
        struct _TrackerAuto

    // Variant for templates (trackerHandle is defined in the generated reflection file).
    #define HK_DECLARE_MEMORY_TRACKER_HOOK_TEMPLATE(CLASS_NAME) \
        struct _OldMacroHack { typedef CLASS_NAME _TrackerType; }; \
        static const hkUint16 _trackerValue; \
        struct _TrackerHelper { static hkReflect::Detail::TypeData typeData; }; \
        struct _TrackerAuto

    namespace Detail
    {
        class TrackerRegNode;

        // Dummy tracked type used for builtins/types with no handle.
        struct HK_EXPORT_COMMON NotTracked
        {
            HK_DECLARE_CLASS(NotTracked, NoNew);
            static const hkUint16 _trackerValue = 0;
        };

        // Stores a static int whose address is used as a type disambiguator.
        // Definition can be inline because it is a template. We rely on the linker to resolve all the local copies
        // to the same symbol.
        // This does not work with DLLs because the helper is not exported.
        template <typename T>
        struct HandleHelper
        {
            static hkUint16 trackerHandle;
        };

        // T::_trackerValue is 0 except for templates, for which it takes the value of the corresponding trackerRegNode
        // so that it is not stripped at link time.
        template <typename T> hkUint16 HandleHelper<T>::trackerHandle = T::_trackerValue;

        
        template <typename T, bool HasOldMacro> struct HandleOldMacroHelper;
        template <typename T> struct HandleOldMacroHelper<T, false> { typedef HandleHelper<NotTracked> Type; };
        template <typename T> struct HandleOldMacroHelper<T, true> { typedef HandleHelper<typename T::_OldMacroHack::_TrackerType> Type; };

        // Type is the holder of the trackerHandle of T if T has one, NotTracked otherwise.
        template <typename T>
        struct HasTrackerHandle
        {
            typedef char yes;
            typedef long no;

            template<typename C> static yes test(typename C::_OldMacroHack*);
            template<typename C> static no test(...);
            enum { result = sizeof(test<T>(0)) == sizeof(yes) };

            // If the type has a manual layout, Type will be T; otherwise it will be HandleHelper<T::_OldMacroHack::_TrackerType|NotTracked>
            typedef typename HandleOldMacroHelper<T, result>::Type Type;
        };

        template<typename T>
        struct TrackerOf
        {
            typedef typename Detail::HasTrackerHandle<HK_REFLECT_RESOLVE(T)>::Type Holder;
        };

        template<typename T> struct TrackerOf<const T> : public TrackerOf<T> {};
    }

    #define HK_TRACKER_GET_HANDLE(...)  reinterpret_cast<hkMemoryTracker::Handle>(&hkReflect::Detail::TrackerOf<__VA_ARGS__>::Holder::trackerHandle)
    #define HK_TRACKER_GET_HANDLE_UNCHECKED(...) &hkReflect::Detail::HandleHelper< __VA_ARGS__ >::trackerHandle

    
    #define HK_TRACKER_CAST_TO_HANDLE(...) hkUint16(hkUlong(__VA_ARGS__) & 0xffff)

    // Manual specializations. Internal use
    #define HK_TRACKEROF_SPECIALIZE( THING, HOLDER ) \
        namespace hkReflect { namespace Detail { template<> struct TrackerOf< THING > { typedef HOLDER Holder; }; } }
    #define HK_TRACKEROF_SPECIALIZE_REFLECTED( DLLIMP, THING ) \
        HK_TRACKEROF_SPECIALIZE( THING, HandleHelper< THING > ); \
        namespace hkReflect { namespace Detail { \
            template<> struct DLLIMP HandleHelper< THING > { \
                static const TrackerRegNode trackerRegNode; \
                static const hkUint16 trackerHandle;\
            }; \
        } }
    #define HK_TRACKEROF_DEFINE_REFLECTED( THING ) \
        const hkReflect::Detail::TrackerRegNode hkReflect::Detail::HandleHelper< THING >::trackerRegNode( \
            hkReflect::ReflectionOf< THING >::Holder::typeData, &trackerHandle, false); \
        const hkUint16 hkReflect::Detail::HandleHelper< THING >::trackerHandle = HK_TRACKER_CAST_TO_HANDLE(&trackerRegNode)
    #define HK_TRACKEROF_SPECIALIZE_OPAQUE( THING ) \
        HK_TRACKEROF_SPECIALIZE( THING, HandleHelper< THING > ); \
        namespace hkReflect { namespace Detail { \
            template<> struct HandleHelper< THING > : public HandleHelper<NotTracked> {}; \
        } }
#else
    #if defined(__HAVOK_PARSER__)
        #define HK_DECLARE_MEMORY_TRACKER_HOOK(CLASS_NAME) static char trackerHook
        #define HK_DECLARE_MEMORY_TRACKER_HOOK_TEMPLATE(CLASS_NAME) static void* trackerHook
    #else
        #define HK_DECLARE_MEMORY_TRACKER_HOOK(CLASS_NAME)
        #define HK_DECLARE_MEMORY_TRACKER_HOOK_TEMPLATE(CLASS_NAME)
    #endif
    #define HK_TRACKEROF_SPECIALIZE( THING, HOLDER )
    #define HK_TRACKEROF_SPECIALIZE_REFLECTED( THING, DLLIMP )
    #define HK_TRACKEROF_DEFINE_REFLECTED( THING )
    #define HK_TRACKEROF_SPECIALIZE_OPAQUE( THING )
#endif

    namespace Detail
    {
        /// Contains the presets of a reflected enum. Empty by default, is specialized by HK_REFLECT_ENUM.
        /// Do not use this directly, use hkReflect::getPresetsOf instead.
        template<typename T> struct PresetsOf{};
            /// Helper to work around
        HK_EXPORT_COMMON bool HK_CALL isValidForPresets(const hk::Presets& pre, int value);
    }

    /// Reflect an enum. Must be used at global scope.
    /// DLLIMP must be the current project export declaration, or empty if the project does not export symbols.
#define HK_REFLECT_ENUM(DLLIMP, THING) \
    namespace hkReflect { namespace Detail { \
        template<> struct DLLIMP PresetsOf< THING > { static const hk::Presets presets; };\
    } } \
    HK_REFLECTIONOF_SPECIALIZE2(DLLIMP, THING, Detail::EnumPropertyImpl<THING> )

    /// Reflect a typedef. Must be used at global scope.
    /// DLLIMP must be the current project export declaration, or empty if the project does not export symbols.
    /// TDEF must be the typedef itself, TTAG a unique C++ identifier.
#define HK_REFLECT_TYPEDEF(DLLIMP, TDEF, TTAG) \
    namespace hkReflect { namespace Typedef { \
        struct TTAG : public Tag< TDEF > {}; \
        template<> struct Resolve< TTAG > { typedef TDEF Type; }; \
    } }\
    HK_REFLECTIONOF_SPECIALIZE_DETAIL( DLLIMP, hkReflect::Typedef::TTAG, ); \
    HK_REFLECTIONOF_SPECIALIZE_KIND( hkReflect::Typedef::TTAG, ReflectedKindOfImpl< TDEF >::Type ); \
    HK_TRACKEROF_SPECIALIZE( hkReflect::Typedef::TTAG, hkReflect::Detail::TrackerOf< TDEF >::Holder )

    namespace Detail
    {
        /// Defines the type to use for reflection default values. (hk::Default)
        /// Normally, we simply use the type itself, however sometimes the type has constructors
        /// which we can't or don't want to use. In this case, we specialize AggregateOf<T>::Type
        /// to define a type with equivalent memory layout. e.g. AggregateOf<hkVector4f>::Type == float[4]
        template<typename T, typename _ = void>
        struct AggregateOf
        {
            typedef T Type;
        };

        template<typename T>
        struct AggregateOf<T, typename hkTrait::If<false, typename T::ReflectDefaultType, void>::Type>
        {
            typedef typename T::ReflectDefaultType Type;
            static_assert( sizeof( Type ) == sizeof( T ), "Aggregate must have same size as original type" );
            static_assert( HK_ALIGN_OF( Type ) == HK_ALIGN_OF( T ), "Aggregate must have same alignment as original type" );
        };
    }
}

namespace hk { struct Presets; }

HK_REFLECTIONOF_SPECIALIZE3(HK_EXPORT_COMMON, char, IntType, Detail::IntegerPropertyImpl<unsigned char>);
HK_REFLECTIONOF_SPECIALIZE3(HK_EXPORT_COMMON, unsigned char, IntType, Detail::IntegerPropertyImpl<unsigned char>);
HK_REFLECTIONOF_SPECIALIZE3(HK_EXPORT_COMMON, signed char, IntType, Detail::IntegerPropertyImpl<signed char>);
HK_REFLECTIONOF_SPECIALIZE3(HK_EXPORT_COMMON, bool, BoolType, Detail::BoolPropertyImpl);
HK_REFLECTIONOF_SPECIALIZE3(HK_EXPORT_COMMON, short, IntType, Detail::IntegerPropertyImpl<short>);
HK_REFLECTIONOF_SPECIALIZE3(HK_EXPORT_COMMON, unsigned short, IntType, Detail::IntegerPropertyImpl<unsigned short>);
HK_REFLECTIONOF_SPECIALIZE3(HK_EXPORT_COMMON, int, IntType, Detail::IntegerPropertyImpl<int>);
HK_REFLECTIONOF_SPECIALIZE3(HK_EXPORT_COMMON, unsigned int, IntType, Detail::IntegerPropertyImpl<unsigned int>);
HK_REFLECTIONOF_SPECIALIZE3(HK_EXPORT_COMMON, long, IntType, Detail::IntegerPropertyImpl<long>);
HK_REFLECTIONOF_SPECIALIZE3(HK_EXPORT_COMMON, unsigned long, IntType, Detail::IntegerPropertyImpl<unsigned long>);
HK_REFLECTIONOF_SPECIALIZE3(HK_EXPORT_COMMON, long long, IntType, Detail::IntegerPropertyImpl<long long>);
HK_REFLECTIONOF_SPECIALIZE3(HK_EXPORT_COMMON, unsigned long long, IntType, Detail::IntegerPropertyImpl<unsigned long long>);
HK_REFLECTIONOF_SPECIALIZE3(HK_EXPORT_COMMON, float, FloatType, Detail::FloatPropertyImpl<float>);
HK_REFLECTIONOF_SPECIALIZE3(HK_EXPORT_COMMON, double, FloatType, Detail::FloatPropertyImpl<double>);
HK_REFLECTIONOF_SPECIALIZE3(HK_EXPORT_COMMON, char*, StringType, Detail::StringPropertyImpl);
HK_REFLECTIONOF_SPECIALIZE3(HK_EXPORT_COMMON, const char*, StringType, Detail::StringPropertyImpl);
HK_REFLECTIONOF_SPECIALIZE(HK_EXPORT_COMMON, void);
HK_REFLECTIONOF_SPECIALIZE_KIND(void, VoidType);

#ifdef HK_MEMORY_TRACKER_ENABLE
HK_TRACKEROF_SPECIALIZE_REFLECTED(HK_EXPORT_COMMON, char*);
HK_TRACKEROF_SPECIALIZE_REFLECTED(HK_EXPORT_COMMON, const char*);

// Flatten all pointers on void* to generate less data.
HK_TRACKEROF_SPECIALIZE_REFLECTED(HK_EXPORT_COMMON, void*);
namespace hkReflect { namespace Detail {
    template<typename T> struct TrackerOf<T*> : public TrackerOf<void*> {};
} }
#endif

HK_REFLECT_TYPEDEF(HK_EXPORT_COMMON, hkInt8, hkInt8_Tag);
HK_REFLECT_TYPEDEF(HK_EXPORT_COMMON, hkUint8, hkUint8_Tag);
HK_REFLECT_TYPEDEF(HK_EXPORT_COMMON, hkInt16, hkInt16_Tag);
HK_REFLECT_TYPEDEF(HK_EXPORT_COMMON, hkUint16, hkUint16_Tag);
HK_REFLECT_TYPEDEF(HK_EXPORT_COMMON, hkInt32, hkInt32_Tag);
HK_REFLECT_TYPEDEF(HK_EXPORT_COMMON, hkUint32, hkUint32_Tag);
HK_REFLECT_TYPEDEF(HK_EXPORT_COMMON, hkInt64, hkInt64_Tag);
HK_REFLECT_TYPEDEF(HK_EXPORT_COMMON, hkUint64, hkUint64_Tag);
HK_REFLECT_TYPEDEF(HK_EXPORT_COMMON, hkUlong, hkUlong_Tag);
HK_REFLECT_TYPEDEF(HK_EXPORT_COMMON, hkLong, hkLong_Tag);
HK_REFLECT_TYPEDEF(HK_EXPORT_COMMON, hkUintReal, hkUintReal_Tag);

HK_REFLECT_ENUM(HK_EXPORT_COMMON, hkReflect::Kind);

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
