// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0


HK_INLINE hkReflect::CallableIterator::CallableIterator(_In_ const Type* containerType, CallableTypes types)
    : m_currentIndex(-1)
    , m_currentType(containerType)
    , m_callableTypes(types)
    , m_currentCallableType(0)
{
}

HK_INLINE bool hkReflect::CallableIterator::advance()
{
    ++m_currentIndex;

    if (m_currentIndex >= m_currentArray.getSize())
    {
        m_currentIndex = 0;
        return nextArray();
    }
    return true;
}

HK_INLINE bool hkReflect::CallableIterator::advanceTo(int index)
{
    HK_ASSERT(0x2cb97dc, m_currentArray.getSize() == 0, "advanceTo can be called only on a newly constructed iterator");
    m_currentIndex = index;
    // skip through the callable arrays
    while (m_currentIndex >= m_currentArray.getSize())
    {
        m_currentIndex -= m_currentArray.getSize();
        if (!nextArray())
        {
            return false;
        }
    }
    return m_currentIndex < m_currentArray.getSize();
}

HK_INLINE _Ret_notnull_ const hkReflect::NamedCallable* hkReflect::CallableIterator::current() const
{
    HK_ASSERT_NO_MSG(0x55bf3192, m_currentIndex >= 0 && m_currentIndex < m_currentArray.getSize());
    return &m_currentArray[m_currentIndex];
}

inline _Ret_maybenull_ const hkReflect::Type* hkReflect::Callable::getObjectType() const
{
    return m_objectType;
}

inline _Ret_maybenull_ const hkReflect::Type* hkReflect::Callable::getReturnType() const
{
    return m_paramInfo->m_returnType;
}

inline int hkReflect::Callable::getNumParams() const
{
    return m_paramInfo->m_numParams;
}

inline _Ret_notnull_ const hkReflect::Type* hkReflect::Callable::getParamType(int i) const
{
    return m_paramInfo->getParam(i).m_type;
}

inline _Ret_z_ const char* hkReflect::Callable::getParamName(int i) const
{
    HK_ASSERT_NO_MSG(0x14cd35f0, i >=0 && i < getNumParams());
    return m_paramNames[i];
}

inline hkReflect::Var hkReflect::Callable::getParamDefaultArg(int i) const
{
    HK_ASSERT_NO_MSG(0x3ce85e71, i >= 0 && i < getNumParams());
    return (m_defaultArgs && m_defaultArgs[i]) ? hkReflect::Var(m_defaultArgs[i], getParamType(i)) : hkReflect::Var();
}

inline int hkReflect::Callable::getParamOffset(int i) const
{
    return m_paramInfo->getParam(i).m_offset;
}

inline int hkReflect::Callable::getParamBufSize() const
{
    return m_paramInfo->m_size;
}

inline int hkReflect::Callable::getParamBufAlignment() const
{
    return m_paramInfo->m_align;
}

inline hkReflect::Var hkReflect::Callable::findAttribute(_In_ const hkReflect::Type* t) const
{
    if (m_attributes)
    {
        return m_attributes->findAttribute(t);
    }
    return Var();
}

template <typename T>
inline _Ret_maybenull_ const T* hkReflect::Callable::findAttribute() const
{
    return static_cast<const T*>(findAttribute(hkReflect::getType<T>()).getAddress());
}

HK_INLINE void hkReflect::Callable::callMethod(void* thisPtr, void* packedArgs, void* returnBuffer) const
{
    HK_ASSERT_NO_MSG(0x7091ec5d, m_objectType);
    m_invoker.invoke(thisPtr, packedArgs, returnBuffer);
}

HK_INLINE void hkReflect::Callable::callFunction(void* args, void* returnBuffer) const
{
    HK_ASSERT_NO_MSG(0x43ffe24a, m_objectType==HK_NULL);
    m_invoker.invoke(HK_NULL, args, returnBuffer);
}

inline hkReflect::SiMethodPointer hkReflect::Callable::getMethodPointer() const
{
    HK_ASSERT_NO_MSG(0x3198e4cb, m_objectType);
    
    return *reinterpret_cast<const hkReflect::SiMethodPointer*>(m_invoker.m_data);
}

inline hkReflect::Detail::CallableId hkReflect::Callable::getCallableId() const
{
    return (hkUlong)m_invoker.m_data;
}

HK_INLINE hkReflect::Detail::CallInvoker hkReflect::Callable::getCallInvoker() const
{
    return m_invoker;
}

void hkReflect::Callable::callGeneric(void* object, void* params, void* retbuf) const
{
    m_invoker.invoke(object, params, retbuf);
}

HK_INLINE hkReflect::Call::Call(_In_ const hkReflect::Callable* callable )
    : m_callable(callable)
    , m_obj(HK_NULL)
    , m_returnBuf(HK_NULL)
{
    HK_ASSERT_NO_MSG(0x61a1d671, callable );
}

namespace hkReflect
{
namespace Detail
{
    HK_INLINE void checkCallableBuffer( hkArrayView<void> buffer, int minSize, int minAlign )
    {
        HK_ASSERT(0x6b193802, buffer.begin(), "Buffer cannot be null" );
        HK_ASSERT(0x7a65f39d, buffer.getSize() >= minSize, "Invalid buffer size" );
        HK_ASSERT(0x1374364d, hkUlong( buffer.begin() ) % minAlign == 0, "Invalid buffer alignment" );
    }
    HK_INLINE void checkCallableBuffer( hkArrayView<void> buffer, const hkReflect::Type* type )
    {
        checkCallableBuffer( buffer, type->getSizeOf(), type->getAlignOf() );
    }
}
}

HK_INLINE hkReflect::Call& hkReflect::Call::onObj( const hkReflect::Var& var )
{

#if defined (HK_DEBUG)
    if ( m_callable->getObjectType() )
    {
        HK_ASSERT_NO_MSG(0x47d966e6, var );
        HK_ON_DEBUG( auto asPtr = m_callable->getObjectType()->asPointer() );
        HK_ASSERT_NO_MSG(0x3e8ee7a3, asPtr );
        HK_ASSERT(0x7d1aa5de, var.isInstanceOf( asPtr->getSubType() ), "Invalid object type" );
    }
    else
    {
        HK_ASSERT(0xf8a5906, !var, "Method is static" );
    }
#endif

    m_obj = var.getAddress();
    return *this;
}

HK_INLINE hkReflect::Call& hkReflect::Call::onObjRaw( hkArrayView<void> buffer )
{
    if ( m_callable->getObjectType() )
    {
        Detail::checkCallableBuffer( buffer, m_callable->getObjectType() );
    }
    else
    {
        HK_ASSERT(0x68d5daf9, buffer.isEmpty(), "Method is static" );
    }
    m_obj = buffer.begin();
    return *this;
}

HK_INLINE hkReflect::Call& hkReflect::Call::into( const Var& returnBuf )
{
    if ( !m_callable->getReturnType()->asVoid() )
    {
        HK_ASSERT_NO_MSG(0x67e17b7c, returnBuf );
        HK_ASSERT(0x5572eaf4, m_callable->getReturnType()->equals( returnBuf.getType() ), "Invalid return type" );
    }
    m_returnBuf = returnBuf.getAddress();
    return *this;
}

HK_INLINE hkReflect::Call& hkReflect::Call::into( hkReflect::Any& returnBuf )
{
    if ( !m_callable->getReturnType()->asVoid() )
    {
        returnBuf.allocateOnly( m_callable->getReturnType() );
        m_returnBuf = returnBuf.var().getAddress();
    }
    return *this;
}

HK_INLINE hkReflect::Call& hkReflect::Call::intoRaw( hkArrayView<void> buffer )
{
    if ( !m_callable->getReturnType()->asVoid() )
    {
        Detail::checkCallableBuffer( buffer, m_callable->getReturnType() );
    }
    m_returnBuf = buffer.begin();
    return *this;
}

HK_INLINE hkReflect::Var hkReflect::Call::withArg( const hkReflect::Var& arg ) const
{
    HK_ASSERT(0x36027987, m_callable->getNumParams() == ( arg ? 1 : 0 ), "Method takes {} args", m_callable->getNumParams() );
    if ( arg )
    {
        HK_ASSERT(0x1c37e76f, m_callable->getParamType( 0 )->equals( arg.getType() ), "Wrong argument type" );
    }
    return call( arg.getAddress() );
}

HK_INLINE hkReflect::Var hkReflect::Call::withArgsRaw( hkArrayView<void> buffer ) const
{
    if ( m_callable->getNumParams() )
    {
        Detail::checkCallableBuffer( buffer, m_callable->getParamBufSize(), m_callable->getParamBufAlignment() );
    }

    return call( buffer.begin() );
}

HK_INLINE hkReflect::Var hkReflect::Call::call( void* argsBuf ) const
{
    bool returnsVoid = m_callable->getReturnType()->asVoid();
    HK_ASSERT(0x14eaf953, returnsVoid || m_returnBuf, "Method returns a value, you need to use into()" );

    if ( m_callable->getObjectType() )
    {
        HK_ASSERT(0x56f98e01, m_obj, "Method is non-static, you need to call onObj()" );
        m_callable->callMethod( m_obj, argsBuf, m_returnBuf );
    }
    else
    {
        m_callable->callFunction( argsBuf, m_returnBuf );
    }

    return hkReflect::Var( m_returnBuf, returnsVoid ? HK_NULL : m_callable->getReturnType() );
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
