// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include<Common/Base/hkBase.h>
#include<Common/Base/Reflect/Core/hkReflectCallable.h>
#include <Common/Base/Reflect/Core/Detail/hkReflectTypeDetail.h>
#include <Common/Base/Reflect/Core/Detail/hkCallableDetail.h>

bool hkReflect::CallableIterator::nextArray()
{
    // goes to the next callable type
    if (m_currentCallableType == 0)
    {
        // first iteration
        m_currentCallableType = CALLABLE_METHODS;
    }
    else
    {
        m_currentCallableType <<= 1;
    }

    while (true)
    {
        const hkReflect::Detail::Functions* fd = hkReflect::TypeDetail::getDeclaredFunctions(m_currentType);

        if (fd == HK_NULL || m_currentCallableType > CALLABLE_STATIC_FUNCTIONS)
        {
            
            if( m_currentType->isDecorator() )
            {
                // constructors must be searched only in the most derived type
                m_callableTypes.clear(CALLABLE_CONSTRUCTORS);
            }
            m_currentType = m_currentType->getParent();

            if (m_currentType == HK_NULL)
            {
                return false;
            }

            fd = hkReflect::TypeDetail::getDeclaredFunctions(m_currentType);
            m_currentCallableType = CALLABLE_METHODS;
        }
        else
        {
            // cast to the pod to read directly the Callable arrays
            const hkReflect::Detail::FunctionsPod* fpod = reinterpret_cast<const hkReflect::Detail::FunctionsPod*>(fd);

            // set the current array
            switch(m_currentCallableType)
            {
            case CALLABLE_METHODS:
                {
                    if (m_callableTypes.allAreSet(CALLABLE_METHODS) && fpod->m_numMethods)
                    {
                        m_currentArray = hkArrayView<const NamedCallable>(fpod->m_methodInfo->cast(), fpod->m_numMethods);
                        return true;
                    }
                    m_currentCallableType <<= 1;
                    // fall through
                }
            case CALLABLE_CONSTRUCTORS:
                {
                    if (m_callableTypes.allAreSet(CALLABLE_CONSTRUCTORS) && fpod->m_numConstructors)
                    {
                        m_currentArray = hkArrayView<const NamedCallable>(
                            fpod->m_methodInfo->cast() + fpod->m_numMethods, fpod->m_numConstructors);
                        return true;
                    }
                    m_currentCallableType <<= 1;
                    // fall through
                }
            case CALLABLE_STATIC_FUNCTIONS:
                {
                    if (m_callableTypes.allAreSet(CALLABLE_STATIC_FUNCTIONS) && fpod->m_numFunctions)
                    {
                        m_currentArray = hkArrayView<const NamedCallable>(
                            fpod->m_methodInfo->cast() + fpod->m_numMethods + fpod->m_numConstructors, fpod->m_numFunctions);
                        return true;
                    }
                    m_currentCallableType <<= 1;
                    break; // continue to the parent type
                }
            default:
                HK_ASSERT_NO_MSG(0x23c4a694,0);
            }
        }
    }
}

_Ret_z_ const char* hkReflect::Callable::getFullName(hkStringBuf& nameBuf) const
{
    if (m_objectType)
    {
        m_objectType->getFullName(nameBuf);
        nameBuf.append("@");
    }

    nameBuf.append(m_name);
    nameBuf.append("(");

    hkStringBuf paramBuf;
    for (int i = 0; i < m_paramInfo->m_numParams; ++i)
    {
        const Detail::CallableSignature::Param& param = m_paramInfo->getParam(i);
        nameBuf.append(param.m_type->getFullName(paramBuf));
        nameBuf.append(i == m_paramInfo->m_numParams - 1 ? ")" : ",");
    }
    nameBuf.append("->");
    nameBuf.append(m_paramInfo->m_returnType->getFullName(paramBuf));

    return nameBuf.cString();
}

struct hkReflect::Detail::StringOut::StringOutImpl : public hkReflect::Detail::StringImpl
{
    StringOutImpl() { /* keep clang happy */ }

    virtual hkResult setValue(_Inout_ void* addr, _In_ const hkReflect::StringType* type, hkReflect::StringValue newValue) const HK_OVERRIDE
    {
        HK_ASSERT_NO_MSG(0x40e1bf84, 0);
        return HK_FAILURE;
    }

    virtual hkResult getValue(_In_ const void* addr, _In_ const hkReflect::StringType* type, _Out_ hkReflect::StringValue* val) const HK_OVERRIDE
    {
        *val = reinterpret_cast<const StringOut*>(addr)->m_string;
        return HK_SUCCESS;
    }
};

const hkReflect::Detail::StringOut::StringOutImpl hkReflect::Detail::StringOut::s_impl;

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
