// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

HK_INLINE void hkReflect::Detail::InheritanceInfo::set(int pre, int right)
{
    HK_ASSERT_NO_MSG(0x43646a1d, pre >= 0 && pre <= 0xffff);
    HK_ASSERT_NO_MSG(0x5ddd923a, right >= 0 && right <= 0xffff);
    m_data = static_cast<unsigned>((pre << 16) | (right & 0xffff));
}

template<hkReflect::Optional OPT>
HK_INLINE typename hkReflect::Detail::OptionStorage<OPT>::Storage hkReflect::TypeDetail::decoratorGetOptional(_In_ const hkReflect::Type* t)
{
    typedef typename Detail::OptionStorage<OPT>::Storage RetType;
    return t->valueDecorator<RetType>(OPT);
}

template<hkReflect::Optional OPT>
HK_INLINE typename hkReflect::Detail::OptionStorage<OPT>::Storage hkReflect::TypeDetail::globalGetOptional(_In_ const hkReflect::Type* t)
{
    typedef typename Detail::OptionStorage<OPT>::Storage RetType;
    return t->valueGlobal<RetType>(OPT);
}

template<hkReflect::Optional OPT>
HK_INLINE typename hkReflect::Detail::OptionStorage<OPT>::Storage hkReflect::TypeDetail::localGetOptional(_In_ const hkReflect::Type* t)
{
    typedef typename Detail::OptionStorage<OPT>::Storage RetType;
    return t->valueLocal<RetType>(OPT);
}

HK_INLINE void hkReflect::TypeDetail::localCopyOptional(_In_ hkReflect::Type* dst, _In_ const hkReflect::Type* src, hkReflect::Optional opt)
{
    localSetOptionalUlong(dst, opt, localGetOptionalUlong(src, opt));
}


template<hkReflect::Optional OPT>
HK_INLINE _Ret_maybenull_ typename hkReflect::Detail::OptionStorage<OPT>::Storage* hkReflect::TypeDetail::decoratorAddressOptional(_In_ const hkReflect::Type* t)
{
    typedef typename Detail::OptionStorage<OPT>::Storage RetType;
    return (RetType*)t->addressDecorator(OPT);
}

template<hkReflect::Optional OPT>
HK_INLINE _Ret_maybenull_ typename hkReflect::Detail::OptionStorage<OPT>::Storage* hkReflect::TypeDetail::localAddressOptional(_In_ const hkReflect::Type* t)
{
    typedef typename Detail::OptionStorage<OPT>::Storage RetType;
    return (RetType*)t->addressLocal(OPT);
}

HK_INLINE bool hkReflect::TypeDetail::globalHasOptional(_In_ const hkReflect::Type* t, hkReflect::Optional opt)
{
    return t->addressGlobal(opt) != HK_NULL;
}
HK_INLINE bool hkReflect::TypeDetail::localHasOptional(_In_ const hkReflect::Type* t, hkReflect::Optional opt)
{
    return t->hasLocal(opt) != 0;
}

template<typename T>
HK_INLINE _Ret_maybenull_ const T* hkReflect::TypeDetail::localFindAttribute(_In_ const hkReflect::Type* t)
{
    return static_cast<const T*>(localFindAttribute(t, hkReflect::getType<T>()).getAddress());
}

template<typename T>
HK_INLINE _Ret_maybenull_ const T* hkReflect::TypeDetail::decoratorFindAttribute(_In_ const hkReflect::Type* t)
{
    return static_cast<const T*>(decoratorFindAttribute(t, hkReflect::getType<T>()).getAddress());
}

HK_INLINE hkUlong hkReflect::TypeDetail::localGetOptionalMask(_In_ const hkReflect::Type* t)
{
    return t->m_optional;
}
HK_INLINE hkUlong hkReflect::TypeDetail::localGetOptionalUlong(_In_ const hkReflect::Type* t, hkReflect::Optional opt)
{
    return t->valueLocal(opt);
}

HK_INLINE hkUlong* hkReflect::TypeDetail::localAddressOptionalUlong(_In_ const hkReflect::Type* t, hkReflect::Optional opt)
{
    return t->addressLocal(opt);
}

HK_INLINE void hkReflect::TypeDetail::localSetOptionalUlong(_Inout_ hkReflect::Type* t, hkReflect::Optional opt, hkUlong value)
{
    *t->accessLocal(opt) = value;
}

template<hkReflect::Optional OPT>
HK_INLINE void hkReflect::TypeDetail::localSetOptional(_Inout_ hkReflect::Type* t, typename Detail::OptionStorage<OPT>::Storage value)
{
    localSetOptionalUlong(t, OPT, (hkUlong)value);
}

HK_INLINE void hkReflect::TypeDetail::localSetSizeAlign(_Inout_ hkReflect::Type* t, int size, int align, hkReflect::Detail::AlignReq req)
{
    Detail::SizeAlign sa(size, align, req);
    localSetOptionalUlong(t, Opt::SIZE_ALIGN, sa.asUlong());
}

HK_INLINE void hkReflect::TypeDetail::localSetSizeAlign(_Inout_ hkReflect::Type* t, int size, int align)
{
    localSetSizeAlign(t, size, align, Detail::ALIGN_REQ_NATURAL);
}

HK_INLINE void hkReflect::TypeDetail::setParent(_Inout_ hkReflect::Type* t, _In_ const hkReflect::Type* p)
{
    t->m_parent = p;
}

HK_INLINE void hkReflect::TypeDetail::setOptMask(_Inout_ hkReflect::Type* t, hkUlong m)
{
    t->m_optional = m;
}
HK_INLINE hkUlong hkReflect::TypeDetail::getOptMask(_In_ const hkReflect::Type* t)
{
    return t->m_optional;
}

HK_INLINE _Ret_maybenull_ hkReflect::Type** hkReflect::TypeDetail::addressParent(_In_ hkReflect::Type* t)
{
    return const_cast<hkReflect::Type**>(&t->m_parent);
}

HK_INLINE const hkReflect::Detail::DeclsArray* hkReflect::TypeDetail::getDeclsArray(_In_ const hkReflect::Type* t)
{
    return globalGetOptional<Opt::DECLS>(t);
}

HK_INLINE void hkReflect::TypeDetail::setFieldName( hkReflect::FieldDecl field, _In_z_ const char* name)
{
    hkReflect::Type* ft = const_cast<hkReflect::Type*>(field.getType().get());
    localSetOptional<Opt::DECL_NAME>( ft, name );
}
HK_INLINE void hkReflect::TypeDetail::setFieldOffset( hkReflect::DataFieldDecl field, int offset)
{
    Detail::FieldDeclFormat ff( offset, field.getFlags().get() );
    hkReflect::Type* ft = const_cast<hkReflect::Type*>(field.getType().get());
    localSetOptional<Opt::DECL_FORMAT>( ft, ff );
}

HK_INLINE hkReflect::Var hkReflect::TypeDetail::allocateForClone(const Var& src)
{
    return allocateForClone(src, src.getType());
}

HK_INLINE hkReflect::Type::Flags hkReflect::TypeDetail::getFlags(_In_ const Type* type)
{
    return type->getTypeFlags();
}


template<typename T>
HK_INLINE hkResult hkReflect::Detail::initializeVtables(_Inout_updates_(_Inexpressible_(size)) void* addr)
{
    return initializeVtables(addr, getType<T>());
}

template<typename T>
HK_INLINE unsigned long hkReflect::Detail::getTypeID(_In_ const T* obj)
{
    return *reinterpret_cast<const unsigned long*>(obj); 
}

HK_EXPORT_COMMON HK_INLINE unsigned long HK_CALL hkReflect::Detail::getTypeID(_In_ const void* obj)
{
    return *reinterpret_cast<const unsigned long*>(obj); 
}

/// Extracts a type id (vtable pointer, hash_code() from rtti, ...) which has to be unique per type
/// from the given Type.
template<typename T>
HK_INLINE unsigned long hkReflect::Detail::getTypeID()
{
    unsigned char buf[sizeof(T)] = { 0 };
    new (buf)T();
    return getTypeID(reinterpret_cast<const T*>(buf));
}

template<typename T, typename U>
HK_INLINE bool hkReflect::Detail::hasSameTypeID(_In_ const U* u)
{
    return getTypeID<T>() == getTypeID(u);
}

template <typename T>
HK_ALWAYS_INLINE hkReflect::QualType hkReflect::Detail::getCallableParamType()
{
    return hkReflect::getType<typename hkReflect::Detail::RefToPtr<T>::Type>();
}

namespace hkReflect
{
    
    template<hkReflect::Optional OPT>
    HK_INLINE bool TypeDetail::isTrivialMethod(typename Detail::OptionStorage<OPT>::Storage func)
    {
        return func == &Detail::Trivial<OPT>::func;
    }

    template<>
    HK_INLINE bool TypeDetail::isTrivialMethod<hkReflect::Opt::DESTRUCTOR>(hkReflect::Detail::UnaryFunction func)
    {
        return func == HK_NULL;
    }

    template<hkReflect::Optional OPT>
    bool TypeDetail::hasTrivialMethod(_In_ const hkReflect::Type* type )
    {
        return isTrivialMethod<OPT>( decoratorGetOptional<OPT>( type ) );
    }

    
    template<hkReflect::Optional OPT>
    HK_INLINE bool TypeDetail::isImplicitMethod( typename Detail::OptionStorage<OPT>::Storage func )
    {
        return func == &Detail::Implicit<OPT>::func;
    }

    template<hkReflect::Optional OPT>
    bool TypeDetail::hasImplicitMethod(_In_ const hkReflect::Type* type )
    {
        return isImplicitMethod<OPT>( decoratorGetOptional<OPT>( type ) );
    }

    template<hkReflect::Optional OPT>
    HK_INLINE bool TypeDetail::isDeletedMethod( typename Detail::OptionStorage<OPT>::Storage func )
    {
        return func == HK_NULL;
    }

    
    template<>
    HK_INLINE bool TypeDetail::isDeletedMethod<hkReflect::Opt::DESTRUCTOR>( hkReflect::Detail::UnaryFunction func )
    {
        return func == &hkReflect::Detail::assertOnInvalidDestruction;
    }

    template<hkReflect::Optional OPT>
    bool TypeDetail::hasDeletedMethod(_In_ const hkReflect::Type* type )
    {
        return isDeletedMethod<OPT>( decoratorGetOptional<OPT>( type ) );
    }


}

inline bool hkReflect::Detail::isOpaqueWrapper(_In_ const hkReflect::Type* type)
{
    
    return type->asOpaque() && !type->isSerializable();
}

inline bool hkReflect::TypeDetail::isNative(_In_ const hkReflect::Type* type )
{
    return type && type->getTypeWorld() == HK_NULL;
}

inline bool hkReflect::Detail::isTypeOfType(_In_ const hkReflect::Type* type )
{
    return TypeDetail::isNative( type ) && type->extendsOrEquals<Type>();
}

inline _Ret_maybenull_ const hkReflect::Type* hkReflect::Detail::asType( _In_ const hkReflect::Var& var )
{
    if ( TypeDetail::isNative( var.getType() ) )
    {
        return var.dynCast<Type>();
    }
    return HK_NULL;
}

inline bool hkReflect::Detail::isPointerTo(_In_ const hkReflect::Type* type, _In_ const hkReflect::Type* ptd)
{
    if (auto ptr = type->asPointer())
    {
        return ptr->getSubType().isNull() || hkReflect::Detail::canSetPtr(ptr->getSubType(), ptd);
    }
    return false;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
