// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

namespace hkReflect
{
    class Any;

    namespace Detail
    {
        struct HK_EXPORT_COMMON DeclFormat
        {
        public:
            DeclFormat(hkUlong u) : m_data(u) { }
        protected:
            hkUlong m_data; // low16 bits=offset, high16=flags (Decl.DeclFlagBits)
        };

        struct HK_EXPORT_COMMON FieldDeclFormat : public DeclFormat
        {
            FieldDeclFormat(hkUlong val=0) : DeclFormat(val) {}

            FieldDeclFormat(int offset, int flags)
                : DeclFormat( (hkUlong(hkLosslessCast<hkUint16>(flags))<<16) | hkLosslessCast<hkUint16>(offset) )
            {}

            operator hkUlong() const { return m_data; }

            hkUint16 getOffset() const { return m_data & 0xffff; }
            hkUint16 getFlags() const { return hkUint32(m_data)>>16; }
        };

            // This class combines sizeof, alignof and any extra alignment request (HK_ALIGN)
            // Be careful not to use this as a field in a type!
            // The encoding as hkUlong is well specified (see HK_REFLECT_TYPE_OPTIONAL_SIZE_ALIGN).
            // However the bitfield layout is compiler dependent. Reinterpreting between SizeAlign
            // and hkUlong won't work in general, one has to use the constructor & asUlong().
        class HK_EXPORT_COMMON SizeAlign
        {
        public:
            HK_DECLARE_CLASS(SizeAlign, New, ReflectIdentity);

            static void HK_CALL toString(const hkReflect::Var& var, hkStringBuf& sb, const hkStringView& extra);
            HK_RECORD_ATTR(hk::ToString(&hkReflect::Detail::SizeAlign::toString));

            SizeAlign() { hkMemUtil::memZeroOne(this); }
            inline SizeAlign(hkUlong d)
            {
                hkMemUtil::memZeroOne(this);
                m_sizeOf = d & 0xffff;
                m_alignOf = (d >> 16) & 0xfff;
                m_reqAlignEncoded = (d >> 28) & 0xf;
            }
            SizeAlign(int s, int a, Detail::AlignReq r=Detail::ALIGN_REQ_NATURAL) { set(s, a, r); }
            inline void set(int size, int align, Detail::AlignReq req=Detail::ALIGN_REQ_NATURAL)
            {
                hkMemUtil::memZeroOne(this);
                m_sizeOf = size;
                m_alignOf = align;
                m_reqAlignEncoded = req;
            }

                /// Get the requested alignment if sizeof(hkQuadReal) was as specified.
            int retargetAlignment(int sizeofReal) const;

                /// Pack values into an hkUlong
            inline hkUlong asUlong() const
            {
                return HK_REFLECT_TYPE_OPTIONAL_SIZE_ALIGN(m_sizeOf, m_alignOf, m_reqAlignEncoded);
            }
            static hkUlong reqAlignOnly(hkUlong u)
            {
                SizeAlign sa(u);
                sa.m_sizeOf = 0;
                sa.m_alignOf = 0;
                return sa.asUlong();
            }

                /// Size in bytes
            hkUlong m_sizeOf : 16; //
                /// Alignment in bytes
            hkUlong m_alignOf : 12;
                /// Log2 of explicitly requested alignment. 0 for no request, 0xf for alignof(hkQuadReal)
            hkUlong m_reqAlignEncoded : 4;
        };

        /// Information for the isA
        class HK_EXPORT_COMMON InheritanceInfo
        {
        public:

            HK_DECLARE_CLASS(InheritanceInfo, New);

            InheritanceInfo() : m_data(0) { }
            InheritanceInfo(int preOrder, int rightMost) { set(preOrder, rightMost); }

            int getPreOrder() const { return static_cast<int>(m_data >> 16); }
            int getRightMost() const { return m_data & 0xffff; }
            bool equals(const InheritanceInfo& i) const { return m_data == i.m_data; }

            hkUlong asUlong() const { return m_data; }

            HK_INLINE void set(int pre, int right);

            operator hkBoolOperator::BoolType() const { return hkBoolOperator::cast(m_data != 0); }

        private:

            hkUlong m_data; //32 bits used - preOrder=16 upper, rightMost=16 lower
        };

        /// Holds the information about a record's functions, methods and constructors.
        class HK_EXPORT_COMMON Functions
        {
        public:
            HK_DECLARE_CLASS(Functions, New);

            Functions() {}

            int getNumMethods() const { return m_numMethods; }
            _Ret_notnull_ const Callable* getUnboundMethod(int i) const;

            int getNumConstructors() const { return m_numConstructors; }
            _Ret_notnull_ const Callable* getConstructor(int i) const;

            int getNumFunctions() const { return m_numFunctions; }
            _Ret_notnull_ const Callable* getFunction(int i) const;

        private:

            const Callable* m_callableInfo;
            hkUint16 m_numMethods;
            hkUint16 m_numConstructors;
            hkUint16 m_numFunctions;
        };
    }

        // This gives access to the type internals without making everything friend of Type directly.
    struct HK_EXPORT_COMMON TypeDetail
    {
        // get optionals
        template<Optional OPT> static HK_INLINE typename Detail::OptionStorage<OPT>::Storage decoratorGetOptional(_In_ const Type* t);
        template<Optional OPT> static HK_INLINE typename Detail::OptionStorage<OPT>::Storage globalGetOptional(_In_ const Type* t);
        template<Optional OPT> static HK_INLINE typename Detail::OptionStorage<OPT>::Storage localGetOptional(_In_ const Type* t);
        // address for writing
        template<Optional OPT> static HK_INLINE _Ret_maybenull_ typename Detail::OptionStorage<OPT>::Storage* decoratorAddressOptional(_In_ const Type* t);
        template<Optional OPT> static HK_INLINE _Ret_maybenull_ typename Detail::OptionStorage<OPT>::Storage* localAddressOptional(_In_ const Type* t);
        //
        static HK_INLINE bool globalHasOptional(_In_ const Type* t, Optional opt);
        static HK_INLINE bool localHasOptional(_In_ const Type* t, Optional opt);

        // attributes
        static hkReflect::Var localFindAttribute(_In_ const Type* t, _In_ const Type* attributeType);
        template<typename T> static HK_INLINE _Ret_maybenull_ const T* localFindAttribute(_In_ const Type* t);
        static hkReflect::Var decoratorFindAttribute(_In_ const Type* t, _In_ const Type* attributeType);
        template<typename T> static HK_INLINE const T* decoratorFindAttribute(_In_ const Type* t);
        static _Ret_opt_z_ const char* getAttributeString(_In_ const Type* t);

        // low level opt access
        static HK_INLINE hkUlong localGetOptionalMask(_In_ const Type* t);
        static HK_INLINE void localCopyOptional(_In_ Type* dst, _In_ const Type* src, Optional opt);
        static HK_INLINE hkUlong localGetOptionalUlong(_In_ const Type* t, Optional opt);
        static HK_INLINE hkUlong* localAddressOptionalUlong(_In_ const Type* t, Optional opt);
        static HK_INLINE void localSetOptionalUlong(_Inout_ Type* t, Optional opt, hkUlong value);
        template<Optional OPT> static HK_INLINE void localSetOptional(_Inout_ Type* t, typename Detail::OptionStorage<OPT>::Storage value);
        /// Set size and align with NATURAL requested alignment
        static HK_INLINE void localSetSizeAlign(_Inout_ Type* t, int size, int align);
        /// Set size and align with requested alignment
        static HK_INLINE void localSetSizeAlign(_Inout_ Type* t, int size, int align, Detail::AlignReq req);
        /// Set size and align PRESERVING any existing extra alignment request
        static void localSetSizeAlignPreserveReq(_Inout_ Type* t, int size, int align);

        static HK_INLINE void setParent(_Inout_ Type* t, _In_ const Type* p);

        static HK_INLINE void setOptMask(_Inout_ Type* t, hkUlong m);
        static HK_INLINE hkUlong getOptMask(_In_ const Type* t);

        static HK_INLINE _Ret_maybenull_ Type** addressParent(_In_ Type* t);

        static HK_INLINE const Detail::DeclsArray* getDeclsArray(_In_ const Type* t);

        static HK_INLINE void setFieldName( hkReflect::FieldDecl field, _In_z_ const char* name);
        static HK_INLINE void setFieldOffset(hkReflect::DataFieldDecl field, int offset);
        static void setFieldType(_Inout_ Type* rec, _In_z_ const char* name, _In_ const Type* type);

        static hkReflect::Var allocate(_In_ const hkReflect::Type* type);
        static hkReflect::Var allocateForClone(const Var& src, _In_ const hkReflect::Type* dstType);
        static HK_INLINE hkReflect::Var allocateForClone(const Var& src);
        static void deallocate(_Inout_ void* target, _In_ const hkReflect::Type* type);
        static bool isInPlaceConstructible(_In_ const hkReflect::Type* type);

        static Detail::UnaryFunction getDefaultConstructionFunction(_In_ const hkReflect::Type* type);
        static Detail::BinaryFunction getCopyConstructionFunction(_In_ const hkReflect::Type* type);
        static Detail::BinaryFunction getCopyAssignmentFunction(_In_ const hkReflect::Type* type);
        static Detail::UnaryFunction getDestructionFunction(_In_ const hkReflect::Type* type);
        static Detail::UnaryFunction getReflectConstructionFunction(_In_ const hkReflect::Type* type);
        static Detail::AfterReflectNewFunction getAfterReflectNewFunction(_In_ const hkReflect::Type* type);

        template<hkReflect::Optional OPT> static bool isTrivialMethod( typename Detail::OptionStorage<OPT>::Storage func );
        template<hkReflect::Optional OPT> static bool hasTrivialMethod(_In_ const hkReflect::Type* type);
        template<hkReflect::Optional OPT> static bool isImplicitMethod( typename Detail::OptionStorage<OPT>::Storage func );
        template<hkReflect::Optional OPT> static bool hasImplicitMethod(_In_ const hkReflect::Type* type );
        template<hkReflect::Optional OPT> static bool isDeletedMethod( typename Detail::OptionStorage<OPT>::Storage func );
        template<hkReflect::Optional OPT> static bool hasDeletedMethod(_In_ const hkReflect::Type* type );

        static hkResult defaultConstruct(_Inout_updates_bytes_(_Inexpressible_(count * size)) void* addr, _In_ const hkReflect::Type* type, int num = 1);
        static hkResult copyConstruct(_Inout_updates_bytes_(_Inexpressible_(count * size))  void* tgt, _In_reads_bytes_(_Inexpressible_(count * size)) const void* src, _In_ const hkReflect::Type* type, int num = 1);
        static hkResult reflectConstruct(_Inout_updates_bytes_(_Inexpressible_(count * size))  void* addr, _In_ const hkReflect::Type* type, int num = 1);
        static hkResult copyAssign(_Inout_updates_bytes_(_Inexpressible_(count * size))  void* tgt, _In_reads_bytes_(_Inexpressible_(count * size))  const void* src, _In_ const hkReflect::Type* type, int num = 1);
        static void destruct(_Inout_updates_bytes_(_Inexpressible_(count * size))  void* addr, _In_ const hkReflect::Type* type, int num = 1);

        static void fixupUnknownSpecialMethods(_Inout_ hkReflect::Type* type, bool fixupDtor = false);

        static _Ret_maybenull_ const hkReflect::Detail::PointerImpl* getPointerImpl(_In_ const hkReflect::Type* type);
        static _Ret_maybenull_ const hkReflect::Detail::InheritanceInfo* getInheritance(_In_ const hkReflect::Type*);
        static _Ret_maybenull_ const hkReflect::Detail::Functions* getDeclaredFunctions(_In_ const hkReflect::Type*);

        static HK_INLINE Type::Flags getFlags(_In_ const Type* type);

        static _Ret_maybenull_ const Type* skipDecorators(_In_ const Type* type);
        static hkArrayView<const hkReflect::FieldDecl> localGetDataFields(_In_ const hkReflect::Type* type);
        static hkArrayView<const hkReflect::FieldDecl> localGetFields(_In_ const hkReflect::Type* type);

        static bool isNative(_In_ const Type* type);

        /// Returns the equivalent type with all typedefs removed from the type itself and its template arguments if any.
        static _Ret_notnull_ const hkReflect::Type* getUndecorated(_In_ const Type* type);

    };

    namespace Detail
    {
        struct DerivedDataCache;

        struct LockedDerivedDataCache
        {
            LockedDerivedDataCache();
            ~LockedDerivedDataCache();

        protected:
            DerivedDataCache& m_cache;

            struct PreCalcII
            {
                enum Status { UNINITIALIZED = -2, EMPTY = -1 };
                PreCalcII(int i, int s) : m_idx(i), m_stride(s) {}
                bool isInitialized() const { return m_idx > UNINITIALIZED; }
                bool hasSome() const { HK_ASSERT_NO_MSG(0x751046f9, isInitialized()); return m_idx > EMPTY; }
                int m_idx;
                int m_stride;
            };
        };

        struct VtableInitializer : private LockedDerivedDataCache
        {
            struct PreCalc : public LockedDerivedDataCache::PreCalcII
            {
                PreCalc(int i=UNINITIALIZED, int s=0) : PreCalcII(i,s) {}
            };

            PreCalc preCalc(_In_ const Type* t);
            hkResult init(const PreCalc& h, _Inout_updates_bytes_(_Inexpressible_(count * size)) void* addr, int count);
        };

        struct AfterInitializer : private LockedDerivedDataCache
        {
            struct PreCalc : public LockedDerivedDataCache::PreCalcII
            {
                PreCalc(int i = UNINITIALIZED, int s = 0) : PreCalcII(i, s) {}
            };
            PreCalc preCalc(_In_ const Type* t);
            hkResult init(const PreCalc& h, _Inout_updates_bytes_(_Inexpressible_(count * size)) void* addr, _In_ const Type* type, int count);
        };

        struct TypeHashCache : private LockedDerivedDataCache
        {
            hkUint32 calc(_In_ const Type* type);
            _Ret_maybenull_ const Type* findNative(_In_ const Type* type, hkUint32 hash);
        };

        struct PropertyHashCache : private LockedDerivedDataCache
        {
            hkUint32 calc( const Type* type );
        };

        void HK_CALL clearDerivedDataCache();

            /// Copy the vtables of an instance of "type" into the correct offsets from addr.
        HK_EXPORT_COMMON hkResult initializeVtables(_Inout_updates_(_Inexpressible_(count * size)) void* addr, _In_ const Type* type, int count = 1);

        template<typename T>
        HK_INLINE hkResult initializeVtables(_Inout_ void* addr);

            /// Recursively call afterReflectNew on the instance
        void callAfterReflectNew(_Inout_updates_(_Inexpressible_(count * size)) void* addr, _In_ const Type* type, int count = 1);
            /// Are there any callbacks (recursively) required for this type?
        bool hasAfterReflectNew(_In_ const Type* type);

            /// Extracts a type id (vtable pointer, hash_code() from RTTI, ...) which has to be unique per type
            /// from the given instance.
        template<typename T>
        HK_INLINE unsigned long getTypeID(_In_ const T* obj);

        HK_EXPORT_COMMON HK_INLINE unsigned long HK_CALL getTypeID(_In_ const void* obj);

            /// Extracts a type id (vtable pointer, hash_code() from rtti, ...) which has to be unique per type
            /// from the given Type.
        template<typename T>
        HK_INLINE unsigned long getTypeID();

        template<typename T, typename U>
        HK_INLINE bool hasSameTypeID(_In_ const U* u);

        /// Copy an object into a typed buffer. Try copy constructor first, otherwise use reflection-based cloning.
        /// Types must be equal and the target must not be a property.
        HK_EXPORT_COMMON hkResult copyObject(const hkReflect::Var& target, const hkReflect::Var& source);

            /// This function should be used on function parameter types instead of hkReflect::getType<T>().
            /// Reference types are not normally reflectable and calling hkReflect::getType<T&>() is forbidden. Reference types in
            /// function parameters are reflected as pointers instead. This function is equivalent to getType() but can be called
            /// with a reference template argument, and it will return the corresponding pointer type.
        template <typename T> HK_ALWAYS_INLINE QualType getCallableParamType();

            /// Detect if this type is an opaque wrapper for a tracker type (used in OpaqueType fields).
        bool isOpaqueWrapper(_In_ const hkReflect::Type* type );

            /// Equivalent to type->extendsOrEquals<hkReflect::Type>(), but will not assert if the type is not native.
        bool isTypeOfType(_In_ const Type* type );

            /// Equivalent to var.dynCast<hkReflect::Type>(), but will not assert if the type is not native.
        _Ret_maybenull_ const Type* asType(_In_ const Var& var);

            /// Lookup a builtin Type corresponding to the provided format.
        HK_EXPORT_COMMON _Ret_maybenull_ const Type* HK_CALL builtinFromFormat( Format::Value format );

            /// Returns true if type can point to a value of type ptd
        bool isPointerTo(_In_ const hkReflect::Type* type, _In_ const hkReflect::Type* ptd);

            /// Initialises the contents of dst with the value of src converted to the type of dst
            /// dst is a typed buffer, it should not contain a valid object (see hkReflect::Detail::copyObject)
        hkResult coerceArg(const hkReflect::Var& dst, const hkReflect::Var& src);

            /// Puts in dst a Var containing the value of src as a dstType
            /// If coercion is required, dst will use buf
        hkResult coerceArgIfNecessary(_In_ const hkReflect::Type* dstType, const hkReflect::Var& src, hkReflect::Var& dst, hkReflect::Any& buf);
    }
}

#include <Common/Base/Reflect/Core/Detail/hkReflectTypeDetail.inl>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
