// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/Reflect/Core/Detail/hkRecordPropertyDetail.h>


#if 0
static void s_deleteThisType(hkReflect::Type* type, hkMemoryAllocator* allocator, hkUlong data)
{
    const hkReflect::Detail::Impl* impl = type->getImpl();
    HK_ASSERT_NO_MSG(0xcc68cb0, hkUlong(impl) + sizeof(hkUlong) == hkUlong(type) );
    delete const_cast<hkReflect::Detail::Impl*>(impl);
}

hkReflect::Detail::RecordPropertyType::RecordPropertyType( const Type* innerType, const Impl* innerImpl )
    : m_impl(innerImpl)
{
    m_optional = Opt::IMPL | Opt::ATTRIBUTES | Opt::FLAGS;
    m_parent = innerType;

    m_attrStorage.m_head = 1;
    m_attrStorage.m_items[0].data = &m_deleter;
    m_attrStorage.m_items[0].type = hkReflect::getType<hk::DeleteTypeInfo>();

    m_deleter.m_func = s_deleteThisType;
    m_deleter.m_allocator = 0;
    m_deleter.m_data = 0;
}

namespace hkReflect { namespace Detail
{
    template<typename TYPE>
    struct ValueRecordPropertyImpl : public ImplFromType<TYPE>::Type
    {
        typedef typename ValueFromType<TYPE>::Type ValueType;

        ValueRecordPropertyImpl(const RecordType* outer, const TYPE* inner, int off)
            : m_type(inner, HK_NULL)
            , m_outerType(outer)
            , m_outerImpl(outer->getImpl())
            , m_innerImpl(inner->getImpl())
            , m_off(off)
        {
            m_type.setImpl(this);
        }

        virtual hkResult setValue(void* addr, ValueType val) const HK_OVERRIDE
        {
            // fetch the enclosing record
            RecordImpl::RecordBuffer inBuf;
            RecordVar obj = m_outerImpl->getValue( const_cast<void*>(addr), m_outerType, inBuf);
            void* field = hkAddByteOffset(obj.getAddress(), m_off);

            // set our field
            if(m_innerImpl->setValue(field, val))
            {
                // push out to enclosing property
                return m_outerImpl->setValue(addr, m_outerType, obj); 
            }
            return false;
        }
        virtual ValueType getValue(const void* addr) const HK_OVERRIDE
        {
            // fetch the enclosing record
            RecordImpl::RecordBuffer inBuf;
            RecordVar obj = m_outerImpl->getValue(const_cast<void*>(addr), m_outerType, inBuf);
            void* field = hkAddByteOffset(obj.getAddress(), m_off);

            // get our field
            return m_innerImpl->getValue(field);
        }

        RecordPropertyType* getType() { return &m_type; }

        RecordPropertyType m_type;
        const RecordType* m_outerType;
        const RecordImpl* m_outerImpl;
        const typename ImplFromType<TYPE>::Type* m_innerImpl;
        int m_off;
    };


    struct RecordRecordPropertyImpl : public RecordImpl
    {
        RecordRecordPropertyImpl(const RecordType* outer, const RecordType* inner, int off)
            : m_type(inner, HK_NULL)
            , m_outerType(outer)
            , m_outerImpl(outer->getImpl())
            , m_innerImpl(inner->getImpl())
            , m_off(off)
        {
            m_type.setImpl(this);
        }

        virtual hkResult setValue(void* addr, const RecordType* type, const RecordVar& other) const HK_OVERRIDE
        {
            const RecordType* innerType = static_cast<const RecordType*>(m_type.getParent());
            if( innerType->isProperty() )
            {
                // reserve space for the record which will bubble upwards
                RecordImpl::RecordBuffer inBuf;
                void* outer = inBuf.resize( m_outerType->getSizeOf() );
                // outer is uninitialized - we're assuming that inner is ok with that - perhaps default construct?

                // convert inner to outer
                if(m_innerImpl->setValue(outer, innerType, other))
                {
                    const RecordType* nonProperty = m_outerType->getParent()->asRecord();
                    HK_ASSERT_NO_MSG(0x11bc03e5, nonProperty->isProperty()==false);
                    // push to parent
                    return m_outerImpl->setValue(addr, m_outerType, hkReflect::RecordVar(outer, nonProperty)); 
                }
            }
            else
            {
                // awkward! we have something like Foo { int a; Bar { x,y} b; ... }; (Foo a property and Bar not)
                // the user has given us a Bar and we need to bubble up - do we fetch foo & copy constuct b?
                HK_ASSERT(0x1bf565f8,0,"Setting non-property record in a property record not yet supported");
            }
            return false;
        }

        virtual RecordVar getValue(void* addr, const RecordType* type, RecordImpl::RecordBuffer& buf) const HK_OVERRIDE
        {
            const RecordType* innerType = static_cast<const RecordType*>(m_type.getParent());
            if( innerType->isProperty() )
            {
                // fetch the enclosing record
                RecordImpl::RecordBuffer inBuf;
                Var rec = m_outerImpl->getValue(const_cast<void*>(addr), m_outerType, inBuf);
                void* field= hkAddByteOffset(rec.getAddress(), m_off);
                // convert to inner
                return m_innerImpl->getValue(field, &m_type, buf);
            }
            else
            {
                // we are not a property (though one of our parents is).
                // get the parent property and do ptr arithmetic on the buffer instead of dumb extra copies
                Var rec = m_outerImpl->getValue(const_cast<void*>(addr), m_outerType, buf);
                return Var(hkAddByteOffset(rec.getAddress(), m_off), innerType);
            }
        }

        virtual hkReflect::VarIter iterBegin(const void* comAddr, const hkReflect::CompoundType* comType) const HK_OVERRIDE
        {
            HK_ASSERT_NO_MSG(0x543a21e0,0); //fixme
            return hkReflect::VarIter();
        }

        virtual void iterNext(hkReflect::VarIter& prev) const HK_OVERRIDE
        {
            HK_ASSERT_NO_MSG(0x4049dd93,0); //fixme
            prev.setInvalid();
        }

        RecordPropertyType* getType() { return &m_type; }

        RecordPropertyType m_type;
        const RecordType* m_outerType;
        const RecordImpl* m_outerImpl;
        const RecordImpl* m_innerImpl;
        int m_off;
    };

    class StringRecordPropertyImpl : public hkReflect::Detail::StringImpl
    {
    public:
        typedef hkReflect::StringValue ValueType;

        StringRecordPropertyImpl(const RecordType* outer, const StringType* inner, int off)
            : m_type(inner, HK_NULL)
            , m_outerType(outer)
            , m_outerImpl(outer->getImpl())
            , m_innerImpl(inner->getImpl())
            , m_off(off)
        {
            m_type.setImpl(this);
        }

        virtual hkResult setValue(void* addr, const hkReflect::StringType* type, ValueType val) const HK_OVERRIDE
        {
            // fetch the enclosing record
            RecordImpl::RecordBuffer inBuf;
            RecordVar obj = m_outerImpl->getValue(const_cast<void*>(addr), m_outerType, inBuf);
            void* field = hkAddByteOffset(obj.getAddress(), m_off);

            // set our field
            if (m_innerImpl->setValue(field, type, val))
            {
                // push out to enclosing property
                return m_outerImpl->setValue(addr, m_outerType, obj); 
            }
            return false;
        }

        virtual ValueType getValue(const void* addr, const hkReflect::StringType* type) const HK_OVERRIDE
        {
            // fetch the enclosing record
            RecordImpl::RecordBuffer inBuf;
            RecordVar obj = m_outerImpl->getValue(const_cast<void*>(addr), m_outerType, inBuf);
            void* field = hkAddByteOffset(obj.getAddress(), m_off);

            // get our field
            return m_innerImpl->getValue(field, type);
        }

        RecordPropertyType* getType() { return &m_type; }

        RecordPropertyType m_type;
        const RecordType* m_outerType;
        const RecordImpl* m_outerImpl;
        const StringImpl* m_innerImpl;
        int m_off;
    };

    typedef ValueRecordPropertyImpl<BoolType> BoolRecordPropertyImpl;
    typedef ValueRecordPropertyImpl<IntType> IntRecordPropertyImpl;
    typedef ValueRecordPropertyImpl<FloatType> FloatRecordPropertyImpl;

    RecordPropertyType* RecordPropertyType::create( const hkReflect::RecordType* recType, hkReflect::FieldDecl field)
    {
        using namespace hkReflect;
        const Type* ftype = field.getType();

        switch( ftype->getKind() )
        {
            case KIND_BOOL:
            {
                return (new BoolRecordPropertyImpl(recType, static_cast<const BoolType*>(ftype), field.getOffset()))->getType();
            }
            case KIND_STRING:
            {
                return (new StringRecordPropertyImpl(recType, static_cast<const StringType*>(ftype), field.getOffset()))->getType();
            }
            case KIND_INT:
            {
                return (new IntRecordPropertyImpl(recType, static_cast<const IntType*>(ftype), field.getOffset()))->getType();
            }
            case KIND_FLOAT:
            {
                return (new FloatRecordPropertyImpl(recType, static_cast<const FloatType*>(ftype), field.getOffset()))->getType();
            }
            case KIND_RECORD:
            {
                return (new RecordRecordPropertyImpl(recType, static_cast<const RecordType*>(ftype), field.getOffset()))->getType();
            }
            //case KIND_POINTER, 
            //case KIND_ARRAY,
            //case KIND_CONTAINER,
            default:
                HK_ASSERT_NO_MSG(0x225ce803,0); //fixme
                return HK_NULL;
        }
    }

} }
#endif

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
