// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL !REFLECT
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/Base/Reflect/Core/hkReflectCallable.h>

namespace hkReflect
{
namespace Detail
{
    template<typename T> struct RawPointer;
    class MixinClass { };
    class MultipleInheritanceClass : public SingleInheritanceClass, public MixinClass { };
    typedef void (MultipleInheritanceClass::*MultipleInheritanceMethodPointer)();


    // The following templates are used by the reflection scripts, to maximize sharing of function
    // and method trampolines.
    template<typename T> struct RefToPtr { typedef T Type; };
    template<typename T> struct RefToPtr<T&> { typedef T* Type; };

    // The trampolines do not need to preserve distinctions between pointer
    // and reference types, so we "flattens" those types to void*.
    template<typename S> struct Flatten { typedef S T; };
    template<typename S> struct Flatten<S*> { typedef void* T; };
    template<typename S> struct Flatten<S&> { typedef void* T; };

    // We don't deal with references in the reflection system, only pointers, so references are represented in
    // the argBuffers as pointers. In function and method trampolines, the type argument is already flattened.
    // In constructor wrappers, it isn't and it simplifies the wrappers if the member types are not flattened.
    template<typename T> struct ArgBufferMember { typedef typename RefToPtr< typename hkTrait::RemoveConst<T>::type >::Type Type; };
    // The default is char to avoid imposing unnecessary alignment requirements on the ArgBuffer.
    template<> struct ArgBufferMember<void> { typedef char Type; };

    template<typename T0, typename T1 = void, typename T2 = void,
        typename T3 = void, typename T4 = void, typename T5 = void,
        typename T6 = void, typename T7 = void, typename T8 = void>
    struct CallableSignatureTraits
    {
        // The args buffer passed to callers has this shape.
        struct ArgBuffer
        {
            typename ArgBufferMember<T0>::Type m_0;
            typename ArgBufferMember<T1>::Type m_1;
            typename ArgBufferMember<T2>::Type m_2;
            typename ArgBufferMember<T3>::Type m_3;
            typename ArgBufferMember<T4>::Type m_4;
            typename ArgBufferMember<T5>::Type m_5;
            typename ArgBufferMember<T6>::Type m_6;
            typename ArgBufferMember<T7>::Type m_7;
            typename ArgBufferMember<T8>::Type m_8;
        };

        // Generic code which needs to fill out an ArgBuffer needs the offsets of its members.
        enum
        {
            OFFSET0 = HK_OFFSET_OF(ArgBuffer, m_0),
            OFFSET1 = HK_OFFSET_OF(ArgBuffer, m_1),
            OFFSET2 = HK_OFFSET_OF(ArgBuffer, m_2),
            OFFSET3 = HK_OFFSET_OF(ArgBuffer, m_3),
            OFFSET4 = HK_OFFSET_OF(ArgBuffer, m_4),
            OFFSET5 = HK_OFFSET_OF(ArgBuffer, m_5),
            OFFSET6 = HK_OFFSET_OF(ArgBuffer, m_6),
            OFFSET7 = HK_OFFSET_OF(ArgBuffer, m_7),
            OFFSET8 = HK_OFFSET_OF(ArgBuffer, m_8),
            ALIGN = HK_ALIGN_OF(ArgBuffer)
        };
    };

    // Reference parameters are reflected as pointers. In the method and function trampolines, the
    // corresponding function and method pointers have a type compatible with the reflection. However,
    // constructors are called directly by their wrappers, so we have to provide arguments which
    // match the parameter types. In particular, the native compiler will not let us provide a pointer
    // argument to a reference parameter. The ConstructorArg template handles this.

    // The unspecialized template does nothing. We can treat the argument as const&, because we know it's
    // not being provided to a non-const & parameter (since that case would be handled by the specialization below).
    template<typename A> struct ConstructorArg
    {
        static HK_INLINE const A& convert(const A& arg) { return arg; }
    };

    // The specialization for references adds a * to convert from the pointer in the buffer to a reference.
    template<typename A> struct ConstructorArg<A&>
    {
        static HK_INLINE A& convert(_In_ A* arg) { return *arg; }
    };

    // Default arg type for normal params is the same type.
    template<typename T>
    struct DefaultArg
    {
        typedef T Type;
        static HK_INLINE Type convert(const T& value) { return value; }
    };

    // Default arg type for references is pointer.
    template<typename T>
    struct DefaultArg<T&>
    {
        struct Type
        {
            Type(const T& param) : m_value(param), m_pointer(&m_value) {}
            Type(const Type& other) : m_value(other.m_value), m_pointer(&m_value) {}

            T* const* operator&() const { return &m_pointer; }

        private:

            Type& operator=(const Type&);

            T m_value;
            T* m_pointer;
        };
        static HK_INLINE Type convert(const T& value)
        {
            return value;
        }
    };


    //
    // Signatures
    //



    // This template is only used inside the getSignature templates.
    template<int N>
    struct CallableSignaturePod
    {
        hkUint8 m_numTypes;
        hkUint8 m_align;
        hkUint16 m_size;
        const hkReflect::Type* m_returnType;
        hkReflect::Detail::CallableSignature::Param m_paramTypes[N];
    };

    template<>
    struct CallableSignaturePod<0>
    {
        hkUint8 m_numTypes;
        hkUint8 m_align;
        hkUint16 m_size;
        const hkReflect::Type* m_returnType;
    };

    // getType<hkReferencedObject*> always returns a pointer type implementaiton that, when used to set a value, increments and decrements the reference count,
    // but we want to use a raw pointer type when working with function signatures to avoid unnecessary add/remove references.
    template <typename T, bool IS_REFCOUNTED> struct RawPointerSelector;

    template <typename T>
    struct RawPointerSelector < T, false >
    {
        typedef T* Type;
    };

    template <typename T>
    struct RawPointerSelector < T, true >
    {
        typedef RawPointer<T> Type;
    };

    template<typename RET>
    struct RawWhenPointer
    {
        typedef RET Type;
    };

    template<typename POINTED>
    struct RawWhenPointer<POINTED*>
    {
        typedef typename RawPointerSelector< POINTED, hkTrait::InheritsFrom<POINTED, hkReferencedObject>::result >::Type Type;
    };

    
    template<typename POINTED>
    struct RawWhenPointer<POINTED&>
    {
        typedef Reference<POINTED> Type;
    };

    // need to avoid returning a Pointer type for hkCString (const char*), and instead should return the its normal type
    template<>
    struct RawWhenPointer<const char*> { typedef const char* Type; };
    template<>
    struct RawWhenPointer<char*> { typedef char* Type; };

    // The templates below produce a hkReflect::Signature corresponding to their
    // C++ template arguments.

    //
    // Signature specializations - these should be autogenerated
    //

    template<typename RET, typename T0=void, typename T1=void, typename T2=void, typename T3=void, typename T4=void, typename T5=void, typename T6=void>
    struct FunctionSignatureOf
    {
        static const CallableSignaturePod<7> pass;
    };

    template<typename RET, typename T0, typename T1, typename T2, typename T3, typename T4, typename T5>
    struct FunctionSignatureOf<RET, T0, T1, T2, T3, T4, T5, void>
    {
        static const CallableSignaturePod<6> pass;
    };

    template<typename RET, typename T0, typename T1, typename T2, typename T3, typename T4>
    struct FunctionSignatureOf<RET, T0, T1, T2, T3, T4, void, void>
    {
        static const CallableSignaturePod<5> pass;
    };

    template<typename RET, typename T0, typename T1, typename T2, typename T3>
    struct FunctionSignatureOf<RET, T0, T1, T2, T3, void, void, void>
    {
        static const CallableSignaturePod<4> pass;
    };

    template<typename RET, typename T0, typename T1, typename T2>
    struct FunctionSignatureOf<RET, T0, T1, T2, void, void, void, void>
    {
        static const CallableSignaturePod<3> pass;
    };

    template<typename RET, typename T0, typename T1>
    struct FunctionSignatureOf<RET, T0, T1, void, void, void, void, void>
    {
        static const CallableSignaturePod<2> pass;
    };

    template<typename RET, typename T0>
    struct FunctionSignatureOf<RET, T0, void, void, void, void, void, void>
    {
        static const CallableSignaturePod<1> pass;
    };

    template<typename RET>
    struct FunctionSignatureOf<RET, void, void, void, void, void, void, void>
    {
        static const CallableSignaturePod<0> pass;
    };

    template<typename RET, typename T0, typename T1, typename T2, typename T3, typename T4, typename T5, typename T6>
    const CallableSignaturePod<7> FunctionSignatureOf<RET, T0, T1, T2, T3, T4, T5, T6>::pass =
    {
        7,
        CallableSignatureTraits<T0, T1, T2, T3, T4, T5, T6>::ALIGN,
        CallableSignatureTraits<T0, T1, T2, T3, T4, T5, T6>::OFFSET6 + sizeof(T6),
        HK_REFLECT_GET_TYPE(typename RawWhenPointer<RET>::Type),
        {
            { HK_REFLECT_GET_TYPE(typename RawWhenPointer<T0>::Type), CallableSignatureTraits<T0, T1, T2, T3, T4, T5, T6>::OFFSET0 },
            { HK_REFLECT_GET_TYPE(typename RawWhenPointer<T1>::Type), CallableSignatureTraits<T0, T1, T2, T3, T4, T5, T6>::OFFSET1 },
            { HK_REFLECT_GET_TYPE(typename RawWhenPointer<T2>::Type), CallableSignatureTraits<T0, T1, T2, T3, T4, T5, T6>::OFFSET2 },
            { HK_REFLECT_GET_TYPE(typename RawWhenPointer<T3>::Type), CallableSignatureTraits<T0, T1, T2, T3, T4, T5, T6>::OFFSET3 },
            { HK_REFLECT_GET_TYPE(typename RawWhenPointer<T4>::Type), CallableSignatureTraits<T0, T1, T2, T3, T4, T5, T6>::OFFSET4 },
            { HK_REFLECT_GET_TYPE(typename RawWhenPointer<T5>::Type), CallableSignatureTraits<T0, T1, T2, T3, T4, T5, T6>::OFFSET5 },
            { HK_REFLECT_GET_TYPE(typename RawWhenPointer<T6>::Type), CallableSignatureTraits<T0, T1, T2, T3, T4, T5, T6>::OFFSET6 },
        }
    };

    template<typename RET, typename T0, typename T1, typename T2, typename T3, typename T4, typename T5>
    const CallableSignaturePod<6> FunctionSignatureOf<RET, T0, T1, T2, T3, T4, T5>::pass =
    {
        6,
        CallableSignatureTraits<T0, T1, T2, T3, T4, T5>::ALIGN,
        CallableSignatureTraits<T0, T1, T2, T3, T4, T5>::OFFSET5 + sizeof(T5),
        HK_REFLECT_GET_TYPE( typename RawWhenPointer<RET>::Type ),
        {
            { HK_REFLECT_GET_TYPE( typename RawWhenPointer<T0>::Type ), CallableSignatureTraits<T0, T1, T2, T3, T4, T5>::OFFSET0 },
            { HK_REFLECT_GET_TYPE( typename RawWhenPointer<T1>::Type ), CallableSignatureTraits<T0, T1, T2, T3, T4, T5>::OFFSET1 },
            { HK_REFLECT_GET_TYPE( typename RawWhenPointer<T2>::Type ), CallableSignatureTraits<T0, T1, T2, T3, T4, T5>::OFFSET2 },
            { HK_REFLECT_GET_TYPE( typename RawWhenPointer<T3>::Type ), CallableSignatureTraits<T0, T1, T2, T3, T4, T5>::OFFSET3 },
            { HK_REFLECT_GET_TYPE( typename RawWhenPointer<T4>::Type ), CallableSignatureTraits<T0, T1, T2, T3, T4, T5>::OFFSET4 },
            { HK_REFLECT_GET_TYPE( typename RawWhenPointer<T5>::Type ), CallableSignatureTraits<T0, T1, T2, T3, T4, T5>::OFFSET5 },
        }
    };

    template<typename RET, typename T0, typename T1, typename T2, typename T3, typename T4>
    const CallableSignaturePod<5> FunctionSignatureOf<RET, T0, T1, T2, T3, T4>::pass =
    {
        5,
        CallableSignatureTraits<T0, T1, T2, T3, T4>::ALIGN,
        CallableSignatureTraits<T0, T1, T2, T3, T4>::OFFSET4 + sizeof(T4),
        HK_REFLECT_GET_TYPE( typename RawWhenPointer<RET>::Type ),
        {
            { HK_REFLECT_GET_TYPE( typename RawWhenPointer<T0>::Type ), CallableSignatureTraits<T0, T1, T2, T3, T4>::OFFSET0 },
            { HK_REFLECT_GET_TYPE( typename RawWhenPointer<T1>::Type ), CallableSignatureTraits<T0, T1, T2, T3, T4>::OFFSET1 },
            { HK_REFLECT_GET_TYPE( typename RawWhenPointer<T2>::Type ), CallableSignatureTraits<T0, T1, T2, T3, T4>::OFFSET2 },
            { HK_REFLECT_GET_TYPE( typename RawWhenPointer<T3>::Type ), CallableSignatureTraits<T0, T1, T2, T3, T4>::OFFSET3 },
            { HK_REFLECT_GET_TYPE( typename RawWhenPointer<T4>::Type ), CallableSignatureTraits<T0, T1, T2, T3, T4>::OFFSET4 },
        }
    };

    template<typename RET, typename T0, typename T1, typename T2, typename T3>
    const CallableSignaturePod<4> FunctionSignatureOf<RET, T0, T1, T2, T3>::pass =
    {
        4,
        CallableSignatureTraits<T0, T1, T2, T3>::ALIGN,
        CallableSignatureTraits<T0, T1, T2, T3>::OFFSET3 + sizeof(T3),
        HK_REFLECT_GET_TYPE( typename RawWhenPointer<RET>::Type ),
        {
            { HK_REFLECT_GET_TYPE( typename RawWhenPointer<T0>::Type ), CallableSignatureTraits<T0, T1, T2, T3>::OFFSET0 },
            { HK_REFLECT_GET_TYPE( typename RawWhenPointer<T1>::Type ), CallableSignatureTraits<T0, T1, T2, T3>::OFFSET1 },
            { HK_REFLECT_GET_TYPE( typename RawWhenPointer<T2>::Type ), CallableSignatureTraits<T0, T1, T2, T3>::OFFSET2 },
            { HK_REFLECT_GET_TYPE( typename RawWhenPointer<T3>::Type ), CallableSignatureTraits<T0, T1, T2, T3>::OFFSET3 },
        }
    };

    template<typename RET, typename T0, typename T1, typename T2>
    const CallableSignaturePod<3> FunctionSignatureOf<RET, T0, T1, T2>::pass =
    {
        3,
        CallableSignatureTraits<T0, T1, T2>::ALIGN,
        CallableSignatureTraits<T0, T1, T2>::OFFSET2 + sizeof(T2),
        HK_REFLECT_GET_TYPE( typename RawWhenPointer<RET>::Type ),
        {
            { HK_REFLECT_GET_TYPE( typename RawWhenPointer<T0>::Type ), CallableSignatureTraits<T0, T1, T2>::OFFSET0 },
            { HK_REFLECT_GET_TYPE( typename RawWhenPointer<T1>::Type ), CallableSignatureTraits<T0, T1, T2>::OFFSET1 },
            { HK_REFLECT_GET_TYPE( typename RawWhenPointer<T2>::Type ), CallableSignatureTraits<T0, T1, T2>::OFFSET2 },
        }
    };

    template<typename RET, typename T0, typename T1>
    const CallableSignaturePod<2> FunctionSignatureOf<RET, T0, T1>::pass =
    {
        2,
        CallableSignatureTraits<T0, T1>::ALIGN,
        CallableSignatureTraits<T0, T1>::OFFSET1 + sizeof(T1),
        HK_REFLECT_GET_TYPE( typename RawWhenPointer<RET>::Type ),
        {
            { HK_REFLECT_GET_TYPE( typename RawWhenPointer<T0>::Type ), CallableSignatureTraits<T0, T1>::OFFSET0 },
            { HK_REFLECT_GET_TYPE( typename RawWhenPointer<T1>::Type ), CallableSignatureTraits<T0, T1>::OFFSET1 },
        }
    };

    template<typename RET, typename T0>
    const CallableSignaturePod<1> FunctionSignatureOf<RET, T0>::pass =
    {
        1,
        HK_ALIGN_OF(T0),
        sizeof(T0),
        HK_REFLECT_GET_TYPE( typename RawWhenPointer<RET>::Type ),
        {
            { HK_REFLECT_GET_TYPE( typename RawWhenPointer<T0>::Type ), CallableSignatureTraits<T0>::OFFSET0 }
        }
    };

    template<typename RET>
    const CallableSignaturePod<0> FunctionSignatureOf<RET>::pass =
    {
        0,
        1,
        0,
        HK_REFLECT_GET_TYPE( typename RawWhenPointer<RET>::Type )
    };

    //
    // THE INVOKERS ARE AUTOGENERATED, DO NOT EDIT. See Tools/PreBuild/GenerateTrampolines.py
    //


    template<typename RET, typename T0 = void, typename T1 = void, typename T2 = void, typename T3 = void, typename T4 = void, typename T5 = void, typename T6 = void, typename T7 = void, typename T8 = void>
    struct FunctionInvoker
    {
        static void invoke(void* /*thisPtr*/, void* packedArgs, void* returnBuf, const void* invokerData)
        {
            typedef RET(*FuncType)(T0, T1, T2, T3, T4, T5, T6, T7, T8);
            FuncType func = (FuncType)invokerData;
            typedef typename CallableSignatureTraits<T0, T1, T2, T3, T4, T5, T6, T7, T8>::ArgBuffer ArgBuf;
            const ArgBuf* argBuf = reinterpret_cast<const ArgBuf*>(packedArgs);
            new (reinterpret_cast<hkPlacementNewArg*>(returnBuf)) RET
                ((*func)(argBuf->m_0, argBuf->m_1, argBuf->m_2, argBuf->m_3, argBuf->m_4, argBuf->m_5, argBuf->m_6, argBuf->m_7, argBuf->m_8));
        }
    };

    template<typename RET, typename T0, typename T1, typename T2, typename T3, typename T4, typename T5, typename T6, typename T7>
    struct FunctionInvoker<RET, T0, T1, T2, T3, T4, T5, T6, T7, void>
    {
        static void invoke(void* /*thisPtr*/, void* packedArgs, void* returnBuf, const void* invokerData)
        {
            typedef RET(*FuncType)(T0, T1, T2, T3, T4, T5, T6, T7);
            FuncType func = (FuncType)invokerData;
            typedef typename CallableSignatureTraits<T0, T1, T2, T3, T4, T5, T6, T7>::ArgBuffer ArgBuf;
            const ArgBuf* argBuf = reinterpret_cast<const ArgBuf*>(packedArgs);
            new (reinterpret_cast<hkPlacementNewArg*>(returnBuf)) RET
                ((*func)(argBuf->m_0, argBuf->m_1, argBuf->m_2, argBuf->m_3, argBuf->m_4, argBuf->m_5, argBuf->m_6, argBuf->m_7));
        }
    };

    template<typename RET, typename T0, typename T1, typename T2, typename T3, typename T4, typename T5, typename T6>
    struct FunctionInvoker<RET, T0, T1, T2, T3, T4, T5, T6, void, void>
    {
        static void invoke(void* /*thisPtr*/, void* packedArgs, void* returnBuf, const void* invokerData)
        {
            typedef RET(*FuncType)(T0, T1, T2, T3, T4, T5, T6);
            FuncType func = (FuncType)invokerData;
            typedef typename CallableSignatureTraits<T0, T1, T2, T3, T4, T5, T6>::ArgBuffer ArgBuf;
            const ArgBuf* argBuf = reinterpret_cast<const ArgBuf*>(packedArgs);
            new (reinterpret_cast<hkPlacementNewArg*>(returnBuf)) RET
                ((*func)(argBuf->m_0, argBuf->m_1, argBuf->m_2, argBuf->m_3, argBuf->m_4, argBuf->m_5, argBuf->m_6));
        }
    };

    template<typename RET, typename T0, typename T1, typename T2, typename T3, typename T4, typename T5>
    struct FunctionInvoker<RET, T0, T1, T2, T3, T4, T5, void, void, void>
    {
        static void invoke(void* /*thisPtr*/, void* packedArgs, void* returnBuf, const void* invokerData)
        {
            typedef RET(*FuncType)(T0, T1, T2, T3, T4, T5);
            FuncType func = (FuncType)invokerData;
            typedef typename CallableSignatureTraits<T0, T1, T2, T3, T4, T5>::ArgBuffer ArgBuf;
            const ArgBuf* argBuf = reinterpret_cast<const ArgBuf*>(packedArgs);
            new (reinterpret_cast<hkPlacementNewArg*>(returnBuf)) RET
                ((*func)(argBuf->m_0, argBuf->m_1, argBuf->m_2, argBuf->m_3, argBuf->m_4, argBuf->m_5));
        }
    };

    template<typename RET, typename T0, typename T1, typename T2, typename T3, typename T4>
    struct FunctionInvoker<RET, T0, T1, T2, T3, T4, void, void, void, void>
    {
        static void invoke(void* /*thisPtr*/, void* packedArgs, void* returnBuf, const void* invokerData)
        {
            typedef RET(*FuncType)(T0, T1, T2, T3, T4);
            FuncType func = (FuncType)invokerData;
            typedef typename CallableSignatureTraits<T0, T1, T2, T3, T4>::ArgBuffer ArgBuf;
            const ArgBuf* argBuf = reinterpret_cast<const ArgBuf*>(packedArgs);
            new (reinterpret_cast<hkPlacementNewArg*>(returnBuf)) RET
                ((*func)(argBuf->m_0, argBuf->m_1, argBuf->m_2, argBuf->m_3, argBuf->m_4));
        }
    };

    template<typename RET, typename T0, typename T1, typename T2, typename T3>
    struct FunctionInvoker<RET, T0, T1, T2, T3, void, void, void, void, void>
    {
        static void invoke(void* /*thisPtr*/, void* packedArgs, void* returnBuf, const void* invokerData)
        {
            typedef RET(*FuncType)(T0, T1, T2, T3);
            FuncType func = (FuncType)invokerData;
            typedef typename CallableSignatureTraits<T0, T1, T2, T3>::ArgBuffer ArgBuf;
            const ArgBuf* argBuf = reinterpret_cast<const ArgBuf*>(packedArgs);
            new (reinterpret_cast<hkPlacementNewArg*>(returnBuf)) RET
                ((*func)(argBuf->m_0, argBuf->m_1, argBuf->m_2, argBuf->m_3));
        }
    };

    template<typename RET, typename T0, typename T1, typename T2>
    struct FunctionInvoker<RET, T0, T1, T2, void, void, void, void, void, void>
    {
        static void invoke(void* /*thisPtr*/, void* packedArgs, void* returnBuf, const void* invokerData)
        {
            typedef RET(*FuncType)(T0, T1, T2);
            FuncType func = (FuncType)invokerData;
            typedef typename CallableSignatureTraits<T0, T1, T2>::ArgBuffer ArgBuf;
            const ArgBuf* argBuf = reinterpret_cast<const ArgBuf*>(packedArgs);
            new (reinterpret_cast<hkPlacementNewArg*>(returnBuf)) RET
                ((*func)(argBuf->m_0, argBuf->m_1, argBuf->m_2));
        }
    };

    template<typename RET, typename T0, typename T1>
    struct FunctionInvoker<RET, T0, T1, void, void, void, void, void, void, void>
    {
        static void invoke(void* /*thisPtr*/, void* packedArgs, void* returnBuf, const void* invokerData)
        {
            typedef RET(*FuncType)(T0, T1);
            FuncType func = (FuncType)invokerData;
            typedef typename CallableSignatureTraits<T0, T1>::ArgBuffer ArgBuf;
            const ArgBuf* argBuf = reinterpret_cast<const ArgBuf*>(packedArgs);
            new (reinterpret_cast<hkPlacementNewArg*>(returnBuf)) RET
                ((*func)(argBuf->m_0, argBuf->m_1));
        }
    };

    template<typename RET, typename T0>
    struct FunctionInvoker<RET, T0, void, void, void, void, void, void, void, void>
    {
        static void invoke(void* /*thisPtr*/, void* packedArgs, void* returnBuf, const void* invokerData)
        {
            typedef RET(*FuncType)(T0);
            FuncType func = (FuncType)invokerData;
            typedef typename CallableSignatureTraits<T0>::ArgBuffer ArgBuf;
            const ArgBuf* argBuf = reinterpret_cast<const ArgBuf*>(packedArgs);
            new (reinterpret_cast<hkPlacementNewArg*>(returnBuf)) RET
                ((*func)(argBuf->m_0));
        }
    };

    template<typename RET>
    struct FunctionInvoker<RET, void, void, void, void, void, void, void, void, void>
    {
        static void invoke(void* /*thisPtr*/, void* packedArgs, void* returnBuf, const void* invokerData)
        {
            typedef RET(*FuncType)();
            FuncType func = (FuncType)invokerData;
            // typedef typename CallableSignatureTraits<>::ArgBuffer ArgBuf;
            // const ArgBuf* argBuf = reinterpret_cast<const ArgBuf*>(packedArgs);
            new (reinterpret_cast<hkPlacementNewArg*>(returnBuf)) RET
                ((*func)());
        }
    };

    template<typename T0, typename T1, typename T2, typename T3, typename T4, typename T5, typename T6, typename T7, typename T8>
    struct FunctionInvoker<void, T0, T1, T2, T3, T4, T5, T6, T7, T8>
    {
        static void invoke(void* /*thisPtr*/, void* packedArgs, void* returnBuf, const void* invokerData)
        {
            typedef void(*FuncType)(T0, T1, T2, T3, T4, T5, T6, T7, T8);
            FuncType func = (FuncType)invokerData;
            typedef typename CallableSignatureTraits<T0, T1, T2, T3, T4, T5, T6, T7, T8>::ArgBuffer ArgBuf;
            const ArgBuf* argBuf = reinterpret_cast<const ArgBuf*>(packedArgs);

            ((*func)(argBuf->m_0, argBuf->m_1, argBuf->m_2, argBuf->m_3, argBuf->m_4, argBuf->m_5, argBuf->m_6, argBuf->m_7, argBuf->m_8));
        }
    };

    template<typename T0, typename T1, typename T2, typename T3, typename T4, typename T5, typename T6, typename T7>
    struct FunctionInvoker<void, T0, T1, T2, T3, T4, T5, T6, T7, void>
    {
        static void invoke(void* /*thisPtr*/, void* packedArgs, void* returnBuf, const void* invokerData)
        {
            typedef void(*FuncType)(T0, T1, T2, T3, T4, T5, T6, T7);
            FuncType func = (FuncType)invokerData;
            typedef typename CallableSignatureTraits<T0, T1, T2, T3, T4, T5, T6, T7>::ArgBuffer ArgBuf;
            const ArgBuf* argBuf = reinterpret_cast<const ArgBuf*>(packedArgs);

            ((*func)(argBuf->m_0, argBuf->m_1, argBuf->m_2, argBuf->m_3, argBuf->m_4, argBuf->m_5, argBuf->m_6, argBuf->m_7));
        }
    };

    template<typename T0, typename T1, typename T2, typename T3, typename T4, typename T5, typename T6>
    struct FunctionInvoker<void, T0, T1, T2, T3, T4, T5, T6, void, void>
    {
        static void invoke(void* /*thisPtr*/, void* packedArgs, void* returnBuf, const void* invokerData)
        {
            typedef void(*FuncType)(T0, T1, T2, T3, T4, T5, T6);
            FuncType func = (FuncType)invokerData;
            typedef typename CallableSignatureTraits<T0, T1, T2, T3, T4, T5, T6>::ArgBuffer ArgBuf;
            const ArgBuf* argBuf = reinterpret_cast<const ArgBuf*>(packedArgs);

            ((*func)(argBuf->m_0, argBuf->m_1, argBuf->m_2, argBuf->m_3, argBuf->m_4, argBuf->m_5, argBuf->m_6));
        }
    };

    template<typename T0, typename T1, typename T2, typename T3, typename T4, typename T5>
    struct FunctionInvoker<void, T0, T1, T2, T3, T4, T5, void, void, void>
    {
        static void invoke(void* /*thisPtr*/, void* packedArgs, void* returnBuf, const void* invokerData)
        {
            typedef void(*FuncType)(T0, T1, T2, T3, T4, T5);
            FuncType func = (FuncType)invokerData;
            typedef typename CallableSignatureTraits<T0, T1, T2, T3, T4, T5>::ArgBuffer ArgBuf;
            const ArgBuf* argBuf = reinterpret_cast<const ArgBuf*>(packedArgs);

            ((*func)(argBuf->m_0, argBuf->m_1, argBuf->m_2, argBuf->m_3, argBuf->m_4, argBuf->m_5));
        }
    };

    template<typename T0, typename T1, typename T2, typename T3, typename T4>
    struct FunctionInvoker<void, T0, T1, T2, T3, T4, void, void, void, void>
    {
        static void invoke(void* /*thisPtr*/, void* packedArgs, void* returnBuf, const void* invokerData)
        {
            typedef void(*FuncType)(T0, T1, T2, T3, T4);
            FuncType func = (FuncType)invokerData;
            typedef typename CallableSignatureTraits<T0, T1, T2, T3, T4>::ArgBuffer ArgBuf;
            const ArgBuf* argBuf = reinterpret_cast<const ArgBuf*>(packedArgs);

            ((*func)(argBuf->m_0, argBuf->m_1, argBuf->m_2, argBuf->m_3, argBuf->m_4));
        }
    };

    template<typename T0, typename T1, typename T2, typename T3>
    struct FunctionInvoker<void, T0, T1, T2, T3, void, void, void, void, void>
    {
        static void invoke(void* /*thisPtr*/, void* packedArgs, void* returnBuf, const void* invokerData)
        {
            typedef void(*FuncType)(T0, T1, T2, T3);
            FuncType func = (FuncType)invokerData;
            typedef typename CallableSignatureTraits<T0, T1, T2, T3>::ArgBuffer ArgBuf;
            const ArgBuf* argBuf = reinterpret_cast<const ArgBuf*>(packedArgs);

            ((*func)(argBuf->m_0, argBuf->m_1, argBuf->m_2, argBuf->m_3));
        }
    };

    template<typename T0, typename T1, typename T2>
    struct FunctionInvoker<void, T0, T1, T2, void, void, void, void, void, void>
    {
        static void invoke(void* /*thisPtr*/, void* packedArgs, void* returnBuf, const void* invokerData)
        {
            typedef void(*FuncType)(T0, T1, T2);
            FuncType func = (FuncType)invokerData;
            typedef typename CallableSignatureTraits<T0, T1, T2>::ArgBuffer ArgBuf;
            const ArgBuf* argBuf = reinterpret_cast<const ArgBuf*>(packedArgs);

            ((*func)(argBuf->m_0, argBuf->m_1, argBuf->m_2));
        }
    };

    template<typename T0, typename T1>
    struct FunctionInvoker<void, T0, T1, void, void, void, void, void, void, void>
    {
        static void invoke(void* /*thisPtr*/, void* packedArgs, void* returnBuf, const void* invokerData)
        {
            typedef void(*FuncType)(T0, T1);
            FuncType func = (FuncType)invokerData;
            typedef typename CallableSignatureTraits<T0, T1>::ArgBuffer ArgBuf;
            const ArgBuf* argBuf = reinterpret_cast<const ArgBuf*>(packedArgs);

            ((*func)(argBuf->m_0, argBuf->m_1));
        }
    };

    template<typename T0>
    struct FunctionInvoker<void, T0, void, void, void, void, void, void, void, void>
    {
        static void invoke(void* /*thisPtr*/, void* packedArgs, void* returnBuf, const void* invokerData)
        {
            typedef void(*FuncType)(T0);
            FuncType func = (FuncType)invokerData;
            typedef typename CallableSignatureTraits<T0>::ArgBuffer ArgBuf;
            const ArgBuf* argBuf = reinterpret_cast<const ArgBuf*>(packedArgs);

            ((*func)(argBuf->m_0));
        }
    };

    template<>
    struct FunctionInvoker<void, void, void, void, void, void, void, void, void, void>
    {
        static void invoke(void* /*thisPtr*/, void* packedArgs, void* returnBuf, const void* invokerData)
        {
            typedef void(*FuncType)();
            FuncType func = (FuncType)invokerData;
            // typedef typename CallableSignatureTraits<>::ArgBuffer ArgBuf;
            // const ArgBuf* argBuf = reinterpret_cast<const ArgBuf*>(packedArgs);

            ((*func)());
        }
    };

    template<typename RET, typename CLASS, typename T0 = void, typename T1 = void, typename T2 = void, typename T3 = void, typename T4 = void, typename T5 = void, typename T6 = void, typename T7 = void, typename T8 = void>
    struct MethodInvoker
    {
        static void invoke(void* thisPtr, void* packedArgs, void* returnBuf, const void* invokerData)
        {
            typedef RET(CLASS::*MethodPointer)(T0, T1, T2, T3, T4, T5, T6, T7, T8);
            MethodPointer methodPtr = *reinterpret_cast<const MethodPointer*>(invokerData);
            typedef typename CallableSignatureTraits<T0, T1, T2, T3, T4, T5, T6, T7, T8>::ArgBuffer ArgBuf;
            const ArgBuf* argBuf = reinterpret_cast<const ArgBuf*>(packedArgs);
            CLASS* self = static_cast<CLASS*>(thisPtr);
            new (reinterpret_cast<hkPlacementNewArg*>(returnBuf)) RET
                ((self->*methodPtr)(argBuf->m_0, argBuf->m_1, argBuf->m_2, argBuf->m_3, argBuf->m_4, argBuf->m_5, argBuf->m_6, argBuf->m_7, argBuf->m_8));
        }
    };

    template<typename RET, typename CLASS, typename T0, typename T1, typename T2, typename T3, typename T4, typename T5, typename T6, typename T7>
    struct MethodInvoker<RET, CLASS, T0, T1, T2, T3, T4, T5, T6, T7, void>
    {
        static void invoke(void* thisPtr, void* packedArgs, void* returnBuf, const void* invokerData)
        {
            typedef RET(CLASS::*MethodPointer)(T0, T1, T2, T3, T4, T5, T6, T7);
            MethodPointer methodPtr = *reinterpret_cast<const MethodPointer*>(invokerData);
            typedef typename CallableSignatureTraits<T0, T1, T2, T3, T4, T5, T6, T7>::ArgBuffer ArgBuf;
            const ArgBuf* argBuf = reinterpret_cast<const ArgBuf*>(packedArgs);
            CLASS* self = static_cast<CLASS*>(thisPtr);
            new (reinterpret_cast<hkPlacementNewArg*>(returnBuf)) RET
                ((self->*methodPtr)(argBuf->m_0, argBuf->m_1, argBuf->m_2, argBuf->m_3, argBuf->m_4, argBuf->m_5, argBuf->m_6, argBuf->m_7));
        }
    };

    template<typename RET, typename CLASS, typename T0, typename T1, typename T2, typename T3, typename T4, typename T5, typename T6>
    struct MethodInvoker<RET, CLASS, T0, T1, T2, T3, T4, T5, T6, void, void>
    {
        static void invoke(void* thisPtr, void* packedArgs, void* returnBuf, const void* invokerData)
        {
            typedef RET(CLASS::*MethodPointer)(T0, T1, T2, T3, T4, T5, T6);
            MethodPointer methodPtr = *reinterpret_cast<const MethodPointer*>(invokerData);
            typedef typename CallableSignatureTraits<T0, T1, T2, T3, T4, T5, T6>::ArgBuffer ArgBuf;
            const ArgBuf* argBuf = reinterpret_cast<const ArgBuf*>(packedArgs);
            CLASS* self = static_cast<CLASS*>(thisPtr);
            new (reinterpret_cast<hkPlacementNewArg*>(returnBuf)) RET
                ((self->*methodPtr)(argBuf->m_0, argBuf->m_1, argBuf->m_2, argBuf->m_3, argBuf->m_4, argBuf->m_5, argBuf->m_6));
        }
    };

    template<typename RET, typename CLASS, typename T0, typename T1, typename T2, typename T3, typename T4, typename T5>
    struct MethodInvoker<RET, CLASS, T0, T1, T2, T3, T4, T5, void, void, void>
    {
        static void invoke(void* thisPtr, void* packedArgs, void* returnBuf, const void* invokerData)
        {
            typedef RET(CLASS::*MethodPointer)(T0, T1, T2, T3, T4, T5);
            MethodPointer methodPtr = *reinterpret_cast<const MethodPointer*>(invokerData);
            typedef typename CallableSignatureTraits<T0, T1, T2, T3, T4, T5>::ArgBuffer ArgBuf;
            const ArgBuf* argBuf = reinterpret_cast<const ArgBuf*>(packedArgs);
            CLASS* self = static_cast<CLASS*>(thisPtr);
            new (reinterpret_cast<hkPlacementNewArg*>(returnBuf)) RET
                ((self->*methodPtr)(argBuf->m_0, argBuf->m_1, argBuf->m_2, argBuf->m_3, argBuf->m_4, argBuf->m_5));
        }
    };

    template<typename RET, typename CLASS, typename T0, typename T1, typename T2, typename T3, typename T4>
    struct MethodInvoker<RET, CLASS, T0, T1, T2, T3, T4, void, void, void, void>
    {
        static void invoke(void* thisPtr, void* packedArgs, void* returnBuf, const void* invokerData)
        {
            typedef RET(CLASS::*MethodPointer)(T0, T1, T2, T3, T4);
            MethodPointer methodPtr = *reinterpret_cast<const MethodPointer*>(invokerData);
            typedef typename CallableSignatureTraits<T0, T1, T2, T3, T4>::ArgBuffer ArgBuf;
            const ArgBuf* argBuf = reinterpret_cast<const ArgBuf*>(packedArgs);
            CLASS* self = static_cast<CLASS*>(thisPtr);
            new (reinterpret_cast<hkPlacementNewArg*>(returnBuf)) RET
                ((self->*methodPtr)(argBuf->m_0, argBuf->m_1, argBuf->m_2, argBuf->m_3, argBuf->m_4));
        }
    };

    template<typename RET, typename CLASS, typename T0, typename T1, typename T2, typename T3>
    struct MethodInvoker<RET, CLASS, T0, T1, T2, T3, void, void, void, void, void>
    {
        static void invoke(void* thisPtr, void* packedArgs, void* returnBuf, const void* invokerData)
        {
            typedef RET(CLASS::*MethodPointer)(T0, T1, T2, T3);
            MethodPointer methodPtr = *reinterpret_cast<const MethodPointer*>(invokerData);
            typedef typename CallableSignatureTraits<T0, T1, T2, T3>::ArgBuffer ArgBuf;
            const ArgBuf* argBuf = reinterpret_cast<const ArgBuf*>(packedArgs);
            CLASS* self = static_cast<CLASS*>(thisPtr);
            new (reinterpret_cast<hkPlacementNewArg*>(returnBuf)) RET
                ((self->*methodPtr)(argBuf->m_0, argBuf->m_1, argBuf->m_2, argBuf->m_3));
        }
    };

    template<typename RET, typename CLASS, typename T0, typename T1, typename T2>
    struct MethodInvoker<RET, CLASS, T0, T1, T2, void, void, void, void, void, void>
    {
        static void invoke(void* thisPtr, void* packedArgs, void* returnBuf, const void* invokerData)
        {
            typedef RET(CLASS::*MethodPointer)(T0, T1, T2);
            MethodPointer methodPtr = *reinterpret_cast<const MethodPointer*>(invokerData);
            typedef typename CallableSignatureTraits<T0, T1, T2>::ArgBuffer ArgBuf;
            const ArgBuf* argBuf = reinterpret_cast<const ArgBuf*>(packedArgs);
            CLASS* self = static_cast<CLASS*>(thisPtr);
            new (reinterpret_cast<hkPlacementNewArg*>(returnBuf)) RET
                ((self->*methodPtr)(argBuf->m_0, argBuf->m_1, argBuf->m_2));
        }
    };

    template<typename RET, typename CLASS, typename T0, typename T1>
    struct MethodInvoker<RET, CLASS, T0, T1, void, void, void, void, void, void, void>
    {
        static void invoke(void* thisPtr, void* packedArgs, void* returnBuf, const void* invokerData)
        {
            typedef RET(CLASS::*MethodPointer)(T0, T1);
            MethodPointer methodPtr = *reinterpret_cast<const MethodPointer*>(invokerData);
            typedef typename CallableSignatureTraits<T0, T1>::ArgBuffer ArgBuf;
            const ArgBuf* argBuf = reinterpret_cast<const ArgBuf*>(packedArgs);
            CLASS* self = static_cast<CLASS*>(thisPtr);
            new (reinterpret_cast<hkPlacementNewArg*>(returnBuf)) RET
                ((self->*methodPtr)(argBuf->m_0, argBuf->m_1));
        }
    };

    template<typename RET, typename CLASS, typename T0>
    struct MethodInvoker<RET, CLASS, T0, void, void, void, void, void, void, void, void>
    {
        static void invoke(void* thisPtr, void* packedArgs, void* returnBuf, const void* invokerData)
        {
            typedef RET(CLASS::*MethodPointer)(T0);
            MethodPointer methodPtr = *reinterpret_cast<const MethodPointer*>(invokerData);
            typedef typename CallableSignatureTraits<T0>::ArgBuffer ArgBuf;
            const ArgBuf* argBuf = reinterpret_cast<const ArgBuf*>(packedArgs);
            CLASS* self = static_cast<CLASS*>(thisPtr);
            new (reinterpret_cast<hkPlacementNewArg*>(returnBuf)) RET
                ((self->*methodPtr)(argBuf->m_0));
        }
    };

    template<typename RET, typename CLASS>
    struct MethodInvoker<RET, CLASS, void, void, void, void, void, void, void, void, void>
    {
        static void invoke(void* thisPtr, void* packedArgs, void* returnBuf, const void* invokerData)
        {
            typedef RET(CLASS::*MethodPointer)();
            MethodPointer methodPtr = *reinterpret_cast<const MethodPointer*>(invokerData);
            // typedef typename CallableSignatureTraits<>::ArgBuffer ArgBuf;
            // const ArgBuf* argBuf = reinterpret_cast<const ArgBuf*>(packedArgs);
            CLASS* self = static_cast<CLASS*>(thisPtr);
            new (reinterpret_cast<hkPlacementNewArg*>(returnBuf)) RET
                ((self->*methodPtr)());
        }
    };

    template<typename CLASS, typename T0, typename T1, typename T2, typename T3, typename T4, typename T5, typename T6, typename T7, typename T8>
    struct MethodInvoker<void, CLASS, T0, T1, T2, T3, T4, T5, T6, T7, T8>
    {
        static void invoke(void* thisPtr, void* packedArgs, void* returnBuf, const void* invokerData)
        {
            typedef void (CLASS::*MethodPointer)(T0, T1, T2, T3, T4, T5, T6, T7, T8);
            MethodPointer methodPtr = *reinterpret_cast<const MethodPointer*>(invokerData);
            typedef typename CallableSignatureTraits<T0, T1, T2, T3, T4, T5, T6, T7, T8>::ArgBuffer ArgBuf;
            const ArgBuf* argBuf = reinterpret_cast<const ArgBuf*>(packedArgs);
            CLASS* self = static_cast<CLASS*>(thisPtr);

            ((self->*methodPtr)(argBuf->m_0, argBuf->m_1, argBuf->m_2, argBuf->m_3, argBuf->m_4, argBuf->m_5, argBuf->m_6, argBuf->m_7, argBuf->m_8));
        }
    };

    template<typename CLASS, typename T0, typename T1, typename T2, typename T3, typename T4, typename T5, typename T6, typename T7>
    struct MethodInvoker<void, CLASS, T0, T1, T2, T3, T4, T5, T6, T7, void>
    {
        static void invoke(void* thisPtr, void* packedArgs, void* returnBuf, const void* invokerData)
        {
            typedef void (CLASS::*MethodPointer)(T0, T1, T2, T3, T4, T5, T6, T7);
            MethodPointer methodPtr = *reinterpret_cast<const MethodPointer*>(invokerData);
            typedef typename CallableSignatureTraits<T0, T1, T2, T3, T4, T5, T6, T7>::ArgBuffer ArgBuf;
            const ArgBuf* argBuf = reinterpret_cast<const ArgBuf*>(packedArgs);
            CLASS* self = static_cast<CLASS*>(thisPtr);

            ((self->*methodPtr)(argBuf->m_0, argBuf->m_1, argBuf->m_2, argBuf->m_3, argBuf->m_4, argBuf->m_5, argBuf->m_6, argBuf->m_7));
        }
    };

    template<typename CLASS, typename T0, typename T1, typename T2, typename T3, typename T4, typename T5, typename T6>
    struct MethodInvoker<void, CLASS, T0, T1, T2, T3, T4, T5, T6, void, void>
    {
        static void invoke(void* thisPtr, void* packedArgs, void* returnBuf, const void* invokerData)
        {
            typedef void (CLASS::*MethodPointer)(T0, T1, T2, T3, T4, T5, T6);
            MethodPointer methodPtr = *reinterpret_cast<const MethodPointer*>(invokerData);
            typedef typename CallableSignatureTraits<T0, T1, T2, T3, T4, T5, T6>::ArgBuffer ArgBuf;
            const ArgBuf* argBuf = reinterpret_cast<const ArgBuf*>(packedArgs);
            CLASS* self = static_cast<CLASS*>(thisPtr);

            ((self->*methodPtr)(argBuf->m_0, argBuf->m_1, argBuf->m_2, argBuf->m_3, argBuf->m_4, argBuf->m_5, argBuf->m_6));
        }
    };

    template<typename CLASS, typename T0, typename T1, typename T2, typename T3, typename T4, typename T5>
    struct MethodInvoker<void, CLASS, T0, T1, T2, T3, T4, T5, void, void, void>
    {
        static void invoke(void* thisPtr, void* packedArgs, void* returnBuf, const void* invokerData)
        {
            typedef void (CLASS::*MethodPointer)(T0, T1, T2, T3, T4, T5);
            MethodPointer methodPtr = *reinterpret_cast<const MethodPointer*>(invokerData);
            typedef typename CallableSignatureTraits<T0, T1, T2, T3, T4, T5>::ArgBuffer ArgBuf;
            const ArgBuf* argBuf = reinterpret_cast<const ArgBuf*>(packedArgs);
            CLASS* self = static_cast<CLASS*>(thisPtr);

            ((self->*methodPtr)(argBuf->m_0, argBuf->m_1, argBuf->m_2, argBuf->m_3, argBuf->m_4, argBuf->m_5));
        }
    };

    template<typename CLASS, typename T0, typename T1, typename T2, typename T3, typename T4>
    struct MethodInvoker<void, CLASS, T0, T1, T2, T3, T4, void, void, void, void>
    {
        static void invoke(void* thisPtr, void* packedArgs, void* returnBuf, const void* invokerData)
        {
            typedef void (CLASS::*MethodPointer)(T0, T1, T2, T3, T4);
            MethodPointer methodPtr = *reinterpret_cast<const MethodPointer*>(invokerData);
            typedef typename CallableSignatureTraits<T0, T1, T2, T3, T4>::ArgBuffer ArgBuf;
            const ArgBuf* argBuf = reinterpret_cast<const ArgBuf*>(packedArgs);
            CLASS* self = static_cast<CLASS*>(thisPtr);

            ((self->*methodPtr)(argBuf->m_0, argBuf->m_1, argBuf->m_2, argBuf->m_3, argBuf->m_4));
        }
    };

    template<typename CLASS, typename T0, typename T1, typename T2, typename T3>
    struct MethodInvoker<void, CLASS, T0, T1, T2, T3, void, void, void, void, void>
    {
        static void invoke(void* thisPtr, void* packedArgs, void* returnBuf, const void* invokerData)
        {
            typedef void (CLASS::*MethodPointer)(T0, T1, T2, T3);
            MethodPointer methodPtr = *reinterpret_cast<const MethodPointer*>(invokerData);
            typedef typename CallableSignatureTraits<T0, T1, T2, T3>::ArgBuffer ArgBuf;
            const ArgBuf* argBuf = reinterpret_cast<const ArgBuf*>(packedArgs);
            CLASS* self = static_cast<CLASS*>(thisPtr);

            ((self->*methodPtr)(argBuf->m_0, argBuf->m_1, argBuf->m_2, argBuf->m_3));
        }
    };

    template<typename CLASS, typename T0, typename T1, typename T2>
    struct MethodInvoker<void, CLASS, T0, T1, T2, void, void, void, void, void, void>
    {
        static void invoke(void* thisPtr, void* packedArgs, void* returnBuf, const void* invokerData)
        {
            typedef void (CLASS::*MethodPointer)(T0, T1, T2);
            MethodPointer methodPtr = *reinterpret_cast<const MethodPointer*>(invokerData);
            typedef typename CallableSignatureTraits<T0, T1, T2>::ArgBuffer ArgBuf;
            const ArgBuf* argBuf = reinterpret_cast<const ArgBuf*>(packedArgs);
            CLASS* self = static_cast<CLASS*>(thisPtr);

            ((self->*methodPtr)(argBuf->m_0, argBuf->m_1, argBuf->m_2));
        }
    };

    template<typename CLASS, typename T0, typename T1>
    struct MethodInvoker<void, CLASS, T0, T1, void, void, void, void, void, void, void>
    {
        static void invoke(void* thisPtr, void* packedArgs, void* returnBuf, const void* invokerData)
        {
            typedef void (CLASS::*MethodPointer)(T0, T1);
            MethodPointer methodPtr = *reinterpret_cast<const MethodPointer*>(invokerData);
            typedef typename CallableSignatureTraits<T0, T1>::ArgBuffer ArgBuf;
            const ArgBuf* argBuf = reinterpret_cast<const ArgBuf*>(packedArgs);
            CLASS* self = static_cast<CLASS*>(thisPtr);

            ((self->*methodPtr)(argBuf->m_0, argBuf->m_1));
        }
    };

    template<typename CLASS, typename T0>
    struct MethodInvoker<void, CLASS, T0, void, void, void, void, void, void, void, void>
    {
        static void invoke(void* thisPtr, void* packedArgs, void* returnBuf, const void* invokerData)
        {
            typedef void (CLASS::*MethodPointer)(T0);
            MethodPointer methodPtr = *reinterpret_cast<const MethodPointer*>(invokerData);
            typedef typename CallableSignatureTraits<T0>::ArgBuffer ArgBuf;
            const ArgBuf* argBuf = reinterpret_cast<const ArgBuf*>(packedArgs);
            CLASS* self = static_cast<CLASS*>(thisPtr);

            ((self->*methodPtr)(argBuf->m_0));
        }
    };

    template<typename CLASS>
    struct MethodInvoker<void, CLASS, void, void, void, void, void, void, void, void, void>
    {
        static void invoke(void* thisPtr, void* packedArgs, void* returnBuf, const void* invokerData)
        {
            typedef void (CLASS::*MethodPointer)();
            MethodPointer methodPtr = *reinterpret_cast<const MethodPointer*>(invokerData);
            // typedef typename CallableSignatureTraits<>::ArgBuffer ArgBuf;
            // const ArgBuf* argBuf = reinterpret_cast<const ArgBuf*>(packedArgs);
            CLASS* self = static_cast<CLASS*>(thisPtr);

            ((self->*methodPtr)());
        }
    };

    template<typename CLASS, typename T0 = void, typename T1 = void, typename T2 = void, typename T3 = void, typename T4 = void, typename T5 = void, typename T6 = void, typename T7 = void, typename T8 = void>
    struct ConstructorInvoker
    {
        static void invoke(void* /*thisPtr*/, void* packedArgs, void* objectBuf, const void* /*invokerData*/)
        {
            typedef typename CallableSignatureTraits<T0, T1, T2, T3, T4, T5, T6, T7, T8>::ArgBuffer ArgBuf;
            const ArgBuf* argBuf = reinterpret_cast<const ArgBuf*>(packedArgs);

            new (objectBuf) CLASS(
                ConstructorArg<T0>::convert(argBuf->m_0),
                ConstructorArg<T1>::convert(argBuf->m_1),
                ConstructorArg<T2>::convert(argBuf->m_2),
                ConstructorArg<T3>::convert(argBuf->m_3),
                ConstructorArg<T4>::convert(argBuf->m_4),
                ConstructorArg<T5>::convert(argBuf->m_5),
                ConstructorArg<T6>::convert(argBuf->m_6),
                ConstructorArg<T7>::convert(argBuf->m_7),
                ConstructorArg<T8>::convert(argBuf->m_8));
        }
    };

    template<typename CLASS, typename T0, typename T1, typename T2, typename T3, typename T4, typename T5, typename T6, typename T7>
    struct ConstructorInvoker<CLASS, T0, T1, T2, T3, T4, T5, T6, T7, void>
    {
        static void invoke(void* /*thisPtr*/, void* packedArgs, void* objectBuf, const void* /*invokerData*/)
        {
            typedef typename CallableSignatureTraits<T0, T1, T2, T3, T4, T5, T6, T7>::ArgBuffer ArgBuf;
            const ArgBuf* argBuf = reinterpret_cast<const ArgBuf*>(packedArgs);

            new (objectBuf) CLASS(
                ConstructorArg<T0>::convert(argBuf->m_0),
                ConstructorArg<T1>::convert(argBuf->m_1),
                ConstructorArg<T2>::convert(argBuf->m_2),
                ConstructorArg<T3>::convert(argBuf->m_3),
                ConstructorArg<T4>::convert(argBuf->m_4),
                ConstructorArg<T5>::convert(argBuf->m_5),
                ConstructorArg<T6>::convert(argBuf->m_6),
                ConstructorArg<T7>::convert(argBuf->m_7));
        }
    };

    template<typename CLASS, typename T0, typename T1, typename T2, typename T3, typename T4, typename T5, typename T6>
    struct ConstructorInvoker<CLASS, T0, T1, T2, T3, T4, T5, T6, void, void>
    {
        static void invoke(void* /*thisPtr*/, void* packedArgs, void* objectBuf, const void* /*invokerData*/)
        {
            typedef typename CallableSignatureTraits<T0, T1, T2, T3, T4, T5, T6>::ArgBuffer ArgBuf;
            const ArgBuf* argBuf = reinterpret_cast<const ArgBuf*>(packedArgs);

            new (objectBuf) CLASS(
                ConstructorArg<T0>::convert(argBuf->m_0),
                ConstructorArg<T1>::convert(argBuf->m_1),
                ConstructorArg<T2>::convert(argBuf->m_2),
                ConstructorArg<T3>::convert(argBuf->m_3),
                ConstructorArg<T4>::convert(argBuf->m_4),
                ConstructorArg<T5>::convert(argBuf->m_5),
                ConstructorArg<T6>::convert(argBuf->m_6));
        }
    };

    template<typename CLASS, typename T0, typename T1, typename T2, typename T3, typename T4, typename T5>
    struct ConstructorInvoker<CLASS, T0, T1, T2, T3, T4, T5, void, void, void>
    {
        static void invoke(void* /*thisPtr*/, void* packedArgs, void* objectBuf, const void* /*invokerData*/)
        {
            typedef typename CallableSignatureTraits<T0, T1, T2, T3, T4, T5>::ArgBuffer ArgBuf;
            const ArgBuf* argBuf = reinterpret_cast<const ArgBuf*>(packedArgs);

            new (objectBuf) CLASS(
                ConstructorArg<T0>::convert(argBuf->m_0),
                ConstructorArg<T1>::convert(argBuf->m_1),
                ConstructorArg<T2>::convert(argBuf->m_2),
                ConstructorArg<T3>::convert(argBuf->m_3),
                ConstructorArg<T4>::convert(argBuf->m_4),
                ConstructorArg<T5>::convert(argBuf->m_5));
        }
    };

    template<typename CLASS, typename T0, typename T1, typename T2, typename T3, typename T4>
    struct ConstructorInvoker<CLASS, T0, T1, T2, T3, T4, void, void, void, void>
    {
        static void invoke(void* /*thisPtr*/, void* packedArgs, void* objectBuf, const void* /*invokerData*/)
        {
            typedef typename CallableSignatureTraits<T0, T1, T2, T3, T4>::ArgBuffer ArgBuf;
            const ArgBuf* argBuf = reinterpret_cast<const ArgBuf*>(packedArgs);

            new (objectBuf) CLASS(
                ConstructorArg<T0>::convert(argBuf->m_0),
                ConstructorArg<T1>::convert(argBuf->m_1),
                ConstructorArg<T2>::convert(argBuf->m_2),
                ConstructorArg<T3>::convert(argBuf->m_3),
                ConstructorArg<T4>::convert(argBuf->m_4));
        }
    };

    template<typename CLASS, typename T0, typename T1, typename T2, typename T3>
    struct ConstructorInvoker<CLASS, T0, T1, T2, T3, void, void, void, void, void>
    {
        static void invoke(void* /*thisPtr*/, void* packedArgs, void* objectBuf, const void* /*invokerData*/)
        {
            typedef typename CallableSignatureTraits<T0, T1, T2, T3>::ArgBuffer ArgBuf;
            const ArgBuf* argBuf = reinterpret_cast<const ArgBuf*>(packedArgs);

            new (objectBuf) CLASS(
                ConstructorArg<T0>::convert(argBuf->m_0),
                ConstructorArg<T1>::convert(argBuf->m_1),
                ConstructorArg<T2>::convert(argBuf->m_2),
                ConstructorArg<T3>::convert(argBuf->m_3));
        }
    };

    template<typename CLASS, typename T0, typename T1, typename T2>
    struct ConstructorInvoker<CLASS, T0, T1, T2, void, void, void, void, void, void>
    {
        static void invoke(void* /*thisPtr*/, void* packedArgs, void* objectBuf, const void* /*invokerData*/)
        {
            typedef typename CallableSignatureTraits<T0, T1, T2>::ArgBuffer ArgBuf;
            const ArgBuf* argBuf = reinterpret_cast<const ArgBuf*>(packedArgs);

            new (objectBuf) CLASS(
                ConstructorArg<T0>::convert(argBuf->m_0),
                ConstructorArg<T1>::convert(argBuf->m_1),
                ConstructorArg<T2>::convert(argBuf->m_2));
        }
    };

    template<typename CLASS, typename T0, typename T1>
    struct ConstructorInvoker<CLASS, T0, T1, void, void, void, void, void, void, void>
    {
        static void invoke(void* /*thisPtr*/, void* packedArgs, void* objectBuf, const void* /*invokerData*/)
        {
            typedef typename CallableSignatureTraits<T0, T1>::ArgBuffer ArgBuf;
            const ArgBuf* argBuf = reinterpret_cast<const ArgBuf*>(packedArgs);

            new (objectBuf) CLASS(
                ConstructorArg<T0>::convert(argBuf->m_0),
                ConstructorArg<T1>::convert(argBuf->m_1));
        }
    };

    template<typename CLASS, typename T0>
    struct ConstructorInvoker<CLASS, T0, void, void, void, void, void, void, void, void>
    {
        static void invoke(void* /*thisPtr*/, void* packedArgs, void* objectBuf, const void* /*invokerData*/)
        {
            typedef typename CallableSignatureTraits<T0>::ArgBuffer ArgBuf;
            const ArgBuf* argBuf = reinterpret_cast<const ArgBuf*>(packedArgs);

            new (objectBuf) CLASS(
                ConstructorArg<T0>::convert(argBuf->m_0));
        }
    };

    template<typename CLASS>
    struct ConstructorInvoker<CLASS, void, void, void, void, void, void, void, void, void>
    {
        static void invoke(void* /*thisPtr*/, void* packedArgs, void* objectBuf, const void* /*invokerData*/)
        {
            // typedef typename CallableSignatureTraits<>::ArgBuffer ArgBuf;
            // const ArgBuf* argBuf = reinterpret_cast<const ArgBuf*>(packedArgs);

            new (objectBuf) CLASS(
                );
        }
    };


    //
    // End of autogenerated invokers.
    //

    template<typename T0, typename T1=void, typename T2=void, typename T3=void, typename T4=void, typename T5=void>
    struct GetLastParam
    {
        static T5* get(typename CallableSignatureTraits<T0, T1, T2, T3, T4, T5>::ArgBuffer* argBuf) { return &argBuf->m_5; }
    };

    template<typename T0, typename T1, typename T2, typename T3, typename T4>
    struct GetLastParam<T0, T1, T2, T3, T4>
    {
        static T4* get(typename CallableSignatureTraits<T0, T1, T2, T3, T4>::ArgBuffer* argBuf) { return &argBuf->m_4; }
    };

    template<typename T0, typename T1, typename T2, typename T3>
    struct GetLastParam<T0, T1, T2, T3>
    {
        static T3* get(typename CallableSignatureTraits<T0, T1, T2, T3>::ArgBuffer* argBuf) { return &argBuf->m_3; }
    };

    template<typename T0, typename T1, typename T2>
    struct GetLastParam<T0, T1, T2>
    {
        static T2* get(typename CallableSignatureTraits<T0, T1, T2>::ArgBuffer* argBuf) { return &argBuf->m_2; }
    };

    template<typename T0, typename T1>
    struct GetLastParam<T0, T1>
    {
        static T1* get(typename CallableSignatureTraits<T0, T1>::ArgBuffer* argBuf) { return &argBuf->m_1; }
    };

    template<typename T0>
    struct GetLastParam<T0>
    {
        static T0* get(typename CallableSignatureTraits<T0>::ArgBuffer* argBuf) { return &argBuf->m_0; }
    };

    template<typename RET, typename CLASS, typename T0=void, typename T1=void, typename T2=void, typename T3=void, typename T4=void, typename T5=void>
    struct StringOutMethodInvoker
    {
        static void invoke(void* thisPtr, void* packedArgs, void* returnBuf, const void* invokerData)
        {
            typedef typename CallableSignatureTraits<T0, T1, T2, T3, T4, T5>::ArgBuffer ArgBuf;
            ArgBuf* argBuf = reinterpret_cast<ArgBuf*>(packedArgs);

            StringOut* stringOut = new (returnBuf) StringOut();
            hkStringBuf** lastArg = GetLastParam<T0, T1, T2, T3, T4, T5>::get(argBuf);
            *lastArg = &stringOut->m_buf;
            MethodInvoker<RET, CLASS, T0, T1, T2, T3, T4, T5>::invoke(thisPtr, packedArgs, &stringOut->m_string, invokerData);
        }
    };

    template<typename RET, typename T0=void, typename T1=void, typename T2=void, typename T3=void>
    struct StringOutFunctionInvoker
    {
        static void invoke(void* /*thisPtr*/, void* packedArgs, void* returnBuf, const void* invokerData)
        {
            typedef typename CallableSignatureTraits<T0, T1, T2, T3>::ArgBuffer ArgBuf;
            ArgBuf* argBuf = reinterpret_cast<ArgBuf*>(packedArgs);

            StringOut* stringOut = new (returnBuf) StringOut();
            hkStringBuf** lastArg = GetLastParam<T0, T1, T2, T3>::get(argBuf);
            *lastArg = &stringOut->m_buf;
            FunctionInvoker<RET, T0, T1, T2, T3>::invoke(HK_NULL, packedArgs, &stringOut->m_string, invokerData);
        }
    };


} // Detail


 #define HK_REFLECT_DEFINE_MAKE_CALLABLE(RET, ...) \
    hkReflect::Callable makeCallable(RET(*funcPtr)(__VA_ARGS__)) \
    { \
        hkReflect::Detail::NamedCallablePod callable = { { nullptr, nullptr }, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr}; \
        callable.m_invoker.m_func = &hkReflect::Detail::FunctionInvoker<RET, __VA_ARGS__>::invoke; \
        static_assert(sizeof(callable.m_invoker.m_data) == sizeof(funcPtr), "Only simple functions"); \
        callable.m_invoker.m_data = (const void*)funcPtr; \
        callable.m_signature = HK_REFLECT_CALLABLE_SIGNATURE_OF(RET, __VA_ARGS__); \
        return *callable.cast(); \
    }

    template<typename T0>
    HK_REFLECT_DEFINE_MAKE_CALLABLE(void, T0)

    template<typename T0, typename T1>
    HK_REFLECT_DEFINE_MAKE_CALLABLE(void, T0, T1)

    template<typename T0, typename T1, typename T2>
    HK_REFLECT_DEFINE_MAKE_CALLABLE(void, T0, T1, T2)

    template<typename T0, typename T1, typename T2, typename T3>
    HK_REFLECT_DEFINE_MAKE_CALLABLE(void, T0, T1, T2, T3)

    template<typename T0, typename T1, typename T2, typename T3, typename T4>
    HK_REFLECT_DEFINE_MAKE_CALLABLE(void, T0, T1, T2, T3, T4)

    template<typename T0, typename T1, typename T2, typename T3, typename T4, typename T5>
    HK_REFLECT_DEFINE_MAKE_CALLABLE(void, T0, T1, T2, T3, T4, T5)

    template<typename T0, typename T1, typename T2, typename T3, typename T4, typename T5, typename T6>
    HK_REFLECT_DEFINE_MAKE_CALLABLE(void, T0, T1, T2, T3, T4, T5, T6)

    template<typename RET, typename T0>
    HK_REFLECT_DEFINE_MAKE_CALLABLE(RET, T0)

    template<typename RET, typename T0, typename T1>
    HK_REFLECT_DEFINE_MAKE_CALLABLE(RET, T0, T1)

    template<typename RET, typename T0, typename T1, typename T2>
    HK_REFLECT_DEFINE_MAKE_CALLABLE(RET, T0, T1, T2)

    template<typename RET, typename T0, typename T1, typename T2, typename T3>
    HK_REFLECT_DEFINE_MAKE_CALLABLE(RET, T0, T1, T2, T3)

    template<typename RET, typename T0, typename T1, typename T2, typename T3, typename T4>
    HK_REFLECT_DEFINE_MAKE_CALLABLE(RET, T0, T1, T2, T3, T4)

    template<typename RET, typename T0, typename T1, typename T2, typename T3, typename T4, typename T5>
    HK_REFLECT_DEFINE_MAKE_CALLABLE(RET, T0, T1, T2, T3, T4, T5)

    template<typename RET, typename T0, typename T1, typename T2, typename T3, typename T4, typename T5, typename T6>
    HK_REFLECT_DEFINE_MAKE_CALLABLE(RET, T0, T1, T2, T3, T4, T5, T6)
} // hkReflect

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
