// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

namespace hkReflect
{
        /// Utility class to copy a type with modifications.
        ///
    class HK_EXPORT_COMMON TypeCopier
    {
    public:

        HK_DECLARE_CLASS(TypeCopier, New);

        struct Pimpl;

            /// Options for configuring how a type is modified as it is copied.
        struct HK_EXPORT_COMMON Options
        {
            HK_DECLARE_CLASS(Options, NewPlacement);

            Options();

                /// Configure for a generic target.
            Options& setPortableTarget();

                /// Configure for the host target.
            Options& setHostTarget();

                /// Configure for a particular target.
                /// 'target' mnemonics are 'a':arm32, 'b':big endian, 'm':msvc, 'g':generic.
                /// Only the most specific target will work, or 'g' if there is no more specific target.
                /// In general, the 32 bit platforms have more variation than the 64 bit ones.
                /// 32a:Arm32,Switch32
                /// 32m:Win32,Switch32_win
                /// 32g:x86(except 32m)
                /// 64m:Win64,XBoxOne,Switch64_win
                /// 64g:x64(except 64m),Arm64,PlayStation(R)4,Switch64
                /// Possible values for "extra" are null or "d" for hkReal==double.
            Options& setTarget(int ptrBits, char target, _In_opt_z_ const char* extra=HK_NULL);

                /// Equivalent to setTarget except using strings of the form "32g" etc.
                /// HK_NULL corresponds to the host platform.
            Options& parseTarget(_In_opt_z_ const char* platform);

                ///
            Options& setRealIsDouble(bool b);

            Options& setIncludeProperties(bool b);

                ///
            int getPointerSize() const { return m_pointerSize; }

                ///
            bool isOk() const { return m_isOk; }

        protected:

            friend struct Pimpl;

            int m_pointerSize;
            int m_minifyFormat;
            int m_littleEndian;
            int m_longIsPointerSize;
            int m_alignedDoubles;
            int m_reusesParentPadding;
            int m_reusesClassAlignPadding;
            int m_includeProperties;
            int m_pruneNonSerializableFields;
            int m_realIsDouble;
            bool m_isOk;
        };

        explicit TypeCopier(const Options& cinfo);

        ~TypeCopier();

            /// m_0=copy, m_1=orig
        typedef hkTuple<hkReflect::Type*, const hkReflect::Type*> TypePair;

            /// Makes a recursive copy of the type.
        _Ret_maybenull_ const hkReflect::Type* copy(_In_ const hkReflect::Type* bt, _Inout_opt_ hkArray<TypePair>* copiesOut = HK_NULL);

            /// Get sizeof(void*) on the target.
        int getPointerSize() const;

            /// Get sizeof(hkReal) on the target.
        int getSizeofReal() const;

            /// Get a string describing the host layout.
        static _Ret_z_ const char* getHostString();

        struct Target
        {
            const char* m_name;
            const char* m_description;
        };

            /// Get a list of preset targets
        static hkArrayView<const Target> getTargetStrings();
            /// Get a list of preset extra additional options (e.g. hkReal=float/double)
        static hkArrayView<const char*> getTargetExtra();

    protected:

        Pimpl* m_pimpl;
    };
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
