// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/Base/Types/Color/hkColor.h>

class hkeNode;
class hkeNodeComponent;

namespace hk
{
    enum UiTypeEnum
    {
        UI_NONE = 0,
        UI_VECTOR2,
        UI_VECTOR3,
        UI_VECTOR4,
        UI_EXPANDABLE_LINK, // like the link, but can be expanded/collapsed like a record
        UI_IMPL_CHOOSER,
        UI_COLLAPSIBLE_PANEL,
        UI_CURVE,
        UI_COLOR_PICKER,
        UI_COLOR_PICKER_ALPHA,
        UI_SLIDER, // Adds a slider to a int / float editor (set hk::AbsMin and hk::AbsMax to define its range)
        UI_SLIDER_WITHOUT_VALUE, // Replaces the normal int / float editor with a valueless slider.
        UI_TAGLIST,
        UI_RADIOBUTTON, // Replaces the default combo box for enums with a radio button widget group.
        UI_CHECKBOX, // Replaces the default checkable combo box for flags with a checkbox button widget group. Can also be used to limit a float to either min or max.
        UI_MULTILINE_TEXT, // Replaces the default text edit with a multi line text edit.
        UI_LARGER_LINK, // Bigger version of the link widget
        UI_ARRAY_OF_DERIVED_TYPES,
        UI_COMBOBOX,

        UI_TYPE_ENUM_SIZE
    };

    enum EditingTypeEnum
    {
        ET_PROPERTY_EDITOR, // Default: editing of local assets is done with a property editor
        ET_EXTERNAL_EDITOR, // No property editing available: the tool defines an external editor
    };

    // The object doesn't support the "make local" workflow
    HK_DECLARE_FLAG_ATTR( Ui_NoLocalCopy, Runtime );

    // A filter used to restrict, through file extensions, which files appear in an open/save file dialog
    struct HK_EXPORT_COMMON FileDialogFilter
    {
        HK_DECLARE_CLASS( FileDialogFilter, New, Reflect );
        HK_RECORD_ATTR( hk::Serialize( false ) );

        FileDialogFilter() {}
        FileDialogFilter(_In_z_ const char* description, _In_opt_z_ const char* ext1, _In_opt_z_ const char* ext2 = HK_NULL, _In_opt_z_ const char* ext3 = HK_NULL, _In_opt_z_ const char* ext4 = HK_NULL)
        {
            m_fileTypeDescription = description;
            if ( ext1 ) m_fileExtensions.pushBack( ext1 );
            if ( ext2 ) m_fileExtensions.pushBack( ext2 );
            if ( ext3 ) m_fileExtensions.pushBack( ext3 );
            if ( ext4 ) m_fileExtensions.pushBack( ext4 );
        }

        hkStringPtr m_fileTypeDescription; // e.g. "Images"
        hkArray<hkStringPtr> m_fileExtensions; // e.g. "png", "jpg" (do NOT prefix with "*.")
    };

    // the field is hidden and its children are inlined
    HK_DECLARE_FLAG_ATTR( Ui_Inlined, Runtime );

    /// Hides the field in the Ui
    HK_DECLARE_FLAG_ATTR(Ui_Hidden, Runtime);

    /// Don't allow expanding on a given item (usually struct or array).
    HK_DECLARE_FLAG_ATTR(Ui_NotExpandable, Runtime);

    /// Pointer type will be shown as a reference in the UI
    HK_DECLARE_FLAG_ATTR(Ui_Navigable, Runtime);

    /// Used to mark the type of editing available in the tool
    HK_DECLARE_VALUE_ATTR(Ui_EditingType, EditingTypeEnum, Runtime);

    /// Pointer can be set to null by the user.
    HK_DECLARE_FLAG_ATTR( Ui_Nullable, Runtime );

    /// Pointer can be set only to objects inside the same document.
    HK_DECLARE_FLAG_ATTR( Ui_LocalReference, Runtime );

    /// Tags a string as representing a path to a folder. Shows a browse button and opens a folder browser dialog.
    HK_DECLARE_FLAG_ATTR( Ui_PathToFolder, Runtime );

    /// Tags a string as representing a path to a file. Shows a browse button and opens a file browser dialog.
    /// The array of values determines which file types can be browsed.
    HK_DECLARE_VALUE_ATTR( Ui_PathToFile, hk::ValueArray<FileDialogFilter>, Runtime );

    /// Component pointer can be set only to direct component children (if property is on a node) or siblings (if property is on a component).
    //HK_DECLARE_FLAG_ATTR( Ui_LocalComponentReference, Runtime );

    struct HK_EXPORT_COMMON Ui_LocalComponentReference : public Ui_LocalReference
    {
        HK_DECLARE_CLASS( Ui_LocalComponentReference, New, Reflect, RuntimeAttribute );
        typedef Ui_LocalReference ReflectDefaultType;
    };


    /// The type of function to be passed as a Ui_CanSelectNode
    /// owningNode contains the property or component with the property the Ui_CanSelectNode attribute is set on.
    /// If false is returned, the node is filtered out of the selection UI as a valid candidate.
    typedef bool (HK_CALL *CanSelectNodeFunc)(_In_ const hkReferencedObject* owner, _In_ const hkeNode* candidateNode);

    /// Use this attribute to specify a static function which should be used to
    /// determine whether a node can be used as a target to local reference. This function can be used for both
    /// hkeNode and hkeNodeComponent references. In the later case, only components on valid nodes can be selected.
    struct HK_EXPORT_COMMON Ui_CanSelectNode
    {
        HK_DECLARE_CLASS( Ui_CanSelectNode, New, Reflect, RuntimeAttribute );
        HK_RECORD_ATTR( hk::Serialize( false ) );

        CanSelectNodeFunc m_canSelectNodeFunc HK_ATTR( hk::Type( void* ) );
    };

    /// The type of function to be passed as a Ui_CanSelectComponent
    /// owner contains the property the Ui_CanSelectComponent attribute is set on.
    /// If false is returned, the component is filtered out of the selection UI as a valid candidate.
    typedef bool (HK_CALL *CanSelectComponentFunc)(_In_ const hkReferencedObject* owner, _In_ const hkeNodeComponent* candidateComponent);

    /// Use this attribute to specify a static function which should be used to
    /// determine whether a component can be used as a target to local reference.
    /// Only components that pass this test function can be selected.
    struct HK_EXPORT_COMMON Ui_CanSelectComponent
    {
        HK_DECLARE_CLASS( Ui_CanSelectComponent, New, Reflect, RuntimeAttribute );
        HK_RECORD_ATTR( hk::Serialize( false ) );

        CanSelectComponentFunc m_canSelectComponentFunc HK_ATTR( hk::Type( void* ) );
    };

    /// Icon associated with a type
    HK_DECLARE_VALUE_ATTR(Ui_Icon, const char*, Runtime);

    /// Category associated with a type
    HK_DECLARE_VALUE_ATTR( Ui_Category, const char*, Runtime );

    /// Category associated with a type
    HK_DECLARE_VALUE_ATTR( Ui_DisplayColor, hkColor::Argb, Runtime );

    /// Human-readable description of a type
    /// If type with the Ui_TypeName attribute is a template type, then the Ui_TypeName value only replaces the instance of this type in the 'template-looking' output:
    ///     e.g. if a type 'T' with template args <A,B> has Ui_TypeName("Marvin") the result Ui type name is "Marvin<[A typename], [B typename]>" (i.e. the Ui type name of A and B are still used)
    HK_DECLARE_VALUE_ATTR(Ui_TypeName, const char*, Runtime);
    /// Allow a type to specify that its name in the UI should be the same as the UI name of another type
    /// If type with this attribute is a template type, then the type name of the Ui_TypeNameIsSameAs value completely replaces the full Ui type name of this template
    ///     e.g. if a type 'T' with template args <A,B> has hk::Ui_TypeNameIsSameAs(HK_REFLECT_GET_TYPE(int)) the result Ui type name is "int"
    HK_DECLARE_VALUE_ATTR(Ui_TypeNameIsSameAs, const hkReflect::Type*, Runtime);
    /// (if both Ui_TypeName and Ui_DelegatTypeNameTo are used on a type, the Ui_TypeName value will be ignored while the Ui_DelegatTypeNameTo value will be honored)

    /// Human-readable description of a field
    HK_DECLARE_VALUE_ATTR(Ui_FieldName, const char*, Runtime);

    /// Human-readable tooltip description
    HK_DECLARE_VALUE_ATTR(Ui_Tooltip, const char*, Runtime);

    /// Use this attribute if you want to suppress continuous updates via the ui.
    /// If set, changes in the ui (e.g. moving a slider) will only apply on release or focus loss instead of being applied continuously.
    HK_DECLARE_FLAG_ATTR(Ui_SuppressContinuousUpdate, Runtime);

    /// Custom names for the x, y, z, w components of a vector. You can use '>' to group components into
    /// categories, e.g. hk::Ui_VectorComponentName( "Pos>X", "Pos>Y", "Scale>X", "Scale>Y" ) will create two
    /// categories 'Pos' and 'Scale', each containing two 'X' and 'Y' components.
    HK_DECLARE_VALUE_ATTR( Ui_VectorComponentName, hk::ValueArray<const char*>, Runtime );

    /// For records, take name from given hkStringPtr field
    HK_DECLARE_VALUE_ATTR(Ui_Name_FieldName, const char*, Runtime);

    /// For properties. Take the field name for the property from a sibling with the given name.
    HK_DECLARE_VALUE_ATTR( Ui_Name_SiblingFieldName, const char*, Runtime );

    /// Ui type override. See QhkObjectDomViewer::getUIType
    HK_DECLARE_VALUE_ATTR(Ui_Type, UiTypeEnum, Runtime);

    /// Shows the field in the Ui - used for records and fields which are hidden by default
    HK_DECLARE_FLAG_ATTR(Ui_Show, Runtime);

    /// Tell that the marked fields represent derived data from the owning class
    HK_DECLARE_FLAG_ATTR(Ui_DerivedAsset, Runtime);

    /// Specifies that an array is not resizable through the UI
    /// (without this attribute, arrays that are resizable according to reflection *will* be considered resizable through the UI)
    struct HK_EXPORT_COMMON Ui_FixedSize
    { HK_DECLARE_CLASS(Ui_FixedSize, New, Reflect, RuntimeAttribute); };

    /// The unit of measurement shown on the right side of the value in edit widgets
    HK_DECLARE_VALUE_ATTR(Ui_UnitOfMeasure, const char*, Runtime);

    /// Format (printf style) for values. use "m" at the end of the format to remove decimal trailing zeros
    HK_DECLARE_VALUE_ATTR(Format, const char*, Runtime);

    /// Step applied per pixel delta when editing the value with a spin box
    ///
    /// Float properties by default use automatic scaling by the current value which
    /// can also be done by setting hk::StepPerPixel(0).
    /// Integer values are generally used for 'count of X' so their scaling is set to a
    /// fixed 8 pixel dragging with the mouse to switch to the previous / next integer value.
    /// This allows to set integer values precisely and is equal to hk::StepPerPixel(1.0 / 8.0).
    HK_DECLARE_VALUE_ATTR(StepPerPixel, float, Runtime);

    /// Declares which value is considered to be the 'identity' for the property. E.g. 0 for offsets, 1 for scale values.
    HK_DECLARE_AUTO_TYPED_ATTR(IdentityValue, Runtime );

    /// Name of the bool field determining if this field is editable
    HK_DECLARE_VALUE_ATTR(EditableIf, const char*, Runtime);

    /// Name of the bool field determining if this field is visible
    HK_DECLARE_VALUE_ATTR( VisibleIf, const char*, Runtime );

    /// The component class will not have a reflection based creator
    HK_DECLARE_FLAG_ATTR( NoDefaultComponentCreator, Runtime );

    /// When in an hkeNode type means the reflection based node creator won't be created for this node type
    /// When in a component type it means that the component based node creator won't be created for the component creator
    HK_DECLARE_FLAG_ATTR(NoDefaultNodeCreator, Runtime);

    // (Applies to hkeNodeComponent objects only) Determines whether the given component can be applied to scenes as well as nodes.
    HK_DECLARE_FLAG_ATTR( ComponentAppliesToScenes, Runtime );

    // (Applies to hkeNodeComponent objects only) Determines whether the given component can be applied exclusively to scenes.
    HK_DECLARE_FLAG_ATTR( ComponentAppliesToScenesOnly, Runtime );

    /// Give a function that determines if the field is visible or not
    struct HK_EXPORT_COMMON VisibleIfFunc
    {
        HK_DECLARE_CLASS( VisibleIfFunc, New, Reflect, RuntimeAttribute );
        HK_RECORD_ATTR( hk::Serialize( false ) );

        typedef bool (*Fn)(const hkReflect::Var& self, _In_ const hkReflect::Type* field);
        Fn m_fn HK_ATTR( hk::Type( void* ) );
    };

    /// Determines whether or not the user can create new instances of this asset type in the tool
    /// (e.g. does a context-menu option of "Create New ..." exist in the Project View)
    HK_DECLARE_FLAG_ATTR(CanCreateInToolAsAsset, Runtime);

    /// Determines whether or not the user can create new instances of this rule type in the rule editor
    /// (e.g. does a context-menu option for instantiating this type exist in the Rule Editor)
    
    HK_DECLARE_FLAG_ATTR(CanCreateInRuleEditor, Runtime);

    /// Marks a field as belonging to a specific group in the UI,
    /// When displaying the fields of a record, all fields in groups are listed first (inside their respective groups) followed by those fields not in any group.
    struct HK_EXPORT_COMMON Ui_Group
    {
        HK_DECLARE_CLASS( Ui_Group, New, Reflect, RuntimeAttribute );

        const char* name;
        float order HK_ATTR( hk::Optional( implicit = true ), hk::Default( -1.0f ) );
    };

    /// A record attribute that specifies (by listing them by name) which record fields/groups should be listed first.
    /// Note that the 'const char*' used to identify a record should be the name according to reflection (e.g. 'someField', in the case of the field 'm_someField')
    /// Also note that even though 'Field' is in the name of this attribute, group names (identified by a UI_Group attribute) can be listed inside an UI_DefineFieldOrder attribute too with the expected effect.
    HK_DECLARE_VALUE_ATTR(Ui_DefineFieldOrder, hk::ValueArray<const char*>, Runtime);

    /// Show a manipulator in the viewport for this field
    HK_DECLARE_FLAG_ATTR(Ui_ShowManipulator, Runtime);

    /// Sets the number of slider steps when using a slider ui
    HK_DECLARE_VALUE_ATTR(Ui_NumSliderSteps, int, Runtime);

    typedef bool (*TagSuggestionCallbackType)(void*, const char*, hkArray<hkStringPtr>&);
    /// Callback used to retrieve suggestions for a tag list
    struct HK_EXPORT_COMMON TagSuggestionCallback
    {
        HK_DECLARE_CLASS( TagSuggestionCallback, New, Reflect, RuntimeAttribute );
        HK_RECORD_ATTR( hk::Serialize( false ) );

        TagSuggestionCallbackType m_cb HK_ATTR( hk::Type( void* ) );
    };

    /// Defines the minimum interval between two values, e.g. the start-end distance in hkInterval.
    HK_DECLARE_AUTO_TYPED_ATTR( Ui_MinInterval, Runtime );

    /// Marks a property as permanently read-only.
    HK_DECLARE_FLAG_ATTR( Ui_ReadOnly, Runtime );

    /// Marks a pointer property as const. Following the pointer will show it as read-only.
    HK_DECLARE_FLAG_ATTR( Ui_ConstTarget, Runtime );

    /// Marks a property as "expert" property so its put into a expandable section in the editor Ui.
    HK_DECLARE_FLAG_ATTR( Ui_Expert, Runtime );

    /// Marks a property as only relevant for a certain renderer.
    HK_DECLARE_ARRAY_ATTR( Ui_RequiredRendererFeatures, const char*, Runtime );

    /// Marks a property as only relevant if a shared world is in use / not in use.
    HK_DECLARE_FLAG_ATTR( Ui_ShowForSharedWorld, Runtime );

    /// Puts all properties belonging to this group in a horizontal layout. The group name is not shown.
    HK_DECLARE_VALUE_ATTR( Ui_HorizontalGroup, const char*, Runtime );

    /// Puts all properties belonging to this group into a compact layout. The group name is shown on the left in a separate label.
    HK_DECLARE_VALUE_ATTR( Ui_PackedGroup, const char*, Runtime );

    /// This attribute forces the use of a custom editor widget which may edit multiple properties at once.
    struct HK_EXPORT_COMMON Ui_CombinedEditor
    {
        HK_DECLARE_CLASS( Ui_CombinedEditor, New, Reflect, RuntimeAttribute );

        const char* name;
        const char* editorTypeName;
    };

    /// Puts the property into the group header.
    HK_DECLARE_FLAG_ATTR( Ui_InGroupHeader, Runtime );

    /// Sets the ordering for the fields in the Ui. The ui sorts by this value before displaying the fields.
    HK_DECLARE_VALUE_ATTR( Ui_Order, float, Runtime );

    /// This attribute is used to display a message when the pointer is null.
    HK_DECLARE_VALUE_ATTR(Ui_NullValidation, const char*, Runtime);
}

HK_REFLECT_ENUM(HK_EXPORT_COMMON, hk::UiTypeEnum);

HK_REFLECT_ENUM(HK_EXPORT_COMMON, hk::EditingTypeEnum);

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
