// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

class hkeNode;

namespace hke
{
    /// Marks the record as a Havok Engine Node, only valid on records. It should never be used directly.
    /// Usage: hke::EngineNode [true|false]
    HK_DECLARE_FLAG_ATTR(EngineNode, Static);

    /// Only used for access specifiers, marks a specific section in an hkeNode as runtime data.
    /// Usage: hk::RuntimeDataSection [true|false]
    HK_DECLARE_FLAG_ATTR(RuntimeDataSection, Static);

    /// Possible data constness types.
    namespace ConstTypes
    {
        enum Enum
        {
            RUNTIME,
            EDIT_AND_RUNTIME
        };
    }

    /// Can only be applied to pointer fields and specifies that the pointed object is a constant.
    /// An object can be a runtime-only constant (meaning that never changes at runtime but can still be edited),
    /// or a constant both during edit and at runtime. This attribute is used to perform optimizations in several
    /// subsystems. When cloning nodes for instance we can always share constant objects between the clone and the
    /// original.
    /// Usage: hke::Constant [RUNTIME|EDIT_AND_RUNTIME]
    HK_DECLARE_VALUE_ATTR(ConstantData, hke::ConstTypes::Enum, Runtime);

    /// Can only be applied to pointer fields and specifies that the pointed object is just cached data that was
    /// built during setup. The cached data should always be cleared while cloning or serializing nodes. A new
    /// setup will restore all the values.
    /// Usage: hke::CachedData [true|false] (false by default)
    HK_DECLARE_FLAG_ATTR(CachedData, Runtime);

    /// If set to false it can be used to mark up specific fields that shouldn't be considered by the runtime update,
    /// both for diffing and for finding live update dependencies.
    HK_DECLARE_FLAG_ATTR(Derived, Runtime);


    typedef char* (*SerializeCallbackType)(hkReflect::Var, hkReflect::Var, hkArray<char, hkContainerHeapAllocator>&);
    /// Pre-serialization callback for hkeObjectSerializer, for advanced use only
    
    struct HK_EXPORT_COMMON SerializeCallback
    {
        HK_DECLARE_CLASS(SerializeCallback, New, Reflect, RuntimeAttribute);
        HK_RECORD_ATTR(hk::Serialize(false));

        SerializeCallbackType m_cb HK_ATTR( hk::Type(void*) );
    };

    struct HK_EXPORT_COMMON IndexedArrayInitializer
    { HK_DECLARE_CLASS(IndexedArrayInitializer , New, Reflect, RuntimeAttribute); };

    struct HK_EXPORT_COMMON LocalService
    { HK_DECLARE_CLASS(LocalService , New, Reflect, RuntimeAttribute); };

    /// Rules
    struct HK_EXPORT_COMMON RuleInput
    { HK_DECLARE_CLASS(RuleInput , New, Reflect, RuntimeAttribute); };

    /// Flags a field as a rule output within an hkeRule. A hkeRule can only have a single RuleOutput.
    struct HK_EXPORT_COMMON RuleOutput
    { HK_DECLARE_CLASS(RuleOutput , New, Reflect, RuntimeAttribute); };

    /// Visual scripts - wired nodes
    HK_DECLARE_FLAG_ATTR(ExposeReflectedFunctionInVisualScript, Runtime);
    HK_DECLARE_FLAG_ATTR(VisualScriptFunction, Runtime);

    struct HK_EXPORT_COMMON VisualScriptTrigger
    { HK_DECLARE_CLASS(VisualScriptTrigger , New, Reflect, RuntimeAttribute); };

    HK_DECLARE_VALUE_ATTR(VisualScriptCategory, const char*, Runtime);

    HK_DECLARE_VALUE_ATTR(VisualScriptUiName, const char*, Runtime);

    HK_DECLARE_VALUE_ATTR(VisualScriptOutputName, const char*, Runtime);

    HK_DECLARE_VALUE_ATTR(VisualScriptClassPinName, const char*, Runtime);

    struct HK_EXPORT_COMMON WireableStruct
    { HK_DECLARE_CLASS(WireableStruct , New, Reflect, RuntimeAttribute); };

    struct HK_EXPORT_COMMON ReferencedWiredArray
    { HK_DECLARE_CLASS(ReferencedWiredArray, New, Reflect, RuntimeAttribute); };

    struct HK_EXPORT_COMMON WiredNodeInput
    { HK_DECLARE_CLASS(WiredNodeInput , New, Reflect, RuntimeAttribute); };

    struct HK_EXPORT_COMMON WiredNodeOutput
    { HK_DECLARE_CLASS(WiredNodeOutput , New, Reflect, RuntimeAttribute); };

    struct HK_EXPORT_COMMON RuleOutputBase
    { HK_DECLARE_CLASS( RuleOutputBase, New, Reflect, RuntimeAttribute ); };

    namespace PublicFieldPin
    {
        enum Enum
        {
            NONE,
            INPUT,
            OUTPUT,
        };
    }
    HK_DECLARE_VALUE_ATTR(PublicFieldPinBehavior, PublicFieldPin::Enum, Runtime);

    struct HK_EXPORT_COMMON TriggerOutputData
    { HK_DECLARE_CLASS(TriggerOutputData, New, Reflect, RuntimeAttribute); };




    struct HK_EXPORT_COMMON TempBuffer
    { HK_DECLARE_CLASS(TempBuffer, New, Reflect, RuntimeAttribute); };

    struct HK_EXPORT_COMMON RequiredProperty
    { HK_DECLARE_CLASS(RequiredProperty, New, Reflect, RuntimeAttribute); };

    struct HK_EXPORT_COMMON AddPropertyIfMissing
    { HK_DECLARE_CLASS(AddPropertyIfMissing, New, Reflect, RuntimeAttribute); };

    struct HK_EXPORT_COMMON Input
    { HK_DECLARE_CLASS(Input, New, Reflect, RuntimeAttribute); };

    struct HK_EXPORT_COMMON Output
    { HK_DECLARE_CLASS(Output, New, Reflect, RuntimeAttribute); };

    /// Marks components that need to be cloned into the render plugin
    struct HK_EXPORT_COMMON ComponentWithRenderRepresentation
    { HK_DECLARE_CLASS(ComponentWithRenderRepresentation, New, Reflect, RuntimeAttribute);};

    /// Marks components that have native visualization of geometry
    HK_DECLARE_VALUE_ATTR(ComponentWithNativeVisualization, bool, Runtime);

    /// Marks nodes that need to be skiped by the thumbnail renderer
    struct HK_EXPORT_COMMON NoThumbnail
    { HK_DECLARE_CLASS(NoThumbnail, New, Reflect, RuntimeAttribute); };

    /// A function pointer type for the canAddToParent function specified using
    /// the \ref CanAddToParent function.
    typedef bool (HK_CALL *CanAddToParentFunc)(const hkeNode* parentNode, const hkReflect::Type* parentNodeType);

    /// Use this attribute to specify a static function which should be used to
    /// determine whether an object of the current type can be added of the
    /// given parent node. The parentNode can be null (i.e. the parent has not
    /// been created yet), in which case parentNodeType must be non-null. If the
    /// parentNode is valid, then parentNodeType is assumed to be equal to
    /// hkReflect::exactTypeOf(parentNode) and will not be used.
    struct HK_EXPORT_COMMON CanAddToParent
    {
        HK_DECLARE_CLASS(CanAddToParent, New, Reflect, RuntimeAttribute);
        HK_RECORD_ATTR(hk::Serialize(false));

        CanAddToParentFunc m_canAddToParentFunc HK_ATTR(hk::Type(void*));
    };

    /// The type of function to be passed as a CanAddToNode
    /// Important: the owning node parameter can be null if we are checking whether we can add to a clean hkeNode
    typedef bool (HK_CALL *CanAddToNodeFunc)(_In_ const hkeNode* owningNode);

    /// Use this attribute to specify a static function which should be used to
    /// determine whether a component can be added to a given hkeNode
    struct HK_EXPORT_COMMON CanAddToNode
    {
        HK_DECLARE_CLASS(CanAddToNode, New, Reflect, RuntimeAttribute);
        HK_RECORD_ATTR(hk::Serialize(false));

        CanAddToNodeFunc m_canAddToNodeFunc HK_ATTR(hk::Type(void*));
    };
}

namespace hk
{
    namespace RPC
    {
        struct Flags
        {
            enum Enum
            {
                LOCAL = 1 << 0, /// Execute and activate a class on local process
                REMOTE = 1 << 1, /// Execute and activate a class on remote process
                PUBLISHER = 1 << 2 /// Mark class as publisher (see Publisher unit test for example)
            };
        };

        HK_DECLARE_FLAG_ATTR(Allowed, Runtime);

        HK_DECLARE_VALUE_ATTR(ExecutionFlags, int, Runtime);

        /// Type to replace publisher with on serialization
        HK_DECLARE_VALUE_ATTR(PublisherType, hkReflect::QualType, Runtime);

        /// After serialization callback
        typedef void (HK_CALL *OnAfterSerializeFunc)(_Inout_ hkReferencedObject* object);

        /// Attribute to hook the first time a class is sent over an RPC boundary
        /// Will only be called once after the class has been serialized.
        struct HK_EXPORT_COMMON OnAfterSerialize
        {
            HK_DECLARE_CLASS(OnAfterSerialize, New, Reflect, RuntimeAttribute);
            HK_RECORD_ATTR(hk::Serialize(false));

            OnAfterSerializeFunc m_onAfterSerialize HK_ATTR(hk::Type(void*));
        };
    }
}

namespace hk
{
    /// Used to identify scene properties (can be used by any product, e.g. renderer, so in hk namespace)
    struct HK_EXPORT_COMMON SceneProperty
    {
        HK_DECLARE_CLASS(SceneProperty, New, Reflect, RuntimeAttribute);
        HK_RECORD_ATTR(hk::Serialize(false));
        typedef hkStaticPropertyDescBase* AttributeType;

        hkStaticPropertyDescBase* m_value HK_ATTR(hk::Type(void*));
    };
    HK_DECLARE_VALUE_ATTR(Icon, const char*, Runtime);
    HK_DECLARE_VALUE_ATTR(IconSize, int, Runtime);
    HK_DECLARE_VALUE_ATTR(MaxWorldSpaceIconSize, float, Runtime);

    struct ComponentDisplayOptions
    {
        enum Enum
        {
            Hidden = 1 << 0,
            Transparent = 1 << 1,
            Wireframe = 1 << 2,
            Opaque = 1 << 3
        };
    };

    HK_DECLARE_VALUE_ATTR(ComponentDisplay, int, Runtime);
    HK_DECLARE_VALUE_ATTR(ComponentDisplayDefault, int, Runtime);

    struct ComponentDisplayUpdateOnChangeOptions
    {
        enum Enum
        {
            NodeOrChildChanged = 0,
            ComponentChanged = 1,
            Never = 2
        };
    };

    HK_DECLARE_VALUE_ATTR(UpdateComponentDisplayOnChange, ComponentDisplayUpdateOnChangeOptions::Enum, Runtime);

    /// Base class for hk::Expose, hk::ExposeAsMap.
    struct HK_EXPORT_COMMON ExposeBase
    {
        public:
            HK_DECLARE_CLASS( ExposeBase, New, Reflect);
            HK_RECORD_ATTR(hk::Validate(false));
            HK_RECORD_ATTR(hk::Serialize(false));

        public:
            enum AccessValues { GET = 1, SET = 2 };
            typedef hkFlags<AccessValues, hkUint8> Access;

            enum ScopeValues { EDITOR = 1, RUNTIME = 2 };
            typedef hkFlags<ScopeValues, hkUint8> Scope;

            /// GET and/or SET. Default is both.
            Access access HK_ATTR( hk::Optional( true, implicit = true ),
                    hk::Default( hk::ExposeBase::GET | hk::ExposeBase::SET ) );

            /// EDITOR and/or RUNTIME. Default is both.
            Scope scope HK_ATTR( hk::Optional, hk::Default( hk::ExposeBase::EDITOR | hk::ExposeBase::RUNTIME ) );

            /// Overrides the exposed value type. Getter/setter must return/take an instance of this type, or a pointer
            /// to it, or something convertible to it.
            /// The special value "Dynamic" means that the decorated field/its elements have a variable type. Getter
            /// and setter must return/take a hkReflect::Var in this case.
            const hkReflect::Type* valueType HK_ATTR( hk::Optional );

        public HK_ATTR( hk::Optional, hk::Type( void* ) ):

            /// Getter for the field.
            /// The signature of the method depends on the specific attribute used.
            const hkReflect::Callable* getter;

            /// Setter for the field.
            /// The signature of the method depends on the specific attribute used.
            const hkReflect::Callable* setter;

        public:
            /// Special value for valueType (see above).
            struct HK_EXPORT_COMMON Dynamic { HK_DECLARE_CLASS( Dynamic, NoNew, ReflectIdentity ); };
    };

    /// EXPERIMENTAL. Mark a field so that it is exposed and can be used in hkObjectPath.
    /// By default will look for methods in the form "ValueType getFieldname()", "bool setFieldname(ValueType)".
    struct HK_EXPORT_COMMON Expose : public ExposeBase
    {
        HK_DECLARE_CLASS( Expose, New, Reflect, RuntimeAttribute);
        HK_RECORD_ATTR(hk::Validate(false));
        typedef ExposeBase ReflectDefaultType;
    };

    /// EXPERIMENTAL. Mark a keyed container field so that it is exposed and can be traversed in hkObjectPath.
    /// By default will look for methods in the form "ValueType getInFieldname(KeyType)". "bool setInFieldname(KeyType, ValueType)".
    struct HK_EXPORT_COMMON ExposeAsMap : public ExposeBase
    {
        public:
        HK_DECLARE_CLASS( ExposeAsMap, New, Reflect, RuntimeAttribute);
        HK_RECORD_ATTR(hk::Validate(false));

        public HK_ATTR( hk::Optional, hk::Type( void* ) ) :

            /// Method to get the list of keys corresponding to the elements in the field.
            /// Must take no arguments and return an array of objects which can be used to index the field.
            const hkReflect::Callable* listKeys;

            /// Method to cache a representation of a key which is faster to resolve than the original key, but can be
            /// still passed safely to getter/setter. For example, if the field is an array, it can be the index in the
            /// array corresponding to the item with a specific key.
            const hkReflect::Callable* cacheKey;

        public:
            struct PodAlias
            {
                Access access;
                Scope scope;
                const hkReflect::Type* valueType;
                const hkReflect::Callable* getter, *setter, *listKeys, *cacheKey;
            };
            typedef PodAlias ReflectDefaultType;
    };

    /// EXPERIMENTAL. Mark a flags field so that it is exposed and can be used in hkObjectPath.
    /// By default will look for methods in the form "bool getFieldnameBits(FlagType)", "bool setFieldnameBits(FlagType, bool)".
    struct HK_EXPORT_COMMON ExposeAsFlags : public ExposeAsMap
    {
        HK_DECLARE_CLASS( ExposeAsFlags, New, Reflect, RuntimeAttribute);
        HK_RECORD_ATTR( hk::Validate(false) );
        typedef PodAlias ReflectDefaultType;
    };

    /// EXPERIMENTAL. Specifies that a field or the return value of a method can be used as a key to identify the
    /// declaring object in a container.
    struct HK_EXPORT_COMMON Key { HK_DECLARE_CLASS( Key, New, Reflect, RuntimeAttribute ); };
};


HK_REFLECT_ENUM(HK_EXPORT_COMMON, hke::ConstTypes::Enum);
HK_REFLECT_ENUM(HK_EXPORT_COMMON, hke::PublicFieldPin::Enum);
HK_REFLECT_ENUM(HK_EXPORT_COMMON, hk::ComponentDisplayOptions::Enum);
HK_REFLECT_ENUM(HK_EXPORT_COMMON, hk::ComponentDisplayUpdateOnChangeOptions::Enum);
HK_REFLECT_ENUM(HK_EXPORT_COMMON, hk::ExposeBase::AccessValues);
HK_REFLECT_ENUM(HK_EXPORT_COMMON, hk::ExposeBase::ScopeValues);

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
