// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

class hkStringBuf;
class hkErrorLog;
class hkMemoryAllocator;
class hkBaseObject;
class hkMemoryTrackerSnapshot;
class hkAttrData;
namespace hkReflect {
    namespace RecordLayout {
        struct Options;
    }

    class Diff;
    class AfterDiffEditList;
    namespace Detail { struct ArraySemantics; }
}

namespace hk
{
    /// Add this attribute to any declaration that should be considered as a static attribute
    /// by the reflection extraction scripts (doesn't produce C++ code).
    /// Static attributes aren't meant to be used as C++ objects but their definition will be
    /// analyzed by the LLVMClangParser in order to parse their arguments.
    struct HK_EXPORT_COMMON StaticAttribute { HK_RECORD_ATTR(hk::StaticAttribute); };

    /// Add this attribute to any declaration that should be considered as a runtime attribute
    /// by the reflection extraction scripts (produces C++ code).
    struct HK_EXPORT_COMMON RuntimeAttribute { HK_RECORD_ATTR(hk::StaticAttribute); };

    template<typename T>
    struct ValueAttribute
    {
        public:
            HK_DECLARE_CLASS(ValueAttribute, New, Reflect);

            typedef T AttributeType;

            operator AttributeType() const { return m_value; }
            AttributeType m_value;
    };

    /// This type is interpreted by the reflection parser as a variable-length array.
    template<typename T>
    struct ValueArray
    {
        public:
            HK_DECLARE_CLASS(ValueArray, New, ReflectIdentity);
            HK_REFLECT_AS_ARRAY(&hk::IsValueArray::s_impl, T);
            HK_RECORD_ATTR(hk::IsValueArray);

            typedef T ElementType;

            operator hkArrayView<const T>() const { return hkArrayView<const T>(m_begin, m_end); }

            const T* m_begin;
            const T* m_end;
    };

    /// Internal.
    struct HK_EXPORT_COMMON IsValueArray
    {
        HK_DECLARE_CLASS(IsValueArray, New, ReflectIdentity, RuntimeAttribute);

        class HK_EXPORT_COMMON Impl;
        static const Impl s_impl;
    };

    /// This type is interpreted specially by the reflection parser.
    /// An attribute of this type will contain an object of the same type as
    /// the field/type it has been applied to.
    struct HK_EXPORT_COMMON AutoType : public ValueAttribute< ValueArray<const char*> >
    {
        HK_DECLARE_CLASS(AutoType, New, ReflectIdentity);
        HK_RECORD_ATTR( hk::Allocatable(false), hk::ExcludeFromVersionCheck );

        hkReflect::Var get(_In_ const hkReflect::Type* type) const
        {
            return hkReflect::Var(this, hkReflect::QualType(type->isProperty() ? type->getParent() : type));
        }
        template <typename T> _Ret_notnull_ const T* get() const { return reinterpret_cast<const T*>(this); }
    };

    

#define HK_DECLARE_FLAG_ATTR2_WITHVALIDATION(EXPORT, NAME, ATTR_TYPE) \
    struct EXPORT HK_ATTR(hk::ExcludeFromVersionCheck) NAME \
    { \
        HK_DECLARE_CLASS(NAME, New, Reflect); \
        typedef bool AttributeType; \
        HK_RECORD_ATTR(hk::ATTR_TYPE ## Attribute, hk::GenerateValidationForAttribute); \
        operator bool() const { return m_value; } \
        bool m_value HK_ATTR(hk::Optional(true, implicit=true), hk::Default(true)); \
        template<typename T> struct Validation; template<typename T> inline bool isValid(const T& x) const { return Validation<T>::isValid(*this, x); } \
    }

#define HK_DECLARE_FLAG_ATTR2(EXPORT, NAME, ATTR_TYPE) \
    struct EXPORT HK_ATTR(hk::ExcludeFromVersionCheck) NAME\
    { \
        HK_DECLARE_CLASS(NAME, New, Reflect); \
        typedef bool AttributeType; \
        HK_RECORD_ATTR(hk::ATTR_TYPE ## Attribute); \
        operator bool() const { return m_value; } \
        bool m_value HK_ATTR(hk::Optional(true, implicit=true), hk::Default(true)); \
    }

#define HK_DECLARE_FLAG_ATTR(NAME, ATTR_TYPE) HK_DECLARE_FLAG_ATTR2(HK_EXPORT_COMMON, NAME, ATTR_TYPE)

#define HK_DECLARE_VALIDATABLE_FLAG_ATTR(NAME, ATTR_TYPE) HK_DECLARE_FLAG_ATTR2_WITHVALIDATION(HK_EXPORT_COMMON, NAME, ATTR_TYPE)

#define HK_DECLARE_VALUE_ATTR2(EXPORT, NAME, VALUE_TYPE, ATTR_TYPE) \
    struct EXPORT HK_ATTR(hk::ExcludeFromVersionCheck) NAME : public hk::ValueAttribute< VALUE_TYPE > \
    { \
        HK_DECLARE_CLASS(NAME, New, Reflect); \
        HK_RECORD_ATTR(hk::ATTR_TYPE ## Attribute); \
        typedef hk::ValueAttribute< VALUE_TYPE > ReflectDefaultType; \
     }
#define HK_DECLARE_VALUE_ATTR(NAME, VALUE_TYPE, ATTR_TYPE) HK_DECLARE_VALUE_ATTR2(HK_EXPORT_COMMON, NAME, VALUE_TYPE, ATTR_TYPE)


#define HK_DECLARE_AUTO_TYPED_ATTR2(EXPORT, NAME, ATTR_TYPE) \
    struct HK_EXPORT_COMMON NAME : public hk::AutoType \
    { \
        HK_DECLARE_CLASS(NAME, New, ReflectIdentity); \
        HK_RECORD_ATTR(hk::ATTR_TYPE ## Attribute); \
        typedef hk::AutoType ReflectDefaultType; \
    }
#define HK_DECLARE_AUTO_TYPED_ATTR(NAME, ATTR_TYPE) HK_DECLARE_AUTO_TYPED_ATTR2(HK_EXPORT_COMMON, NAME, ATTR_TYPE)

// The Validation struct is so that we can partially specialize validation functions
// These are only used by attribute definitions to declare that they can be validated
#define HK_DECLARE_VALIDATABLE_AUTO_TYPED_ATTR2(EXPORT, NAME, ATTR_TYPE) \
    struct HK_EXPORT_COMMON NAME : public hk::AutoType \
    { HK_DECLARE_CLASS(NAME, New, ReflectIdentity); HK_RECORD_ATTR(hk::ATTR_TYPE ## Attribute, hk::GenerateValidationForAttribute); template<typename T> struct Validation; template<typename T> inline bool isValid(const T& x) const { return Validation<T>::isValid(*this, x); } }
#define HK_DECLARE_VALIDATABLE_AUTO_TYPED_ATTR(NAME, ATTR_TYPE) HK_DECLARE_VALIDATABLE_AUTO_TYPED_ATTR2(HK_EXPORT_COMMON, NAME, ATTR_TYPE)

#define HK_DECLARE_ATTRIBUTE_IS_VALIDATABLE() HK_RECORD_ATTR(hk::GenerateValidationForAttribute); template<typename T> struct Validation; template<typename T> inline bool isValid(const T& x) const { return Validation<T>::isValid(*this, x); }

#define HK_DECLARE_ARRAY_ATTR2(EXPORT, NAME, VALUE_TYPE, ATTR_TYPE) \
    struct EXPORT NAME : public hk::ValueAttribute< hk::ValueArray< VALUE_TYPE > > \
    { \
        HK_DECLARE_CLASS(NAME, New, Reflect); \
        HK_RECORD_ATTR(hk::ATTR_TYPE ## Attribute, hk::Serialize(false)); \
        typedef hk::ValueAttribute< hk::ValueArray< VALUE_TYPE > > ReflectDefaultType; \
    }
#define HK_DECLARE_ARRAY_ATTR(NAME, VALUE_TYPE, ATTR_TYPE) HK_DECLARE_ARRAY_ATTR2(HK_EXPORT_COMMON, NAME, VALUE_TYPE, ATTR_TYPE)

    // -------------------------------- Static reflection attributes -------------------------------- //


    /// Used to qualify the field of an attribute which can be optional.
    /// By default the value for an optional field must be specified as a named argument in the attribute string;
    /// if 'implicit' is set to true, the field will be set with an unnamed argument (if present).
    /// Usage: hk::Optional [true|false]
    struct HK_EXPORT_COMMON Optional
    {
        HK_DECLARE_CLASS(Optional, New, Reflect, RuntimeAttribute);

        bool m_optional HK_ATTR( hk::Optional(implicit=true), hk::Default(true) );
        bool m_implicit HK_ATTR( hk::Optional, hk::Default(false) );
    };

    /// Must be applied to a field of an attribute. Values assigned to an attribute field decorated with this will be
    /// cast using the provided function before assignment.
    /// The function provided to this attribute will be called at static initialization time for each usage of
    /// the decorated attribute, so it *must not* rely on external data which might not have been initialized yet,
    /// and should ideally be small and inlineable.
    /// Usage: int m_attrField HK_ATTR( hk::Cast(MyFunc) );
    /// (values assigned to m_attrField will be replaced with 'MyFunc(<value>)')
    HK_DECLARE_VALUE_ATTR(Cast, const char*, Static);

    /// Enables reflection for the declaration it is applied to.
    /// Usage: hk::Reflect [true|false]
    HK_DECLARE_FLAG_ATTR(Reflect, Static);

    struct HK_EXPORT_COMMON ReflectDetails
    {
        HK_DECLARE_CLASS(ReflectDetails, New, Reflect);
        HK_RECORD_ATTR(hk::StaticAttribute);

        bool m_parents HK_ATTR(hk::Optional, hk::Default(true)); // parent and interfaces
        bool m_inheritance HK_ATTR(hk::Optional, hk::Default(true)); // inheritance, dynamic type
        bool m_specials HK_ATTR(hk::Optional, hk::Default(true)); // version, default, special methods
        bool m_fields HK_ATTR(hk::Optional, hk::Default(true));
        bool m_methods HK_ATTR(hk::Optional, hk::Default(false));
        bool m_allowMultipleDataInheritance HK_ATTR(hk::Optional, hk::Default(false)); 
    };

    /// Allows an OpaqueType type to be reflected as an hkReflect::OpaqueType. Implies hk::Serialize false.
    /// Usage: hk::OpaqueType [true|false]
    HK_DECLARE_FLAG_ATTR(OpaqueType, Static);

    /// Enables or disables serialization.
    /// Usage: hk::Serialize [true|false]
    HK_DECLARE_FLAG_ATTR(Serialize, Static);

    /// Marks a type as not being Retargetable.
    /// The layout of the type on a foreign platform cannot be determined from the current type.
    /// The most common cause is containing fields which are marked as hk::Reflect(false).
    /// Types must be retargetable in order to be exported for inplace load.
    /// Usage: hk::Retargetable [true|false]
    HK_DECLARE_FLAG_ATTR(Retargetable, Static);

    /// Enables optimization for POD types.
    /// Usage: hk::Pod [true|false]
    HK_DECLARE_FLAG_ATTR(Pod, Static);

    /// Enables the generation of the bypass constructor
    /// Usage: hk::GenerateBypassCtor [true|false]
    HK_DECLARE_FLAG_ATTR(GenerateBypassCtor, Static);

    /// Allows this class to be used as a MessageType.
    /// The class should have a static integer field to store the id.
    /// Usage: hk::MessageType(address_of_typeid)
    HK_DECLARE_VALUE_ATTR(MessageType, hkUint16*, Runtime);

    /// Allows this class to be used as a MessageHandler.
    /// The class should have a static integer field to store the id.
    /// Usage: hk::MessageHandler(address_of_handlerid)
    HK_DECLARE_VALUE_ATTR(MessageHandler, hkUint16*, Runtime);

    /// Specifies that a given method handles a specific message type.
    /// This attribute must be set on handler methods with a generic signature so that they are
    /// properly reflected as handlers. It is optional to set this attribute on methods which
    /// accept a message pointer/reference (these will be reflected as handlers automatically).
    /// This attribute will be ignored if applied on a non-reflected method.
    /// An error will occur during reflection generation if the handled message type is not found.
    HK_DECLARE_VALUE_ATTR(HandledMessage, const hkReflect::Type*, Static);

    /// Generates the getExactType method (default true)
    /// Usage: hk::GenerateExactTypeMethod [true|false]
    HK_DECLARE_FLAG_ATTR(GenerateExactTypeMethod, Static);

    /// Register this type automatically (default true)
    /// Usage: hk::RegisterType [true|false]
    HK_DECLARE_FLAG_ATTR(RegisterType, Static);

    /// Defines memory tracking options for a type/field.
    struct HK_EXPORT_COMMON MemoryTracker
    {
        HK_DECLARE_CLASS(MemoryTracker, New, Reflect, RuntimeAttribute);

        /// If true do not generate information about array/pointer fields.
        /// If attached to a field, the field is ignored.
        bool m_opaque HK_ATTR(hk::Optional, hk::Default(false));

        /// If present on a type, will be called to obtain additional tracked blocks from each instance.
        typedef void (*Handler)(const hkReflect::Var& obj, hkMemoryTrackerSnapshot& snapshot);
        Handler m_handler HK_ATTR(hk::Type(void*), hk::Optional, hk::Default(HK_NULL));
    };

    /// Adds a check in the Clang parser forcing children classes to be reflected.
    /// Usage: hk::ReflectChildren [true|false]
    HK_DECLARE_FLAG_ATTR(ReflectChildren, Static);

    /// The alignment is ALIGN_REAL
    /// Usage: hk::AlignReal [true|false]
    HK_DECLARE_FLAG_ATTR(AlignReal, Static);

    /// Sets the version of this type
    /// Usage: hk::Version [int]
    HK_DECLARE_VALUE_ATTR(Version, int, Static);

    /// Sets a field prefix for this record. It will be removed from field names.
    /// Usage: hk::FieldPrefix [str]
    /// Example: HK_ATTR( hk::FieldPrefix("m_") )
    struct HK_EXPORT_COMMON FieldPrefix
    {
        HK_DECLARE_CLASS(FieldPrefix, New);
        HK_RECORD_ATTR(hk::StaticAttribute);

        const char* prefix;
    };

    /// Include the reflection of this type only if the feature is enabled
    /// Usage: hk::Feature [str]
    /// Example: HK_ATTR( hk::Feature("hkMonitorStream") )
    HK_DECLARE_VALUE_ATTR(Feature, const char*, Static);

    /// Instructs the reflection extraction scripts to use the reflection of this type instead.
    /// Usage: hk::Type [token]
    /// Example: enum Foo m_foo HK_ATTR( hk::Type(hkUint8) );
    HK_DECLARE_VALUE_ATTR(Type, const hkReflect::Type*, Static);

    /// Create a synthetic field which calls methods to get/set the underlying value.
    /// Do not use this attribute directly. Use the HK_PROPERTY macro instead.
    struct HK_EXPORT_COMMON PropertyInternal
    {
        HK_RECORD_ATTR(hk::StaticAttribute);

        const char* name;
        const char* getter;
        // Stores the setter name if provided
        const char* setter HK_ATTR( hk::Optional(true, implicit=true) );
    };

    /// Emit code into the generated reflection source.
    /// The line looks like "type <qualified_name_of_class>::name = value;"
    /// "value" may be omitted.
    struct HK_EXPORT_COMMON EmitQualifiedData
    {
        HK_RECORD_ATTR(hk::StaticAttribute);

        const char* type;
        const char* name;
        const char* value HK_ATTR(hk::Optional(true, implicit=true));
    };

    /// Instructs the reflection extraction scripts to use these values in the reflection generation.
    struct HK_EXPORT_COMMON ReflectAs
    {
        HK_RECORD_ATTR(hk::StaticAttribute);

        const char* format;
        const hkReflect::Type* subtype HK_ATTR( hk::Optional );
        const char* impl HK_ATTR( hk::Optional(false, implicit=true) );
    };

    /// Reflect the decorated type as a typedef of the provided type.
    /// Can be used on typedefs as well as other types (in that case will override the underlying type).
    struct HK_EXPORT_COMMON ReflectAsTypedef
    {
        HK_RECORD_ATTR(hk::StaticAttribute);
        const hkReflect::Type* type;
    };

    /// Uses the provided name as reflected name of the class.
    /// Usage: hk::Rename [token]
    HK_DECLARE_VALUE_ATTR(Rename, const char*, Static);

    /// Takes an hkReflect::Detail::ExactTypeFunction function pointer and stores it in the Opt::EXACT_TYPE optional of the type.
    /// Usage: hk::ExactTypeFunction [function]
    HK_DECLARE_VALUE_ATTR(ExactTypeFunction, const char*, Static);

    /// TypeLayoutFunction
    struct HK_EXPORT_COMMON TypeLayout
    {
        HK_DECLARE_CLASS(TypeLayout, New, Reflect, RuntimeAttribute);
        typedef void(*Function)(_Inout_ hkReflect::Type* copy, _In_ const hkReflect::Type* orig, const hkReflect::RecordLayout::Options& opts);
        void compute(_Inout_ hkReflect::Type* copy, _In_ const hkReflect::Type* orig, const hkReflect::RecordLayout::Options& opts) const { return (*m_func)(copy, orig, opts); }
        Function m_func HK_ATTR(hk::Type(void*));
    };

    ///
    HK_DECLARE_VALUE_ATTR(ReflectionImpl, const char*, Static);

    /// Marks a field/class with a default value. The value will be used during versioning when initializing fields
    /// added by patches.
    HK_DECLARE_AUTO_TYPED_ATTR(Default, Static);

    /// Adds the given optional to the type generated
    /// Usage: hk::AddOptional Opt::XXX val
    struct HK_EXPORT_COMMON AddOptional
    {
        HK_RECORD_ATTR(hk::StaticAttribute);

        const char* optName;
        const char* optValue;
    };

    /// Adds the given flags to the type generated
    /// Usage: hk::AddFlags TYPE_XXX
    struct HK_EXPORT_COMMON AddFlags
    {
        HK_RECORD_ATTR(hk::StaticAttribute);

        const char* flags;
    };
    /// Mostly for internal usage. Gives access to the attribute list allowing the injection of raw values.
    /// Usage: hk::AddAttribute [attrName] [attrVal]
    struct HK_EXPORT_COMMON AddAttribute
    {
        HK_RECORD_ATTR(hk::StaticAttribute);

        const char* attrName;
        const char* attrVal;
    };

    /// Specify some template parameters to be ignored when reflecting this class template
    HK_DECLARE_ARRAY_ATTR(IgnoreTemplateParams, const char*, Static);

    /// Marks the method as returning a string in output.
    /// The return type must be void or (const) char* and will be changed to a helper string type in the
    /// reflected signature. The last parameter must be a pointer/reference to hkStringBuf and will be
    /// removed from the reflected signature (a temporary hkStringBuf will be created automatically when
    /// calling the reflected function).
    HK_DECLARE_FLAG_ATTR(StringOut, Static);

    /// If false, this type can not be allocated by reflection. We do not create an alloc impl
    /// Default and normal behaviour is true, alloc impl allocates from the heap
    HK_DECLARE_FLAG_ATTR(Allocatable, Static);

    /// Reflection data for a class is generated by default in a nested struct which is injected
    /// in the class by the HK_DECLARE_CLASS macro. If this attribute is true, reflection data will
    /// be generated in an external struct (and will not have access to private members/types).
    /// Use this when reflecting classes where the HK_DECLARE_CLASS macro cannot be added (e.g. std classes).
    HK_DECLARE_FLAG_ATTR(ExternalReflection, Static);

    /// Use on a template type to indicate that its special methods (constructors, assignment operator, destructor)
    /// might not be available depending on its arguments. The provided function will be called on each instantiation
    /// at registration time and must set the special methods Optionals to the correct values (or to HK_NULL if the
    /// methods are not available.
    struct HK_EXPORT_COMMON FixupReflectedMethods
    {
        HK_DECLARE_CLASS(FixupReflectedMethods, New, Reflect, RuntimeAttribute);

        typedef void (HK_CALL *FixupFunc)(_Inout_ hkReflect::Type* type);

        FixupFunc m_func HK_ATTR(hk::Type(void*));
    };

    // -------------------------------- Runtime reflection attributes -------------------------------- //

    /// Marks this record as containing hkRelArrays (arrays in the same allocation which immediately follow the record)
    /// Usage: hk::ContainsRelArrays [value]
    HK_DECLARE_FLAG_ATTR(ContainsRelArrays, Runtime);

    /// Sets a maximum value which might be checked by various components (Dom, ...).
    /// Usage: hk::AbsMax [value]
    HK_DECLARE_VALIDATABLE_AUTO_TYPED_ATTR(AbsMax, Runtime);

    /// Sets a minimum value which might be checked by various components (Dom, ...)
    /// Usage: hk::AbsMin [value]
    HK_DECLARE_VALIDATABLE_AUTO_TYPED_ATTR(AbsMin, Runtime);

    /// Attaches triple slash documentation strings as attributes.
    /// Usually used on a record to attach all contained documentation.
    HK_DECLARE_FLAG_ATTR(AttachDocString, Static);

    /// Attaches a documentation string to a declaration.
    HK_DECLARE_VALUE_ATTR(DocString, const char*, Runtime);

    /// Instructs the message dispatch system that the given message handler implements the specified interface.
    /// The specified interface is the name of a class, the message handler implementing this interface should
    /// always handle all the messages handled by the interface.
    /// An error will occur during message dispatch initialization if this condition is not respected.
    
    HK_DECLARE_VALUE_ATTR(Implements, const char*, Runtime);

    /// Used by the hkDefaultAssetRepository to set the UUID for a pointed object asset when automatically
    /// added to the asset manager. If this attribute is not used a new random UUID will be generated.
    /// Only available on smart pointer fields, on other fields it will be ignored.
    HK_DECLARE_VALUE_ATTR(DependentUUID, const char*, Runtime);

    /// When this is applied to an attribute class, it indicates to use a different class
    /// as a type declaration during parsing.
    struct HK_EXPORT_COMMON ParsingDecl
    {
        HK_DECLARE_CLASS(ParsingDecl, New, Reflect, RuntimeAttribute);
        HK_RECORD_ATTR(hk::Serialize(false));
        HK_RECORD_ATTR(hk::IncludeInMgd(false));

        typedef hkReflect::Var(*ConvertFunc)(const hkAttrData& parsed, _In_ const hkReflect::Type* ownerType, _Inout_ hkMemoryAllocator* allocator);

        const hkReflect::Type* m_decl;
        ConvertFunc m_convertFunc HK_ATTR( hk::Type(void*), hk::Optional, hk::Default(HK_NULL) );
    };

    /// Defines a set of predefined values interesting for this type. The strict flag
    /// specifies if the value has to be one of the presets or if they are only suggestions.
    struct HK_EXPORT_COMMON Presets
    {
        HK_DECLARE_CLASS(Presets, New, Reflect, RuntimeAttribute);
        HK_RECORD_ATTR(hk::Serialize(false));
        HK_RECORD_ATTR(hk::IncludeInMgd(false));
        HK_DECLARE_ATTRIBUTE_IS_VALIDATABLE();

        struct ParsingDecl
        {
            HK_DECLARE_CLASS(ParsingDecl, New, Reflect);
            HK_RECORD_ATTR(hk::Serialize(false));
            HK_RECORD_ATTR(hk::IncludeInMgd(false));

            bool m_strict HK_ATTR(hk::Optional, hk::Default(false));
            const hkReflect::Type* m_type HK_ATTR( hk::Optional );
            ValueArray<const char*> m_values;
        };

        static hkReflect::Var createFromParsed(const hkAttrData& parsed, _In_ const hkReflect::Type* ownerType,
            _Inout_ hkMemoryAllocator* allocator = hkMemHeapAllocator());
        static hkReflect::Var createFromValues(hkArrayView<const hkStringView> names,
            hkArrayView<const hkStringView> values, _In_ const hkReflect::Type* valueType,
            bool strict = false, _Inout_ hkMemoryAllocator* allocator = hkMemHeapAllocator());

        HK_RECORD_ATTR( hk::ParsingDecl(hk::Presets::ParsingDecl, convertFunc=&hk::Presets::createFromParsed) );

        bool m_strict;

        const hkReflect::Type * m_valueType;
        int m_numPresets;
        const char* const * m_names HK_ATTR(hk::Reflect(false));
        const void* const * m_values HK_ATTR(hk::Reflect(false));
        const hkReflect::Detail::AttributeArray* const * m_attribs HK_ATTR(hk::Reflect(false));

        int getNumPresets() const { return m_numPresets; }
        hkReflect::Var getPreset(int idx) const;
        _Ret_z_ const char* getPresetName(int idx) const { return m_names[idx]; }

        hkReflect::Var getPresetByName(_In_z_ const char* presetName) const;
        hkReflect::Var getPresetByName(const hkStringView& presetName) const;
        _Ret_opt_z_ const char* getNameByPreset(const hkReflect::Var& val) const;

        /// Find an attribute of the given template type T attached to the
        /// preset with the given index.
        _Ret_opt_z_ const void* findAttribute(int presetIdx, _In_ const hkReflect::Type* t) const;

        /// Find an attribute of the given type \p t attached to the preset with
        /// the given index.
        template<typename T>
        _Ret_opt_z_ const T* findAttribute(int presetIdx) const { return static_cast<const T*>(findAttribute(presetIdx, hkReflect::getType<T>())); }

        /// Utility to set a var with a preset value, while specifying the preset by name
        /// Returns HK_SUCCESS if the operation succeeded (this operation may fail if the preset's type isn't compatible with the var's type)
        static hkResult assign(const hkReflect::Var& var, _In_z_ const char* presetName);
        static hkResult assign(const hkReflect::Var& var, const hkStringView& presetName);

        /// is a particular value valid for hkEnum / hkFlags
        bool isValidForEnum(int enumValue) const;
        bool isValidForFlags(int flagmValue) const;
    };

    /// Contains the data which must be used to deallocate the type which this attribute
    /// belongs to. This attribute should be only present in dynamically created types.
    struct HK_EXPORT_COMMON DeleteTypeInfo
    {
        HK_DECLARE_CLASS(DeleteTypeInfo, New, Reflect, RuntimeAttribute);
        HK_RECORD_ATTR(hk::Serialize(false));

        /// Try to delete a type searching for a DeleteTypeInfo attribute.
        /// Returns true if the type had such an attribute and has been deleted.
        static bool deleteType(hkReflect::Type* type);

        typedef void (HK_CALL *Func)(_Inout_ hkReflect::Type* type, _Inout_ hkMemoryAllocator* allocator, hkUlong data);

        Func m_func HK_ATTR( hk::Type(void*) );
        hkMemoryAllocator* m_allocator HK_ATTR( hk::Type(void*) );
        hkUlong m_data;
    };

    
    HK_DECLARE_VALUE_ATTR(DynamicFieldsOffset, hkUint16, Runtime);

    /// If the type is dynamically created, then this object is its owner.
    HK_DECLARE_VALUE_ATTR(TypeOwner, hkBaseObject*, Runtime);

    typedef void (HK_CALL *ToStringFunc)(const hkReflect::Var& var, hkStringBuf& sb, const hkStringView& extra);
    /// Attribute to customize turning a var into a string.
    /// The function should replace string buffer contents.
    struct HK_EXPORT_COMMON ToString
    {
        HK_DECLARE_CLASS(ToString, New, Reflect, RuntimeAttribute);
        HK_RECORD_ATTR(hk::Serialize(false));

        ToStringFunc m_func HK_ATTR( hk::Type(void*) );
    };


    /// Specifies an auxiliary type used when declaring default values for the marked class. Used for string types
    /// where we want the default values to be pointers to char[]. See hkStringPtr for usage.
    HK_DECLARE_VALUE_ATTR(DefaultStringType, const char*, Static);

    /// For abstract classes, specifies a base class for synthesized types (types which are created at runtime
    /// and provide some kind of emulation of a virtual interface)
    HK_DECLARE_VALUE_ATTR(SyntheticBase, const hkReflect::Type*, Runtime);

    /// For abstract classes, specifies a base class for foreign types
    HK_DECLARE_VALUE_ATTR(ForeignBase, const hkReflect::Type*, Runtime);

    /// Attribute used to specify that a pointer is strongly referencing its pointee. A strong reference means that
    /// the pointee will become a member of the same strong graph as the object containing the annotated pointer.
    HK_DECLARE_FLAG_ATTR(StrongRef, Runtime);

    /// Attribute used to specify that a pointer value needs to be discarded in case its containing object gets
    /// duplicated.
    HK_DECLARE_FLAG_ATTR(WeakRef, Runtime);

    /// Attribute used to specify that an object is a leaf object. Leaf objects are considered to strongly own all
    /// objects they point to with non-weak pointers. A leaf object can be part of a strong graph if pointed to
    /// strongly, but its pointed-to objects will not consequentially become part of that strong graph.
    HK_DECLARE_FLAG_ATTR(LeafObject, Runtime);

    /// Attribute used to specify that a field should not participate in the tracking done by the ObjectTracker.
    HK_DECLARE_FLAG_ATTR(Untracked, Runtime);

    /// Set a custom backup callback for the ObjectTracker.
    struct HK_EXPORT_COMMON Backup
    {
        HK_DECLARE_CLASS(Backup, New, Reflect, RuntimeAttribute);

        typedef hkReflect::Var (*Fn)(const hkReflect::Var&);
        Fn m_fn HK_ATTR(hk::Type(void*));
    };

    /// Set a custom diff callback for the ObjectTracker.
    struct HK_EXPORT_COMMON Diff
    {
        HK_DECLARE_CLASS(Diff, New, Reflect, RuntimeAttribute);

        typedef hkReflect::Diff* (*Fn)(const hkReflect::Var&, const hkReflect::Var&);
        Fn m_fn HK_ATTR(hk::Type(void*));
    };

    /// Set a custom apply diff callback for hte ObjectTracker.
    struct HK_EXPORT_COMMON ApplyDiff
    {
        HK_DECLARE_CLASS(ApplyDiff, New, Reflect, RuntimeAttribute);

        typedef void(*Fn)(const hkReflect::Var&, const hkReflect::Diff&, hkReflect::AfterDiffEditList& afterDiffEdits);
        Fn m_fn HK_ATTR(hk::Type(void*));
    };

    /// States that a type or fields should be treated atomically by the diff system.
    HK_DECLARE_FLAG_ATTR(DiffAtomic, Runtime);

    /// By default, the hkReflect::Diff algorithms treat arrays atomically. Use this attribute to provide alternative semantics to use when diffing.
    struct HK_EXPORT_COMMON DiffArraySemantics
    {
        HK_DECLARE_CLASS( DiffArraySemantics, New, Reflect, RuntimeAttribute );

        typedef const hkReflect::Detail::ArraySemantics* (*GetArraySemanticsFunc)();

        /// A common alternative to the default (atomic) semantics is treat arrays as sets, where diffs describe adds, removes, etc.
        /// Providing this function as an argument to the hk::DiffArraySemantics attribute gives that behavior,
        /// e.g. HK_ATTR(hk::DiffArraySemantics(hk::DiffArraySemantics::treatAsSet)).
        /// Further customization can be achieved using the attributes SetArrayKey, SetArrayAddOp and SetArrayRemoveOp below.
        /// Note: If "HK_BUILDING_WITH_ENGINE" is defined, this is implemented in a NewBase cpp.
        static const hkReflect::Detail::ArraySemantics* treatAsSet();

        typedef GetArraySemanticsFunc AttributeType;
        AttributeType m_value HK_ATTR( hk::OpaqueType );
    };

    /// When using DiffArraySemantics::treatAsSet, this attribute can be put on fields of compound elements to ensure they are not used for
    /// equality comparisons. The effect of using this attribute on an array element's fields is that the array gets treated as a map from
    /// those fields which are parts of an element's identify to those which are not.
    /// By default, this is true for serializable data fields, and false otherwise.
    HK_DECLARE_FLAG_ATTR(SetArrayKey, Runtime);

    /// For an array with set semantics m_X, methods with the names "addToX" and "removeFromX" which have the right form
    /// are automatically associated to the array, and will be used to modify the array by e.g. undo and the prefab system.
    /// For element type E, acceptable forms include "void addToX( int, const E& )", "bool addToX( int, E )", etc.
    /// You can explicitly use this attribute to override the default behavior, by associated differently named methods,
    /// or using NULLs.
    struct HK_EXPORT_COMMON SetArrayAddOp
    {
        HK_DECLARE_CLASS(SetArrayAddOp, New, Reflect, RuntimeAttribute);

        /// The type of an add function which takes the containing record, the index and the address of the new contents.
        typedef bool (HK_CALL *AddFn)(_Inout_ void*, int, _In_ const void*);

        typedef AddFn AttributeType;
        operator AttributeType() const { return m_value; }

        AddFn m_value HK_ATTR(hk::Type(void*));
    };

    struct HK_EXPORT_COMMON SetArrayRemoveOp
    {
        HK_DECLARE_CLASS(SetArrayRemoveOp, New, Reflect, RuntimeAttribute);

        /// The type of remove function which takes the containing record and an index.
        typedef bool (HK_CALL *RemoveFn)(void*, int);

        /// If you are using the SetArrayOps attribute explicitly, this function simplifies the process of adapting a static function
        /// to the RemoveFn type.
        template<typename T> static RemoveFn removeFn(bool(*fn)(T*, int)) { return reinterpret_cast<RemoveFn>(fn); }

        typedef RemoveFn AttributeType;
        operator AttributeType() const { return m_value; }

        RemoveFn m_value HK_ATTR(hk::Type(void*));
    };

    /// Defines a callback for the current class which will be called by hk::DiffArraySemantics::treatAsSet when
    /// comparing a key with an instance of the class, or two instances of the class.
    struct HK_EXPORT_COMMON SetCompare
    {
        HK_DECLARE_CLASS( SetCompare, New, Reflect, RuntimeAttribute );

        typedef int( *CompareFunc )( const hkReflect::Var& lhs, const hkReflect::Var& rhs );
        CompareFunc m_func HK_ATTR( hk::Type( void* ) );
    };

    /// For a field with name m_X, a method with the name "setX" which has the right form is automatically associated
    /// with the field. You can explicitly use this attribute to override the default behavior.
    struct HK_EXPORT_COMMON FieldSetter
    {
        HK_DECLARE_CLASS(FieldSetter, New, StaticAttribute);

        /// This is the type of a function which wraps the setter function.
        typedef hkReflect::Detail::Impl::SetterType Fn;

        const char* value HK_ATTR(hk::Optional(implicit=true));
    };

    /// If used on a field with a FieldSetter, setters will not be called when applying diffs.
    /// If used on a field with DiffArraySemantics, neither remove, add or setter functions will be called for any element.
    /// This Attribute is usually used with an afterDiffEdit callback in the corresponding class.
    HK_DECLARE_FLAG_ATTR( IgnoreSettersOnDiff, Runtime );

    HK_DECLARE_ARRAY_ATTR( DependsOn, const char*, Runtime );

    HK_DECLARE_FLAG_ATTR(ExcludeFromVersionCheck, Runtime);

    // Automatic registration will not happen for this type (but it will be registered somewhere else)
    HK_DECLARE_FLAG_ATTR(ManualTypeRegistration, Static);

    // Override default behaviour for inclusion in HavokAssembly
    HK_DECLARE_FLAG_ATTR(IncludeInMgd, Static);

    struct HK_EXPORT_COMMON PreferredSerializationFormat
    {
        HK_DECLARE_CLASS(PreferredSerializationFormat, New, Reflect, RuntimeAttribute);
        HK_RECORD_ATTR(hk::Validate(false));

        enum Format
        {
            BINARY,
            TEXT
        };

        typedef Format AttributeType;
        hkEnum<Format, hkUint32> m_value;
    };

    /// Do not warn if this import fails to resolve.
    HK_DECLARE_FLAG_ATTR(WeakImport, Runtime);

    /// Attributes with this flag should have an isValid method
    /// Any field with an attribute that has Validate will have an isValid
    /// method generated in _Auto that calls the attribute isValid with the field value

    HK_DECLARE_FLAG_ATTR(GenerateValidationForAttribute, Static);
    HK_DECLARE_FLAG_ATTR(Validate, Static);
    HK_DECLARE_FLAG_ATTR(HasCustomValidation, Static);

    /// Declares that a callable will set a field with its argument value
    /// This is really a hkReflect::Type* but we make it a hkUlong to stop the attribute generation from mangling it
    /// You should not need to set this yourself, it is automatically generated
    HK_DECLARE_VALUE_ATTR(SetsField, hkUlong, Runtime);

    HK_DECLARE_VALIDATABLE_FLAG_ATTR(Normalized, Runtime);

    HK_DECLARE_VALIDATABLE_FLAG_ATTR(NonNull, Runtime);
}

HK_REFLECT_ENUM(HK_EXPORT_COMMON, hk::PreferredSerializationFormat::Format);

/// Hide criteria for attributes
struct HK_EXPORT_COMMON hkAttributeHideCriteria
{
    HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_HKCLASS, hkAttributeHideCriteria );
    HK_DECLARE_REFLECTION();

    // This is a bitfield(!) used to filter out certain modelers from displaying selected GUI elements.
    enum Types
    {
        NONE = 0,

        MODELER_IS_MAX  = (1 << 0),         ///< This member will not be displayed in 3ds Max's GUI.
        MODELER_IS_MAYA = (1 << 1),         ///< This member will not be displayed in Maya's GUI.

        UI_SCHEME_IS_DESTRUCTION        = (1 << 2), ///< The UI is set to show 'New Destruction' controls
        UI_SCHEME_IS_DESTRUCTION_2012   = (1 << 3), ///< The UI is set to show Destruction 2012 contros
    };
};

HK_REFLECT_ENUM(HK_EXPORT_COMMON, hkAttributeHideCriteria::Types);

    /// An attribute for specifying the range of possible values for an hkReal.
struct HK_EXPORT_COMMON hkRangeRealAttribute
{
    public:
        HK_RECORD_ATTR( dotnet::DefineAttribute(true) );
        HK_DECLARE_CLASS( hkRangeRealAttribute, New, Reflect, RuntimeAttribute );

//      inline hkRangeRealAttribute(hkReal absmin, hkReal absmax, hkReal softmin, hkReal softmax) :
//          m_absmin(absmin), m_absmax(absmax), m_softmin(softmin), m_softmax(softmax)
//      {
//          HK_ASSERT(0x2fd9e4a5, m_absmin <= m_absmax, "Make sure that absmin is less or equal than absmax.");
//          HK_ASSERT(0x2fd9e4a6, m_softmin <= m_softmax, "Make sure that softmin is less or equal than softmax.");
//          HK_ASSERT(0x2fd9e4a7, m_absmin <= m_softmin && m_softmax <= m_absmax, "Make sure that softmin and softmax are within [absmin,absmax] range.");
//      }

            /// The value should never be lower than this.
            /// Default minimum is -HK_REAL_MAX.
        hkReal m_absmin HK_ATTR( hk::Optional, hk::Default(-HK_REAL_MAX) );

            /// The value should never be higher than this.
            /// Default maximum is HK_REAL_MAX.
        hkReal m_absmax HK_ATTR( hk::Optional, hk::Default(HK_REAL_MAX) );

            /// The value should typically not by lower than this.
        hkReal m_softmin HK_ATTR( hk::Optional, hk::Default(-HK_REAL_MAX) );

            /// The value should typically not be higher than this.
        hkReal m_softmax HK_ATTR( hk::Optional, hk::Default(HK_REAL_MAX) );
};

    /// An attribute for specifying the range of possible values for an hkInt32.
struct HK_EXPORT_COMMON hkRangeInt32Attribute
{
    public:

        HK_RECORD_ATTR( dotnet::DefineAttribute(true) );
        HK_DECLARE_CLASS( hkRangeInt32Attribute, New, Reflect, RuntimeAttribute );

//      inline hkRangeInt32Attribute(hkInt32 absmin, hkInt32 absmax, hkInt32 softmin, hkInt32 softmax) :
//      m_absmin(absmin), m_absmax(absmax), m_softmin(softmin), m_softmax(softmax)
//      {
//          HK_ASSERT(0x2fd9e4a8, m_absmin <= m_absmax, "Make sure that absmin is less or equal than absmax.");
//          HK_ASSERT(0x2fd9e4a9, m_softmin <= m_softmax, "Make sure that softmin is less or equal than softmax.");
//          HK_ASSERT(0x2fd9e4b0, m_absmin <= m_softmin && m_softmax <= m_absmax, "Make sure that softmin and softmax are within [absmin,absmax] range.");
//      }
            /// The value should never be lower than this.
            /// Default minimum is HK_INT32_MIN.
        hkInt32 m_absmin HK_ATTR( hk::Optional, hk::Default(HK_INT32_MIN) );

            /// The value should never be higher than this.
            /// Default maximum is HK_INT32_MAX.
        hkInt32 m_absmax HK_ATTR( hk::Optional, hk::Default(HK_INT32_MAX) );

            /// The value should typically not by lower than this.
        hkInt32 m_softmin HK_ATTR( hk::Optional, hk::Default(HK_INT32_MIN) );

            /// The value should typically not be higher than this.
        hkInt32 m_softmax HK_ATTR( hk::Optional, hk::Default(HK_INT32_MAX) );
};


    /// An attribute for specifying editor specific information (visibility, editability, ...)
struct HK_EXPORT_COMMON hkUiAttribute
{
public:
    HK_RECORD_ATTR(dotnet::DefineAttribute(true));
    HK_RECORD_ATTR(hk::Version(4));
    HK_DECLARE_CLASS(hkUiAttribute, New, Reflect, RuntimeAttribute);
    HK_RECORD_ATTR(hk::Validate(false));

    /// Defines whether the member is visible in an editor
    bool m_visible HK_ATTR(hk::Optional, hk::Default(true));

    /// Defines whether the member is editable
    bool m_editable HK_ATTR(hk::Optional, hk::Default(true));

    /// Can be used to explicitly hide GUI elements in certain modelers.
    hkEnum<hkAttributeHideCriteria::Types, hkInt8> m_hideCriteria
        HK_ATTR(hk::Optional, hk::Default(hkAttributeHideCriteria::NONE));

    /// An alternative label for the GUI element.
    const char* m_label HK_ATTR(hk::Optional, hk::Default(""));

    /// Opens a new subgroup with the specified name.
    const char* m_group HK_ATTR(hk::Optional, hk::Default(""));

    /// A comma-separated list [string] used to hide any usually visible baseclass members. This tag can only be used on a class itself and will
    /// be ignored when used on a member.
    const char* m_hideBaseClassMembers HK_ATTR(hk::Optional, hk::Default(""));

    /// Close the current subgroup.
    bool m_endGroup HK_ATTR(hk::Optional, hk::Default(false));

    /// Close a second subgroup on the same line. Kinda hacky right now.
    bool m_endGroup2 HK_ATTR(hk::Optional, hk::Default(false));

    /// If set to true, this member will only show up under the 'Advanced Settings' section in the GUI.
    bool m_advanced HK_ATTR(hk::Optional, hk::Default(false));
};

    /// An attribute for specifying visual editing aids ('Gizmos') to be displayed in the modeler
struct HK_EXPORT_COMMON hkGizmoAttribute
{
    public:
        HK_RECORD_ATTR( dotnet::DefineAttribute(true) );
        HK_DECLARE_CLASS(hkGizmoAttribute, New, Reflect, RuntimeAttribute);
        HK_RECORD_ATTR(hk::Validate(false));

        enum GizmoType
        {
            POINT = 0,      ///< This draws a simple point (no extent)
            SPHERE,         ///< This draws a sphere
            PLANE,          ///< This draws a plane
            ARROW           ///< This draws an arrow
        };

            /// Defines whether the gizmo is visible in the modeler
        hkBool m_visible HK_ATTR( hk::Optional, hk::Default(false) );

            /// An alternative label for the GUI element.
        const char* m_label HK_ATTR( hk::Optional, hk::Default("") );

            /// The gizmo type.
        hkEnum<GizmoType,hkInt8> m_type;
};

HK_REFLECT_ENUM(HK_EXPORT_COMMON, hkGizmoAttribute::GizmoType);


    /// An attribute for specifying the type of base modeler node this class needs
struct HK_EXPORT_COMMON hkModelerNodeTypeAttribute
{
    HK_RECORD_ATTR( dotnet::DefineAttribute(true) );
    HK_DECLARE_CLASS(hkModelerNodeTypeAttribute, New, Reflect, RuntimeAttribute);
    HK_RECORD_ATTR(hk::Validate(false));

    enum ModelerType
    {
        DEFAULT = 0,

        LOCATOR,    ///< This class should use a locator type node.
    };

        /// Can be used to define the modeler node type
    hkEnum<ModelerType,hkInt8> m_type;
};

HK_REFLECT_ENUM(HK_EXPORT_COMMON, hkModelerNodeTypeAttribute::ModelerType);

/// An attribute for specifying the type of link for a class member (only appropriate for a pointer or string)
struct HK_EXPORT_COMMON hkLinkAttribute
{
    HK_RECORD_ATTR( dotnet::DefineAttribute(true) );
    HK_DECLARE_CLASS(hkLinkAttribute, New, Reflect, RuntimeAttribute);
    HK_RECORD_ATTR(hk::Validate(false));

    enum Link
    {
        NONE = 0,

        DIRECT_LINK,    ///< This member represents a link to the object being pointed to.
        CHILD,          ///< This member represents a link to an object which must child off the current object.
        MESH,           ///< This member represents a link to a mesh (as defined by the relevant external modeler/editor).
        PARENT_NAME,    ///< This member represents a link to the name of the object (effectively will store the name of the object in the string)
        IMGSELECT,      ///< This member represents the full path name to an image
        NODE_UUID,      ///< This member represents a link to a scene node (as defined by the relevant external modeler/editor).
    };

        /// Can be used to define the link type
    hkEnum<Link,hkInt8> m_type;
};

HK_REFLECT_ENUM(HK_EXPORT_COMMON, hkLinkAttribute::Link);


    /// An attribute for specifying more details about a class member
struct HK_EXPORT_COMMON hkSemanticsAttribute
{
    HK_RECORD_ATTR( dotnet::DefineAttribute(true) );
    HK_DECLARE_CLASS(hkSemanticsAttribute, New, Reflect, RuntimeAttribute);
    HK_RECORD_ATTR(hk::Validate(false));

    enum Semantics
    {
        UNKNOWN = 0,
        DISTANCE,
        ANGLE,
        NORMAL,
        POSITION,
        COSINE_ANGLE,
    };

        /// Can be used to define the parameter in more detail.
    hkEnum<Semantics,hkInt8> m_type;
};

HK_REFLECT_ENUM(HK_EXPORT_COMMON, hkSemanticsAttribute::Semantics);


    /// An attribute giving a string description to a class member.
struct HK_EXPORT_COMMON hkDescriptionAttribute
{
    HK_RECORD_ATTR( dotnet::DefineAttribute(true) );
    HK_DECLARE_CLASS( hkDescriptionAttribute, New, Reflect, RuntimeAttribute );

        /// The description string.
    const char* m_string;
};

/// An attribute linking a class to the corresponding section in the documentation.
struct HK_EXPORT_COMMON hkDocumentationAttribute
{
    HK_RECORD_ATTR( dotnet::DefineAttribute(true) );
    //+version(1)
    HK_DECLARE_CLASS(hkDocumentationAttribute, New, Reflect, RuntimeAttribute);

    const char* (HK_CALL *m_getDocsSectionTag)(hkAttributeHideCriteria::Types) HK_ATTR( hk::Reflect(false) );
};

namespace hkReflect
{
    namespace Detail
    {
        /// Used for attributes parsed at runtime. Instances cannot be allocated directly
        /// and are deallocated using easyFree (which will free the additional storage for strings and arrays).
        class AttributeAllocImpl : public hkReflect::Detail::AllocationImpl
        {
            public:
                HK_DECLARE_CLASS(AttributeAllocImpl, New);

                AttributeAllocImpl(_In_ hkMemoryAllocator* allocator);

                /// An instance which was constructed using the allocator returned
                /// by hkMemHeapAllocator(). We make this a static instance so that
                /// it's possible to simply add a pointer to this allocator to a
                /// type, without having to worry about the lifetime management of
                /// the allocator. This instance itself is always available, but
                /// since it uses the allocator returned by hkMemHeapAllocator(),
                /// it's the user's responsibility to make sure that this instance
                /// is only used after the memory system has been initialized and
                /// before it is shut down.
                static const AttributeAllocImpl s_heapInstance;

                virtual hkReflect::Var allocate(_In_ const hkReflect::Type* type) const HK_OVERRIDE;
                virtual hkReflect::Var allocateForClone(const hkReflect::Var& src, _In_ const hkReflect::Type* type) const HK_OVERRIDE;
                virtual bool isInPlaceConstructible(_In_ const hkReflect::Type* type) const HK_OVERRIDE;

                virtual void deallocate(_Inout_ void* target, _In_ const hkReflect::Type* type) const HK_OVERRIDE;

            private:
                hkMemoryAllocator* m_allocator;
        };
    }
}

#if !defined(__HAVOK_PARSER__)

namespace hk
{
    // The default AbsMin and AbsMax validation, this will work for simple types that define >= and <=
    template<typename T> struct AbsMin::Validation
    {
        inline static bool isValid(const AbsMin& attrib, const T& x)
        {
            // Look through any typedefs
            typedef const HK_REFLECT_RESOLVE(T) UnderlyingType;
            return *hkBitCast<UnderlyingType*>(&x) >= *(attrib.get<UnderlyingType>());
        }
    };

    template<typename T> struct AbsMax::Validation
    {
        inline static bool isValid(const AbsMax& attrib, const T& x)
        {
            // Look through any typedefs
            typedef const HK_REFLECT_RESOLVE(T) UnderlyingType;
            return *hkBitCast<UnderlyingType*>(&x) <= *(attrib.get<UnderlyingType>());
        }
    };

    // The underlying type must have an isNormalized<4> method
    template<typename T> struct Normalized::Validation
    {
        inline static bool isValid(const Normalized& attrib, const T& x)
        {
            return x.template isNormalized<4>();
        }
    };

    // The underlying type must have an isNormalized<4> method
    template<typename T> struct NonNull::Validation
    {
        inline static bool isValid(const NonNull& attrib, const T& x)
        {
            return x != nullptr;
        }
    };

    template<typename T> struct Presets::Validation
    {
        inline static bool isValid(const Presets& attrib, const T& x)
        {
            return attrib.isValidForEnum(x);
        }
    };
}
#endif

#include <Common/Base/_Auto/TemplateTypes/hkAttributes_Types.inl>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
