// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/Reflect/Attributes/hkAttributeParser.h>
#include <Common/Base/Reflect/Builder/hkTypeBuilder.h>
#include <Common/Base/Reflect/Core/Detail/hkReflectTypeDetail.h>
#include <Common/Base/Memory/Allocator/Linear/hkLinearBuffer.h>

#define DEBUG_LOG_IDENTIFIER "reflect.AttributeReader"
#include <Common/Base/System/Log/hkLog.hxx>

hkReflect::Var hk::Presets::getPreset(int idx) const
{
    return hkReflect::Var(m_values[idx], m_valueType);
}

hkReflect::Var hk::Presets::getPresetByName(_In_z_ const char* presetName) const
{
    return getPresetByName(hkStringView(presetName));
}

hkReflect::Var hk::Presets::getPresetByName(const hkStringView& presetName) const
{
    hkStringView scope(m_valueType->getName(), hkString::lastIndexOf(m_valueType->getName(), ':') + 1);
    hkStringView simpleName(presetName);

    if (scope && simpleName.beginsWith(scope))
    {
        simpleName = simpleName.ltrim(scope.getSize());
    }

    for(int i = 0; i < m_numPresets; ++i)
    {
        if(simpleName == m_names[i])
        {
            return getPreset(i);
        }
    }

    return hkReflect::Var();
}

_Ret_opt_z_ const char* hk::Presets::getNameByPreset(const hkReflect::Var& val) const
{
    for(int i = 0; i < m_numPresets; ++i)
    {
        if(val.equals(getPreset(i)))
        {
            return m_names[i];
        }
    }

    return HK_NULL;
}

_Ret_opt_z_ const void* hk::Presets::findAttribute(int presetIdx, _In_ const hkReflect::Type* t) const
{
    if(m_attribs)
    {
        const hkReflect::Detail::AttributeArray* attrs = m_attribs[presetIdx];
        if(attrs)
        {
            for(const hkReflect::Detail::AttributeItem& item : attrs->items())
            {
                if(item.type->extendsOrEquals(t))
                {
                    return item.data;
                }
            }
        }
    }

    return HK_NULL;
}

bool hk::DeleteTypeInfo::deleteType(_In_ hkReflect::Type* type)
{
    if (const hk::DeleteTypeInfo* deleteAttr = hkReflect::TypeDetail::localFindAttribute<hk::DeleteTypeInfo>(type))
    {
        deleteAttr->m_func(type, deleteAttr->m_allocator, deleteAttr->m_data);
        return true;
    }
    return false;
}

#if defined(HK_BUILDING_WITH_ENGINE)
#include <Common/NewBase/Reflect/Attributes/hkAttributeReader.h> 
#endif

hkReflect::Var hk::Presets::createFromParsed(const hkAttrData& parsed, _In_ const hkReflect::Type* ownerType, _Inout_ hkMemoryAllocator* allocator)
{
#if defined(HK_BUILDING_WITH_ENGINE)

    // check if the attribute overrides the type
    const hkReflect::Type* valueType = ownerType;
    hkAttrData::Field parsedType = parsed.getField("type");
    if (parsedType.isSet())
    {
        valueType = hkReflect::typeFromName(hkStringBuf(parsedType.getValue()).cString());
        if (!valueType)
        {
            Log_Warning("Invalid value type name: '{}'", parsedType.getValue());
            return hkReflect::Var();
        }
    }

    // check if 'strict' is specified
    bool strict = false;
    hkAttrData::Field parsedStrict = parsed.getField("strict");
    if (parsedStrict.isSet())
    {
        hkResult strictRes = hkReflect::Var(&strict).fromString(parsedStrict.getValue());
        if (!strictRes.isSuccess())
        {
            Log_Warning("Invalid value for 'strict' field: '{}'", parsedStrict.getValue());
            return hkReflect::Var();
        }
    }

    hkArrayView<const hkStringView> valuesStrings = parsed.getField("values").getValuesArray();

    hkArray<hkStringView>::Temp names;
    names.reserveExactly(valuesStrings.getSize());

    hkArray<hkStringView>::Temp values;
    values.reserveExactly(valuesStrings.getSize());

    for (int i = 0; i < valuesStrings.getSize(); ++i)
    {
        int equals = valuesStrings[i].rfind('=');
        if(equals == hkStringView::npos)
        {
            Log_Warning("Element {} is not a valid \"name = value\" pair ('{}')", i, valuesStrings[i]);
            return hkReflect::Var();
        }

        hkStringView name = valuesStrings[i].slice(0, equals);
        hkStringView value = valuesStrings[i].ltrim(equals + 1);

        if (!name || !value)
        {
            Log_Warning("Element {} is not a valid \"name = value\" pair ('{}')", i, valuesStrings[i]);
            return hkReflect::Var();
        }

        names.pushBackUnchecked(name);
        values.pushBackUnchecked(value);
    }

    return createFromValues(names, values, valueType, strict, allocator);
#else
    return hkReflect::Var();
#endif
}

hkReflect::Var hk::Presets::createFromValues(hkArrayView<const hkStringView> names,
    hkArrayView<const hkStringView> values, _In_ const hkReflect::Type* valueType, bool strict /*= false*/,
    _Inout_ hkMemoryAllocator* allocator)
{
    HK_ASSERT(0x368ce628, names.getSize() == values.getSize(), "Number of preset names doesn't match number of preset values");

    int extraSize = (sizeof(char*) + sizeof(void*)) * names.getSize(); 
    extraSize += sizeof(hkReflect::Detail::AttributeAllocImpl);        

    for (int i = 0; i < names.getSize(); ++i)
    {
        extraSize += names[i].getSize() + 1; 
    }

    extraSize += valueType->getSizeOf() * values.getSize(); 

                                                                   // override the alloc impl in the attribute type
    hkReflect::TypeBuilder builder;
    builder.beginDerived(hkReflect::getType<hk::Presets>());
    builder.addItem<hkReflect::Opt::ALLOC_IMPL>(HK_NULL);

    // allocate the buffer
    int allocSize = sizeof(Presets) + builder.getTotalNeededMemory() + extraSize;
    void* allocation = hkMemoryRouter::easyAlloc(*allocator, allocSize);
    hkLinearBuffer buffer(allocation, allocSize);

    // write the attribute
    Presets* p = reinterpret_cast<Presets*>(buffer.blockAlloc(sizeof(Presets)));
    p->m_valueType = valueType;
    p->m_strict = strict;
    p->m_numPresets = names.getSize();

    // This is needed so the the Presets can be deleted with Var::destroy
    hkReflect::Detail::AttributeAllocImpl* allocImpl = buffer.objAlloc<hkReflect::Detail::AttributeAllocImpl>();
    new(allocImpl) hkReflect::Detail::AttributeAllocImpl(allocator);
    builder.setItem<hkReflect::Opt::ALLOC_IMPL>(allocImpl);

    // write the type
    hkReflect::Type* overriddenType = builder.writeOnBuffer(buffer);

    // write the extras
    const char** nameBuffer = buffer.objAlloc<const char*>(p->m_numPresets);
    const void** valueBuffer = buffer.objAlloc<const void*>(p->m_numPresets);


    // writes the values
    bool failed = false;
    for (int i = 0; i < p->m_numPresets; ++i)
    {
        hkStringView name = names[i];
        hkStringView value = values[i];

        char* nameBuf = buffer.objAlloc<char>(name.getSize() + 1);
        HK_ON_DEBUG(hkResult nameRes = )name.copy(nameBuf, name.getSize() + 1, name.getSize() + 1);
        HK_ASSERT_NO_MSG(0x3a3efcba, nameRes.isSuccess());
        nameBuffer[i] = nameBuf;

        void* valueBuf = buffer.blockAlloc(p->m_valueType->getSizeOf());
        hkResult valueRes = hkReflect::Var(valueBuf, p->m_valueType).fromString(value);
        if (!valueRes.isSuccess())
        {
            Log_Warning("Invalid value for element {}: '{}'", i, value);
            failed = true;
            break;
        }
        valueBuffer[i] = valueBuf;
    }

    if (failed)
    {
        hkMemoryRouter::getInstance().easyFree(*hkMemHeapAllocator(), allocation);
        return hkReflect::Var();
    }

    p->m_names = nameBuffer;
    p->m_values = valueBuffer;
    p->m_attribs = HK_NULL;

    return hkReflect::Var(p, overriddenType);

}

hkResult hk::Presets::assign(const hkReflect::Var& var, _In_z_ const char* presetName)
{
    return assign(var, hkStringView(presetName));
}

hkResult hk::Presets::assign(const hkReflect::Var& var, const hkStringView& presetName)
{
    if (var)
    {
        if (const hk::Presets* presets = var.getType()->findAttribute<hk::Presets>())
        {
            hkReflect::Var specifiedPreset = presets->getPresetByName(presetName);

            if (specifiedPreset)
            {
                return var.assign(specifiedPreset);
            }
        }
    }

    return HK_FAILURE;
}

class HK_EXPORT_COMMON hk::IsValueArray::Impl : public hkReflect::Detail::ArrayImpl
{
public:
    Impl() {}
    virtual hkResult getValue(_In_ const void* arrAddr, _In_ const hkReflect::ArrayType* arrType, _Out_ hkReflect::ArrayValue * val) const HK_OVERRIDE
    {
        typedef hk::ValueArray<void> AnyArray;
        const AnyArray* arr = static_cast<const AnyArray*>(arrAddr);
        int size = hkGetByteOffsetInt(arr->m_begin, arr->m_end) / arrType->getSubType()->getSizeOf();
        *val = hkReflect::ArrayValue(const_cast<void*>(arr->m_begin), size, arrType->getSubType());
        return HK_SUCCESS;
    }

    virtual hkResult setNumElements(_Inout_ void* arrAddr, _In_ const hkReflect::ArrayType* arrType, int nelem) const HK_OVERRIDE
    {
        HK_ASSERT_NO_MSG(0x554b7010, 0);
        return HK_FAILURE;
    }

    virtual hkResult spliceInto(
        _Inout_ void* arrAddr, _In_ const hkReflect::ArrayType* arrType,
        int index, int numToDel, const hkReflect::ArrayValue& val) const HK_OVERRIDE
    {
        HK_ASSERT_NO_MSG(0x3b27d027, 0);
        return HK_FAILURE;
    }
};

const hk::IsValueArray::Impl hk::IsValueArray::s_impl;

#ifndef HK_BUILDING_WITH_ENGINE
const hkReflect::Detail::ArraySemantics* hk::DiffArraySemantics::treatAsSet()
{
    return HK_NULL;
}
#endif

const hkReflect::Detail::AttributeAllocImpl hkReflect::Detail::AttributeAllocImpl::s_heapInstance(hkMemHeapAllocator());

hkReflect::Detail::AttributeAllocImpl::AttributeAllocImpl(_In_ hkMemoryAllocator* allocator)
 : m_allocator(allocator)
{
}

hkReflect::Var hkReflect::Detail::AttributeAllocImpl::allocate(_In_ const hkReflect::Type* type) const
{
    HK_ERROR(0xfd11cd2, "Only AttributeAllocImpl's deallocate function should be used.");
    return hkReflect::Var();
}

hkReflect::Var hkReflect::Detail::AttributeAllocImpl::allocateForClone(const hkReflect::Var& src, _In_ const hkReflect::Type* type) const
{
    HK_ERROR(0x2d8bd59c, "Only AttributeAllocImpl's deallocate function should be used.");
    return hkReflect::Var();
}

bool hkReflect::Detail::AttributeAllocImpl::isInPlaceConstructible(_In_ const hkReflect::Type*) const
{
    return false;
}

void hkReflect::Detail::AttributeAllocImpl::deallocate(_Inout_ void* target, _In_ const hkReflect::Type* type) const
{
    hkMemoryRouter::easyFree(*m_allocator, target);
}

bool hk::Presets::isValidForEnum(int enumValue) const
{
    hkReflect::IntVar valueToValidate(&enumValue);

    for (int idx = 0; idx < getNumPresets(); idx++)
    {
        if (getPreset(idx).equals(valueToValidate))
        {
            return true;
        }
    }
    return false;
}

bool hkReflect::Detail::isValidForPresets(const hk::Presets& pre, int value)
{
    return pre.isValidForEnum(value);
}

bool hk::Presets::isValidForFlags(int flagValue) const
{
    hkUint32 allFlagValues = 0;

    for (int idx = 0; idx < getNumPresets(); idx++)
    {
        hkReflect::IntVar flagBit(getPreset(idx));
        if(flagBit)
        {
            const hkUint32 flagBitValue = flagBit.getValue().convertTo<hkUint32>();
            allFlagValues |= flagBitValue;
        }
    }

    // flagValue should contain only bits that are in allFlagValues
    return (allFlagValues | flagValue) == allFlagValues;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
