// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

hkAttrData::FieldDecl::FieldDecl(_In_z_ const char* name, int numElements, Flags flags)
    : m_name(name), m_numElements(numElements), m_flags(flags)
{
}

hkAttrData::FieldDecl hkAttrData::FieldDecl::simple(_In_z_ const char* name, Flags flags)
{
    return FieldDecl(name, 0, flags);
}

hkAttrData::FieldDecl hkAttrData::FieldDecl::fixedArray(_In_z_ const char* name, int numElements, Flags flags)
{
    return FieldDecl(name, numElements, flags);
}

hkAttrData::FieldDecl hkAttrData::FieldDecl::variableArray(_In_z_ const char* name, Flags flags)
{
    return FieldDecl(name, -1, flags);
}

_Ret_z_ const char* hkAttrData::FieldDecl::getName() const
{
    return m_name;
}

bool hkAttrData::FieldDecl::isOptional() const
{
    return m_flags.anyIsSet(FLAG_OPTIONAL);
}

bool hkAttrData::FieldDecl::isExplicit() const
{
    return m_flags.anyIsSet(FLAG_EXPLICIT);
}

bool hkAttrData::FieldDecl::isSimple() const
{
    return m_numElements == 0;
}

bool hkAttrData::FieldDecl::isVariableArray() const
{
    return m_numElements == -1;
}

bool hkAttrData::FieldDecl::isFixedArray() const
{
    return m_numElements > 0;
}

int hkAttrData::FieldDecl::getFixedSize() const
{
    return m_numElements;
}

template<typename AttrDataType>
hkAttrData::FieldBase<AttrDataType>::FieldBase(AttrDataType& data, int fieldIdx)
    : m_data(data), m_fieldIdx(fieldIdx)
{
}

template<typename AttrDataType>
const hkAttrData::FieldDecl& hkAttrData::FieldBase<AttrDataType>::getDecl() const
{
    return m_data.m_fields[m_fieldIdx].decl;
}

template<typename AttrDataType>
hkStringView hkAttrData::FieldBase<AttrDataType>::getValue() const
{
    HK_ASSERT_NO_MSG(0x5a00c41b, getDecl().isSimple() ||
        m_data.m_fields[m_fieldIdx].end == m_data.m_fields[m_fieldIdx].begin + 1);
    HK_ASSERT_NO_MSG(0x488c2f67, isSet());
    return m_data.m_values[m_data.m_fields[m_fieldIdx].begin];
}

template<typename AttrDataType>
hkArrayView<const hkStringView> hkAttrData::FieldBase<AttrDataType>::getValuesArray() const
{
    HK_ASSERT_NO_MSG(0x3aba0f1e, !getDecl().isSimple());
    HK_ASSERT_NO_MSG(0x1383313e, isSet());
    return hkArrayView<const hkStringView>(m_data.m_values.begin() + m_data.m_fields[m_fieldIdx].begin, m_data.m_values.begin() + m_data.m_fields[m_fieldIdx].end);
}

template<typename AttrDataType>
bool hkAttrData::FieldBase<AttrDataType>::isValid() const { return m_fieldIdx >= 0; }


template<typename AttrDataType>
bool hkAttrData::FieldBase<AttrDataType>::isSet() const { return m_data.m_fields[m_fieldIdx].begin >= 0; }

hkAttrData::WritableField::WritableField(hkAttrData& data, int fieldIdx)
    : hkAttrData::FieldBase<hkAttrData>(data, fieldIdx)
{
}

void hkAttrData::WritableField::setValue(const hkStringView& value) const
{
    HK_ASSERT_NO_MSG(0x555acaa1, getDecl().isSimple());
    HK_ASSERT_NO_MSG(0x1eb8148c, !isSet());
    m_data.m_fields[m_fieldIdx].begin = m_data.m_values.getSize();
    m_data.m_fields[m_fieldIdx].end = m_data.m_values.getSize();
    m_data.m_values.pushBack(value);
}

void hkAttrData::WritableField::setValuesArray(const hkArrayView<const hkStringView>& values) const
{
    HK_ASSERT_NO_MSG(0x257dd749, getDecl().isVariableArray() || getDecl().getFixedSize() >= values.getSize());
    HK_ASSERT_NO_MSG(0xb05e564, !isSet());
    m_data.m_fields[m_fieldIdx].begin = m_data.m_values.getSize();
    m_data.m_fields[m_fieldIdx].end = m_data.m_values.getSize() + values.getSize();
    m_data.m_values.append(values.data(), values.getSize());
}


void hkAttrData::addDecl(const FieldDecl& decl)
{
    m_fields.pushBack(FieldData(decl));
}

hkAttrData::Field hkAttrData::getField(int fieldIdx) const
{
    return Field(*this, fieldIdx);
}

hkAttrData::WritableField hkAttrData::getWritableField(int fieldIdx)
{
    return WritableField(*this, fieldIdx);
}

int hkAttrData::getNumFields() const
{
    return m_fields.getSize();
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
