// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL !REFLECT
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/PreProcessor/Values/hkPreProcessorBoolExtra.h>
#include <Common/Base/PreProcessor/Values/hkPreProcessorShr.h>
#include <Common/Base/PreProcessor/Values/hkPreProcessorShl.h>
#include <Common/Base/PreProcessor/Values/hkPreProcessorLsb.h>
#include <Common/Base/PreProcessor/Values/hkPreProcessorOr.h>
#include <Common/Base/PreProcessor/Values/hkPreProcessorAnd.h>

//
//  Macro that returns the Least Significant Bit of x (x in [0, 8191])

#define HK_PREPROCESSOR_LSB(x)                  HK_PREPROCESSOR_TEMP_LSB(x)

//
//  Macro that shifts x to the right by count (x in [0, 8191], count in )

#define HK_PREPROCESSOR_SHR(x, count)           HK_PREPROCESSOR_SHR_COUNT_##count(x)

//
//  Macro that shifts x to the left by count (x in [0, 8191], count in )

#define HK_PREPROCESSOR_SHL(x, count)           HK_PREPROCESSOR_SHL_COUNT_##count(x)

//
//  Macro that returns A | B bitwise, 16 bits (values in [0, 8191])

#define HK_PREPROCESSOR_BITWISE_OR(x, y)            HK_PREPROCESSOR_BITWISE_OR_16_BITS(x, y)
#define HK_PREPROCESSOR_BITWISE_OR_3(x, y, z)       HK_PREPROCESSOR_BITWISE_OR(HK_PREPROCESSOR_BITWISE_OR(x, y), z)
#define HK_PREPROCESSOR_BITWISE_OR_4(x, y, z, w)    HK_PREPROCESSOR_BITWISE_OR(HK_PREPROCESSOR_BITWISE_OR(x, y), HK_PREPROCESSOR_BITWISE_OR(z, w))

//
//  Macro that returns A & B bitiwise, 16 bits (values in [0, 8191])

#define HK_PREPROCESSOR_BITWISE_AND(x, y)           HK_PREPROCESSOR_BITWISE_AND_16_BITS(x, y)

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
