// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL !REFLECT
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/PreProcessor/Values/hkPreProcessorBool.h>
#include <Common/Base/PreProcessor/Values/hkPreProcessorFor.h>

//
//  Macro to convert an int number into a bool value.
//  x must be in [0, 31], or [0, 8191] if hkPreProcessorBoolExtra.h is included.

#define HK_PREPROCESSOR_BOOL(x) HK_PREPROCESSOR_BOOL_##x

//
//  Macro that conditionally selects t or f based on x, i.e. (x ? t : f).
//  x must be in [0, 31], or [0, 8191] if hkPreProcessorBoolExtra.h is included.

#define HK_PREPROCESSOR_EVAL_IF(boolX, t, f)        HK_PREPROCESSOR_TEMP_IF(boolX, t, f)
#define HK_PREPROCESSOR_IF(x, t, f)                 HK_PREPROCESSOR_EVAL_IF(HK_PREPROCESSOR_BOOL(x), t, f)


// Macro that iterates over a variadic list of arguments calling the macro 'action' on all of them.
// The second argument must be present and is called 'data'. The subsequent arguments are looped over.
// This 'data' is user-defined and will be passed as is to the 'action' macro. If unused you can simply pass _
// The 'action' macro must have the following prototype: ACTION(I, D, X) with:
//   - I the iteration number (starting at NUM_ARGS, counting down to 1)
//   - D the data given to HK_FOR_EACH
//   - X an element of the argument list
// Max 20 arguments.

#define HK_PP_FOR_EACH(action, ...)     HK_DETAIL_FOR_EACH(action, __VA_ARGS__)

/// Expands into "action(NUM-1) action(NUM-2) ... action(0)" (NUM in [0, 32]).
#define HK_PP_FOR(NUM, action)          HK_DETAIL_FOR_ ## NUM (action)

/// Expands into a comma if I != 0. Use with HK_PP_FOR/HK_PP_FOREACH.
#define HK_PP_COMMA_IF(I)               HK_DETAIL_COMMA_IF( HK_PREPROCESSOR_BOOL(I) )

/// Consume and ignore any arguments
#define HK_PP_IGNORE_ARGS(...)

/// Empty preprocessor token for passing an empty value to a macro
#define HK_PP_EMPTY

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
