// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL !REFLECT
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

// Macro that returns the number of arguments minus 1 in a variadic argument list
#define HK_DETAIL_NUM_ARGS_MINUS1(...) HK_DETAIL_NUM_ARGS1((__VA_ARGS__,20,19,18,17,16,15,14,13,12,11,10,9,8,7,6,5,4,3,2,1,0))
#define HK_DETAIL_NUM_ARGS1(tuple) HK_DETAIL_NUM_ARGS2 tuple
#define HK_DETAIL_NUM_ARGS2(_0,_1,_2,_3,_4,_5,_6,_7,_8,_9,_10,_11,_12,_13,_14,_15,_16,_17,_18,_19,_20,N,...) N


// Macro that concatenates 'macro' with the number of variadic arguments given (HK_DETAIL0_GET_MACRO(MACRO, a, b, c) expands to MACRO3)
// This would be written HK_DETAIL_GET_MACRO(macro, ...) except that empty varargs are not allowed.
#define HK_DETAIL_GET_MACRO(...) HK_DETAIL_GET_MACRO1( HK_DETAIL_FIRST(__VA_ARGS__), HK_DETAIL_NUM_ARGS_MINUS1(__VA_ARGS__))
#define HK_DETAIL_GET_MACRO1(macro, nargs) HK_DETAIL_GET_MACRO2(macro, nargs)
#define HK_DETAIL_GET_MACRO2(macro, nargs) HK_DETAIL_GET_MACRO3(macro, nargs)
#define HK_DETAIL_GET_MACRO3(macro, nargs) macro ## nargs

#if defined(HK_COMPILER_MSVC)
    // MSVC has a couple of bugs in its preprocessor which can be workaround by adding an intermediate layer.
    // This is this macro's sole purpose. It will expand the given macro with the given args (HK_CALL_MACRO(MACRO, (a,b,c)) -> MACRO(a,b,c))
    #define HK_DETAIL_CALL_MACRO(macro, args) macro args

    // Set of macros that implement the FOR_EACH behavior by removing one argument of the vararg list, call the WHAT macro on it and calling the N-1 macro.
    // Note that the first argument is ignored (it is the "data" argument which is passed around)
    #define HK_DETAIL_FE_1(WHAT, DATA)
    #define HK_DETAIL_FE_2(WHAT, DATA, X)       WHAT(1, DATA, X)
    #define HK_DETAIL_FE_3(WHAT, DATA, X, ...)  WHAT(2, DATA, X) HK_DETAIL_CALL_MACRO(HK_DETAIL_FE_2, (WHAT, DATA, __VA_ARGS__))
    #define HK_DETAIL_FE_4(WHAT, DATA, X, ...)  WHAT(3, DATA, X) HK_DETAIL_CALL_MACRO(HK_DETAIL_FE_3, (WHAT, DATA, __VA_ARGS__))
    #define HK_DETAIL_FE_5(WHAT, DATA, X, ...)  WHAT(4, DATA, X) HK_DETAIL_CALL_MACRO(HK_DETAIL_FE_4, (WHAT, DATA, __VA_ARGS__))
    #define HK_DETAIL_FE_6(WHAT, DATA, X, ...)  WHAT(5, DATA, X) HK_DETAIL_CALL_MACRO(HK_DETAIL_FE_5, (WHAT, DATA, __VA_ARGS__))
    #define HK_DETAIL_FE_7(WHAT, DATA, X, ...)  WHAT(6, DATA, X) HK_DETAIL_CALL_MACRO(HK_DETAIL_FE_6, (WHAT, DATA, __VA_ARGS__))
    #define HK_DETAIL_FE_8(WHAT, DATA, X, ...)  WHAT(7, DATA, X) HK_DETAIL_CALL_MACRO(HK_DETAIL_FE_7, (WHAT, DATA, __VA_ARGS__))
    #define HK_DETAIL_FE_9(WHAT, DATA, X, ...)  WHAT(8, DATA, X) HK_DETAIL_CALL_MACRO(HK_DETAIL_FE_8, (WHAT, DATA, __VA_ARGS__))
    #define HK_DETAIL_FE_10(WHAT, DATA, X, ...) WHAT(9, DATA, X) HK_DETAIL_CALL_MACRO(HK_DETAIL_FE_9, (WHAT, DATA, __VA_ARGS__))
    #define HK_DETAIL_FE_11(WHAT, DATA, X, ...) WHAT(10, DATA, X) HK_DETAIL_CALL_MACRO(HK_DETAIL_FE_10, (WHAT, DATA, __VA_ARGS__))
    #define HK_DETAIL_FE_12(WHAT, DATA, X, ...) WHAT(11, DATA, X) HK_DETAIL_CALL_MACRO(HK_DETAIL_FE_11, (WHAT, DATA, __VA_ARGS__))
    #define HK_DETAIL_FE_13(WHAT, DATA, X, ...) WHAT(12, DATA, X) HK_DETAIL_CALL_MACRO(HK_DETAIL_FE_12, (WHAT, DATA, __VA_ARGS__))
    #define HK_DETAIL_FE_14(WHAT, DATA, X, ...) WHAT(13, DATA, X) HK_DETAIL_CALL_MACRO(HK_DETAIL_FE_13, (WHAT, DATA, __VA_ARGS__))
    #define HK_DETAIL_FE_15(WHAT, DATA, X, ...) WHAT(14, DATA, X) HK_DETAIL_CALL_MACRO(HK_DETAIL_FE_14, (WHAT, DATA, __VA_ARGS__))
    #define HK_DETAIL_FE_16(WHAT, DATA, X, ...) WHAT(15, DATA, X) HK_DETAIL_CALL_MACRO(HK_DETAIL_FE_15, (WHAT, DATA, __VA_ARGS__))
    #define HK_DETAIL_FE_17(WHAT, DATA, X, ...) WHAT(16, DATA, X) HK_DETAIL_CALL_MACRO(HK_DETAIL_FE_16, (WHAT, DATA, __VA_ARGS__))
    #define HK_DETAIL_FE_18(WHAT, DATA, X, ...) WHAT(17, DATA, X) HK_DETAIL_CALL_MACRO(HK_DETAIL_FE_17, (WHAT, DATA, __VA_ARGS__))
    #define HK_DETAIL_FE_19(WHAT, DATA, X, ...) WHAT(18, DATA, X) HK_DETAIL_CALL_MACRO(HK_DETAIL_FE_18, (WHAT, DATA, __VA_ARGS__))
    #define HK_DETAIL_FE_20(WHAT, DATA, X, ...) WHAT(19, DATA, X) HK_DETAIL_CALL_MACRO(HK_DETAIL_FE_19, (WHAT, DATA, __VA_ARGS__))

    // Implementation of the HK_FOR_EACH macro.
    #define HK_DETAIL_FOR_EACH(action, ...) \
        HK_DETAIL_CALL_MACRO(HK_DETAIL_GET_MACRO(HK_DETAIL_FE_, __VA_ARGS__), (action, __VA_ARGS__))

    #define HK_DETAIL_FIRST2(FIRST, ...) FIRST
    #define HK_DETAIL_FIRST(...) HK_DETAIL_CALL_MACRO(HK_DETAIL_FIRST2, (__VA_ARGS__))
    #define HK_DETAIL_REST2(FIRST, ...) __VA_ARGS__
    #define HK_DETAIL_REST(...) HK_DETAIL_CALL_MACRO(HK_DETAIL_REST2, (__VA_ARGS__))

    /// Call MACRO# with the given arguments, where # is the number of arguments.
    /// e.g. HK_PP_CALL_OVERLOAD(FOO, a, b) == FOO2(a,b)
    #define HK_PP_CALL_OVERLOAD(MACRO,...) HK_DETAIL_CALL_MACRO(HK_DETAIL_GET_MACRO(MACRO,__VA_ARGS__), (__VA_ARGS__))

#else

    // Set of macros that implement the FOR_EACH behavior by removing one argument of the vararg list, call the WHAT macro on it and calling the N-1 macro.
    // Note that the first argument is ignored (it is the "data" argument which is passed around)
    #define HK_DETAIL_FE_1(WHAT, DATA)
    #define HK_DETAIL_FE_2(WHAT, DATA, X)       WHAT(1, DATA, X)
    #define HK_DETAIL_FE_3(WHAT, DATA, X, ...)  WHAT(2, DATA, X) HK_DETAIL_FE_2(WHAT, DATA, __VA_ARGS__)
    #define HK_DETAIL_FE_4(WHAT, DATA, X, ...)  WHAT(3, DATA, X) HK_DETAIL_FE_3(WHAT, DATA, __VA_ARGS__)
    #define HK_DETAIL_FE_5(WHAT, DATA, X, ...)  WHAT(4, DATA, X) HK_DETAIL_FE_4(WHAT, DATA, __VA_ARGS__)
    #define HK_DETAIL_FE_6(WHAT, DATA, X, ...)  WHAT(5, DATA, X) HK_DETAIL_FE_5(WHAT, DATA, __VA_ARGS__)
    #define HK_DETAIL_FE_7(WHAT, DATA, X, ...)  WHAT(6, DATA, X) HK_DETAIL_FE_6(WHAT, DATA, __VA_ARGS__)
    #define HK_DETAIL_FE_8(WHAT, DATA, X, ...)  WHAT(7, DATA, X) HK_DETAIL_FE_7(WHAT, DATA, __VA_ARGS__)
    #define HK_DETAIL_FE_9(WHAT, DATA, X, ...)  WHAT(8, DATA, X) HK_DETAIL_FE_8(WHAT, DATA, __VA_ARGS__)
    #define HK_DETAIL_FE_10(WHAT, DATA, X, ...) WHAT(9, DATA, X) HK_DETAIL_FE_9(WHAT, DATA, __VA_ARGS__)
    #define HK_DETAIL_FE_11(WHAT, DATA, X, ...) WHAT(10, DATA, X) HK_DETAIL_FE_10(WHAT, DATA, __VA_ARGS__)
    #define HK_DETAIL_FE_12(WHAT, DATA, X, ...) WHAT(11, DATA, X) HK_DETAIL_FE_11(WHAT, DATA, __VA_ARGS__)
    #define HK_DETAIL_FE_13(WHAT, DATA, X, ...) WHAT(12, DATA, X) HK_DETAIL_FE_12(WHAT, DATA, __VA_ARGS__)
    #define HK_DETAIL_FE_14(WHAT, DATA, X, ...) WHAT(13, DATA, X) HK_DETAIL_FE_13(WHAT, DATA, __VA_ARGS__)
    #define HK_DETAIL_FE_15(WHAT, DATA, X, ...) WHAT(14, DATA, X) HK_DETAIL_FE_14(WHAT, DATA, __VA_ARGS__)
    #define HK_DETAIL_FE_16(WHAT, DATA, X, ...) WHAT(15, DATA, X) HK_DETAIL_FE_15(WHAT, DATA, __VA_ARGS__)
    #define HK_DETAIL_FE_17(WHAT, DATA, X, ...) WHAT(16, DATA, X) HK_DETAIL_FE_16(WHAT, DATA, __VA_ARGS__)
    #define HK_DETAIL_FE_18(WHAT, DATA, X, ...) WHAT(17, DATA, X) HK_DETAIL_FE_17(WHAT, DATA, __VA_ARGS__)
    #define HK_DETAIL_FE_19(WHAT, DATA, X, ...) WHAT(18, DATA, X) HK_DETAIL_FE_18(WHAT, DATA, __VA_ARGS__)
    #define HK_DETAIL_FE_20(WHAT, DATA, X, ...) WHAT(19, DATA, X) HK_DETAIL_FE_19(WHAT, DATA, __VA_ARGS__)

    //
    // Implementation of the HK_FOR_EACH macro.
    #define HK_DETAIL_FOR_EACH(action, ...) \
        HK_DETAIL_GET_MACRO(HK_DETAIL_FE_, __VA_ARGS__)(action, __VA_ARGS__)

    #define HK_DETAIL_FIRST(FIRST, ...) FIRST
    #define HK_DETAIL_REST(FIRST, ...) __VA_ARGS__

    /// Call MACRO# with the given arguments, where # is the number of arguments.
    /// e.g. HK_PP_CALL_OVERLOAD(FOO, a, b) == FOO2(a,b)
    #define HK_PP_CALL_OVERLOAD(MACRO,...) HK_DETAIL_GET_MACRO(MACRO,__VA_ARGS__)(__VA_ARGS__)

#endif

#define HK_DETAIL_FOR_0(action)
#define HK_DETAIL_FOR_1(action) action(0)
#define HK_DETAIL_FOR_2(action) action(1) HK_DETAIL_FOR_1(action)
#define HK_DETAIL_FOR_3(action) action(2) HK_DETAIL_FOR_2(action)
#define HK_DETAIL_FOR_4(action) action(3) HK_DETAIL_FOR_3(action)
#define HK_DETAIL_FOR_5(action) action(4) HK_DETAIL_FOR_4(action)
#define HK_DETAIL_FOR_6(action) action(5) HK_DETAIL_FOR_5(action)
#define HK_DETAIL_FOR_7(action) action(6) HK_DETAIL_FOR_6(action)
#define HK_DETAIL_FOR_8(action) action(7) HK_DETAIL_FOR_7(action)
#define HK_DETAIL_FOR_9(action) action(8) HK_DETAIL_FOR_8(action)
#define HK_DETAIL_FOR_10(action) action(9) HK_DETAIL_FOR_9(action)
#define HK_DETAIL_FOR_11(action) action(10) HK_DETAIL_FOR_10(action)
#define HK_DETAIL_FOR_12(action) action(11) HK_DETAIL_FOR_11(action)
#define HK_DETAIL_FOR_13(action) action(12) HK_DETAIL_FOR_12(action)
#define HK_DETAIL_FOR_14(action) action(13) HK_DETAIL_FOR_13(action)
#define HK_DETAIL_FOR_15(action) action(14) HK_DETAIL_FOR_14(action)
#define HK_DETAIL_FOR_16(action) action(15) HK_DETAIL_FOR_15(action)
#define HK_DETAIL_FOR_17(action) action(16) HK_DETAIL_FOR_16(action)
#define HK_DETAIL_FOR_18(action) action(17) HK_DETAIL_FOR_17(action)
#define HK_DETAIL_FOR_19(action) action(18) HK_DETAIL_FOR_18(action)
#define HK_DETAIL_FOR_20(action) action(19) HK_DETAIL_FOR_19(action)
#define HK_DETAIL_FOR_21(action) action(20) HK_DETAIL_FOR_20(action)
#define HK_DETAIL_FOR_22(action) action(21) HK_DETAIL_FOR_21(action)
#define HK_DETAIL_FOR_23(action) action(22) HK_DETAIL_FOR_22(action)
#define HK_DETAIL_FOR_24(action) action(23) HK_DETAIL_FOR_23(action)
#define HK_DETAIL_FOR_25(action) action(24) HK_DETAIL_FOR_24(action)
#define HK_DETAIL_FOR_26(action) action(25) HK_DETAIL_FOR_25(action)
#define HK_DETAIL_FOR_27(action) action(26) HK_DETAIL_FOR_26(action)
#define HK_DETAIL_FOR_28(action) action(27) HK_DETAIL_FOR_27(action)
#define HK_DETAIL_FOR_29(action) action(28) HK_DETAIL_FOR_28(action)
#define HK_DETAIL_FOR_30(action) action(29) HK_DETAIL_FOR_29(action)
#define HK_DETAIL_FOR_31(action) action(30) HK_DETAIL_FOR_30(action)
#define HK_DETAIL_FOR_32(action) action(31) HK_DETAIL_FOR_31(action)
#define HK_DETAIL_FOR_33(action) action(32) HK_DETAIL_FOR_32(action)
#define HK_DETAIL_FOR_34(action) action(33) HK_DETAIL_FOR_33(action)
#define HK_DETAIL_FOR_35(action) action(34) HK_DETAIL_FOR_34(action)
#define HK_DETAIL_FOR_36(action) action(35) HK_DETAIL_FOR_35(action)
#define HK_DETAIL_FOR_37(action) action(36) HK_DETAIL_FOR_36(action)
#define HK_DETAIL_FOR_38(action) action(37) HK_DETAIL_FOR_37(action)
#define HK_DETAIL_FOR_39(action) action(38) HK_DETAIL_FOR_38(action)
#define HK_DETAIL_FOR_40(action) action(39) HK_DETAIL_FOR_39(action)
#define HK_DETAIL_FOR_41(action) action(40) HK_DETAIL_FOR_40(action)

#define HK_DETAIL_COMMA_IF(B) HK_PREPROCESSOR_JOIN_TOKEN(HK_DETAIL_COMMA_IF_, B)
#define HK_DETAIL_COMMA_IF_0
#define HK_DETAIL_COMMA_IF_1 ,

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
