// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/Base/System/hkBaseSystem.h>

namespace hkSingletonUtil
{
        /// Singleton initialization function. Initialize singleton with an instance of DERIVED.
    template<typename BASE, typename DERIVED>
    static hkResult HK_CALL initWith(_Inout_ hkRefPtr<BASE>* ptr)
    {
        // null check to allow custom replacement of singletons before init called.
        if(*ptr == HK_NULL)
        {
            ptr->setAndDontIncrementRefCount(new DERIVED());
        }
        return HK_SUCCESS;
    }

        /// Default singleton initialization function. Initialize singleton with an instance of T.
    template<typename T>
    static hkResult HK_CALL init(_Inout_ hkRefPtr<T>* ptr)
    {
        return initWith<T,T>(ptr);
    }

        /// Default singleton quit function, resets the singleton pointer (and removes a reference).
    template<typename T>
    static hkResult HK_CALL quit(_Inout_ hkRefPtr<T>* ptr)
    {
        // hkRefPtr<T>::operator=(TYPE*val) sets m_ptr to val just after remove reference occures (in this case refCount=1),
        // thus if during singleton destructor there is a call to T::getInstancePtr() it will return valid pointer.
        // To prevent such behavior copy is created, then ptr (T::singletonEntry) is set to NULL,
        // thus T::getInstancePtr() will return NULL during the singleton's destructuin, and finally
        // destructor is called.
        
        hkRefPtr<T> copy = *ptr;
        *ptr = HK_NULL;
        copy = HK_NULL;
        return HK_SUCCESS;
    }
}

/// Create a singleton which will be automatically initialized and quit.
#define HK_SINGLETON_IMPLEMENTATION(SINGLETON) \
    HK_SINGLETON_MANUAL_IMPLEMENTATION(SINGLETON, &hkSingletonUtil::init<SINGLETON>, &hkSingletonUtil::quit<SINGLETON> )

/// Create a singleton which will be automatically initialized with an instance of SUBCLASS and automatically quit.
#define HK_SINGLETON_SUBCLASS_IMPLEMENTATION(SINGLETON, SUBCLASS) \
    HK_SINGLETON_MANUAL_IMPLEMENTATION(SINGLETON, (&hkSingletonUtil::initWith<SINGLETON, SUBCLASS>), &hkSingletonUtil::quit<SINGLETON> )

/// Create a singleton with custom initialize and quit functions.
/// Use HK_NULL INIT/QUIT if you want to initialize/quit your singleton manually.
#define HK_SINGLETON_MANUAL_IMPLEMENTATION(SINGLETON, INIT, QUIT) \
    hkBaseSystem::Detail::RefPtrNoDtor<SINGLETON> SINGLETON::singleton; \
    hkBaseSystem::InitNode SINGLETON::singletonEntry( "$"#SINGLETON, INIT, QUIT, static_cast<hkRefPtr<SINGLETON>*>(&SINGLETON::singleton) )

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
