// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/Base/Container/Hash/hkHashSet.h>
#include <Common/Base/Thread/CriticalSection/hkCriticalSection.h>

/// The hkReferencedObjectRegistry manages pointer fix-up when objects are replaced (e.g. on reload or when a hkeRule needs to create an output of different type).
class HK_EXPORT_COMMON hkReferencedObjectRegistry
{
    public:

        HK_DECLARE_CLASS(hkReferencedObjectRegistry, New);

        hkReferencedObjectRegistry() {}
        virtual ~hkReferencedObjectRegistry() {}

        /// Register an object so its pointers are fixed up when an object is replaced.
        static void registerObject(_In_ hkReferencedObject* obj);

        /// Unregister an object.
        static void unregisterObject(_In_ hkReferencedObject* obj);

    public:
        static void replaceInstance(_In_ hkReferencedObjectRegistry* inst);
        _Ret_notnull_
        static hkReferencedObjectRegistry* getInstancePtr() { return s_instance; }

    protected:

        friend class hkReferencedObject;

        static hkReferencedObjectRegistry* s_instance;

        void registerObjectInternal(_In_ hkReferencedObject* obj);
        void unregisterObjectInternal(_In_ hkReferencedObject* obj);

        hkCriticalSection m_cs;
        hkHashSet<hkReferencedObject*> m_objects;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
