// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

HK_INLINE hk_size_t hkMemoryRouter::numBytesToFree(_In_ const hkReferencedObject* obj, hk_size_t nbytes)
{
    return (obj->getMemorySizeAndFlags() == hkReferencedObject::AUTO_MEMSIZE)
        ? nbytes
        : obj->getMemorySizeAndFlags();
}

HK_INLINE hkReferencedObject::hkReferencedObject()
:   m_memSizeAndFlags(0xFFFF)
,   m_refCount(1)
{}

HK_INLINE hkReferencedObject::hkReferencedObject( const hkReferencedObject& originalObject )
:   hkBaseObject()
,   m_propertyBag(originalObject.m_propertyBag)
,   m_memSizeAndFlags(0xFFFF)
,   m_refCount(1)
{
}

HK_INLINE void hkReferencedObject::operator=( const hkReferencedObject& originalObject )
{
    m_propertyBag = originalObject.m_propertyBag;
}

HK_INLINE int hkReferencedObject::getReferenceCount() const
{
    return m_refCount;
}

HK_INLINE int hkReferencedObject::getMemorySizeAndFlags() const
{
    return m_memSizeAndFlags;
}

HK_INLINE int hkReferencedObject::getAllocatedSize() const
{
    return m_memSizeAndFlags & 0x7FFF;
}

//
//  Sets the memory size and flags

inline void hkReferencedObject::setMemorySizeAndFlags(int newMemSizeAndFlags)
{
    HK_ASSERT_NO_MSG( 0xf0fcdfde, newMemSizeAndFlags <= 0xffff );
    m_memSizeAndFlags = hkUint16(newMemSizeAndFlags);
}

//
//  Sets the reference count

inline void hkReferencedObject::setReferenceCount(int newRefCount)
{
    HK_ASSERT_NO_MSG( 0xf0fcdfdf, newRefCount < 0xffff );
    m_refCount = (hkUint16) newRefCount;
}

//
// Sets the memory size, flags and reference count, no need for atomic here since we can only call this
// function if we are the only owner. (This function is not thread safe.
inline void hkReferencedObject::setMemorySizeFlagsAndReferenceCount(int newMemSizeAndFlags, int newRefCount)
{
    setMemorySizeAndFlags(newMemSizeAndFlags);
    setReferenceCount(newRefCount);
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
