// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#if defined(HK_PLATFORM_PSP)
#   include <psptypes.h>
#   include <kernel.h>
#elif defined(HK_PLATFORM_CTR) || defined(HK_PLATFORM_NX)
#   include <nn/os/os_Tick.h>
#elif defined(HK_PLATFORM_ANDROID) || defined(HK_PLATFORM_NACL) || defined(HK_PLATFORM_TIZEN)
#   include <time.h>
#endif

#if defined (HK_PLATFORM_WIN32) && defined(HK_ARCH_X64)
extern "C" {
    unsigned __int64 __rdtsc (void);
    #pragma intrinsic(__rdtsc)
}
#endif

#ifndef __GCCXML__
#   ifdef HK_PLATFORM_IOS
#       include <mach/mach_time.h>
#   elif defined(HK_PLATFORM_MAC)
#       include <Kernel/mach/mach_time.h>
#   elif defined(HK_PLATFORM_PSVITA)
#       include <kernel/processmgr.h>
#   elif defined(HK_PLATFORM_WINRT) && defined(HK_ARCH_ARM_64)
#       ifndef _ARM64_
#           define _ARM64_
#       endif
#       include <profileapi.h> 
#   elif defined(HK_PLATFORM_WINRT) && defined(HK_ARCH_ARM)
#       ifndef _ARM_
#           define _ARM_
#       endif
#       include <profileapi.h> 
#   elif defined(HK_SUPPORT_DWM) && defined(HK_ARCH_IA32)
#       include <profileapi.h> 
#   endif
#endif

#if (defined(HK_COMPILER_GCC) || defined(HK_COMPILER_CLANG)) && (defined(HK_ARCH_IA32) || defined(HK_ARCH_X64))
#   include <x86intrin.h>
#endif

void hkMonitorStream::TimerCommand::setTime()
{
#if defined(HK_ARCH_IA32) && !defined(HK_PLATFORM_NACL) && !defined(HK_SUPPORT_DWM) && !defined(HK_PLATFORM_NX)
#   if defined(HK_COMPILER_GCC) || defined(HK_COMPILER_CLANG)
        #if HK_ENABLE_64BIT_TIMERS
            m_time0 = __rdtsc();
        #else
            m_time0 = __rdtsc() & 0xffffffff;
        #endif
#   else
        TimerValue ticks;
        __asm {
            //push ebx
            //cpuid
            //pop ebx
            rdtsc
            mov dword ptr[ticks], eax
#       if HK_ENABLE_64BIT_TIMERS
            mov dword ptr[ticks+4], edx
#       endif
        }
        m_time0 = ticks;
#   endif

#elif defined( HK_PLATFORM_PSP )

// fill in with the correct performance counter info when available
// for now we will use the system timing data ( accurate to 1 microsecond )
    m_time0 = sceKernelGetSystemTimeLow();

#elif defined(HK_PLATFORM_WIIU)
    m_time0 = __MFTB();
#elif defined(HK_PLATFORM_PSVITA)
    //SceRtcTick tick;
    //sceRtcGetCurrentTick(&tick);
    //m_time0 = static_cast<hkUint32>( tick.tick );

    //__builtin_mcr(15,0,0,12,15);
    //m_time0 = __builtin_mrc(15,0,9,13,2);

    m_time0 = sceKernelGetProcessTimeLow();

#elif defined(HK_ARCH_X64) && !defined(HK_PLATFORM_NACL) && !defined(HK_PLATFORM_IOS) && !defined(HK_PLATFORM_NX)
#   if defined(HK_PLATFORM_WIN32)
#       if HK_ENABLE_64BIT_TIMERS
        m_time0 = static_cast<TimerValue>( __rdtsc() );
#       else
        m_time0 = static_cast<TimerValue>( __rdtsc() & 0xffffffff );
#       endif
#   elif defined(HK_PLATFORM_PS4)
        m_time0 = __builtin_readcyclecounter();
#   else
#       if HK_ENABLE_64BIT_TIMERS
            m_time0 = __rdtsc();
#       else
            m_time0 = __rdtsc() & 0xffffffff;
#       endif
#   endif
#elif !defined(__GCCXML__) && (defined(HK_PLATFORM_IOS) || defined(HK_PLATFORM_MAC))
    m_time0 = (TimerValue) mach_absolute_time();
#elif defined(HK_PLATFORM_CTR)
    m_time0 = (hkUint64) nn::os::Tick::GetSystemCurrent();
#elif defined(HK_PLATFORM_NX)
    m_time0 = (hkMonitorStream::TimerValue) nn::os::GetSystemTick().GetInt64Value();
#elif defined(HK_PLATFORM_ANDROID) || defined(HK_PLATFORM_TIZEN)
    struct timespec now;
    clock_gettime(CLOCK_MONOTONIC, &now); //CLOCK_MONOTONIC_HR not supported on a lot of them (any?)
    m_time0 = ((hkUint64)now.tv_sec)*1000000000LL + now.tv_nsec;
#elif defined(HK_PLATFORM_NACL)
    m_time0 = 0; //CK: to come in future
#elif (defined(HK_PLATFORM_WINRT) && defined(HK_ARCH_ARM)) || (defined(HK_SUPPORT_DWM) && defined(HK_ARCH_IA32))
    //
    LARGE_INTEGER i;
    QueryPerformanceCounter(&i);
    #if HK_ENABLE_64BIT_TIMERS
        m_time0 = i.QuadPart;
    #else
        m_time0 = i.LowPart;
    #endif
#else
    m_time0 = 0;
//# error dont know how to set time
#endif
}


#define HK_MONITOR_TYPE_TIMER "t"
#define HK_MONITOR_TYPE_TIMER_DRAW_CALL "g"
#define HK_MONITOR_TYPE_SINGLE "f"
#define HK_MONITOR_TYPE_INT "i"

#define HK_MONITOR_COMMAND_FRAME_ID "Fi"

#define HK_MONITOR_COMMAND_PUSH_DIR "Pd"
#define HK_MONITOR_COMMAND_POP_DIR  "pd"

#define HK_MONITOR_COMMAND_BEGIN_TIMER "T"
#define HK_MONITOR_COMMAND_BEGIN_TIMER_AND_SELF "R"
#define HK_MONITOR_COMMAND_BEGIN_OBJECT_NAME "O"

#define HK_MONITOR_COMMAND_BEGIN_MULTI_TIMER "Y"
#define HK_MONITOR_COMMAND_END_MULTI_TIMER "W"

#define HK_MONITOR_COMMAND_END_TIMER "E"
#define HK_MONITOR_COMMAND_BEGIN_LIST "L"
#define HK_MONITOR_COMMAND_SPLIT_LIST "S"
#define HK_MONITOR_COMMAND_END_LIST "l"

#define HK_MONITOR_COMMAND_ADD_TAG "X"
#define HK_MONITOR_COMMAND_GOTO_TAG "G" // tag = 0 implies exit

#define HK_MONITOR_COMMAND_ADD_VALUE "M"

#define HK_MONITOR_COMMAND_ADD_STRUCT "As"

#define HK_MONITOR_COMMAND_ADD_DRAW_CALL_HANDLE "H"

//#define HK_MONITOR_COMMAND_MEMORY_* "m" // m* tags reserved for memory

#define HK_MONITOR_COMMAND_PAUSE "Qp"
#define HK_MONITOR_COMMAND_UNPAUSE "Qu"

#define HK_MONITOR_COMMAND_NOP "N" // nops added when monitor stream transfers have to be of certain alignment (eg: on SPUs)

#if HK_CONFIG_MONITORS == HK_CONFIG_MONITORS_ENABLED

#   define HK_ON_MONITORS_ENABLED( code ) code

#   define HK_TIMER_BEGIN_INTERN( STREAM, NAME, COMMAND, OBJECT ) { \
    if ( HK_VERY_UNLIKELY((STREAM) && (STREAM)->memoryAvailable()) ) \
    { \
        (STREAM)->platformBeginEvent(NAME); \
        hkMonitorStream::TimerCommand* HK_RESTRICT h = reinterpret_cast<hkMonitorStream::TimerCommand*>((STREAM)->getEnd()); \
        h->m_commandAndMonitor = COMMAND HK_MONITOR_TYPE_TIMER NAME; \
        h->setTime(); \
        (STREAM)->setEnd( (char*)(h+1) ); \
    } }

#   define HK_TIMER_END_INTERN( STREAM, NAME, COMMAND, OBJECT ) { \
    if ( HK_VERY_UNLIKELY((STREAM) && (STREAM)->memoryAvailable()) ) \
    { \
        hkMonitorStream::TimerCommand* HK_RESTRICT h = reinterpret_cast<hkMonitorStream::TimerCommand*>((STREAM)->getEnd()); \
        h->m_commandAndMonitor = COMMAND HK_MONITOR_TYPE_TIMER NAME; \
        h->setTime(); \
        (STREAM)->setEnd( (char*)(h+1) ); \
        (STREAM)->platformEndEvent(); \
    } }

#   define HK_TIMER_BEGIN_OBJECT_NAME_INTERN(STREAM, OBJECT_NAME) { \
    if ( HK_VERY_UNLIKELY((STREAM) && (STREAM)->memoryAvailable()) ) \
    { \
        (STREAM)->platformBeginEvent(OBJECT_NAME); \
        hkUint16 _size = (hkUint16)hkString::strLen(OBJECT_NAME) + 1; \
        hkMonitorStream::TimerBeginObjectNameCommand* HK_RESTRICT h = reinterpret_cast<hkMonitorStream::TimerBeginObjectNameCommand*>((STREAM)->getEnd()); \
        h->m_commandAndMonitor = HK_MONITOR_COMMAND_BEGIN_OBJECT_NAME HK_MONITOR_TYPE_TIMER; \
        h->m_objectNameSize = _size; \
        h->setTime(); \
        hkMemUtil::memCpy( (char*)(h+1), OBJECT_NAME, _size ); \
        (STREAM)->setEnd( (char*)(h+1) + _size ); \
        (STREAM)->padEnd(); \
    } }

#   define HK_TIMER_BEGIN_LIST_INTERN( STREAM, NAME1, NAME2, COMMAND, OBJECT ) { \
    if ( HK_VERY_UNLIKELY((STREAM) && (STREAM)->memoryAvailable()) ) \
    { \
        (STREAM)->platformBeginEvent(NAME1); \
        (STREAM)->platformBeginEvent(NAME2); \
        hkMonitorStream::TimerBeginListCommand* HK_RESTRICT h = reinterpret_cast<hkMonitorStream::TimerBeginListCommand*>((STREAM)->getEnd()); \
        h->m_commandAndMonitor = COMMAND HK_MONITOR_TYPE_TIMER NAME1; \
        h->m_nameOfFirstSplit = HK_MONITOR_COMMAND_SPLIT_LIST HK_MONITOR_TYPE_TIMER NAME2; \
        h->setTime(); \
        (STREAM)->setEnd( (char*)(h+1) ); \
    } }

#   define HK_TIMER_SPLIT_LIST_INTERN( STREAM, NAME, COMMAND, OBJECT ) { \
    if ( HK_VERY_UNLIKELY((STREAM) && (STREAM)->memoryAvailable()) ) \
    { \
        hkMonitorStream::TimerCommand* HK_RESTRICT h = reinterpret_cast<hkMonitorStream::TimerCommand*>((STREAM)->getEnd()); \
        h->m_commandAndMonitor = COMMAND HK_MONITOR_TYPE_TIMER NAME; \
        h->setTime(); \
        (STREAM)->setEnd( (char*)(h+1) ); \
        (STREAM)->platformEndEvent(); \
        (STREAM)->platformBeginEvent(NAME); \
    } }

#   define HK_TIMER_END_LIST_INTERN( STREAM, NAME, COMMAND, OBJECT ) { \
    if ( HK_VERY_UNLIKELY((STREAM) && (STREAM)->memoryAvailable()) ) \
    { \
        hkMonitorStream::TimerCommand* HK_RESTRICT h = reinterpret_cast<hkMonitorStream::TimerCommand*>((STREAM)->getEnd()); \
        h->m_commandAndMonitor = COMMAND HK_MONITOR_TYPE_TIMER NAME; \
        h->setTime(); \
        (STREAM)->setEnd( (char*)(h+1) ); \
        (STREAM)->platformEndEvent(); \
        (STREAM)->platformEndEvent(); \
    } }

#   define HK_TIMER_DRAW_CALL_BEGIN_INTERN( STREAM, NAME, COMMAND, GPU_HANDLE ) { \
        if ( (STREAM) && (STREAM)->memoryAvailable() ) \
        { \
            (STREAM)->platformBeginEvent(NAME); \
            hkMonitorStream::TimerDrawCallCommand* HK_RESTRICT h = reinterpret_cast<hkMonitorStream::TimerDrawCallCommand*>((STREAM)->getEnd());    \
            h->m_commandAndMonitor = COMMAND HK_MONITOR_TYPE_TIMER_DRAW_CALL NAME; \
            h->setTime(); \
            h->m_gpuHandle = GPU_HANDLE; \
            (STREAM)->setEnd( (char*)(h+1) ); \
        } }

#   define HK_TIMER_DRAW_CALL_END_INTERN( STREAM, NAME, COMMAND, GPU_HANDLE ) { \
        if ( (STREAM) && (STREAM)->memoryAvailable() ) \
        { \
            hkMonitorStream::TimerDrawCallCommand* HK_RESTRICT h = reinterpret_cast<hkMonitorStream::TimerDrawCallCommand*>((STREAM)->getEnd());    \
            h->m_commandAndMonitor = COMMAND HK_MONITOR_TYPE_TIMER_DRAW_CALL NAME; \
            h->setTime(); \
            h->m_gpuHandle = GPU_HANDLE; \
            (STREAM)->setEnd( (char*)(h+1) ); \
            (STREAM)->platformEndEvent(); \
        } }

#   define HK_MONITOR_ADD_FRAME_ID_INTERN( STREAM ) { \
        if ( (STREAM) && (STREAM)->memoryAvailable() ) \
        { \
            hkMonitorStream::FrameIdCommand* HK_RESTRICT h = reinterpret_cast<hkMonitorStream::FrameIdCommand*>((STREAM)->getEnd()); \
            h->m_commandAndMonitor = HK_MONITOR_COMMAND_FRAME_ID "FrameId" ; \
            h->m_id = (STREAM)->getCurrentFrameId();\
            (STREAM)->setEnd( (char*)(h+1) ); \
        } }

#   define HK_MONITOR_ADD_VALUE_INTERN( STREAM, NAME, VALUE, MONITOR_TYPE ) { \
        if ( (STREAM) && (STREAM)->memoryAvailable() ) \
        { \
             hkMonitorStream::AddValueCommand* HK_RESTRICT h = reinterpret_cast<hkMonitorStream::AddValueCommand*>((STREAM)->getEnd()); \
             h->m_commandAndMonitor = HK_MONITOR_COMMAND_ADD_VALUE MONITOR_TYPE NAME; \
             h->m_value = VALUE; \
             (STREAM)->setEnd( (char*)(h+1) ); \
        } }

#   define HK_MONITOR_ADD_GPU_HANDLE_INTERN( STREAM, NAME, GPU_HANDLE ) { \
        if ( (STREAM) && (STREAM)->memoryAvailable() ) \
        { \
            hkMonitorStream::AddGpuHandleCommand* HK_RESTRICT h = reinterpret_cast<hkMonitorStream::AddGpuHandleCommand*>((STREAM)->getEnd()); \
            h->m_commandAndMonitor = HK_MONITOR_COMMAND_ADD_DRAW_CALL_HANDLE NAME; \
            h->m_gpuHandle = GPU_HANDLE; \
            (STREAM)->setEnd( (char*)(h+1) ); \
        } }

#   define HK_MULTI_TIMER_BEGIN( STREAM, NAME ) { \
        if ( HK_VERY_UNLIKELY((STREAM) && (STREAM)->memoryAvailable()) ) \
        { \
            (STREAM)->platformBeginEvent(NAME); \
            hkMonitorStream::Command* HK_RESTRICT h = reinterpret_cast<hkMonitorStream::Command*>((STREAM)->getEnd()); \
            h->m_commandAndMonitor = HK_MONITOR_COMMAND_BEGIN_MULTI_TIMER HK_MONITOR_TYPE_TIMER NAME; \
            (STREAM)->setEnd( (char*)(h+1) );\
            (STREAM)->padEnd(); \
        } }

#   define HK_MULTI_TIMER_END( STREAM, NAME, DATA ) { \
        if ( HK_VERY_UNLIKELY((STREAM) && (STREAM)->memoryAvailable()) ) \
        { \
            hkMonitorStream::MultiTimerCommand* HK_RESTRICT h = reinterpret_cast<hkMonitorStream::MultiTimerCommand*>((STREAM)->getEnd()); \
            *h = (DATA); \
            h->m_timerCommand.m_commandAndMonitor = HK_MONITOR_COMMAND_END_MULTI_TIMER HK_MONITOR_TYPE_TIMER NAME; \
            (STREAM)->setEnd( (char*)(h+1) ); \
            (STREAM)->platformEndEvent(); \
        } }

#   define HK_MONITOR_MEMORY_INTERNAL(STREAM, TAG, PTR, NBYTES) { \
        if ( (STREAM) && (STREAM)->memoryAvailable() ) \
        { \
        hkMonitorStream::MemoryCommand* HK_RESTRICT h = reinterpret_cast<hkMonitorStream::MemoryCommand*>((STREAM)->getEnd()); \
            h->m_commandAndMonitor = TAG; \
            h->m_ptr = PTR; \
            h->m_sizeAndFlags = NBYTES; \
            (STREAM)->setEnd( (char*)(h+1) ); \
        } }

        template <typename T>
        void addInplace( hkMonitorStream* stream, const char* name, T** structPointer )
        {
            if (stream)
            {
                hkMonitorStream::AddStructCommand* cmd = reinterpret_cast<hkMonitorStream::AddStructCommand*>(stream->getEnd());

                // Align depending on given struct (note, size also includes alignment padding)
                T* pointer = reinterpret_cast<T*>(HK_NEXT_MULTIPLE_OF(HK_ALIGN_OF(T), hkUlong(cmd + 1)));
                int size = sizeof(hkMonitorStream::AddStructCommand) + sizeof(T) + (int)(hkUlong(pointer) - hkUlong(cmd + 1));

                if (stream->memoryAvailable(size))
                {
                    cmd->m_commandAndMonitor = name;
                    cmd->m_type = hkReflect::getType<T>().get();

                    (*structPointer) = pointer;
                    stream->setEnd((char*)(pointer)+sizeof(T));

                    stream->padEnd();
                }
            }
        }

#   define HK_MONITOR_ADD_STRUCT_INTERN( STREAM, NAME, STRUCT)  { addInplace(STREAM, HK_MONITOR_COMMAND_ADD_STRUCT NAME, STRUCT); }


#   define HK_MONITOR_PAUSE_INTERN( STREAM, NAME ) { \
        if ( (STREAM) && (STREAM)->memoryAvailable() ) \
        { \
            hkMonitorStream::TimerCommand* HK_RESTRICT h = reinterpret_cast<hkMonitorStream::TimerCommand*>((STREAM)->getEnd()); \
            h->m_commandAndMonitor = HK_MONITOR_COMMAND_PAUSE NAME; \
            h->setTime(); \
            (STREAM)->setEnd( (char*)(h+1) ); \
        } }

#   define HK_MONITOR_UNPAUSE_INTERN( STREAM ) { \
        if ( (STREAM) && (STREAM)->memoryAvailable() ) \
        { \
            hkMonitorStream::TimerCommand* HK_RESTRICT h = reinterpret_cast<hkMonitorStream::TimerCommand*>((STREAM)->getEnd()); \
            h->m_commandAndMonitor = HK_MONITOR_COMMAND_UNPAUSE; \
            h->setTime(); \
            (STREAM)->setEnd( (char*)(h+1) ); \
        } }

#   define HK_MONITOR_MEMORY_ALLOC(TAG, PTR, NBYTES) { hkMonitorStream* _mStream = hkMonitorStream::getInstancePtr(); HK_MONITOR_MEMORY_INTERNAL(_mStream, TAG,PTR,NBYTES); }
#   define HK_MONITOR_MEMORY_FREE(TAG, PTR, NBYTES)  { hkMonitorStream* _mStream = hkMonitorStream::getInstancePtr(); HK_MONITOR_MEMORY_INTERNAL(_mStream, TAG,PTR,(NBYTES)|(1<<31)); }

#   define HK_MONITOR_ADD_FRAME_ID()    {   hkMonitorStream* _mStream = hkMonitorStream::getInstancePtr(); HK_MONITOR_ADD_FRAME_ID_INTERN( _mStream ); }

#   define HK_TIMER_BEGIN( NAME, OBJECT )   {   hkMonitorStream* _mStream = hkMonitorStream::getInstancePtr(); HK_TIMER_BEGIN_INTERN( _mStream, NAME, HK_MONITOR_COMMAND_BEGIN_TIMER, OBJECT    ); }
#   define HK_TIMER_BEGIN_AND_SELF( NAME )  {   hkMonitorStream* _mStream = hkMonitorStream::getInstancePtr(); HK_TIMER_BEGIN_INTERN( _mStream, NAME, HK_MONITOR_COMMAND_BEGIN_TIMER_AND_SELF, HK_NULL  ); }
#   define HK_TIMER_BEGIN_OBJECT_NAME( OBJECT_NAME )    { hkMonitorStream* _mStream = hkMonitorStream::getInstancePtr(); HK_TIMER_BEGIN_OBJECT_NAME_INTERN( _mStream, OBJECT_NAME ); }
#   define HK_TIMER_END()                   {   hkMonitorStream* _mStream = hkMonitorStream::getInstancePtr(); HK_TIMER_END_INTERN( _mStream, "", HK_MONITOR_COMMAND_END_TIMER, HK_NULL ); }

    /// Timer end call which also checks for matching timer begin call
#   define HK_TIMER_NAMED_END( NAME )       { hkMonitorStream* _mStream = hkMonitorStream::getInstancePtr(); HK_TIMER_END_INTERN( _mStream, NAME, HK_MONITOR_COMMAND_END_TIMER, HK_NULL ); }

#   define HK_TIMER_BEGIN_LIST( NAME, FIRSTITEM )   { hkMonitorStream* _mStream = hkMonitorStream::getInstancePtr(); HK_TIMER_BEGIN_LIST_INTERN( _mStream, NAME, FIRSTITEM, HK_MONITOR_COMMAND_BEGIN_LIST, HK_NULL );}
#   define HK_TIMER_SPLIT_LIST( NEXTITEM )          { hkMonitorStream* _mStream = hkMonitorStream::getInstancePtr(); HK_TIMER_SPLIT_LIST_INTERN( _mStream, NEXTITEM, HK_MONITOR_COMMAND_SPLIT_LIST, HK_NULL );}
#   define HK_TIMER_END_LIST()                      { hkMonitorStream* _mStream = hkMonitorStream::getInstancePtr(); HK_TIMER_END_LIST_INTERN( _mStream, "", HK_MONITOR_COMMAND_END_LIST, HK_NULL );}

#   define HK_TIMER_DRAW_CALL_BEGIN( NAME, GPU_HANDLE ) { hkMonitorStream* _mStream = hkMonitorStream::getInstancePtr(); HK_TIMER_DRAW_CALL_BEGIN_INTERN( _mStream, NAME, HK_MONITOR_COMMAND_BEGIN_TIMER, GPU_HANDLE ); }
#   define HK_TIMER_DRAW_CALL_END()                     { hkMonitorStream* _mStream = hkMonitorStream::getInstancePtr(); HK_TIMER_DRAW_CALL_END_INTERN( _mStream, "", HK_MONITOR_COMMAND_END_TIMER, 0 ); }

    /// Timer end call which also checks for matching timer begin call
#   define HK_TIMER_DRAW_CALL_NAMED_END( NAME )                 { hkMonitorStream* _mStream = hkMonitorStream::getInstancePtr(); HK_TIMER_DRAW_CALL_END_INTERN( _mStream, NAME, HK_MONITOR_COMMAND_END_TIMER, 0 ); }

#   define HK_MONITOR_ADD_VALUE( NAME, VALUE, MONITOR_TYPE )    { hkMonitorStream* _mStream = hkMonitorStream::getInstancePtr(); HK_MONITOR_ADD_VALUE_INTERN( _mStream, NAME, VALUE, MONITOR_TYPE ); }

    // Name should be optional. Have a convention to add this struct after the preceding timer to instrument it
#   define HK_MONITOR_ADD_STRUCT( NAME, STRUCT )                { hkMonitorStream* _mStream = hkMonitorStream::getInstancePtr(); HK_MONITOR_ADD_STRUCT_INTERN( _mStream, NAME, STRUCT ); }

    // Inserted between HK_TIMER_BEGIN and HK_TIMER_END in case of draw call recording
#   define HK_MONITOR_ADD_GPU_HANDLE( NAME, GPU_HANDLE )        { hkMonitorStream* _mStream = hkMonitorStream::getInstancePtr(); HK_MONITOR_ADD_GPU_HANDLE_INTERN( _mStream, NAME, GPU_HANDLE ); }

#   define HK_MONITOR_PAUSE(NAME)   { hkMonitorStream* _mStream = hkMonitorStream::getInstancePtr(); HK_MONITOR_PAUSE_INTERN( _mStream, NAME ); }
#   define HK_MONITOR_UNPAUSE() { hkMonitorStream* _mStream = hkMonitorStream::getInstancePtr(); HK_MONITOR_UNPAUSE_INTERN( _mStream ); }


    //
    //  Timer calls where you pass on a stream to avoid tls lookups
    //
#   define HK_TIMER_BEGIN2( STREAM, NAME, OBJECT )          HK_TIMER_BEGIN_INTERN( STREAM, NAME, HK_MONITOR_COMMAND_BEGIN_TIMER, OBJECT )
#   define HK_TIMER_BEGIN_AND_SELF2( STREAM, NAME )         HK_TIMER_BEGIN_INTERN( STREAM, NAME, HK_MONITOR_COMMAND_BEGIN_TIMER_AND_SELF, HK_NULL   )
#   define HK_TIMER_END2( STREAM )                          HK_TIMER_END_INTERN( STREAM, "", HK_MONITOR_COMMAND_END_TIMER, HK_NULL )

    /// Timer end call which also checks for matching timer begin call
#   define HK_TIMER_NAMED_END2( STREAM, NAME )              HK_TIMER_END_INTERN( STREAM, NAME, HK_MONITOR_COMMAND_END_TIMER, HK_NULL )

#   define HK_TIMER_BEGIN_LIST2( STREAM, NAME, FIRSTITEM )  HK_TIMER_BEGIN_LIST_INTERN( STREAM, NAME, FIRSTITEM, HK_MONITOR_COMMAND_BEGIN_LIST, HK_NULL )
#   define HK_TIMER_SPLIT_LIST2( STREAM, NEXTITEM )         HK_TIMER_SPLIT_LIST_INTERN( STREAM, NEXTITEM, HK_MONITOR_COMMAND_SPLIT_LIST, HK_NULL )
#   define HK_TIMER_END_LIST2( STREAM )                     HK_TIMER_END_LIST_INTERN( STREAM, "", HK_MONITOR_COMMAND_END_LIST, HK_NULL )

#   define HK_MONITOR_ADD_VALUE2( STREAM, NAME, VALUE, MONITOR_TYPE )   HK_MONITOR_ADD_VALUE_INTERN( (STREAM), NAME, VALUE, MONITOR_TYPE )

#if !defined(__HAVOK_PARSER__) && (defined(HK_COMPILER_GCC) || defined(HK_COMPILER_SNC))
#   define HK_POSSIBLY_UNUSED __attribute__((unused))
#else
#   define HK_POSSIBLY_UNUSED
#endif

class HK_POSSIBLY_UNUSED hkTimeFunctionHelper
{
    public:
        HK_INLINE hkTimeFunctionHelper(_In_ hkMonitorStream* ptr) : m_streamPtr(ptr) {}

        HK_INLINE hkTimeFunctionHelper()
        {
            m_streamPtr = hkMonitorStream::getInstancePtr();
        }
        HK_INLINE ~hkTimeFunctionHelper() { HK_TIMER_END2(m_streamPtr); }
        hkMonitorStream* m_streamPtr;
};

class HK_POSSIBLY_UNUSED hkTimeListFunctionHelper
{
    public:
        HK_INLINE hkTimeListFunctionHelper(_In_ hkMonitorStream* ptr): m_streamPtr(ptr){}

        HK_INLINE hkTimeListFunctionHelper()
        {
            m_streamPtr = hkMonitorStream::getInstancePtr();
        }

        HK_INLINE ~hkTimeListFunctionHelper() { HK_TIMER_END_LIST2(m_streamPtr); }
        hkMonitorStream* m_streamPtr;
};


HK_INLINE void hkAppendScopeToMultiTimer(const hkMonitorStream::TimerCommand& scopeTime, _Inout_ hkMonitorStream::MultiTimerCommand* HK_RESTRICT multiTimer)
{
    multiTimer->m_timerCommand += scopeTime;
    multiTimer->m_callCount    += 1;
}


/// Helper class
class HK_POSSIBLY_UNUSED hkMultiTimerScopeHelper
{
    public:
        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_MONITOR, hkMultiTimerScopeHelper );

        HK_INLINE hkMultiTimerScopeHelper(_In_ hkMonitorStream::MultiTimerCommand* HK_RESTRICT timer, bool enabled)
            : m_timer(timer), m_enabled(enabled)
        {
            if (HK_VERY_UNLIKELY(m_enabled))
            {
                m_scopeTime.setTime();
            }
        }

        HK_INLINE ~hkMultiTimerScopeHelper()
        {
            if (HK_VERY_UNLIKELY(m_enabled))
            {
                hkMonitorStream::TimerCommand curTime;
                curTime.setTime();
                curTime.m_time0 = hkMonitorStream::TimerCommand::subtract(curTime.m_time0, m_scopeTime.m_time0);
            #if HK_ENABLE_EXTRA_TIMER
                curTime.m_time1 = 0;
            #endif
                hkAppendScopeToMultiTimer(curTime, m_timer);
            }
        }

        hkMonitorStream::MultiTimerCommand* HK_RESTRICT m_timer;
        hkMonitorStream::TimerCommand                   m_scopeTime;
        hkBool32 m_enabled;
};


/// Helper class to generate 2 nested timers
struct HK_POSSIBLY_UNUSED hkMultiTimerScopeHelper2
{
    HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_MONITOR, hkMultiTimerScopeHelper2 );

    HK_INLINE hkMultiTimerScopeHelper2( bool enabled )
        : m_enabled(enabled)
    {
        HK_ON_DEBUG( m_timerExported = 0 );
        if (HK_VERY_UNLIKELY(m_enabled))
        {
            m_scopeTime.setTime();
        }
    }

    HK_INLINE hkMultiTimerScopeHelper2(_In_ hkMonitorStream::MultiTimerCommand* HK_RESTRICT
#if HK_ENABLE_EXTRA_TIMER
        timer
#endif
        , bool enabled)
        : m_enabled(enabled)
    {
        #if HK_ENABLE_EXTRA_TIMER
        if (timer->m_timerCommand.m_time1 == 0)
        #endif
        {
            if (HK_VERY_UNLIKELY(m_enabled))
            {
                m_scopeTime.setTime();
            }
        }
        HK_ON_DEBUG( m_timerExported = 0 );
    }

    HK_INLINE ~hkMultiTimerScopeHelper2()
    {
        HK_ASSERT_NO_MSG( 0xf0343454, m_timerExported == 1 );
    }

    HK_INLINE void exportTimer2(
        _In_ hkMonitorStream::MultiTimerCommand* HK_RESTRICT top,
        _In_ hkMonitorStream::MultiTimerCommand* HK_RESTRICT timer )
    {
        #if HK_ENABLE_EXTRA_TIMER
        if (top->m_timerCommand.m_time1 == 0)
        #endif
        {
            if (HK_VERY_UNLIKELY(m_enabled))
            {
                hkMonitorStream::TimerCommand curTime;
                curTime.setTime();
                curTime.m_time0 = curTime.m_time0 - m_scopeTime.m_time0;
            #if HK_ENABLE_EXTRA_TIMER
                curTime.m_time1 = 0;
            #endif
                hkAppendScopeToMultiTimer(curTime, top);
                hkAppendScopeToMultiTimer(curTime, timer);
            }
        }
        HK_ON_DEBUG( m_timerExported = 1 );
    }
    HK_INLINE void exportTimer(
        _In_ hkMonitorStream::MultiTimerCommand* HK_RESTRICT top )
    {
        #if HK_ENABLE_EXTRA_TIMER
        if (top->m_timerCommand.m_time1 == 0)
        #endif
        {
            if (HK_VERY_UNLIKELY(m_enabled))
            {
                hkMonitorStream::TimerCommand curTime;
                curTime.setTime();
                curTime.m_time0 = curTime.m_time0 - m_scopeTime.m_time0;
            #if HK_ENABLE_EXTRA_TIMER
                curTime.m_time1 = 0;
            #endif
                hkAppendScopeToMultiTimer(curTime, top);
            }
        }
        HK_ON_DEBUG( m_timerExported = 1 );
    }

    HK_INLINE void exportIntermediateTime( hkMultiTimerScopeHelper2& splitTime, _In_ hkMonitorStream::MultiTimerCommand* HK_RESTRICT timer )
    {
        #if HK_ENABLE_EXTRA_TIMER
        if (timer->m_timerCommand.m_time1 == 0)
        #endif
        {
            if (HK_VERY_UNLIKELY(m_enabled))
            {
                splitTime.m_scopeTime.setTime();

                hkMonitorStream::TimerCommand curTime;
                curTime.m_time0 = splitTime.m_scopeTime.m_time0 - m_scopeTime.m_time0;
            #if HK_ENABLE_EXTRA_TIMER
                curTime.m_time1 = 0;
            #endif
                hkAppendScopeToMultiTimer(curTime, timer);
            }
        }
    }

    hkMonitorStream::TimerCommand   m_scopeTime;
    hkBool32 m_enabled;
    HK_DEBUG_ONLY_MEMBER(hkBool32, m_timerExported);

private:
    // Prevent pointer being used for 'bool enabled' constructor
    hkMultiTimerScopeHelper2(_In_ hkMonitorStream::MultiTimerCommand* timer);
};


#define HK_TIME_LOOP_SCOPE( TIMER, ENABLED ) hkMultiTimerScopeHelper HK_PREPROCESSOR_JOIN_TOKEN(_multiTimerHelper, __LINE__)( &TIMER, ENABLED )
#define HK_TIME_LOOP_SCOPE_ALWAYS_ENABLED( TIMER ) HK_TIME_LOOP_SCOPE( TIMER, true )


#define HK_TIME_CODE_BLOCK( NAME, OBJECT, ... ) hkMonitorStream* HK_PREPROCESSOR_JOIN_TOKEN(_timerStreamPtr, __LINE__## __VA_ARGS__) = hkMonitorStream::getInstancePtr(); \
    HK_TIMER_BEGIN2( (HK_PREPROCESSOR_JOIN_TOKEN(_timerStreamPtr, __LINE__## __VA_ARGS__)), NAME, OBJECT);\
    hkTimeFunctionHelper HK_PREPROCESSOR_JOIN_TOKEN(_timerHelper, __LINE__## __VA_ARGS__)(HK_PREPROCESSOR_JOIN_TOKEN(_timerStreamPtr, __LINE__## __VA_ARGS__))
#define HK_TIME_CODE_BLOCK2( STREAM, NAME, OBJECT ) HK_TIMER_BEGIN2(STREAM, NAME, OBJECT);\
    hkTimeFunctionHelper HK_PREPROCESSOR_JOIN_TOKEN(_timerHelper, __LINE__)
#define HK_TIME_CODE_BLOCK_LIST( NAME, OBJECT ) hkMonitorStream* HK_PREPROCESSOR_JOIN_TOKEN(_timerStreamPtr, __LINE__) = hkMonitorStream::getInstancePtr();\
    HK_TIMER_BEGIN_LIST2( (HK_PREPROCESSOR_JOIN_TOKEN(_timerStreamPtr, __LINE__)), NAME, OBJECT);\
    hkTimeListFunctionHelper HK_PREPROCESSOR_JOIN_TOKEN(_timerHelper, __LINE__)(HK_PREPROCESSOR_JOIN_TOKEN(_timerStreamPtr, __LINE__))

#   define HK_MONITOR_PUSH_DIR( PATH )  {                           \
    hkMonitorStream* _mStream = hkMonitorStream::getInstancePtr();      \
    if ( _mStream && _mStream->memoryAvailable() )                              \
{                                                                   \
        hkMonitorStream::Command* h = (hkMonitorStream::Command*)( _mStream->expandby( sizeof(hkMonitorStream::Command) ) );    \
        h->m_commandAndMonitor = HK_MONITOR_COMMAND_PUSH_DIR PATH;  \
} }

#   define HK_MONITOR_ADD_TAG( STREAM, TAG )    {               \
    if ( (STREAM) && (STREAM)->memoryAvailable() )                              \
{                                                               \
    hkMonitorStream::TagCommand* h = (hkMonitorStream::TagCommand*)( STREAM->expandby( sizeof(hkMonitorStream::TagCommand) ) ); \
    h->m_commandAndMonitor = HK_MONITOR_COMMAND_ADD_TAG;    h->m_tag = TAG; \
} }

#   define HK_MONITOR_ENTER_TAG( STREAM, TAG )  {               \
    if ( STREAM && STREAM->memoryAvailable() )                              \
{                                                               \
    hkMonitorStream::TagCommand* h = (hkMonitorStream::TagCommand*)( STREAM->expandby( sizeof(hkMonitorStream::TagCommand) ) ); \
    h->m_commandAndMonitor = HK_MONITOR_COMMAND_GOTO_TAG;   h->m_tag = TAG; \
} }

#   define HK_MONITOR_EXIT_TAG( STREAM )    {                   \
    if ( STREAM && STREAM->memoryAvailable() )                              \
{                                                               \
    hkMonitorStream::TagCommand* h = (hkMonitorStream::TagCommand*)( STREAM->expandby( sizeof(hkMonitorStream::TagCommand) ) ); \
    h->m_commandAndMonitor = HK_MONITOR_COMMAND_GOTO_TAG;   h->m_tag = 0; \
} }

#   define HK_MONITOR_POP_DIR() {                                   \
    hkMonitorStream* _mStream = hkMonitorStream::getInstancePtr();      \
    if ( _mStream && _mStream->memoryAvailable() )                              \
{                                                                   \
    hkMonitorStream::Command* h = (hkMonitorStream::Command*)( _mStream->expandby( sizeof(hkMonitorStream::Command) ) );    \
    h->m_commandAndMonitor = HK_MONITOR_COMMAND_POP_DIR;            \
}   }

#   define HK_MONITOR_NOP() {                                       \
    hkMonitorStream* _mStream = hkMonitorStream::getInstancePtr();      \
    if ( _mStream && _mStream->getEnd() <= (_mStream->getCapacity() - sizeof(hkMonitorStream::Command)) )                               \
{                                                                   \
    hkMonitorStream::Command* h = (hkMonitorStream::Command*)( _mStream->expandby( sizeof(hkMonitorStream::Command) ) );    \
    h->m_commandAndMonitor = HK_MONITOR_COMMAND_NOP;                \
}   }

#if defined(HK_COMPILER_MSVC)
#   define HK_TIME_FUNCTION() HK_TIME_CODE_BLOCK(__FUNCTION__,HK_NULL)
#else
// __FUNCTION__ and __func__ etc are not macros so they can not be used
// in context of joining string literals, as these macros attempt. The
// GCC documentation explicitly explains this:
//  https://gcc.gnu.org/onlinedocs/gcc/Function-Names.html
//
//  "These identifiers are variables, not preprocessor macros, and may
//  not be used to initialize char arrays or be concatenated with string
//  literals."
// However, MSVC does allow using __FUNCTION__ as a string literal, so
// our code relies on it for now. Pass a literal string for compatibility
// until the code is refactored to be portable.
#   define HK_TIME_FUNCTION() HK_TIME_CODE_BLOCK("<function>", HK_NULL)
#endif

#else // HK_CONFIG_MONITORS == HK_CONFIG_MONITORS_DISABLED

#   define HK_ON_MONITORS_ENABLED( code )

#   define HK_TIMER_BEGIN_OBJECT_NAME_INTERN(STREAM, OBJECT_NAME)

#   define HK_TIMER_BEGIN_INTERN( STREAM, NAME, COMMAND, OBJECT )
#   define HK_TIMER_END_INTERN( STREAM, NAME, COMMAND, OBJECT )
#   define HK_TIMER_BEGIN_OBJECT_NAME_INTERN(STREAM, OBJECT_NAME)
#   define HK_TIMER_BEGIN_LIST_INTERN( STREAM, NAME1, NAME2, COMMAND, OBJECT )
#   define HK_TIMER_SPLIT_LIST_INTERN( STREAM, NAME, COMMAND, OBJECT )
#   define HK_TIMER_END_LIST_INTERN( STREAM, NAME, COMMAND, OBJECT )
#   define HK_TIMER_DRAW_CALL_BEGIN_INTERN( STREAM, NAME, COMMAND, GPU_HANDLE )
#   define HK_TIMER_DRAW_CALL_END_INTERN( STREAM, NAME, COMMAND, GPU_HANDLE )

#   define HK_MONITOR_ADD_FRAME_ID_INTERN( STREAM )
#   define HK_MONITOR_ADD_VALUE_INTERN( STREAM, NAME, VALUE, MONITOR_TYPE )
#   define HK_MONITOR_ADD_GPU_HANDLE_INTERN( STREAM, NAME, GPU_HANDLE )

#   define HK_MONITOR_ADD_FRAME_ID()

#   define HK_MULTI_TIMER_BEGIN( STREAM, NAME )
#   define HK_MULTI_TIMER_END( STREAM, NAME, DATA )

#   define HK_MONITOR_PUSH_DIR( PATH )
#   define HK_MONITOR_POP_DIR()
#   define HK_MONITOR_ADD_VALUE( NAME, VALUE, MONITOR_TYPE )
#   define HK_MONITOR_ADD_VALUE2( STREAM, NAME, VALUE, MONITOR_TYPE )
#   define HK_MONITOR_NOP()
#   define HK_MONITOR_MEMORY_ALLOC(TAG, PTR, NBYTES)
#   define HK_MONITOR_MEMORY_FREE(TAG, PTR, NBYTES)
#   define HK_MONITOR_ADD_TAG( STREAM, TAG )
#   define HK_MONITOR_ENTER_TAG( STREAM, TAG )
#   define HK_MONITOR_EXIT_TAG( STREAM )

#   define HK_TIMER_BEGIN( NAME, OBJECT )
#   define HK_TIMER_BEGIN_AND_SELF( NAME )
#   define HK_TIMER_BEGIN_OBJECT_NAME( OBJECT_NAME )
#   define HK_TIMER_END()
#   define HK_TIMER_NAMED_END(NAME)
#   define HK_TIMER_BEGIN_LIST( NAME, FIRSTITEM )
#   define HK_TIMER_SPLIT_LIST( NAME )
#   define HK_TIMER_END_LIST()

#   define HK_TIMER_ENTER_TAG( STREAM, TAG )
#   define HK_TIMER_EXIT_TAG( STREAM )

#   define HK_TIMER_DRAW_CALL_BEGIN( NAME, GPU_HANDLE )
#   define HK_TIMER_DRAW_CALL_END()
#   define HK_TIMER_DRAW_CALL_NAMED_END( NAME )
#   define HK_MONITOR_ADD_STRUCT( NAME, STRUCT )
#   define HK_MONITOR_ADD_GPU_HANDLE( NAME, GPU_HANDLE )

#   define HK_TIMER_BEGIN2( STREAM, NAME, OBJECT )
#   define HK_TIMER_BEGIN_AND_SELF2( STREAM, NAME )
#   define HK_TIMER_END2( STREAM )
#   define HK_TIMER_NAMED_END2( STREAM, NAME )
#   define HK_TIMER_BEGIN_LIST2( STREAM, NAME, FIRSTITEM )
#   define HK_TIMER_SPLIT_LIST2( STREAM, NEXTITEM )
#   define HK_TIMER_END_LIST2( STREAM )

#   define HK_TIME_LOOP_SCOPE( TIMER, ENABLED )
#   define HK_TIME_LOOP_SCOPE_ALWAYS_ENABLED( TIMER )

#   define HK_TIME_CODE_BLOCK( NAME, OBJECT )
#   define HK_TIME_CODE_BLOCK2( STREAM, NAME, OBJECT )
#   define HK_TIME_CODE_BLOCK_LIST( NAME, OBJECT )

#   define HK_TIME_FUNCTION()

#   define HK_TIMER_PAUSE(NAME)
#   define HK_TIMER_UNPAUSE()

#endif


// Set this to 1 for extra detailed timers
#if 0

#   define HK_INTERNAL_TIMER_BEGIN(NAME, OBJECT)        HK_TIMER_BEGIN(NAME,OBJECT)
#   define HK_INTERNAL_TIMER_END                HK_TIMER_END
#   define HK_INTERNAL_TIMER_BEGIN_LIST(a,b)    HK_TIMER_BEGIN_LIST(a,b)
#   define HK_INTERNAL_TIMER_SPLIT_LIST(a)      HK_TIMER_SPLIT_LIST(a)
#   define HK_INTERNAL_TIMER_END_LIST           HK_TIMER_END_LIST
#   define HK_INTERNAL_MONITOR_ADD_VALUE(NAME, VALUE, MONITOR_TYPE)     HK_MONITOR_ADD_VALUE(NAME, VALUE, MONITOR_TYPE)
#   define HK_INTERNAL_TIME_CODE_BLOCK( NAME, OBJECT) HK_TIME_CODE_BLOCK( NAME, OBJECT)
#   define HK_INTERNAL_TIME_CODE_BLOCK_LIST( NAME, OBJECT) HK_TIME_CODE_BLOCK_LIST( NAME, OBJECT)

#   define HK_USER_TIMER_BEGIN(NAME,OBJECT)     {}
#   define HK_USER_TIMER_END()              {}
#   define HK_USER_TIMER_BEGIN_LIST(a,b)    {}
#   define HK_USER_TIMER_SPLIT_LIST(a)      {}
#   define HK_USER_TIMER_END_LIST()     {}

#else

#   define HK_INTERNAL_TIMER_BEGIN(NAME,OBJECT)     {}
#   define HK_INTERNAL_TIMER_END()              {}
#   define HK_INTERNAL_TIMER_BEGIN_LIST(a,b)    {}
#   define HK_INTERNAL_TIMER_SPLIT_LIST(a)      {}
#   define HK_INTERNAL_TIMER_END_LIST()     {}
#   define HK_INTERNAL_MONITOR_ADD_VALUE(NAME, VALUE, MONITOR_TYPE) {}
#   define HK_INTERNAL_TIME_CODE_BLOCK( NAME, OBJECT) {}
#   define HK_INTERNAL_TIME_CODE_BLOCK_LIST( NAME, OBJECT) {}

#   define HK_USER_TIMER_BEGIN(NAME,OBJECT)     HK_TIMER_BEGIN(NAME,HK_NULL)
#   define HK_USER_TIMER_END                HK_TIMER_END
#   define HK_USER_TIMER_BEGIN_LIST(a,b)    HK_TIMER_BEGIN_LIST(a,b)
#   define HK_USER_TIMER_SPLIT_LIST(a)      HK_TIMER_SPLIT_LIST(a)
#   define HK_USER_TIMER_END_LIST           HK_TIMER_END_LIST

#endif

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
