// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/Monitor/MonitorStreamAnalyzer/hkMonitorStreamParser.h>

hkMonitorStreamParser::Node::Node()
{
    m_parent = HK_NULL;
    m_name = HK_NULL;
    m_type = NODE_TYPE_TIMER;
    m_value = 0;
    m_count = 0;
    m_threadMaxValue = 0;
    m_threadMinValue = HK_FLOAT_MAX;
    m_threadFlags.clear();
    m_moveToTag = 0;
    m_absoluteStartTime = 0;
    m_flags.clear();
    m_tags = 0;
    m_gpuHandle = 0;
}

hkMonitorStreamParser::Node::Node(_In_opt_ Node* parent, _In_z_ const char* name, NodeType type)
: m_name( name ), m_parent(parent), m_type( type )
{
    if (parent)
    {
        parent->m_children.pushBack(this);
    }

    m_value = 0;
    m_count = 0;
    m_threadMaxValue = 0;
    m_threadMinValue = HK_FLOAT_MAX;
    m_threadFlags.clear();
    m_moveToTag = 0;
    m_absoluteStartTime = 0;
    m_flags.clear();
    m_tags = 0;
    m_gpuHandle = 0;
}

hkMonitorStreamParser::Node::Node(const Node& rhs)
    : m_absoluteStartTime(rhs.m_absoluteStartTime)
    , m_name(rhs.m_name)
    , m_type(rhs.m_type)
{
    m_parent = rhs.m_parent;
    m_value = rhs.m_value;
    m_count = rhs.m_count;
    m_threadMaxValue = 0;
    m_threadMinValue = HK_FLOAT_MAX;
    m_threadFlags.clear();
    if (rhs.m_children.getSize())
    {
        m_children.insertAt(0, rhs.m_children.begin(), rhs.m_children.getSize() );
    }
    m_moveToTag = rhs.m_moveToTag;
    m_tags = 0;
    m_gpuHandle = rhs.m_gpuHandle;
    m_metaData = rhs.m_metaData;
}

hkMonitorStreamParser::Node::~Node()
{
    for (int i=0; i< m_children.getSize();i++)
    {
        delete m_children[i];
    }
    m_children.clear();
    if ( m_tags )
    {
        delete m_tags;
    }
}

hkMonitorStreamParser::Node& hkMonitorStreamParser::Node::operator=( const Node& rhs )
{
    m_absoluteStartTime = rhs.m_absoluteStartTime;
    m_parent = rhs.m_parent;
    m_name = rhs.m_name;
    m_type = rhs.m_type;
    m_value = rhs.m_value;
    m_count = rhs.m_count;
    m_threadMaxValue = rhs.m_threadMaxValue;
    m_threadMinValue = rhs.m_threadMinValue;
    m_threadFlags = rhs.m_threadFlags;
    if (rhs.m_children.getSize())
    {
        m_children.insertAt(0, rhs.m_children.begin(), rhs.m_children.getSize() );
    }
    m_moveToTag = rhs.m_moveToTag;
    if (rhs.m_tags)
    {
        m_tags = new TagInfo();
        m_tags->m_tags.insertAt(0, rhs.m_tags->m_tags.begin(), rhs.m_tags->m_tags.getSize() );
    }
    else
    {
        m_tags  = HK_NULL;
    }
    m_gpuHandle = rhs.m_gpuHandle;
    m_metaData = rhs.m_metaData;
    return *this;
}


void hkMonitorStreamParser::Node::setTimers( hkReal timerFactor, const hkMonitorStream::TimerCommand& start, const hkMonitorStream::TimerCommand& end)
{
    m_value += float( timerFactor * (end.m_time0 - start.m_time0) );
    m_count += 1;
    m_absoluteStartTime = double(timerFactor) * double( start.m_time0 );
    m_threadMaxValue = m_threadMinValue = m_value;  // for use with combine tress
}

void hkMonitorStreamParser::Node::setTimers( hkReal timerFactor, const hkMonitorStream::MultiTimerCommand& multiTimer)
{
    m_value += float( timerFactor * ( multiTimer.m_timerCommand.m_time0 ) );
    m_count += multiTimer.m_callCount;
    m_threadMaxValue = m_threadMinValue = m_value;
}


void hkMonitorStreamParser::Node::clear()
{
    m_value = 0;
    m_count = 0;
    m_threadMaxValue = 0;
    m_threadMinValue = HK_FLOAT_MAX;
    m_threadFlags.clear();
    m_gpuHandle = 0;
    m_absoluteStartTime = 0;
    //m_name = HK_NULL;
    //m_parent = HK_NULL;
    if (m_tags)
    {
        delete m_tags;
        m_tags = HK_NULL;
    }

    //m_moveToTag = 0;
    //m_type;
    //m_flags;
    for (int c=0; c < m_children.getSize(); ++c)
    {
        m_children[c]->clear();
    }
    m_metaData.clear();
}

void hkMonitorStreamParser::Tree::clear()
{
    m_tagToNode.clear();
    m_taggedNodes.clear();
    m_gpuHandleCache.clear();
    m_frameId = 0;

    Node::clear();
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
