// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/Base/Monitor/hkMonitorStream.h>
#include <Common/Base/Monitor/MonitorStreamAnalyzer/hkMonitorStreamParser.h>
#include <Common/Base/Types/Geometry/Rect/hkRect.h>

class HK_EXPORT_COMMON hkMonitorStreamFlameGraph : public hkReferencedObject
{
    public:

        HK_DECLARE_CLASS_ALLOCATOR( HK_MEMORY_CLASS_MONITOR );

        hkMonitorStreamFlameGraph();

        // can call to resize too, but will wipe existing frame
        void init( hkRect16 graphArea );

        struct Quad
        {
            hkStringPtr m_timerName;

            hkReal m_time;

            hkUint16 m_startX; // will be the the range m_graphArea.m_x to m_graphArea.m_x + m_graphArea.m_width, not 0..width, to make rendering trivial for Quad->Screen
            hkUint16 m_startY;
            hkUint16 m_endX;
            hkUint16 m_endY;

            hkColor::Argb m_color;
            hkUint16 m_threadNum;

            const hkMonitorStreamParser::Node* m_srcNode;
            const hkGpuTraceResult* m_srcGpuResult;
        };

        // Use makeStatisticsTreeForSingleFrame in hkMonitorStream, with allowRoot as false so that all timers under proper owners
        // Take all such Node for each thread/SPU etc and provide them here. Do not use any of the merge funcs in hkMonitorStream.
        // Use startPos and endPos ( 0..1 of the time graph) to zoom, and thread to reduce to just a given thread of interest (for higher detail)
        // Use ignoreFirstCalls to ignore the first N calls deep (so you can scroll a bit basically)
        void updateCpu( const hkArrayView<hkMonitorStreamParser::Tree*>& timers, float startPos = 0, float endPos = -1.f, int ignoreFirstNCalls = 0, int highlightNodeFlagMask = 0);
        void updateGpu( const hkArrayView<hkMonitorStreamParser::Tree*>& timers, const hkArrayView<hkGpuTraceResult>& gpuTrace, float startPos = 0, float endPos = -1.f, hkUint32 viewPixels = 1270*720, int highlightNodeFlagMask = 0);

        // when doing a sub selection based on name say, we want to find the extents to zoom to before going and making all the visible quads. You can use nodeFlagMask > 0 to select off that mask only selected nodes etc
        void findTightZoomCpu( const hkArrayView<hkMonitorStreamParser::Tree*>& timers, int nodeFlagMask, float& startPos, float& endPos );
        void findTightZoomGpu( const hkArrayView<hkMonitorStreamParser::Tree*>& timers, const hkArrayView<hkGpuTraceResult>& gpuTrace, int nodeFlagMask, float& startPos, float& endPos );

        // get the area that the graph will limit itself too
        const hkRect16& getGraphRect() const { return m_graphArea; }

        const hkArray<Quad>& getQuads( ) const { return m_quads; }

        _Ret_maybenull_ const Quad* getQuadUnderPos( int x, int y ) const;

        _Ret_maybenull_ hkMonitorStreamColorTable* getColorTable() { return m_colorTable; }
        void setColorTable(_In_opt_ hkMonitorStreamColorTable* c);

        int getNumThreads() const;
        float getGraphStartTime() const; // in ms
        float getGraphEndTime() const; // in ms

        void setSmallestQuadSize(int p) { m_smallestQuadSize = p; }
        int getSmallestQuadSize() const { return m_smallestQuadSize; }

    protected:

        hkRect16 m_graphArea;
        hkInt32 m_numThreads;
        hkArray<Quad> m_quads;
        hkRefPtr<hkMonitorStreamColorTable> m_colorTable;

        hkReal m_frameTime;

        float m_graphStartTime;
        float m_graphEndTime;

        int m_smallestQuadSize;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
