// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/Base/Monitor/MonitorStreamAnalyzer/hkMonitorStreamParser.h>

// For serializing a full timer dump to file or a different computer
// It contains all the info needed to parse the trace correctly
class HK_EXPORT_COMMON hkMonitorStreamContainer : public hkReferencedObject
{
    public:
        HK_DECLARE_CLASS(hkMonitorStreamContainer, New, Reflect, EmptyCtor);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);
        HK_RECORD_ATTR(hk::Retargetable(false));

        // where it came from etc
        hkStringPtr m_info;

        // Platform config
        hkBool m_pointersAre64Bit;
        hkBool m_littleEndian;

        // Timer config
        hkBool m_timersAre64Bit;
        hkReal m_timerFactor; // from recorded ticks to milliseconds

        // local ptrs (strings, types) that are in trace, that we will need to fixup on load
        hkMonitorStreamStringMap m_stringMap;
        hkMonitorStreamTypeMap m_typeMap;

        // The data
        hkArray<hkUint8> m_trace;
        hkArray<hkUint32> m_threadStartOffsets; // into m_trace
        hkArray<hkUint32> m_frameStartOffsets; // into m_threadStartOffsets

        hkArray<hkGpuTraceResult> m_gpuTrace;
        hkArray<hkUint32> m_gpuFrameStartOffsets; // into m_gpuTrace

        int getNumGpuFrames() const;
        int getNumCpuFrames() const;
        int getNumThreads( int frame = 0 ) const;
        int getMaxNumThreads() const;

        void getCpuTimerData( int frame, hkArray<hkTimerData>& timers ) const;
        void getGpuTimerData( int frame, hkArrayView<hkGpuTraceResult>& timers ) const;

        void getStreamConfig( hkMonitorStream::CommandStreamConfig& c );

};


class HK_EXPORT_COMMON hkMonitorStreamContainerCache : public hkReferencedObject
{
    public:

        HK_RECORD_ATTR( hk::Feature("hkMonitorStream") );
        HK_DECLARE_CLASS(hkMonitorStreamContainerCache, New, EmptyCtor);

        struct Data
        {
            HK_DECLARE_CLASS(Data, New, EmptyCtor);
            hkRefPtr<hkMonitorStreamContainer> m_container;
            hkRefPtr<hkMonitorStreamColorTable> m_colorTable;
        };
        hkArray< Data > m_caches;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
