// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/Monitor/MonitorStreamAnalyzer/hkMonitorStreamParser.h>
#include <Common/Base/Monitor/MonitorStreamAnalyzer/hkMonitorStreamContainer.h>

void hkMonitorStreamContainer::getStreamConfig( hkMonitorStream::CommandStreamConfig& c )
{
    c.m_needEndianSwap = m_littleEndian? (HK_ENDIAN_LITTLE==0) : (HK_ENDIAN_LITTLE==1);
    c.m_pointersAre64Bit = m_pointersAre64Bit;
    c.m_timersAre64Bit = m_timersAre64Bit;

    if (m_stringMap.m_runtimeMap.getSize() == 0) m_stringMap.createRuntime();
    c.m_stringMap = &m_stringMap.m_runtimeMap;

    if (m_typeMap.m_runtimeMap.getSize() == 0) m_typeMap.createRuntime();
    c.m_typeMap = &m_typeMap.m_runtimeMap;
}

void hkMonitorStreamContainer::getCpuTimerData( int frame, hkArray<hkTimerData>& timers ) const
{
    if ( (frame < 0) || (frame >= m_frameStartOffsets.getSize()))
    {
        timers.setSize(0);
        return;
    }

    int startIndex = m_frameStartOffsets[frame];
    int endIndex = m_threadStartOffsets.getSize();
    if (frame < (m_frameStartOffsets.getSize() - 1))
    {
        endIndex = m_frameStartOffsets[frame + 1];
    }

    int numThreadsInFrame = endIndex - startIndex;
    timers.setSize(numThreadsInFrame);
    for (int t=startIndex; t < endIndex; ++t)
    {
        timers[t-startIndex].m_streamBegin = (const char*)( m_trace.begin() + m_threadStartOffsets[t] );
        timers[t-startIndex].m_streamEnd = (const char*)( m_trace.begin() + ( t != (m_threadStartOffsets.getSize() - 1) ? m_threadStartOffsets[t+1] : (hkUint32)m_trace.getSize() ) );
    }
}

void hkMonitorStreamContainer::getGpuTimerData( int frame, hkArrayView<hkGpuTraceResult>& timers ) const
{
    if ( (frame < 0) || (frame >= m_gpuFrameStartOffsets.getSize()))
    {
        timers = hkArrayView<hkGpuTraceResult>();
        return;
    }

    int startIndex = m_gpuFrameStartOffsets[frame];
    int endIndex = m_gpuTrace.getSize();
    if (frame < (m_gpuFrameStartOffsets.getSize() - 1))
    {
        endIndex = m_gpuFrameStartOffsets[frame + 1];
    }

    timers = hkArrayView<hkGpuTraceResult>( (hkGpuTraceResult*)m_gpuTrace.begin() + startIndex, (hkGpuTraceResult*)m_gpuTrace.begin() + endIndex );
}

int hkMonitorStreamContainer::getNumGpuFrames() const
{
    return m_gpuFrameStartOffsets.getSize();
}

int hkMonitorStreamContainer::getNumCpuFrames() const
{
    return m_frameStartOffsets.getSize();
}

int hkMonitorStreamContainer::getNumThreads( int frame ) const
{
    if ( (frame < 0) || (frame >= m_frameStartOffsets.getSize()))
        return 0;

    int startIndex = m_frameStartOffsets[frame];
    int endIndex = m_threadStartOffsets.getSize();
    if (frame < (m_frameStartOffsets.getSize() - 1))
    {
        endIndex = m_frameStartOffsets[frame + 1];
    }

    int numThreadsInFrame = endIndex - startIndex;
    return numThreadsInFrame;
}

int hkMonitorStreamContainer::getMaxNumThreads() const
{
    int numFrames = getNumCpuFrames();
    int maxThreads = 0;
    for (int f=0; f < numFrames; ++f)
    {
        int nt = getNumThreads(f);
        maxThreads  = hkMath::max2(nt, maxThreads);
    }
    return maxThreads;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
