// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/Base/Monitor/MonitorStreamAnalyzer/hkMonitorStreamParser.h>
#include <Common/Base/Monitor/MonitorStreamAnalyzer/hkMonitorStreamContainer.h>

class HK_EXPORT_COMMON hkMonitorStreamCache : public hkReferencedObject
{
    public:

        HK_RECORD_ATTR( hk::Feature("hkMonitorStream") );
        HK_DECLARE_CLASS(hkMonitorStreamCache, New);

        hkMonitorStreamCache( const hkMonitorStream::CommandStreamConfig& config );

        /// Clears the current contents of the cache (but leaves the buffer sizes
        /// unchanged) and sets a new configuration for the cached data.
        void clearAndSetConfig( const hkMonitorStream::CommandStreamConfig& config );

        // Resize the storage
        // Will wipe current contents if different to current sizes
        void resize( int numFrames, int bytesPerFrame );

        void getSize( int& numFrames, int& bytesPerFrame ) const;

        float getUsage() const;

        bool captureCpuTrace( const hkArrayView<hkTimerData>& timers );

        // returns number of frames back we captured for
        int captureGpuTrace( const hkArrayView<hkGpuTraceResult>& r );

        int getNumCapturedFrames() const;
        int getNumPendingGpuCaptures() const;

        int getNumThreads(int numFramesBack) const;
        int getMaxNumThreads() const;

        hkArrayView<hkTimerData> getCpuTimers( int numFramesBack, bool& isComplete ) const;
        hkArrayView<hkGpuTraceResult> getGpuTimers( int numFramesBack ) const;
        const hkMonitorStream::CommandStreamConfig& getCpuConfig() const { return m_config; }


        
        

        bool save( int numFramesBack, int numFramesToSave, hkMonitorStreamContainer& c ) const;

    protected:

        inline int getIndexFromFrame(int framesBack) const
        {
            return (m_back + m_frameData.getSize() - (framesBack + 1) ) % m_frameData.getSize();
        }

        struct FrameData
        {
            FrameData() {}
            FrameData(const FrameData& other) {}

            void clear();

            hkArray<char>::Debug m_data;
            hkArray<hkTimerData>::Debug m_timerData; /// points into m_data
            hkArray<hkUint32>::Debug m_timerFrameIds;
            hkArray<hkGpuTraceResult>::Debug m_gpuTrace;
            hkUint32 m_usedDataSize;
            hkBool m_complete;
            
        };

        hkMonitorStream::CommandStreamConfig m_config;
        hkArray< FrameData >::Debug m_frameData;
        hkUint32 m_back;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
