// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/Base/Monitor/hkMonitorStream.h>
#include <Common/Base/Container/PointerMap/hkPointerMap.h>
#include <Common/Base/Types/Color/hkColor.h>

#include <Common/Base/Reflect/Util/hkReflectAny.h>

class hkOstream;

#include <Common/Base/Monitor/MonitorStreamAnalyzer/hkMonitorStreamParser.h>

/// Note: This file is becoming deprecated. See hkMonitorStreamParser for impl that uses less mem per node, and is
/// being updated.


/// Information about how to read the data from the monitors captured over a
/// given frame. You need to fill this structure in per frame captured.
/// The timing monitors are setup to capture 2 floats per call. However,
/// there are 4 "slots" in the corresponding monitor capture structure here.
/// This allows you for example to alternate between i-cache and d-cache misses
struct HK_EXPORT_COMMON hkMonitorStreamFrameInfo
{
    HK_RECORD_ATTR( hk::Feature("hkMonitorStream") );
    HK_DECLARE_CLASS(hkMonitorStreamFrameInfo, New, Reflect);

    // To keep the Visual Debugger backward compatible as much as possible, try not to
    // add any members to this struct. If you do, add them at the end (in the second public section)
    // (to make the version-ing trivial) as the VDB client does not have version-ing, and serializes this struct
    // directly.

        /// The heading for the frame (which will be printed out in the detailed timings file).
        /// Typically you should not forget to record what timers are being used for, and what units you
        /// are measuring times in (e.g., usec).
    hkStringPtr m_heading;

        /// The slot in our monitor capture structure, where the timer 0 should be stored.
        /// If this is set to -1, timer 0 will not get stored. By default this is 0.
    hkInt32 m_indexOfTimer0;

        /// The slot in our monitor capture structure, where the timer 1 should be stored.
        /// If this is set to -1, timer 1 will not get stored. By default this is 1.
    hkInt32 m_indexOfTimer1;

        /// The index of the absolute time. This should be 0 if timer O is used to
        /// store the absolute time, 1 if timer 1 is used to store the absolute time
        /// and -1 if neither timer 0 or timer 1 are used to store absolute time.
        /// This value is used to draw multiple timer threads to an image.
        /// By default this is ABSOLUTE_TIME_TIMER_0.
    enum AbsoluteTimeCounter
    {
        ABSOLUTE_TIME_TIMER_0 = 0,
        ABSOLUTE_TIME_TIMER_1 = 1,
        ABSOLUTE_TIME_NOT_TIMED = -1
    };

        /// Which timer if either is used to measure absolute time
    hkEnum<AbsoluteTimeCounter,hkUint32> m_absoluteTimeCounter;

        /// This value is used to multiply the raw data collected by the monitors and written into slot 0 of the
        /// monitor capture structure. The value should be set depending on what information the monitors are
        /// collecting for this slot. (e.g., timings, cache misses). For example, if you wish to display timings
        /// in microseconds you would set this value to (1 / number of clock cycles per microsecond). Using hkBase
        /// this would be 1e6f / float(hkStopwatch::getTicksPerSecond()).
        /// By default this is 1.f
    hkReal m_timerFactor0;

        /// This value is used to multiply the raw data collected by the monitors and written into slot 1 of the
        /// monitor capture structure. See comments for m_timerFactor0 for more info.
        /// By default this is 1.f
    hkReal m_timerFactor1;


public:

        /// The thread that this frame data came from. This must be between 0 and the number of
        /// threads passed into the analyzer on construction.
        /// Only need to set this if you are calling captureFrameDetails().
    int m_threadId;

        /// Set automatically when you call captureFrameDetails. There is no need to initialize this value.
    int m_frameStreamStart;

        /// Set automatically when you call captureFrameDetails. There is no need to initialize this value.
    int m_frameStreamEnd;

        /// Constructor. Initializes values to defaults as documented.
    hkMonitorStreamFrameInfo();
    };

HK_REFLECT_ENUM(HK_EXPORT_COMMON, hkMonitorStreamFrameInfo::AbsoluteTimeCounter);



/// Allows you to capture several frames (generated by hkMonitorStream)
/// and convert the data stream into a stream that can be moved across the network.
/// Also this class allows you to pretty print the results to a file.
class HK_EXPORT_COMMON hkMonitorStreamAnalyzer
{
    public:

        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_MONITOR, hkMonitorStreamAnalyzer);

        ///////////////////////////////////////////////////////////////////////
        //
        // Constructor, monitor capture, and reset
        //
        ///////////////////////////////////////////////////////////////////////

            /// Create an analyzer given a maximum memory size. This will allocate a block of data
            /// with this size, and use it to copy monitor information when captureFrameDetails is called.
        hkMonitorStreamAnalyzer( int maxMemorySize, int numThreads = 1 );

            /// This function must be called every frame. It copies the data between monitorStreamBegin and
            /// monitorStreamEnd, and stores the frame info structure.
        hkBool captureFrameDetails( _In_ const char* monitorStreamBegin, _In_ const char* monitorStreamEnd, const hkMonitorStreamFrameInfo& info );

            /// This allows you to change the number of threads the analyzer captures.
            /// This resets the analyzer. It clears all the arrays, but does not deallocate any data.
        void resetNumThreads( int numThreads = 1 );

            /// This resets the analyzer. It clears all the arrays, but does not deallocate any data.
        void reset();

            /// Resets N frames of the analyzer beginning with the oldest ones.
        void resetFrames( int frameCount );

            /// Get the start of the data stream.
            /// If the steam is empty, HK_NULL will be returned.
        char* getStreamBegin();


        ///////////////////////////////////////////////////////////////////////
        //
        // Utilities to write .txt statistics files
        //
        ///////////////////////////////////////////////////////////////////////

        enum
        {
            REPORT_ALL = 0xF7,
            REPORT_SUMMARIES = 0x07,
            REPORT_TOTAL = 0x01,
            REPORT_PERFRAME_TIME = 0x02,
            REPORT_PERFRAME_SUMMARY = 0x04,
            REPORT_PERFRAME_PERTYPE = 0x08,
            REPORT_PERFRAME_DETAIL = 0x10
        };

            /// Create a user readable statistics file of the raw data.
        void writeStatistics( hkOstream& outStream, int reportLevel = REPORT_ALL );

        void writeStatisticsForFrames( hkOstream& outStream, int numFrames, int reportLevel = REPORT_ALL, _In_opt_ const hkArrayView<hkGpuTraceResult>* traceResults = HK_NULL );

        void writeGpuStatistics( hkOstream& outStream, int numFrames, _In_reads_(numFrames) hkArrayView<hkGpuTraceResult>* traceResultsPerFrame, hkArrayView<hkReflect::Var> rootMetdata, hkArrayView<hkStringPtr> ignoredNames );

        void writeRawStatistics( hkOstream& outStream );

            /// Write statistics to Json file that can be viewed in Google Chrome (navigate to 'chrome://tracing/').
        void writeJsonStatistics( hkOstream& outStream, hkUint64 ticksPerSecond );

        ///////////////////////////////////////////////////////////////////////
        //
        // Utilities to draw statistics to an image
        //
        ///////////////////////////////////////////////////////////////////////

        struct HK_EXPORT_COMMON ThreadDrawInput
        {
            HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_MONITOR, hkMonitorStreamAnalyzer::ThreadDrawInput );

            ThreadDrawInput() : m_colorTable(HK_NULL), m_streamConfig(HK_NULL) {}

                /// The frame to start drawing from (1 by default)
            hkInt32 m_frameStart;

                /// The number of frames to draw (1 by default)
            hkInt32 m_numFrames;

                /// Layout info
            hkInt32 m_heightPerThread;
                /// Layout info
            hkInt32 m_gapBetweenThreads;

            hkInt32 m_gapBetweenFrames;

                /// Number of samples to take per frame
            hkInt32 m_outputPixelWidth;

                /// Set this to > 0 if you want to limit the frame duration
            hkReal m_limitFrameTime;
            hkReal m_limitStartTime;

            hkBool m_warnAboutMissingTimers;

            static int HK_CALL computePerThreadHeightToFit( int textureHeight, int numFrames, int numThreads, int frameGap, int threadGap );

                /// A mapping of timer names to colors
            hkMonitorStreamColorTable* m_colorTable;

            const hkMonitorStream::CommandStreamConfig* m_streamConfig;
        };

        ///////////////////////////////////////////////////////////////////////
        //
        // Utilities to print timers to a runtime display
        //
        ///////////////////////////////////////////////////////////////////////

        struct Node;
        struct Tree;

        typedef hkMap< hkUint64, hkTuple< Node*, Node* > > DrawCallHandleMap;

        /// How createTreeOneFrameManyThreads should handle timer deduction nodes.
        enum TimerDeductionNodeHandling
        {
            IGNORE_TIMER_DEDUCTION_NODES,
            APPLY_TIMER_DEDUCTION_NODES,
            APPLY_AND_DELETE_TIMER_DEDUCTION_NODES
        };

            /// You can use this function in conjunction navigateMonitors and printMonitorsToRuntimeDisplay
            /// to display user navigable timers on screen. You need to be able to output text to the screen, and capture
            /// cursor key input to do this.
            /// This call will create a multithreaded tree of nodes given a monitor streams start and end. It returns the root node of the tree.
        static _Ret_notnull_ Tree* HK_CALL createTreeOneFrameManyThreads(
            const hkMonitorStream::CommandStreamConfig& streamConfig, const hkMonitorStreamFrameInfo& frameInfo,
            _In_reads_(numThreads) const hkTimerData* threadStreams, int numThreads, TimerDeductionNodeHandling timerDeductionNodeHandling = IGNORE_TIMER_DEDUCTION_NODES);

            /// Take one tree and blend it into another by using a smoothing factor.
            /// Values closer to 1 smooth the timers more. 0 is un-smoothed.
        static void HK_CALL blendTree(_Inout_ Node* smoothedTreeInOut, _In_ const Node* frameTree, hkReal smoothingFactor = 0.9f);

            /// Scale all timer values by scale and set all counts to 0
        static void HK_CALL scaleTimerValuesRec(_Inout_ hkMonitorStreamAnalyzer::Node* node, hkReal scale );

            /// You can use this function in conjunction with navigateMonitors and printMonitorsToRuntimeDisplay
            /// to display user navigable timers on screen. You need to be able to output text to the screen, and capture
            /// cursor key input to do this.
            /// This call will create a tree of nodes given a monitor stream start and end. It returns the root node of the tree.
            /// For multithreaded applications, you will have a monitor stream per thread. You call this on each monitor stream,
            /// and merge the results together using mergeTreesForRuntimeDisplay. You can then use navigateMonitors and
            /// printMonitorsToRuntimeDisplay to view the combined trees.
        static _Ret_maybenull_ Tree* HK_CALL makeStatisticsTreeForSingleFrame(const hkMonitorStream::CommandStreamConfig& config, _In_ const char* frameStart, _In_ const char* frameEnd, const hkMonitorStreamFrameInfo& frameInfo,
            _In_z_ const char* rootNodeName = "/", bool reuseNodesIfPossible = true, _Inout_opt_ DrawCallHandleMap* drawCallMappings = HK_NULL);

            /// Given two trees, this function takes all the nodes in the subTree and merges them into the main tree. The sourceTimerId
            /// describes which slot in the subTree nodes the time is stored. This corresponds with your monitor setup, but is usually 0.
            /// The destTimerId describes which slot in the main tree nodes you wish to write. There are 4 slots, so this value must be
            /// between 0 and 3. If a node exists in the subTree but not in mainTree it is created. The smoothingFactor describes
            /// how the value is smoothed as it changes over time. Values closer to 1 smooth the timers more. 0 is unsmoothed.
        static void HK_CALL mergeTreesForCombinedThreadSummary(_Inout_ Tree* mainTree, _In_ const Tree* subTree, int destTimerId, int sourceTimerId = 0);

            /// Helper call which needs to be called if you have multiple trees from multiple thread and you need to reshuffle the trees
            /// to match the timer logic in the code, and not the timer logic for each thread.
        static void HK_CALL fixupTags(_Inout_ Tree* tree );

            /// Utility to remove any tag information from a tree. Useful if you wish to merge one tree over several frames
        static void HK_CALL removeTagsFromNodeRec(_Inout_ Node* node);


            /// Set these values from your input device. This is used as an input to navigateMonitors
        struct HK_EXPORT_COMMON CursorKeys
        {
            HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_MONITOR, hkMonitorStreamAnalyzer::CursorKeys );
                /// up
            hkBool m_upPressed;
                /// down
            hkBool m_downPressed;
                /// left
            hkBool m_leftPressed;
                /// right
            hkBool m_rightPressed;
        };

            /// This function will ensure the monitors are collapsed starting from the provided node.
        static void HK_CALL collapseMonitors( Node* nodeIn );
            /// This function will ensure the monitors are expanded to reveal the node.
        static void HK_CALL expandMonitors( Node* nodeIn );
            /// This function returns the new active node, given the active node and the cursor keys.
        static _Ret_maybenull_ Node* HK_CALL navigateMonitors(const CursorKeys& keys, _Inout_ Node* activeNodeIn);


            /// The options structure for showCombinedThreadSummaryForSingleFrame
        struct HK_EXPORT_COMMON CombinedThreadSummaryOptions
        {
            HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_MONITOR, hkMonitorStreamAnalyzer::CombinedThreadSummaryOptions );

            CombinedThreadSummaryOptions();

                /// Spacing info
            int m_indentationToFirstTimerValue;
                /// Spacing info
            int m_timerColumnWidth;
                /// Spacing info
            int m_tabSpacingForTimerNames;
                /// Spacing info
            int m_tabSpacingForTimerValues;

                /// If set, only nodes with user flags set will be displayed. User flags are set by the navigateMonitors function
            bool m_displayPartialTree;
                /// The current selected node - only set if m_displayPartialTree is true
            Node* m_activeNode;
                /// Only set if m_displayPartialTree is true
            char m_rightArrowChar;
                /// Only set if m_displayPartialTree is true
            char m_downArrowChar;

                /// Set this if you are using a non fixed (so space != same as other chars), it will insert slash t instead of spaces.
            bool m_useTabsNotSpacesForColumns;

                /// If set, display unaccounted for time in percents.
            bool m_showUnaccountedForTimes;

                /// Don't show levels deeper than maxDepth.
            int m_maxDepth;
        };

            /// This function prints the monitor tree to an hkOstream. You can create an hkOstream from an array of char,
            /// then print this array to the screen, or to file. The rootNode is the root of the tree, and the active node is the
            /// current selected node, returned by navigateMonitors. The numThreads is the number of fields (from 1 to 4)
            /// to print. The unexpanded and expanded variables allow you to insert your own graphics for these markers.
        static void HK_CALL showCombinedThreadSummaryForSingleFrame( _Inout_ Node* node, int numThreads, hkOstream& os, CombinedThreadSummaryOptions& options );

    public:

        //
        // Static internal utility methods and data used for the above functions
        //

        typedef hkUlong TagType;    // 32 bit in 32bit mode, 64 bit in 64 bit mode

        /// Helper struct for collect tags. Because of multithreading, the same timer
        /// could be issued on multiple threads, so once you merge threads, the same node
        /// might get multiple tags, therefor we need to use an array of tags.
        struct HK_EXPORT_COMMON TagInfo
        {
            HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE, hkMonitorStreamAnalyzer::TagInfo );
            hkArray<TagType> m_tags;
        };

        
        struct HK_EXPORT_COMMON NodeBase
        {
            HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_MONITOR, NodeBase );
            virtual ~NodeBase() {}
        };

        /// Data to store the parsed results of a capture
        struct HK_EXPORT_COMMON Node : public NodeBase
        {
            HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_MONITOR, Node );

            enum NodeType
            {
                NODE_TYPE_TIMER,
                NODE_TYPE_TIMER_DRAW_CALL,
                NODE_TYPE_DIRECTORY,
                NODE_TYPE_SINGLE,
                NODE_TYPE_META_DATA,
                NODE_TYPE_GPU_HANDLE,
                NODE_TYPE_TIMER_DEDUCTION
            };

            enum NodeFlags
            {
                FLAGS_REQUEST_SELF = 1<<0,
                FLAGS_TIME_IS_NOT_ABSOLUTE = 1<<1,
                FLAGS_FORCE_ROOT = 1<<2,
                FLAGS_IS_SELF = 1<<3,
            };

            hkUint64        m_gpuHandle;
            hkReflect::Any  m_metaData;

            Node(_In_opt_ Node* parent, _In_z_ const char* name, NodeType type);
            Node();
            Node(const Node& rhs);

            void setTimers( const hkMonitorStreamFrameInfo& frameInfo, const hkMonitorStream::CommandStreamConfig& streamConfig, const hkMonitorStream::TimerCommand& start, const hkMonitorStream::TimerCommand& end);
            void setTimers( const hkMonitorStreamFrameInfo& frameInfo, const hkMonitorStream::MultiTimerCommand& multiTimer);

            // creates a new child which is this - sum(children)
            void createSelfTimer( const hkMonitorStreamFrameInfo& frameInfo, _Inout_ struct Tree* rootNode);

            hkReal valuesSum() const { hkReal s=0; for(int i=0; i<m_threadData.getSize(); ++i) s += m_threadData[i].m_value; return s; }
            hkUint32 countsSum() const { hkUint32 s=0; for(int i=0; i<m_threadData.getSize(); ++i) s += m_threadData[i].m_count; return s; }

            // non-timer nodes and multi-timer nodes don't have a valid start time
            bool hasValidStartTime() const { return m_type != hkMonitorStreamAnalyzer::Node::NODE_TYPE_SINGLE && m_flags.noneIsSet( Node::FLAGS_TIME_IS_NOT_ABSOLUTE ); }

            void getPath( hkStringBuf& pathOut ) const;
            struct Node* findChild( const char* path );
            const struct Node* findChild( const char* path ) const { return const_cast< Node* >( this )->findChild( path ); }

            virtual ~Node();

            struct ThreadData
            {
                HK_INLINE ThreadData() : m_value(0), m_count(0) {}
                float m_value;
                hkUint32 m_count;
            };

            hkInplaceArray<ThreadData,16> m_threadData;
            hkArray<struct Node*>       m_children;
            double                      m_absoluteStartTime;    // this needs double precision
            Node*                       m_parent;
            TagInfo*                    m_tags;                 // tags if available;
            TagType                     m_moveToTag;            // a tag of a node which should become my new parent
            const char*                 m_name;
            hkUint32                    m_userFlags;
            hkUint32                    m_totalCallCountForChildren;
            hkEnum<NodeType,hkUint16>   m_type;
            hkFlags<NodeFlags,hkUint16> m_flags;
        };

        // Tracks the root node for each thread that captured timer data. When used in an array, the array index will generally correspond to the thread ID of the captured node data.
        struct ThreadRootNodes
        {
            Node* m_node;
        };

        struct HK_EXPORT_COMMON Tree : public Node
        {
            HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_MONITOR, Tree );

            Tree( ) : Node(HK_NULL, "/", NODE_TYPE_DIRECTORY ) {}
            virtual ~Tree() { }

            typedef hkPointerMap<Node*,TagType> TaggedNodesMap;

            void clearTags();

            hkPointerMap<TagType, Node*> m_tagToNode;
            TaggedNodesMap m_nodesWhichNeedToBeMovedToATag; // nodes which we need to move to be a child of a tagNode
        };

        enum TimerDeductionNodeRemovalStrategy
        {
            DONT_REMOVE_TIMER_DEDUCTION_NODES,
            REMOVE_TIMER_DEDUCTION_NODES
        };
        static void HK_CALL applyDeductionsToTree(hkMonitorStreamAnalyzer::Node* node, const hkMonitorStreamFrameInfo& frameInfo, TimerDeductionNodeRemovalStrategy timerDeductionNodeRemovalStrategy);

        static int HK_CALL findMaxTimerNameIndent( hkMonitorStreamAnalyzer::Node* node, int recursionDepth, int spacing, bool displayPartialTree );
        static void HK_CALL traverseCompleteTreeToFindTotalCallCounts( Node* node, hkUint32 numFields );

        static void HK_CALL showCombinedThreadSummaryRec( hkOstream& os, _Inout_ hkMonitorStreamAnalyzer::Node* node, int recursionDepth, int numThreads, const CombinedThreadSummaryOptions& options );

        _Ret_notnull_ Node* HK_CALL makeStatisticsTreeForMultipleFrames(int threadId, hkBool reuseNodesIfPossible = false, _Inout_opt_ DrawCallHandleMap* drawCallMappings = HK_NULL);

        void checkAllThreadsCapturedSameNumFrames() const;

        static void HK_CALL writeStatisticsDetails( hkOstream& outStream, hkArrayBase<ThreadRootNodes>& nodes, int numThreads, int reportLevel,
            _In_z_ const char* nodeIdForFrameOverview = "", bool showMultithreadedSummary = false, _Inout_opt_ DrawCallHandleMap* drawCallMappings = HK_NULL, _In_opt_ const hkArrayView<hkGpuTraceResult>* traceResultsPerFrame = HK_NULL);

        static void HK_CALL extractStringMap(_In_reads_to_ptr_(frameEnd) const char* frameStart, _In_ const char* frameEnd, hkPointerMap<const void*, const char*>& map );

        static void HK_CALL applyStringMap( const char* frameStart, const char* frameEnd, const hkPointerMap<const void*, const char*>& map, hkBool endianSwap );

        struct HK_EXPORT_COMMON SampleInfo
        {
            HK_DECLARE_PLACEMENT_ALLOCATOR();
            hkReal m_maxSampleTime;
        };

            /// called by drawThreadsToTga (and the VDB). Call hkDeallocate on the data when you are done. Always has 4 bytes per pixel.
        static void HK_CALL writeStatisticsDetailsToTexture( const hkArrayBase<ThreadRootNodes>& perThreadNodes, const ThreadDrawInput& input, hkArray< hkArray< hkMonitorStreamFrameInfo > >& frameInfos, int*& textureData, int& height, _Inout_opt_ SampleInfo* sampleInfo = HK_NULL );

            /// called by drawThreadsToTga (and the VDB). Calls the above and writes it in a simple TARGA format.
        static void HK_CALL writeStatisticsDetailsToTga( const hkArrayBase<ThreadRootNodes>& perThreadNodes, const ThreadDrawInput& input, hkArray< hkArray< hkMonitorStreamFrameInfo > >& frameInfos, hkOstream& outStream, _Inout_opt_ SampleInfo* sampleInfo = HK_NULL );

        static Node* HK_CALL reverseLookupNodeAtTgaSample( int x, int y, const hkArrayBase<ThreadRootNodes>& nodes, const ThreadDrawInput& input, hkArray< hkArray< hkMonitorStreamFrameInfo > >& frameInfos );
        static void HK_CALL getTimerLimits( const hkArrayBase<ThreadRootNodes>& nodeList, const ThreadDrawInput& input, hkArray< hkArray< hkMonitorStreamFrameInfo > >& frameInfos, hkDouble64& maxFrameTime, hkArray<hkDouble64>& startTimes);

            /// look for root-most occurrences of the given timer names in a raw timer stream and return their summed values
        static void HK_CALL gatherRawStreamTimerValues(_In_reads_to_ptr_(frameEnd) const char* frameStart, _In_ const char* frameEnd, const hkMonitorStreamFrameInfo& info,
                                                        const char** timerNames, int numTimers, _Out_writes_all_(numTimers) hkReal* valuesOut, const hkMonitorStream::CommandStreamConfig* streamConfig = HK_NULL );

        static void HK_CALL accumulateMetaData( hkMonitorStreamAnalyzer::Node* node, hkArrayView<hkReflect::Var> parents );

        static void HK_CALL makeStringsLocal(_Inout_ hkMonitorStreamAnalyzer::Node* node, hkPointerMap<char*, char*>& map);

        static void HK_CALL deallocateLocalStrings(hkPointerMap<char*, char*>& map);

    protected:

        //
        // Data for multiple frames
        //

        hkArray< hkArray< hkMonitorStreamFrameInfo > > m_frameInfos;
        hkArray<char>::Debug m_data;
        int m_numThreads;

    public:

        static hkReal s_lastFrameTime;
        const char* m_nodeIdForFrameOverview;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
