// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

// hkMemUtil
namespace hkMemUtil
{
    // called from hkArray::removeAt
    template<unsigned int ELEMENTSIZE, unsigned int ALIGN>
    HK_INLINE void memCpyOneAligned(_Out_writes_bytes_all_(ELEMENTSIZE) void* dst, _In_reads_(ELEMENTSIZE) const void* src)
    {
        typedef typename TypeFromAlign<ALIGN>::type CopyType;
        unsigned int i = 0;
        do
        {
            static_cast<CopyType*>(dst)[i] = static_cast<const CopyType*>(src)[i];
        }
        while( ++i < ELEMENTSIZE/sizeof(CopyType) );
    }

    template <typename T>
    HK_INLINE void memCpyOne(_Out_writes_bytes_all_(sizeof(T)) T* dst, _In_reads_(sizeof(T)) const T* src)
    {
        memCpyOneAligned< sizeof(T), HK_ALIGN_OF(T) >(dst, src);
    }

    template<unsigned int ELEMENTSIZE, unsigned int ALIGN>
    HK_INLINE void memZeroAligned(_Out_writes_bytes_all_(ELEMENTSIZE) void* dst)
    {
        typedef typename TypeFromAlign<ALIGN>::type CopyType;
        unsigned int i = 0;
        do
        {
            static_cast<CopyType*>(dst)[i] = 0;
        } while(++i < ELEMENTSIZE / sizeof(CopyType));
    }

    template <typename T>
    HK_INLINE void memZeroOne(_Out_writes_bytes_all_(sizeof(T)) T* dst)
    {
        memZeroAligned< sizeof(T), HK_ALIGN_OF(T) >(dst);
    }

    template<unsigned int ELEMENTALIGN>
    HK_INLINE void memCpy(_Out_writes_bytes_all_(n) void* dst, _In_reads_bytes_(n) const void* src, hkLong n)
    {
        typedef typename TypeFromAlign<ELEMENTALIGN>::type CopyType;
        HK_ON_DEBUG( if ( dst == src ) HK_BREAKPOINT(0x0) ); // Can't use assert here because of include order
        for( int i = 0, j = 0; i < n; i += sizeof(CopyType), ++j )
        {
            static_cast<CopyType*>(dst)[j] = static_cast<const CopyType*>(src)[j];
        }
    }

    // Implementation from http://en.cppreference.com/w/cpp/memory/addressof
    template<typename T>
    HK_INLINE _Ret_notnull_ T* addressOf(T& arg) {
        return reinterpret_cast<T*>(&const_cast<char&>(reinterpret_cast<const volatile char&>(arg)));
    }
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
