// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

/// Utility functions to copy memory.
namespace hkMemUtil
{
    template <unsigned int NBYTES> struct TypeFromAlign;
    template <> struct TypeFromAlign<1> { typedef char type; };
    template <> struct TypeFromAlign<2> { typedef hkInt16 type; };
    template <> struct TypeFromAlign<4> { typedef hkInt32 type; };
    template <> struct TypeFromAlign<8> { typedef hkInt64 type; };
    template <unsigned int NBYTES> struct TypeFromAlign: public TypeFromAlign<NBYTES/2> {};

    // called from hkArray::removeAt
    template <unsigned int ELEMENTSIZE, unsigned int ELEMENTALIGN>
    HK_INLINE void memCpyOneAligned(_Out_writes_bytes_all_(ELEMENTSIZE) void* dst, _In_reads_(ELEMENTSIZE) const void* src);
    template <typename T>
    HK_INLINE void memCpyOne(_Out_writes_bytes_all_(sizeof(T)) T* dst, _In_reads_(sizeof(T)) const T* src);

    template <unsigned int ELEMENTSIZE, unsigned int ELEMENTALIGN>
    HK_INLINE void memZeroAligned(_Out_writes_bytes_all_(ELEMENTSIZE) void* dst);
    template <typename T>
    HK_INLINE void memZeroOne(_Out_writes_bytes_all_(sizeof(T)) T* dst);

    template <unsigned int ELEMENTALIGN>
    HK_INLINE void memCpy(_Out_writes_bytes_all_(nbytes) void* dst, _In_reads_bytes_(nbytes) const void* src, hkLong nbytes);

    HK_EXPORT_COMMON void HK_CALL memCpy(_Out_writes_bytes_all_(nbytes) void* dst, _In_reads_bytes_(nbytes) const void* src, hkLong nbytes);
    HK_EXPORT_COMMON void HK_CALL memCpyBackwards(_Out_writes_bytes_all_(nbytes) void* dst, _In_reads_bytes_(nbytes) const void* src, hkLong nbytes);
    HK_EXPORT_COMMON void HK_CALL memMove(_Out_writes_bytes_all_(nbytes) void* dst, _In_reads_bytes_(nbytes) const void* src, hkLong nbytes);
    HK_EXPORT_COMMON void HK_CALL memSet(_Out_writes_bytes_all_(nbytes) void* dst, const int c, hkLong nbytes);
        // unlike ::memcmp, this always returns -1,0,+1
    HK_EXPORT_COMMON int HK_CALL memCmp(_In_reads_bytes_(nbytes) const void* a, _In_reads_bytes_(nbytes) const void* b, hkLong nbytes);

    // Bypass potential operator& overloads and get the address of a variable.
    template<typename T>
    HK_INLINE _Ret_notnull_ T* addressOf(T& arg);
}

#include <Common/Base/Memory/Util/hkMemUtil.inl>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
